/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32.access.impl;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import org.gudy.azureus2.platform.PlatformManagerPingCallback;
import org.gudy.azureus2.platform.win32.access.AEWin32Access;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessException;
import org.gudy.azureus2.platform.win32.access.AEWin32AccessListener;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessCallback;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessInterface;

public class AEWin32AccessImpl
implements AEWin32Access,
AEWin32AccessCallback {
    protected static AEWin32AccessImpl singleton;
    private boolean fully_initialise;
    private int trace_id_next = new Random().nextInt();
    private List listeners = new ArrayList();

    public static synchronized AEWin32Access getSingleton(boolean fully_initialise) {
        if (singleton == null) {
            singleton = new AEWin32AccessImpl(fully_initialise);
        }
        return singleton;
    }

    protected AEWin32AccessImpl(boolean _fully_initialise) {
        this.fully_initialise = _fully_initialise;
        if (this.isEnabled()) {
            AEWin32AccessInterface.load(this, this.fully_initialise);
        }
    }

    public boolean isEnabled() {
        return AEWin32AccessInterface.isEnabled(this.fully_initialise);
    }

    public long windowsMessage(int msg, int param1, long param2) {
        for (int i = 0; i < this.listeners.size(); ++i) {
            try {
                ((AEWin32AccessListener)this.listeners.get(i)).eventOccurred(msg);
                continue;
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
        return -1L;
    }

    public long generalMessage(String str) {
        return 0L;
    }

    public String getVersion() {
        return AEWin32AccessInterface.getVersion();
    }

    public String readStringValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        return AEWin32AccessInterface.readStringValue(type, subkey, value_name);
    }

    public void writeStringValue(int type, String subkey, String value_name, String value_value) throws AEWin32AccessException {
        AEWin32AccessInterface.writeStringValue(type, subkey, value_name, value_value);
    }

    public int readWordValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        return AEWin32AccessInterface.readWordValue(type, subkey, value_name);
    }

    public void writeWordValue(int type, String subkey, String value_name, int value_value) throws AEWin32AccessException {
        AEWin32AccessInterface.writeWordValue(type, subkey, value_name, value_value);
    }

    public void deleteKey(int type, String subkey) throws AEWin32AccessException {
        this.deleteKey(type, subkey, false);
    }

    public void deleteKey(int type, String subkey, boolean recursive) throws AEWin32AccessException {
        AEWin32AccessInterface.deleteKey(type, subkey, recursive);
    }

    public void deleteValue(int type, String subkey, String value_name) throws AEWin32AccessException {
        AEWin32AccessInterface.deleteValue(type, subkey, value_name);
    }

    public String getUserAppData() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "appdata";
        return this.readStringValue(4, app_data_key, app_data_name);
    }

    public String getUserDocumentsDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "personal";
        return this.readStringValue(4, app_data_key, app_data_name);
    }

    public String getUserMusicDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "my music";
        try {
            return this.readStringValue(4, app_data_key, app_data_name);
        }
        catch (AEWin32AccessException e) {
            String s = this.getUserDocumentsDir();
            if (s != null) {
                s = s + "\\My Music";
            }
            return s;
        }
    }

    public String getUserVideoDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion\\explorer\\shell folders";
        String app_data_name = "my video";
        try {
            return this.readStringValue(4, app_data_key, app_data_name);
        }
        catch (AEWin32AccessException e) {
            String s = this.getUserDocumentsDir();
            if (s != null) {
                s = s + "\\My Video";
            }
            return s;
        }
    }

    public String getProgramFilesDir() throws AEWin32AccessException {
        String app_data_key = "software\\microsoft\\windows\\currentversion";
        String app_data_name = "ProgramFilesDir";
        return this.readStringValue(3, app_data_key, app_data_name);
    }

    public String getApplicationInstallDir(String app_name) throws AEWin32AccessException {
        String res = "";
        try {
            res = this.readStringValue(4, "software\\" + app_name, null);
        }
        catch (AEWin32AccessException e) {
            res = this.readStringValue(3, "software\\" + app_name, null);
        }
        return res;
    }

    public void createProcess(String command_line, boolean inherit_handles) throws AEWin32AccessException {
        AEWin32AccessInterface.createProcess(command_line, inherit_handles);
    }

    public void moveToRecycleBin(String file_name) throws AEWin32AccessException {
        AEWin32AccessInterface.moveToRecycleBin(file_name);
    }

    public void copyFilePermissions(String from_file_name, String to_file_name) throws AEWin32AccessException {
        AEWin32AccessInterface.copyPermission(from_file_name, to_file_name);
    }

    public boolean testNativeAvailability(String name) throws AEWin32AccessException {
        return AEWin32AccessInterface.testNativeAvailability(name);
    }

    public void traceRoute(InetAddress source_address, InetAddress target_address, PlatformManagerPingCallback callback) throws AEWin32AccessException {
        this.traceRoute(source_address, target_address, false, callback);
    }

    public void ping(InetAddress source_address, InetAddress target_address, PlatformManagerPingCallback callback) throws AEWin32AccessException {
        this.traceRoute(source_address, target_address, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void traceRoute(InetAddress source_address, InetAddress target_address, boolean ping_mode, PlatformManagerPingCallback callback) throws AEWin32AccessException {
        int trace_id;
        AEWin32AccessImpl aEWin32AccessImpl = this;
        synchronized (aEWin32AccessImpl) {
            trace_id = this.trace_id_next++;
        }
        traceRouteCallback cb = new traceRouteCallback(ping_mode, callback);
        AEWin32AccessInterface.traceRoute(trace_id, this.addressToInt(source_address), this.addressToInt(target_address), ping_mode ? 1 : 0, cb);
    }

    private int addressToInt(InetAddress address) {
        byte[] bytes = address.getAddress();
        int resp = bytes[0] << 24 & 0xFF000000 | bytes[1] << 16 & 0xFF0000 | bytes[2] << 8 & 0xFF00 | bytes[3] & 0xFF;
        return resp;
    }

    private InetAddress intToAddress(int address) {
        byte[] bytes = new byte[]{(byte)(address >> 24), (byte)(address >> 16), (byte)(address >> 8), (byte)address};
        try {
            InetAddress res = InetAddress.getByAddress(bytes);
            return res;
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    public void addListener(AEWin32AccessListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(AEWin32AccessListener listener) {
        this.listeners.remove(listener);
    }

    protected class traceRouteCallback
    implements AEWin32AccessCallback {
        private boolean ping_mode;
        private PlatformManagerPingCallback cb;

        protected traceRouteCallback(boolean _ping_mode, PlatformManagerPingCallback _cb) {
            this.ping_mode = _ping_mode;
            this.cb = _cb;
        }

        public long windowsMessage(int msg, int param1, long param2) {
            return 0L;
        }

        public long generalMessage(String msg) {
            InetAddress address;
            StringTokenizer tok = new StringTokenizer(msg, ",");
            int ttl = Integer.parseInt(tok.nextToken().trim());
            int time = -1;
            if (tok.hasMoreTokens()) {
                int i_addr = Integer.parseInt(tok.nextToken().trim());
                address = AEWin32AccessImpl.this.intToAddress(i_addr);
                time = Integer.parseInt(tok.nextToken().trim());
                boolean is_udp = Integer.parseInt(tok.nextToken().trim()) == 1;
            } else {
                address = null;
            }
            return this.cb.reportNode(this.ping_mode ? -1 : ttl, address, time) ? 1 : 0;
        }
    }
}

