/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.platform.win32.access.impl;

import org.gudy.azureus2.platform.win32.access.AEWin32AccessException;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessCallback;
import org.gudy.azureus2.platform.win32.access.impl.AEWin32AccessExceptionImpl;
import org.gudy.azureus2.update.UpdaterUtils;

public class AEWin32AccessInterface {
    public static final int HKEY_CLASSES_ROOT = 1;
    public static final int HKEY_CURRENT_CONFIG = 2;
    public static final int HKEY_LOCAL_MACHINE = 3;
    public static final int HKEY_CURRENT_USER = 4;
    public static final int WM_QUERYENDSESSION = 17;
    public static final int WM_ENDSESSION = 22;
    private static boolean enabled;
    private static boolean enabled_set;
    private static AEWin32AccessCallback cb;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean isEnabled(boolean check_if_disabled) {
        if (!check_if_disabled) {
            return true;
        }
        if (enabled_set) {
            return enabled;
        }
        try {
            boolean bl = enabled = !UpdaterUtils.disableNativeCode(AEWin32AccessInterface.getVersion());
            if (!enabled) {
                System.err.println("Native code has been disabled");
            }
        }
        finally {
            enabled_set = true;
        }
        return enabled;
    }

    protected static void load(AEWin32AccessCallback _callback, boolean _fully_initialise) {
        cb = _callback;
        if (_fully_initialise) {
            try {
                AEWin32AccessInterface.initialise();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static long callback(int msg, int param1, long param2) {
        if (cb == null) {
            System.out.println("callback: " + msg + "/" + param1 + "/" + param2);
            return -1L;
        }
        return cb.windowsMessage(msg, param1, param2);
    }

    protected static native void initialise() throws AEWin32AccessExceptionImpl;

    protected static native void destroy() throws AEWin32AccessExceptionImpl;

    protected static native String getVersion();

    protected static native String readStringValue(int var0, String var1, String var2) throws AEWin32AccessExceptionImpl;

    protected static native void writeStringValue(int var0, String var1, String var2, String var3) throws AEWin32AccessExceptionImpl;

    protected static native int readWordValue(int var0, String var1, String var2) throws AEWin32AccessExceptionImpl;

    protected static native void writeWordValue(int var0, String var1, String var2, int var3) throws AEWin32AccessExceptionImpl;

    protected static native void deleteKey(int var0, String var1, boolean var2) throws AEWin32AccessExceptionImpl;

    protected static native void deleteValue(int var0, String var1, String var2) throws AEWin32AccessExceptionImpl;

    public static native void createProcess(String var0, boolean var1) throws AEWin32AccessException;

    public static native void moveToRecycleBin(String var0) throws AEWin32AccessException;

    public static native void copyPermission(String var0, String var1) throws AEWin32AccessException;

    public static native boolean testNativeAvailability(String var0) throws AEWin32AccessException;

    public static native void traceRoute(int var0, int var1, int var2, int var3, AEWin32AccessCallback var4) throws AEWin32AccessException;

    static {
        System.loadLibrary("aereg");
    }
}

