/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local;

import com.aelitis.net.magneturi.MagnetURIHandler;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gudy.azureus2.core3.config.COConfigurationListener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.pluginsimpl.local.config.ConfigParameterImpl;

public class PluginConfigImpl
implements PluginConfig {
    protected static Map external_to_internal_key_map = new HashMap();
    private PluginInterface plugin_interface;
    private String key;

    public PluginConfigImpl(PluginInterface _plugin_interface, String _key) {
        this.plugin_interface = _plugin_interface;
        this.key = _key + ".";
    }

    public boolean isNewInstall() {
        return COConfigurationManager.isNewInstall();
    }

    public String getPluginConfigKeyPrefix() {
        return this.key;
    }

    public void setPluginConfigKeyPrefix(String _key) {
        if (_key.length() <= 0 && !this.plugin_interface.isBuiltIn()) {
            throw new RuntimeException("Can't set Plugin Config Key Prefix to '" + _key + "'");
        }
        this.key = _key;
    }

    public String getStringParameter(String name) {
        return COConfigurationManager.getStringParameter(this.mapKeyName(name, false));
    }

    public String getStringParameter(String name, String _default) {
        return COConfigurationManager.getStringParameter(this.mapKeyName(name, false), _default);
    }

    public float getFloatParameter(String name) {
        return COConfigurationManager.getFloatParameter(this.mapKeyName(name, false));
    }

    public int getIntParameter(String name) {
        return COConfigurationManager.getIntParameter(this.mapKeyName(name, false));
    }

    public int getIntParameter(String name, int default_value) {
        return COConfigurationManager.getIntParameter(this.mapKeyName(name, false), default_value);
    }

    private String mapKeyName(String key, boolean for_set) {
        String result = (String)external_to_internal_key_map.get(key);
        if (result == null) {
            if (for_set) {
                throw new RuntimeException("No permission to set the value of core parameter: " + key);
            }
            return key;
        }
        return result;
    }

    public void setIntParameter(String key, int value) {
        COConfigurationManager.setParameter(this.mapKeyName(key, true), value);
    }

    public boolean getBooleanParameter(String name) {
        return COConfigurationManager.getBooleanParameter(this.mapKeyName(name, false));
    }

    public boolean getBooleanParameter(String name, boolean _default) {
        return COConfigurationManager.getBooleanParameter(this.mapKeyName(name, false), _default);
    }

    public void setBooleanParameter(String key, boolean value) {
        COConfigurationManager.setParameter(this.mapKeyName(key, true), value);
    }

    public byte[] getByteParameter(String name, byte[] _default) {
        return COConfigurationManager.getByteParameter(this.mapKeyName(name, false), _default);
    }

    public int getPluginIntParameter(String key) {
        return this.getIntParameter(this.key + key);
    }

    public int getPluginIntParameter(String key, int defaultValue) {
        COConfigurationManager.setIntDefault(this.key + key, defaultValue);
        return COConfigurationManager.getIntParameter(this.key + key, defaultValue);
    }

    public String getPluginStringParameter(String key) {
        return this.getStringParameter(this.key + key);
    }

    public String getPluginStringParameter(String key, String defaultValue) {
        COConfigurationManager.setStringDefault(this.key + key, defaultValue);
        return COConfigurationManager.getStringParameter(this.key + key, defaultValue);
    }

    public boolean getPluginBooleanParameter(String key) {
        return this.getBooleanParameter(this.key + key);
    }

    public boolean getPluginBooleanParameter(String key, boolean defaultValue) {
        COConfigurationManager.setBooleanDefault(this.key + key, defaultValue);
        return COConfigurationManager.getBooleanParameter(this.key + key, defaultValue);
    }

    public byte[] getPluginByteParameter(String key, byte[] defaultValue) {
        COConfigurationManager.setByteDefault(this.key + key, defaultValue);
        return COConfigurationManager.getByteParameter(this.key + key, defaultValue);
    }

    public List getPluginListParameter(String key, List default_value) {
        return COConfigurationManager.getListParameter(this.key + key, default_value);
    }

    public void setPluginListParameter(String key, List value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public Map getPluginMapParameter(String key, Map default_value) {
        return COConfigurationManager.getMapParameter(this.key + key, default_value);
    }

    public void setPluginMapParameter(String key, Map value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, int value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, int value, boolean global) {
        COConfigurationManager.setParameter(this.key + key, value);
        if (global) {
            MagnetURIHandler.getSingleton().addInfo(this.key + key, value);
        }
    }

    public void setPluginParameter(String key, String value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, boolean value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public void setPluginParameter(String key, byte[] value) {
        COConfigurationManager.setParameter(this.key + key, value);
    }

    public ConfigParameter getParameter(String key) {
        return new ConfigParameterImpl(this.mapKeyName(key, false));
    }

    public ConfigParameter getPluginParameter(String key) {
        return new ConfigParameterImpl(this.key + key);
    }

    public boolean removePluginParameter(String key) {
        return COConfigurationManager.removeParameter(this.key + key);
    }

    public boolean getUnsafeBooleanParameter(String key, boolean default_value) {
        return COConfigurationManager.getBooleanParameter(key, default_value);
    }

    public void setUnsafeBooleanParameter(String key, boolean value) {
        COConfigurationManager.setParameter(key, value);
    }

    public int getUnsafeIntParameter(String key, int default_value) {
        return COConfigurationManager.getIntParameter(key, default_value);
    }

    public void setUnsafeIntParameter(String key, int value) {
        COConfigurationManager.setParameter(key, value);
    }

    public long getUnsafeLongParameter(String key, long default_value) {
        return COConfigurationManager.getLongParameter(key, default_value);
    }

    public void setUnsafeLongParameter(String key, long value) {
        COConfigurationManager.setParameter(key, value);
    }

    public float getUnsafeFloatParameter(String key, float default_value) {
        return COConfigurationManager.getFloatParameter(key, default_value);
    }

    public void setUnsafeFloatParameter(String key, float value) {
        COConfigurationManager.setParameter(key, value);
    }

    public String getUnsafeStringParameter(String key, String default_value) {
        return COConfigurationManager.getStringParameter(key, default_value);
    }

    public void setUnsafeStringParameter(String key, String value) {
        COConfigurationManager.setParameter(key, value);
    }

    public Map getUnsafeParameterList() {
        Set params = COConfigurationManager.getAllowedParameters();
        Iterator it = params.iterator();
        HashMap<String, Object> result = new HashMap<String, Object>();
        while (it.hasNext()) {
            try {
                String name = (String)it.next();
                Object val = COConfigurationManager.getParameter(name);
                if (!(val instanceof String) && !(val instanceof Long)) {
                    if (val instanceof byte[]) {
                        val = new String((byte[])val, "UTF-8");
                    } else if (val instanceof Integer) {
                        val = new Long(((Integer)val).intValue());
                    } else if (val instanceof List) {
                        val = null;
                    } else if (val instanceof Map) {
                        val = null;
                    } else if (val instanceof Boolean) {
                        val = new Long((Boolean)val != false ? 1L : 0L);
                    } else if (val instanceof Float || val instanceof Double) {
                        val = val.toString();
                    }
                }
                if (val == null) continue;
                result.put(name, val);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        return result;
    }

    public void save() {
        COConfigurationManager.save();
    }

    public File getPluginUserFile(String name) {
        String dir = this.plugin_interface.getUtilities().getAzureusUserDir();
        File file = new File(dir, "plugins");
        String p_dir = this.plugin_interface.getPluginDirectoryName();
        if (p_dir.length() != 0) {
            int lp = p_dir.lastIndexOf(File.separatorChar);
            if (lp != -1) {
                p_dir = p_dir.substring(lp + 1);
            }
            file = new File(file, p_dir);
        } else {
            String id = this.plugin_interface.getPluginID();
            if (id.length() > 0 && !id.equals("<internal>")) {
                file = new File(file, id);
            } else {
                throw new RuntimeException("Plugin was not loaded from a directory");
            }
        }
        FileUtil.mkdirs(file);
        return new File(file, name);
    }

    public void addListener(final PluginConfigListener l) {
        COConfigurationManager.addListener(new COConfigurationListener(){

            public void configurationSaved() {
                l.configSaved();
            }
        });
    }

    public boolean hasParameter(String param_name) {
        return COConfigurationManager.hasParameter(param_name, false);
    }

    public boolean hasPluginParameter(String param_name) {
        return COConfigurationManager.hasParameter(this.key + param_name, true);
    }

    static {
        external_to_internal_key_map.put("Max Upload Speed KBs", "Max Upload Speed KBs");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding KBs", "Max Upload Speed Seeding KBs");
        external_to_internal_key_map.put("Max Download Speed KBs", "Max Download Speed KBs");
        external_to_internal_key_map.put("Max Connections Global", "Max.Peer.Connections.Total");
        external_to_internal_key_map.put("Max Connections Per Torrent", "Max.Peer.Connections.Per.Torrent");
        external_to_internal_key_map.put("Max Downloads", "max downloads");
        external_to_internal_key_map.put("Max Active Torrents", "max active torrents");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding", "StartStopManager_iMaxActiveTorrentsWhenSeeding");
        external_to_internal_key_map.put("Max Uploads", "Max Uploads");
        external_to_internal_key_map.put("Max Uploads Seeding", "Max Uploads Seeding");
        external_to_internal_key_map.put("Max Upload Speed When Only Seeding Enabled", "enable.seedingonly.upload.rate");
        external_to_internal_key_map.put("Max Active Torrents When Only Seeding Enabled", "StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled");
        external_to_internal_key_map.put("Auto Upload Speed Enabled", "Auto Upload Speed Enabled");
        external_to_internal_key_map.put("SOCKS Proxy No Inward Connection", "Proxy.Data.SOCKS.inform");
        external_to_internal_key_map.put("Newly Seeding Torrents Get First Priority", "Newly Seeding Torrents Get First Priority");
        external_to_internal_key_map.put("CORE_PARAM_STRING_LOCAL_BIND_IP", "Bind IP");
        external_to_internal_key_map.put("CORE_PARAM_BOOLEAN_FRIENDLY_HASH_CHECKING", "diskmanager.friendly.hashchecking");
        String[] passthrough_params = new String[]{"Open MyTorrents", "IconBar.enabled", "Wizard Completed", "welcome.version.lastshown", "Set Completion Flag For Completed Downloads On Start"};
        for (int i = 0; i < passthrough_params.length; ++i) {
            external_to_internal_key_map.put(passthrough_params[i], passthrough_params[i]);
        }
    }
}

