/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ipfilter;

import java.io.File;
import org.gudy.azureus2.core3.ipfilter.BannedIp;
import org.gudy.azureus2.core3.ipfilter.BlockedIp;
import org.gudy.azureus2.core3.ipfilter.IpFilter;
import org.gudy.azureus2.core3.ipfilter.IpFilterManagerFactory;
import org.gudy.azureus2.core3.ipfilter.IpRange;
import org.gudy.azureus2.plugins.ipfilter.IPBanned;
import org.gudy.azureus2.plugins.ipfilter.IPBlocked;
import org.gudy.azureus2.plugins.ipfilter.IPFilter;
import org.gudy.azureus2.plugins.ipfilter.IPFilterException;
import org.gudy.azureus2.plugins.ipfilter.IPRange;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPBannedImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPBlockedImpl;
import org.gudy.azureus2.pluginsimpl.local.ipfilter.IPRangeImpl;

public class IPFilterImpl
implements IPFilter {
    protected IpFilter filter = IpFilterManagerFactory.getSingleton().getIPFilter();

    public File getFile() {
        return this.filter.getFile();
    }

    public void reload() throws IPFilterException {
        try {
            this.filter.reload();
        }
        catch (Throwable e) {
            throw new IPFilterException("IPFilter::reload fails", e);
        }
    }

    public void save() throws IPFilterException {
        try {
            this.filter.save();
        }
        catch (Throwable e) {
            throw new IPFilterException("IPFilter::reload fails", e);
        }
    }

    public IPRange[] getRanges() {
        IpRange[] l = this.filter.getRanges();
        IPRange[] res = new IPRange[l.length];
        for (int i = 0; i < l.length; ++i) {
            res[i] = new IPRangeImpl(this, l[i]);
        }
        return res;
    }

    public int getNumberOfRanges() {
        return this.filter.getNbRanges();
    }

    public int getNumberOfBlockedIPs() {
        return this.filter.getNbIpsBlocked();
    }

    public int getNumberOfBannedIPs() {
        return this.filter.getNbBannedIps();
    }

    public boolean isInRange(String IPAddress) {
        return this.filter.isInRange(IPAddress);
    }

    public IPRange createRange(boolean this_session_only) {
        return new IPRangeImpl(this, this.filter.createRange(this_session_only));
    }

    public void addRange(IPRange range) {
        if (!(range instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.addRange(((IPRangeImpl)range).getRange());
    }

    public IPRange createAndAddRange(String description, String start_ip, String end_ip, boolean this_session_only) {
        IPRange range = this.createRange(this_session_only);
        range.setDescription(description);
        range.setStartIP(start_ip);
        range.setEndIP(end_ip);
        range.checkValid();
        if (range.isValid()) {
            this.addRange(range);
            return range;
        }
        return null;
    }

    public void removeRange(IPRange range) {
        if (!(range instanceof IPRangeImpl)) {
            throw new RuntimeException("range must be created by createRange");
        }
        this.filter.removeRange(((IPRangeImpl)range).getRange());
    }

    public IPBlocked[] getBlockedIPs() {
        BlockedIp[] l = this.filter.getBlockedIps();
        IPBlocked[] res = new IPBlocked[l.length];
        for (int i = 0; i < l.length; ++i) {
            res[i] = new IPBlockedImpl(this, l[i]);
        }
        return res;
    }

    public void block(String IPAddress) {
        this.filter.ban(IPAddress, "<plugin>");
    }

    public IPBanned[] getBannedIPs() {
        BannedIp[] l = this.filter.getBannedIps();
        IPBanned[] res = new IPBanned[l.length];
        for (int i = 0; i < l.length; ++i) {
            res[i] = new IPBannedImpl(l[i]);
        }
        return res;
    }

    public void ban(String IPAddress, String text) {
        this.filter.ban(IPAddress, text);
    }

    public void unban(String IPAddress) {
        this.filter.unban(IPAddress);
    }

    public boolean isEnabled() {
        return this.filter.isEnabled();
    }

    public void setEnabled(boolean enabled) {
        this.filter.setEnabled(enabled);
    }

    public boolean getInRangeAddressesAreAllowed() {
        return this.filter.getInRangeAddressesAreAllowed();
    }

    public void setInRangeAddressesAreAllowed(boolean b) {
        this.filter.setInRangeAddressesAreAllowed(b);
    }

    public void markAsUpToDate() {
        this.filter.markAsUpToDate();
    }

    public long getLastUpdateTime() {
        return this.filter.getLastUpdateTime();
    }
}

