/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.launch;

import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.PluginManagerArgumentHandler;
import org.gudy.azureus2.plugins.logging.LoggerChannelListener;

public class PluginSingleInstanceHandler {
    private static boolean active;
    private static int port;
    private static PluginManagerArgumentHandler handler;

    public static void initialise(int _port, PluginManagerArgumentHandler _handler) {
        port = _port;
        handler = _handler;
        String multi_instance = System.getProperty("MULTI_INSTANCE");
        if (multi_instance != null && multi_instance.equalsIgnoreCase("true")) {
            return;
        }
        active = true;
    }

    protected static boolean process(LoggerChannelListener log, String[] args) {
        if (active) {
            if (PluginSingleInstanceHandler.startListener(log)) {
                return false;
            }
            PluginSingleInstanceHandler.sendArguments(log, args);
            return true;
        }
        return false;
    }

    protected static boolean startListener(final LoggerChannelListener log) {
        try {
            final ServerSocket server_socket = new ServerSocket(port, 50, InetAddress.getByName("127.0.0.1"));
            log.messageLogged(1, "SingleInstanceHandler: listening on 127.0.0.1:" + port + " for passed arguments");
            Thread t = new Thread("Single Instance Handler"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    while (true) {
                        Socket socket = null;
                        ObjectInputStream ois = null;
                        try {
                            socket = server_socket.accept();
                            String address = socket.getInetAddress().getHostAddress();
                            if (!address.equals("localhost") && !address.equals("127.0.0.1")) {
                                socket.close();
                                continue;
                            }
                            ois = new ObjectInputStream(socket.getInputStream());
                            ois.readInt();
                            String header = (String)ois.readObject();
                            if (!header.equals(PluginSingleInstanceHandler.getHeader())) {
                                log.messageLogged(3, "SingleInstanceHandler: invalid header - " + header);
                                continue;
                            }
                            String[] args = (String[])ois.readObject();
                            handler.processArguments(args);
                            continue;
                        }
                        catch (Throwable e) {
                            log.messageLogged("SingleInstanceHandler: receive error", e);
                            continue;
                        }
                        finally {
                            if (ois != null) {
                                try {
                                    ois.close();
                                }
                                catch (Throwable e) {}
                            }
                            if (socket == null) continue;
                            try {
                                socket.close();
                            }
                            catch (Throwable e) {}
                            continue;
                        }
                        break;
                    }
                }
            };
            t.setDaemon(true);
            t.start();
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void sendArguments(LoggerChannelListener log, String[] args) {
        Socket socket = null;
        try {
            socket = new Socket("127.0.0.1", port);
            ObjectOutputStream oos = new ObjectOutputStream(socket.getOutputStream());
            oos.writeInt(0);
            oos.writeObject(PluginSingleInstanceHandler.getHeader());
            oos.writeObject(args);
            log.messageLogged(1, "SingleInstanceHandler: arguments passed to existing process");
        }
        catch (Throwable e) {
            log.messageLogged("SingleInstanceHandler: send error", e);
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    protected static String getHeader() {
        return SystemProperties.getApplicationName() + " Single Instance Handler";
    }
}

