/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui;

import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.plugins.ui.UIInputReceiver;
import org.gudy.azureus2.plugins.ui.UIInputValidator;

public abstract class AbstractUIInputReceiver
implements UIInputReceiver {
    private boolean prompted = false;
    protected String[] messages = new String[0];
    protected String title = null;
    protected boolean multiline_mode = false;
    protected String preentered_text = null;
    protected boolean preentered_text_is_old_value = false;
    protected UIInputValidator validator = null;
    private boolean result_recorded = false;
    private boolean result_input_submitted = false;
    private String result_input = null;
    protected boolean maintain_whitespace = false;
    protected boolean allow_empty_input = true;

    protected final void assertPrePrompt() {
        if (this.prompted) {
            throw new RuntimeException("cannot invoke after prompt has been called");
        }
    }

    protected final void assertPostPrompt() {
        if (!this.prompted) {
            throw new RuntimeException("cannot before after prompt has been called");
        }
    }

    public void setLocalisedMessage(String message) {
        this.setLocalisedMessages(new String[]{message});
    }

    public void setLocalisedMessages(String[] messages) {
        this.assertPrePrompt();
        this.messages = messages;
    }

    public void setLocalisedTitle(String title) {
        this.assertPrePrompt();
        this.title = title;
    }

    public void setMessage(String message) {
        this.setLocalisedMessage(this.localise(message));
    }

    public void setMessages(String[] messages) {
        String[] new_messages = new String[messages.length];
        for (int i = 0; i < new_messages.length; ++i) {
            new_messages[i] = this.localise(messages[i]);
        }
        this.setLocalisedMessages(new_messages);
    }

    public void setMultiLine(boolean multiline) {
        this.assertPrePrompt();
        this.multiline_mode = multiline;
    }

    public void setPreenteredText(String text, boolean as_suggested) {
        this.assertPrePrompt();
        this.preentered_text = text;
        this.preentered_text_is_old_value = !as_suggested;
    }

    public void setTitle(String title) {
        this.setLocalisedTitle(this.localise(title));
    }

    public void setInputValidator(UIInputValidator validator) {
        this.assertPrePrompt();
        this.validator = validator;
    }

    public final void prompt() {
        this.assertPrePrompt();
        this.promptForInput();
        if (!this.result_recorded) {
            throw new RuntimeException(this.toString() + " did not record a result.");
        }
        this.prompted = true;
    }

    protected abstract void promptForInput();

    protected final void recordUserInput(String input) {
        this.result_recorded = true;
        this.result_input_submitted = true;
        this.result_input = input;
        if (!this.maintain_whitespace) {
            this.result_input = input.trim();
        }
    }

    protected final void recordUserAbort() {
        this.result_recorded = true;
        this.result_input_submitted = false;
        this.result_input = null;
    }

    public boolean hasSubmittedInput() {
        this.assertPostPrompt();
        return this.result_input_submitted;
    }

    public String getSubmittedInput() {
        this.assertPostPrompt();
        return this.result_input;
    }

    public void maintainWhitespace(boolean keep_whitespace) {
        this.maintain_whitespace = keep_whitespace;
    }

    public void allowEmptyInput(boolean empty_input) {
        this.allow_empty_input = empty_input;
    }

    protected final String localise(String key) {
        return MessageText.getString(key);
    }
}

