/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.components;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AETemporaryFileHandler;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.ui.components.UIPropertyChangeListener;
import org.gudy.azureus2.plugins.ui.components.UITextArea;
import org.gudy.azureus2.pluginsimpl.local.ui.components.UIComponentImpl;

public class UITextAreaImpl
extends UIComponentImpl
implements UITextArea {
    private int max_size = 60000;
    PrintWriter pw;
    File file;
    boolean useFile = true;
    AEMonitor file_mon = new AEMonitor("filemon");

    public UITextAreaImpl() {
        this.setText("");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setText(String text) {
        if (this.useFile) {
            try {
                this.file_mon.enter();
                if (this.pw == null) {
                    try {
                        this.file = AETemporaryFileHandler.createTempFile();
                        FileWriter fr = new FileWriter(this.file);
                        this.pw = new PrintWriter(fr);
                        this.pw.print(text);
                        this.pw.flush();
                        return;
                    }
                    catch (IOException e) {}
                }
            }
            finally {
                this.file_mon.exit();
            }
        }
        if (text.length() > this.max_size) {
            int size_to_show = this.max_size - 10000;
            if (size_to_show < 0) {
                size_to_show = this.max_size;
            }
            text = text.substring(text.length() - size_to_show);
        }
        this.setProperty("value", text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendText(String text) {
        if (this.useFile && this.pw != null) {
            try {
                this.file_mon.enter();
                this.pw.print(text);
                this.pw.flush();
                return;
            }
            finally {
                this.file_mon.exit();
            }
        }
        String str = this.getText();
        if (str == null) {
            this.setText(text);
        } else {
            this.setText(str + text);
        }
    }

    public String getText() {
        if (this.useFile && this.pw != null) {
            return this.getFileText();
        }
        return (String)this.getProperty("value");
    }

    public void setMaximumSize(int _max_size) {
        this.max_size = _max_size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getFileText() {
        boolean recreate = this.pw != null;
        try {
            this.file_mon.enter();
            if (recreate) {
                this.pw.close();
            }
            String text = null;
            try {
                text = FileUtil.readFileEndAsString(this.file, this.max_size);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (text == null) {
                text = "";
            }
            if (recreate) {
                try {
                    FileWriter fr = new FileWriter(this.file, true);
                    this.pw = new PrintWriter(fr);
                }
                catch (IOException e) {
                    this.useFile = false;
                    e.printStackTrace();
                }
            }
            String string = text;
            return string;
        }
        finally {
            this.file_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPropertyChangeListener(UIPropertyChangeListener l) {
        if (this.useFile) {
            if (this.pw != null) {
                try {
                    this.file_mon.enter();
                    this.pw.close();
                    this.pw = null;
                }
                finally {
                    this.file_mon.exit();
                }
            }
            this.useFile = false;
            this.setText(this.getFileText());
        }
        super.addPropertyChangeListener(l);
    }
}

