/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.tables;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableRow;

public class TableContextMenuItemImpl
implements TableContextMenuItem {
    private String sTableID;
    private String sName;
    private int style = 1;
    private boolean enabled = true;
    private Object data;
    private Graphic graphic;
    private List listeners = new ArrayList();
    private List m_listeners = new ArrayList();
    private List fill_listeners = new ArrayList();
    private List children = new ArrayList();
    private TableContextMenuItemImpl parent = null;
    private String display_text = null;

    public TableContextMenuItemImpl(String tableID, String key) {
        this.sTableID = tableID;
        this.sName = key;
    }

    public TableContextMenuItemImpl(TableContextMenuItemImpl ti, String key) {
        this.parent = ti;
        this.parent.addChildMenuItem(this);
        this.sTableID = this.parent.getTableID();
        this.sName = key;
    }

    public String getTableID() {
        return this.sTableID;
    }

    public String getResourceKey() {
        return this.sName;
    }

    public int getStyle() {
        return this.style;
    }

    public void setStyle(int _style) {
        if (this.style == 5 && _style != 5) {
            throw new RuntimeException("cannot revert menu style MenuItem object to another style");
        }
        this.style = _style;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object _data) {
        this.data = _data;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean _enabled) {
        this.enabled = _enabled;
    }

    public void setGraphic(Graphic _graphic) {
        this.graphic = _graphic;
    }

    public Graphic getGraphic() {
        return this.graphic;
    }

    public void invokeMenuWillBeShownListeners(TableRow[] rows) {
        for (int i = 0; i < this.fill_listeners.size(); ++i) {
            try {
                ((MenuItemFillListener)this.fill_listeners.get(i)).menuWillBeShown(this, rows);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addFillListener(MenuItemFillListener listener) {
        this.fill_listeners.add(listener);
    }

    public void removeFillListener(MenuItemFillListener listener) {
        this.fill_listeners.remove(listener);
    }

    public void invokeListeners(TableRow[] rows) {
        this.invokeListeners0(this.m_listeners, rows);
        if (!this.listeners.isEmpty()) {
            for (int i = 0; i < rows.length; ++i) {
                this.invokeListeners0(this.listeners, rows[i]);
            }
        }
    }

    private void invokeListeners0(List listeners_to_notify, Object o) {
        for (int i = 0; i < listeners_to_notify.size(); ++i) {
            try {
                ((MenuItemListener)listeners_to_notify.get(i)).selected(this, o);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void addListener(MenuItemListener l) {
        this.listeners.add(l);
    }

    public void removeListener(MenuItemListener l) {
        this.listeners.remove(l);
    }

    public void addMultiListener(MenuItemListener l) {
        this.m_listeners.add(l);
    }

    public void removeMultiListener(MenuItemListener l) {
        this.m_listeners.remove(l);
    }

    public MenuItem getParent() {
        return this.parent;
    }

    public MenuItem[] getItems() {
        if (this.style != 5) {
            return null;
        }
        return this.children.toArray(new TableContextMenuItem[this.children.size()]);
    }

    public MenuItem getItem(String key) {
        if (this.style != 5) {
            return null;
        }
        Iterator itr = this.children.iterator();
        TableContextMenuItem result = null;
        while (itr.hasNext()) {
            result = (TableContextMenuItem)itr.next();
            if (!key.equals(result.getResourceKey())) continue;
            return result;
        }
        return null;
    }

    private void addChildMenuItem(TableContextMenuItem child) {
        if (this.style != 5) {
            throw new RuntimeException("cannot add to non-container MenuItem");
        }
        this.children.add(child);
    }

    public String getText() {
        if (this.display_text == null) {
            return MessageText.getString(this.getResourceKey());
        }
        return this.display_text;
    }

    public void setText(String text) {
        this.display_text = text;
    }
}

