/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.ui.tables;

import java.util.ArrayList;
import java.util.List;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.UIInstance;
import org.gudy.azureus2.plugins.ui.UIManagerListener;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.menus.MenuItem;
import org.gudy.azureus2.plugins.ui.menus.MenuItemFillListener;
import org.gudy.azureus2.plugins.ui.menus.MenuItemListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableContextMenuItem;
import org.gudy.azureus2.plugins.ui.tables.TableManager;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerEventAdapter;
import org.gudy.azureus2.pluginsimpl.local.ui.UIManagerImpl;
import org.gudy.azureus2.pluginsimpl.local.ui.tables.TableContextMenuItemImpl;

public class TableManagerImpl
implements TableManager {
    private UIManagerImpl ui_manager;

    public TableManagerImpl(UIManagerImpl _ui_manager) {
        this.ui_manager = _ui_manager;
    }

    public TableColumn createColumn(String tableID, String cellID) {
        return new TableColumnDelegate(tableID, cellID);
    }

    public void addColumn(TableColumn tableColumn) {
        if (!(tableColumn instanceof TableColumnDelegate)) {
            throw new UIRuntimeException("table column must have been created via createColumn");
        }
        ((TableColumnDelegate)tableColumn).addToUI();
    }

    public TableContextMenuItem addContextMenuItem(TableContextMenuItem parent, String resourceKey) {
        if (!(parent instanceof TableContextMenuItemImpl)) {
            throw new UIRuntimeException("parent must have been created by addContextMenuItem");
        }
        if (parent.getStyle() != 5) {
            throw new UIRuntimeException("parent menu item must have the menu style associated");
        }
        TableContextMenuItemImpl item = new TableContextMenuItemImpl((TableContextMenuItemImpl)parent, resourceKey);
        UIManagerImpl.fireEvent(14, item);
        return item;
    }

    public TableContextMenuItem addContextMenuItem(String tableID, String resourceKey) {
        TableContextMenuItemImpl item = new TableContextMenuItemImpl(tableID, resourceKey);
        UIManagerImpl.fireEvent(12, item);
        return item;
    }

    protected class TableColumnDelegate
    implements TableColumn,
    UIManagerListener {
        private TableColumn delegate;
        private boolean added_to_ui;
        private String cell_id;
        private String table_id;
        private int type = 3;
        private int alignment = 1;
        private int position = -1;
        private int width = 50;
        private int interval = -3;
        private List cell_added_listeners = new ArrayList();
        private List cell_dispose_listeners = new ArrayList();
        private List cell_mouse_listeners = new ArrayList();
        private List cell_refresh_listeners = new ArrayList();
        private List cell_tooltip_listeners = new ArrayList();
        private List context_memu_items = new ArrayList();
        private List general_listeners = new ArrayList();

        protected TableColumnDelegate(String t, String c) {
            this.table_id = t;
            this.cell_id = c;
            TableManagerImpl.this.ui_manager.addUIListener(this);
        }

        public void UIAttached(UIInstance ui_instance) {
            if (this.delegate != null) {
                return;
            }
            UIManagerEventAdapter event2 = new UIManagerEventAdapter(10, new String[]{this.table_id, this.cell_id});
            if (UIManagerImpl.fireEvent(event2)) {
                int i;
                this.delegate = (TableColumn)event2.getResult();
                this.delegate.setAlignment(this.alignment);
                this.delegate.setPosition(this.position);
                this.delegate.setRefreshInterval(this.interval);
                this.delegate.setType(this.type);
                this.delegate.setWidth(this.width);
                for (i = 0; i < this.cell_added_listeners.size(); ++i) {
                    this.delegate.addCellAddedListener((TableCellAddedListener)this.cell_added_listeners.get(i));
                }
                for (i = 0; i < this.cell_dispose_listeners.size(); ++i) {
                    this.delegate.addCellDisposeListener((TableCellDisposeListener)this.cell_dispose_listeners.get(i));
                }
                for (i = 0; i < this.cell_refresh_listeners.size(); ++i) {
                    this.delegate.addCellRefreshListener((TableCellRefreshListener)this.cell_refresh_listeners.get(i));
                }
                for (i = 0; i < this.cell_tooltip_listeners.size(); ++i) {
                    this.delegate.addCellToolTipListener((TableCellToolTipListener)this.cell_tooltip_listeners.get(i));
                }
                for (i = 0; i < this.cell_mouse_listeners.size(); ++i) {
                    this.delegate.addCellMouseListener((TableCellMouseListener)this.cell_mouse_listeners.get(i));
                }
                for (i = 0; i < this.general_listeners.size(); ++i) {
                    this.delegate.addListeners(this.general_listeners.get(i));
                }
                for (i = 0; i < this.context_memu_items.size(); ++i) {
                    TableContextMenuItemDelegate d = (TableContextMenuItemDelegate)this.context_memu_items.get(i);
                    d.setDelegate(this.delegate);
                }
                if (this.added_to_ui) {
                    this.addToUI();
                }
            }
        }

        public void UIDetached(UIInstance instance) {
        }

        protected void addToUI() {
            this.added_to_ui = true;
            if (this.delegate != null) {
                UIManagerEventAdapter event2 = new UIManagerEventAdapter(11, this.delegate);
                UIManagerImpl.fireEvent(event2);
            }
        }

        public void initialize(int iAlignment, int iPosition, int iWidth, int iInterval) {
            if (this.delegate == null) {
                this.alignment = iAlignment;
                this.position = iPosition;
                this.width = iWidth;
                this.interval = iInterval;
            } else {
                this.delegate.initialize(iAlignment, iPosition, iWidth, iInterval);
            }
        }

        public void initialize(int iAlignment, int iPosition, int iWidth) {
            if (this.delegate == null) {
                this.alignment = iAlignment;
                this.position = iPosition;
                this.width = iWidth;
            } else {
                this.delegate.initialize(iAlignment, iPosition, iWidth);
            }
        }

        public String getName() {
            return this.cell_id;
        }

        public String getTableID() {
            return this.table_id;
        }

        public void setType(int _type) {
            if (this.delegate == null) {
                this.type = _type;
            } else {
                this.delegate.setType(_type);
            }
        }

        public int getType() {
            return this.delegate == null ? this.type : this.delegate.getType();
        }

        public void setWidth(int _width) {
            if (this.delegate == null) {
                this.width = _width;
            } else {
                this.delegate.setWidth(_width);
            }
        }

        public int getWidth() {
            return this.delegate == null ? this.width : this.delegate.getWidth();
        }

        public void setPosition(int _position) {
            if (this.delegate == null) {
                this.position = _position;
            } else {
                this.delegate.setPosition(_position);
            }
        }

        public int getPosition() {
            return this.delegate == null ? this.position : this.delegate.getPosition();
        }

        public void setAlignment(int _alignment) {
            if (this.delegate == null) {
                this.alignment = _alignment;
            } else {
                this.delegate.setAlignment(_alignment);
            }
        }

        public int getAlignment() {
            return this.delegate == null ? this.alignment : this.delegate.getAlignment();
        }

        public void setRefreshInterval(int _interval) {
            if (this.delegate == null) {
                this.interval = _interval;
            } else {
                this.delegate.setRefreshInterval(_interval);
            }
        }

        public int getRefreshInterval() {
            return this.delegate == null ? this.interval : this.delegate.getRefreshInterval();
        }

        public void invalidateCells() {
            if (this.delegate != null) {
                this.delegate.invalidateCells();
            }
        }

        public void addCellRefreshListener(TableCellRefreshListener listener) {
            if (this.delegate == null) {
                this.cell_refresh_listeners.add(listener);
            } else {
                this.delegate.addCellRefreshListener(listener);
            }
        }

        public void removeCellRefreshListener(TableCellRefreshListener listener) {
            if (this.delegate == null) {
                this.cell_refresh_listeners.remove(listener);
            } else {
                this.delegate.removeCellRefreshListener(listener);
            }
        }

        public void addCellAddedListener(TableCellAddedListener listener) {
            if (this.delegate == null) {
                this.cell_added_listeners.add(listener);
            } else {
                this.delegate.addCellAddedListener(listener);
            }
        }

        public void removeCellAddedListener(TableCellAddedListener listener) {
            if (this.delegate == null) {
                this.cell_added_listeners.remove(listener);
            } else {
                this.delegate.removeCellAddedListener(listener);
            }
        }

        public void addCellDisposeListener(TableCellDisposeListener listener) {
            if (this.delegate == null) {
                this.cell_dispose_listeners.add(listener);
            } else {
                this.delegate.addCellDisposeListener(listener);
            }
        }

        public void removeCellDisposeListener(TableCellDisposeListener listener) {
            if (this.delegate == null) {
                this.cell_dispose_listeners.remove(listener);
            } else {
                this.delegate.removeCellDisposeListener(listener);
            }
        }

        public void addCellToolTipListener(TableCellToolTipListener listener) {
            if (this.delegate == null) {
                this.cell_tooltip_listeners.add(listener);
            } else {
                this.delegate.addCellToolTipListener(listener);
            }
        }

        public void removeCellToolTipListener(TableCellToolTipListener listener) {
            if (this.delegate == null) {
                this.cell_tooltip_listeners.remove(listener);
            } else {
                this.delegate.removeCellToolTipListener(listener);
            }
        }

        public TableContextMenuItem addContextMenuItem(String resourceKey) {
            if (this.delegate == null) {
                TableContextMenuItemDelegate res = new TableContextMenuItemDelegate(resourceKey);
                this.context_memu_items.add(res);
                return res;
            }
            return this.delegate.addContextMenuItem(resourceKey);
        }

        public void addCellMouseListener(TableCellMouseListener listener) {
            if (this.delegate == null) {
                this.cell_mouse_listeners.add(listener);
            } else {
                this.delegate.addCellMouseListener(listener);
            }
        }

        public void removeCellMouseListener(TableCellMouseListener listener) {
            if (this.delegate == null) {
                this.cell_mouse_listeners.remove(listener);
            } else {
                this.delegate.removeCellMouseListener(listener);
            }
        }

        public void addListeners(Object listenerObject) {
            if (this.delegate == null) {
                this.general_listeners.add(listenerObject);
            } else {
                this.delegate.addListeners(listenerObject);
            }
        }

        public boolean isObfusticated() {
            return this.delegate == null ? false : this.delegate.isObfusticated();
        }

        public void setObfustication(boolean hideData) {
            if (this.delegate != null) {
                this.delegate.setObfustication(hideData);
            }
        }

        protected class TableContextMenuItemDelegate
        implements TableContextMenuItem {
            private TableContextMenuItem delegate;
            private String resource_key;
            private int style = 1;
            private boolean enabled = true;
            private Object data;
            private Graphic graphic;
            private List listeners = new ArrayList();
            private List m_listeners = new ArrayList();
            private List fill_listeners = new ArrayList();
            private String display_text = null;

            protected TableContextMenuItemDelegate(String _resource_key) {
                this.resource_key = _resource_key;
            }

            protected void setDelegate(TableColumn _delegate) {
                int i;
                this.delegate = _delegate.addContextMenuItem(this.resource_key);
                this.delegate.setData(this.data);
                this.delegate.setEnabled(this.enabled);
                this.delegate.setGraphic(this.graphic);
                this.delegate.setStyle(this.style);
                for (i = 0; i < this.listeners.size(); ++i) {
                    this.delegate.addListener((MenuItemListener)this.listeners.get(i));
                }
                for (i = 0; i < this.listeners.size(); ++i) {
                    this.delegate.addMultiListener((MenuItemListener)this.m_listeners.get(i));
                }
                for (i = 0; i < this.fill_listeners.size(); ++i) {
                    this.delegate.addFillListener((MenuItemFillListener)this.fill_listeners.get(i));
                }
            }

            public String getTableID() {
                return TableColumnDelegate.this.table_id;
            }

            public String getResourceKey() {
                return this.resource_key;
            }

            public int getStyle() {
                return this.delegate == null ? this.style : this.delegate.getStyle();
            }

            public void setStyle(int _style) {
                if (this.delegate == null) {
                    this.style = _style;
                } else {
                    this.delegate.setStyle(_style);
                }
            }

            public Object getData() {
                return this.delegate == null ? this.data : this.delegate.getData();
            }

            public void setData(Object _data) {
                if (this.delegate == null) {
                    this.data = _data;
                } else {
                    this.delegate.setData(_data);
                }
            }

            public boolean isEnabled() {
                return this.delegate == null ? this.enabled : this.delegate.isEnabled();
            }

            public void setEnabled(boolean _enabled) {
                if (this.delegate == null) {
                    this.enabled = _enabled;
                } else {
                    this.delegate.setEnabled(_enabled);
                }
            }

            public void setGraphic(Graphic _graphic) {
                if (this.delegate == null) {
                    this.graphic = _graphic;
                } else {
                    this.delegate.setGraphic(_graphic);
                }
            }

            public Graphic getGraphic() {
                return this.delegate == null ? this.graphic : this.delegate.getGraphic();
            }

            public void addFillListener(MenuItemFillListener listener) {
                if (this.delegate == null) {
                    this.fill_listeners.add(listener);
                } else {
                    this.delegate.addFillListener(listener);
                }
            }

            public void removeFillListener(MenuItemFillListener listener) {
                if (this.delegate == null) {
                    this.fill_listeners.remove(listener);
                } else {
                    this.delegate.removeFillListener(listener);
                }
            }

            public void addListener(MenuItemListener listener) {
                if (this.delegate == null) {
                    this.listeners.add(listener);
                } else {
                    this.delegate.addListener(listener);
                }
            }

            public void removeListener(MenuItemListener listener) {
                if (this.delegate == null) {
                    this.listeners.remove(listener);
                } else {
                    this.delegate.removeListener(listener);
                }
            }

            public void addMultiListener(MenuItemListener listener) {
                if (this.delegate == null) {
                    this.m_listeners.add(listener);
                } else {
                    this.delegate.addMultiListener(listener);
                }
            }

            public void removeMultiListener(MenuItemListener listener) {
                if (this.delegate == null) {
                    this.m_listeners.remove(listener);
                } else {
                    this.delegate.removeMultiListener(listener);
                }
            }

            public MenuItem[] getItems() {
                if (this.delegate == null) {
                    if (this.getStyle() == 5) {
                        return new TableContextMenuItem[0];
                    }
                    return null;
                }
                return this.delegate.getItems();
            }

            public String getText() {
                return this.delegate == null ? this.display_text : this.delegate.getText();
            }

            public void setText(String text) {
                if (this.delegate == null) {
                    this.display_text = text;
                } else {
                    this.delegate.setText(text);
                }
            }

            public MenuItem getParent() {
                if (this.delegate == null) {
                    return null;
                }
                return this.delegate.getParent();
            }

            public MenuItem getItem(String key) {
                if (this.delegate == null) {
                    return null;
                }
                return this.delegate.getItem(key);
            }
        }
    }
}

