/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.update;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.update.UpdateException;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.update.UpdateManager;

public class UpdateInstallerImpl
implements UpdateInstaller {
    protected static final String UPDATE_DIR = "updates";
    protected static final String ACTIONS = "install.act";
    protected static AEMonitor class_mon = new AEMonitor("UpdateInstaller:class");
    private UpdateManager manager;
    private File install_dir;

    protected static void checkForFailedInstalls(UpdateManager manager) {
        try {
            File update_dir = new File(manager.getUserDir() + File.separator + UPDATE_DIR);
            File[] dirs = update_dir.listFiles();
            if (dirs != null) {
                boolean found_failure = false;
                for (int i = 0; i < dirs.length; ++i) {
                    File dir = dirs[i];
                    if (!dir.isDirectory()) continue;
                    found_failure = true;
                    FileUtil.recursiveDelete(dir);
                }
                if (found_failure) {
                    Logger.log(new LogAlert(false, 3, "Installation of at least one component failed - see 'update.log' for details"));
                }
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected UpdateInstallerImpl(UpdateManager _manager) throws UpdateException {
        this.manager = _manager;
        try {
            class_mon.enter();
            String update_dir = this.getUserDir() + File.separator + UPDATE_DIR;
            for (int i = 1; i < 1024; ++i) {
                File try_dir = new File(update_dir + File.separator + "inst_" + i);
                if (try_dir.exists()) continue;
                if (!FileUtil.mkdirs(try_dir)) {
                    throw new UpdateException("Failed to create a temporary installation dir");
                }
                this.install_dir = try_dir;
                break;
            }
            if (this.install_dir == null) {
                throw new UpdateException("Failed to find a temporary installation dir");
            }
        }
        finally {
            class_mon.exit();
        }
    }

    public void addResource(String resource_name, InputStream is) throws UpdateException {
        this.addResource(resource_name, is, true);
    }

    public void addResource(String resource_name, InputStream is, boolean closeInputStream) throws UpdateException {
        try {
            File target_file = new File(this.install_dir, resource_name);
            FileUtil.copyFile(is, (OutputStream)new FileOutputStream(target_file), closeInputStream);
        }
        catch (Throwable e) {
            throw new UpdateException("UpdateInstaller: resource addition fails", e);
        }
    }

    public String getInstallDir() {
        return this.manager.getInstallDir();
    }

    public String getUserDir() {
        return this.manager.getUserDir();
    }

    public void addMoveAction(String from_file_or_resource, String to_file) throws UpdateException {
        if (from_file_or_resource.indexOf(File.separator) == -1) {
            from_file_or_resource = this.install_dir.toString() + File.separator + from_file_or_resource;
        }
        try {
            File to_f = new File(to_file);
            File parent = to_f.getParentFile();
            if (parent != null && !parent.canWrite()) {
                Logger.log(new LogAlert(false, 1, "The location '" + parent.toString() + "' isn't writable, this update will probably fail." + " Check permissions and rety the update"));
            }
            try {
                PlatformManager pm = PlatformManagerFactory.getPlatformManager();
                if (pm.hasCapability(PlatformManagerCapabilities.CopyFilePermissions)) {
                    String parent_str = parent.getAbsolutePath();
                    PlatformManagerFactory.getPlatformManager().copyFilePermissions(parent_str, from_file_or_resource);
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.appendAction("move," + from_file_or_resource + "," + to_file);
    }

    public void addChangeRightsAction(String rights, String to_file) throws UpdateException {
        this.appendAction("chmod," + rights + "," + to_file);
    }

    public void addRemoveAction(String file) throws UpdateException {
        this.appendAction("remove," + file);
    }

    protected void appendAction(String data) throws UpdateException {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new FileWriter(this.install_dir.toString() + File.separator + ACTIONS, true));
            pw.println(data);
        }
        catch (Throwable e) {
            throw new UpdateException("Failed to write actions file", e);
        }
        finally {
            if (pw != null) {
                try {
                    pw.close();
                }
                catch (Throwable e) {
                    throw new UpdateException("Failed to write actions file", e);
                }
            }
        }
    }
}

