/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.gudy.azureus2.core3.security.SEPasswordListener;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.AddressUtils;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderException;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderBaseImpl;

public class ResourceDownloaderURLImpl
extends ResourceDownloaderBaseImpl
implements SEPasswordListener {
    private static final int BUFFER_SIZE = 32768;
    protected URL original_url;
    protected boolean auth_supplied;
    protected String user_name;
    protected String password;
    protected InputStream input_stream;
    protected boolean cancel_download = false;
    protected boolean download_initiated;
    protected long size = -2L;
    private final String postData;

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url) {
        this(_parent, _url, false, null, null);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _user_name, String _password) {
        this(_parent, _url, true, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, boolean _auth_supplied, String _user_name, String _password) {
        this(_parent, _url, null, _auth_supplied, _user_name, _password);
    }

    public ResourceDownloaderURLImpl(ResourceDownloaderBaseImpl _parent, URL _url, String _data, boolean _auth_supplied, String _user_name, String _password) {
        super(_parent);
        this.original_url = _url;
        this.postData = _data;
        this.auth_supplied = _auth_supplied;
        this.user_name = _user_name;
        this.password = _password;
    }

    protected URL getURL() {
        return this.original_url;
    }

    public String getName() {
        return this.original_url.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getSize() throws ResourceDownloaderException {
        if (this.size == -2L) {
            try {
                ResourceDownloaderURLImpl c = (ResourceDownloaderURLImpl)this.getClone(this);
                this.addReportListener(c);
                this.size = c.getSizeSupport();
                this.setProperties(c);
            }
            finally {
                if (this.size == -2L) {
                    this.size = -1L;
                }
            }
        }
        return this.size;
    }

    protected void setSize(long l) {
        this.size = l;
    }

    protected void setProperty(String name, Object value) {
        this.setPropertySupport(name, value);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected long getSizeSupport() throws ResourceDownloaderException {
        try {
            String protocol = this.original_url.getProtocol().toLowerCase();
            if (protocol.equals("magnet")) {
                return -1L;
            }
            this.reportActivity(this, "Getting size of " + this.original_url);
            try {
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                url = AddressUtils.adjustURL(url);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.addPasswordHandler(url, this);
                    }
                    int i = 0;
                    while (i < 2) {
                        try {
                            HttpURLConnection con;
                            if (url.getProtocol().equalsIgnoreCase("https")) {
                                HttpsURLConnection ssl_con = (HttpsURLConnection)url.openConnection();
                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String host, SSLSession session) {
                                        return true;
                                    }
                                });
                                con = ssl_con;
                            } else {
                                con = (HttpURLConnection)url.openConnection();
                            }
                            con.setRequestMethod("HEAD");
                            con.setRequestProperty("User-Agent", "Azureus 2.5.0.4");
                            con.connect();
                            int response = con.getResponseCode();
                            if (response != 202 && response != 200) {
                                throw new ResourceDownloaderException("Error on connect for '" + url.toString() + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                            }
                            this.setProperty("ContentType", con.getContentType());
                            long l = con.getContentLength();
                            return l;
                        }
                        catch (SSLException e) {
                            if (i != 0) throw e;
                            if (SESecurityManager.installServerCertificates(url) == null) throw e;
                            ++i;
                        }
                    }
                    throw new ResourceDownloaderException("Should never get here");
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.removePasswordHandler(url, this);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.original_url + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.original_url + "':" + e.toString(), e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde;
            if (e instanceof ResourceDownloaderException) {
                rde = (ResourceDownloaderException)e;
                throw rde;
            }
            rde = new ResourceDownloaderException("Unexpected error", e);
            throw rde;
        }
    }

    public ResourceDownloaderBaseImpl getClone(ResourceDownloaderBaseImpl parent) {
        ResourceDownloaderURLImpl c = new ResourceDownloaderURLImpl(parent, this.original_url, this.postData, this.auth_supplied, this.user_name, this.password);
        c.setSize(this.size);
        c.setProperties(this);
        return c;
    }

    public void asyncDownload() {
        AEThread t = new AEThread("ResourceDownloader:asyncDownload"){

            public void runSupport() {
                try {
                    ResourceDownloaderURLImpl.this.download();
                }
                catch (ResourceDownloaderException resourceDownloaderException) {
                    // empty catch block
                }
            }
        };
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public InputStream download() throws ResourceDownloaderException {
        try {
            this.reportActivity(this, this.getLogIndent() + "Downloading: " + this.original_url);
            try {
                this.this_mon.enter();
                if (this.download_initiated) {
                    throw new ResourceDownloaderException("Download already initiated");
                }
                this.download_initiated = true;
            }
            finally {
                this.this_mon.exit();
            }
            try {
                URL url = new URL(this.original_url.toString().replaceAll(" ", "%20"));
                String protocol = url.getProtocol().toLowerCase();
                if (url.getPort() == -1 && !protocol.equals("magnet")) {
                    int target_port = protocol.equals("http") ? 80 : 443;
                    try {
                        String str = this.original_url.toString().replaceAll(" ", "%20");
                        int pos = str.indexOf("://");
                        pos = str.indexOf("/", pos + 4);
                        url = pos == -1 ? new URL(str + ":" + target_port + "/") : new URL(str.substring(0, pos) + ":" + target_port + str.substring(pos));
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
                url = AddressUtils.adjustURL(url);
                try {
                    if (this.auth_supplied) {
                        SESecurityManager.addPasswordHandler(url, this);
                    }
                    int i = 0;
                    while (i < 2) {
                        try {
                            ByteArrayOutputStream baos;
                            HttpURLConnection con;
                            if (url.getProtocol().equalsIgnoreCase("https")) {
                                HttpsURLConnection ssl_con = (HttpsURLConnection)url.openConnection();
                                ssl_con.setHostnameVerifier(new HostnameVerifier(){

                                    public boolean verify(String host, SSLSession session) {
                                        return true;
                                    }
                                });
                                con = ssl_con;
                            } else {
                                con = (HttpURLConnection)url.openConnection();
                            }
                            con.setRequestProperty("User-Agent", "Azureus 2.5.0.4");
                            con.setRequestProperty("Connection", "close");
                            con.addRequestProperty("Accept-Encoding", "gzip");
                            if (this.postData != null) {
                                con.setDoOutput(true);
                                con.setRequestMethod("POST");
                                OutputStreamWriter wr = new OutputStreamWriter(con.getOutputStream());
                                wr.write(this.postData);
                                wr.flush();
                            }
                            con.connect();
                            int response = con.getResponseCode();
                            if (response != 202 && response != 200) {
                                throw new ResourceDownloaderException("Error on connect for '" + url.toString() + "': " + Integer.toString(response) + " " + con.getResponseMessage());
                            }
                            boolean gzip = false;
                            try {
                                this.this_mon.enter();
                                this.input_stream = con.getInputStream();
                                String encoding = con.getHeaderField("content-encoding");
                                boolean bl = gzip = encoding != null && encoding.equalsIgnoreCase("gzip");
                                if (gzip) {
                                    this.input_stream = new GZIPInputStream(this.input_stream);
                                }
                            }
                            finally {
                                this.this_mon.exit();
                            }
                            try {
                                int read;
                                byte[] buf = new byte[32768];
                                int total_read = 0;
                                int size = gzip ? -1 : con.getContentLength();
                                ByteArrayOutputStream byteArrayOutputStream = baos = size > 0 ? new ByteArrayOutputStream(size) : new ByteArrayOutputStream();
                                while (!this.cancel_download && (read = this.input_stream.read(buf)) > 0) {
                                    baos.write(buf, 0, read);
                                    total_read += read;
                                    if (size <= 0) continue;
                                    this.informPercentDone(100 * total_read / size);
                                }
                                if (size > 0 && total_read != size) {
                                    if (total_read <= size) throw new IOException("Premature end of stream");
                                    Debug.out("Inconsistent stream length for '" + this.original_url + "': expected = " + size + ", actual = " + total_read);
                                }
                            }
                            finally {
                                this.input_stream.close();
                            }
                            ByteArrayInputStream res = new ByteArrayInputStream(baos.toByteArray());
                            if (!this.informComplete(res)) throw new ResourceDownloaderException("Contents downloaded but rejected: '" + this.original_url + "'");
                            ByteArrayInputStream byteArrayInputStream = res;
                            return byteArrayInputStream;
                        }
                        catch (SSLException e) {
                            if (i != 0) throw e;
                            if (SESecurityManager.installServerCertificates(url) == null) throw e;
                            ++i;
                        }
                    }
                    throw new ResourceDownloaderException("Should never get here");
                }
                finally {
                    if (this.auth_supplied) {
                        SESecurityManager.removePasswordHandler(url, this);
                    }
                }
            }
            catch (MalformedURLException e) {
                throw new ResourceDownloaderException("Exception while parsing URL '" + this.original_url + "':" + e.getMessage(), e);
            }
            catch (UnknownHostException e) {
                throw new ResourceDownloaderException("Exception while initializing download of '" + this.original_url + "': Unknown Host '" + e.getMessage() + "'", e);
            }
            catch (IOException e) {
                throw new ResourceDownloaderException("I/O Exception while downloading '" + this.original_url + "':" + e.toString(), e);
            }
        }
        catch (Throwable e) {
            ResourceDownloaderException rde = e instanceof ResourceDownloaderException ? (ResourceDownloaderException)e : new ResourceDownloaderException("Unexpected error", e);
            this.informFailed(rde);
            throw rde;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.setCancelled();
        this.cancel_download = true;
        try {
            this.this_mon.enter();
            if (this.input_stream != null) {
                try {
                    this.input_stream.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        finally {
            this.this_mon.exit();
        }
        this.informFailed(new ResourceDownloaderException("Download cancelled"));
    }

    public PasswordAuthentication getAuthentication(String realm, URL tracker) {
        if (this.user_name == null || this.password == null) {
            String user_info = tracker.getUserInfo();
            if (user_info == null) {
                return null;
            }
            String user_bit = user_info;
            String pw_bit = "";
            int pos = user_info.indexOf(58);
            if (pos != -1) {
                user_bit = user_info.substring(0, pos);
                pw_bit = user_info.substring(pos + 1);
            }
            return new PasswordAuthentication(user_bit, pw_bit.toCharArray());
        }
        return new PasswordAuthentication(this.user_name, this.password.toCharArray());
    }

    public void setAuthenticationOutcome(String realm, URL tracker, boolean success) {
    }

    public void clearPasswords() {
    }
}

