/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.plugins.PluginConfig;
import org.gudy.azureus2.plugins.PluginConfigListener;
import org.gudy.azureus2.plugins.PluginException;
import org.gudy.azureus2.plugins.config.ConfigParameter;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestDispatcher;

public class RPPluginConfig
extends RPObject
implements PluginConfig {
    protected transient PluginConfig delegate;
    protected transient Properties property_cache;
    public String[] cached_property_names;
    public Object[] cached_property_values;

    public static PluginConfig create(PluginConfig _delegate) {
        RPPluginConfig res = (RPPluginConfig)RPPluginConfig._lookupLocal(_delegate);
        if (res == null) {
            res = new RPPluginConfig(_delegate);
        }
        return res;
    }

    protected RPPluginConfig(PluginConfig _delegate) {
        super(_delegate);
    }

    protected void _setDelegate(Object _delegate) {
        this.delegate = (PluginConfig)_delegate;
        this.cached_property_names = new String[]{"Max Upload Speed KBs", "Max Upload Speed When Only Seeding KBs", "Max Download Speed KBs", "Max Connections Per Torrent", "Max Connections Global", "Max Downloads", "Max Active Torrents", "Max Active Torrents When Only Seeding", "Max Uploads", "Max Uploads Seeding"};
        this.cached_property_values = new Object[]{new Integer(this.delegate.getIntParameter(this.cached_property_names[0])), new Integer(this.delegate.getIntParameter(this.cached_property_names[1])), new Integer(this.delegate.getIntParameter(this.cached_property_names[2])), new Integer(this.delegate.getIntParameter(this.cached_property_names[3])), new Integer(this.delegate.getIntParameter(this.cached_property_names[4])), new Integer(this.delegate.getIntParameter(this.cached_property_names[5])), new Integer(this.delegate.getIntParameter(this.cached_property_names[6])), new Integer(this.delegate.getIntParameter(this.cached_property_names[7])), new Integer(this.delegate.getIntParameter(this.cached_property_names[8])), new Integer(this.delegate.getIntParameter(this.cached_property_names[9]))};
    }

    public Object _setLocal() throws RPException {
        return this._fixupLocal();
    }

    public void _setRemote(RPRequestDispatcher _dispatcher) {
        super._setRemote(_dispatcher);
        this.property_cache = new Properties();
        for (int i = 0; i < this.cached_property_names.length; ++i) {
            this.property_cache.put(this.cached_property_names[i], this.cached_property_values[i]);
        }
    }

    public RPReply _process(RPRequest request2) {
        String method = request2.getMethod();
        Object[] params = request2.getParams();
        if (method.equals("getPluginIntParameter[String,int]")) {
            return new RPReply(new Integer(this.delegate.getPluginIntParameter((String)params[0], (Integer)params[1])));
        }
        if (method.equals("getPluginStringParameter[String,String]")) {
            return new RPReply(this.delegate.getPluginStringParameter((String)params[0], (String)params[1]));
        }
        if (method.equals("setPluginParameter[String,int]")) {
            this.delegate.setPluginParameter((String)params[0], (Integer)params[1]);
            return null;
        }
        if (method.equals("getIntParameter[String,int]") || method.equals("getParameter[String,int]")) {
            return new RPReply(new Integer(this.delegate.getIntParameter((String)params[0], (Integer)params[1])));
        }
        if (method.equals("setParameter[String,int]")) {
            this.delegate.setIntParameter((String)params[0], (Integer)params[1]);
            return null;
        }
        if (method.equals("save")) {
            try {
                this.delegate.save();
                return null;
            }
            catch (PluginException e) {
                return new RPReply(e);
            }
        }
        throw new RPException("Unknown method: " + method);
    }

    public boolean isNewInstall() {
        this.notSupported();
        return false;
    }

    public String getPluginConfigKeyPrefix() {
        this.notSupported();
        return null;
    }

    public float getFloatParameter(String key) {
        this.notSupported();
        return 0.0f;
    }

    public int getIntParameter(String key) {
        this.notSupported();
        return 0;
    }

    public int getIntParameter(String key, int default_value) {
        Integer res = (Integer)this.property_cache.get(key);
        if (res == null) {
            res = (Integer)this._dispatcher.dispatch(new RPRequest(this, "getIntParameter[String,int]", new Object[]{key, new Integer(default_value)})).getResponse();
        }
        return res;
    }

    public void setIntParameter(String key, int value) {
        this.property_cache.put(key, new Integer(value));
        this._dispatcher.dispatch(new RPRequest(this, "setParameter[String,int]", new Object[]{key, new Integer(value)})).getResponse();
    }

    public String getStringParameter(String key) {
        this.notSupported();
        return null;
    }

    public String getStringParameter(String name, String _default) {
        this.notSupported();
        return null;
    }

    public boolean getBooleanParameter(String key) {
        this.notSupported();
        return false;
    }

    public boolean getBooleanParameter(String key, boolean _default) {
        this.notSupported();
        return false;
    }

    public void setBooleanParameter(String key, boolean value) {
        this.notSupported();
    }

    public byte[] getByteParameter(String name, byte[] _default) {
        this.notSupported();
        return null;
    }

    public List getPluginListParameter(String key, List default_value) {
        this.notSupported();
        return null;
    }

    public void setPluginListParameter(String key, List value) {
        this.notSupported();
    }

    public Map getPluginMapParameter(String key, Map default_value) {
        this.notSupported();
        return null;
    }

    public void setPluginMapParameter(String key, Map value) {
        this.notSupported();
    }

    public int getPluginIntParameter(String key) {
        this.notSupported();
        return 0;
    }

    public int getPluginIntParameter(String key, int defaultValue) {
        Integer res = (Integer)this._dispatcher.dispatch(new RPRequest(this, "getPluginIntParameter[String,int]", new Object[]{key, new Integer(defaultValue)})).getResponse();
        return res;
    }

    public String getPluginStringParameter(String key) {
        this.notSupported();
        return null;
    }

    public String getPluginStringParameter(String key, String defaultValue) {
        String res = (String)this._dispatcher.dispatch(new RPRequest(this, "getPluginStringParameter[String,String]", new Object[]{key, defaultValue})).getResponse();
        return res;
    }

    public boolean getPluginBooleanParameter(String key) {
        this.notSupported();
        return false;
    }

    public byte[] getPluginByteParameter(String key, byte[] defaultValue) {
        this.notSupported();
        return null;
    }

    public boolean getPluginBooleanParameter(String key, boolean defaultValue) {
        this.notSupported();
        return false;
    }

    public void setPluginParameter(String key, int value) {
        this._dispatcher.dispatch(new RPRequest(this, "setPluginParameter[String,int]", new Object[]{key, new Integer(value)}));
    }

    public void setPluginParameter(String key, int value, boolean global) {
        this.notSupported();
    }

    public void setPluginParameter(String key, String value) {
        this.notSupported();
    }

    public void setPluginParameter(String key, boolean value) {
        this.notSupported();
    }

    public void setPluginParameter(String key, byte[] value) {
        this.notSupported();
    }

    public ConfigParameter getParameter(String key) {
        this.notSupported();
        return null;
    }

    public ConfigParameter getPluginParameter(String key) {
        this.notSupported();
        return null;
    }

    public boolean getUnsafeBooleanParameter(String key, boolean default_value) {
        this.notSupported();
        return false;
    }

    public void setUnsafeBooleanParameter(String key, boolean value) {
        this.notSupported();
    }

    public int getUnsafeIntParameter(String key, int default_value) {
        this.notSupported();
        return 0;
    }

    public void setUnsafeIntParameter(String key, int value) {
        this.notSupported();
    }

    public long getUnsafeLongParameter(String key, long default_value) {
        this.notSupported();
        return 0L;
    }

    public void setUnsafeLongParameter(String key, long value) {
        this.notSupported();
    }

    public float getUnsafeFloatParameter(String key, float default_value) {
        this.notSupported();
        return 0.0f;
    }

    public void setUnsafeFloatParameter(String key, float value) {
        this.notSupported();
    }

    public String getUnsafeStringParameter(String key, String default_value) {
        this.notSupported();
        return null;
    }

    public void setUnsafeStringParameter(String key, String value) {
        this.notSupported();
    }

    public Map getUnsafeParameterList() {
        this.notSupported();
        return null;
    }

    public void save() throws PluginException {
        try {
            this._dispatcher.dispatch(new RPRequest(this, "save", null)).getResponse();
        }
        catch (RPException e) {
            Throwable cause = e.getCause();
            if (cause instanceof PluginException) {
                throw (PluginException)cause;
            }
            throw e;
        }
    }

    public File getPluginUserFile(String name) {
        this.notSupported();
        return null;
    }

    public void addListener(PluginConfigListener l) {
        this.notSupported();
    }

    public void setPluginConfigKeyPrefix(String _key) {
    }

    public boolean hasParameter(String x) {
        this.notSupported();
        return false;
    }

    public boolean hasPluginParameter(String x) {
        this.notSupported();
        return false;
    }

    public boolean removePluginParameter(String x) {
        this.notSupported();
        return false;
    }
}

