/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.pluginsimpl.remote;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.gudy.azureus2.plugins.PluginManager;
import org.gudy.azureus2.pluginsimpl.remote.MethodSignature;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;

public class RPUtils {
    public static final String PLUGIN_PACKAGE_ROOT = "org.gudy.azureus2.plugins";
    public static final String REMOTE_PLUGIN_PACKAGE_ROOT = "org.gudy.azureus2.pluginsimpl.remote";

    private RPUtils() {
    }

    public static boolean isPluginAPIPackage(Package p) {
        return p != null && p.getName().startsWith(PLUGIN_PACKAGE_ROOT);
    }

    public static boolean isRemotePluginImplPackage(Package p) {
        return p != null && p.getName().startsWith(REMOTE_PLUGIN_PACKAGE_ROOT);
    }

    public static Object invoke(Method m, Object o, Object[] args) throws InvocationTargetException {
        try {
            return m.invoke(o, args);
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException(iae);
        }
        catch (IllegalArgumentException iae) {
            throw new RuntimeException(iae);
        }
    }

    public static Class asRemoteClass(Class c) {
        if (c.isArray()) {
            throw new RuntimeException("array type given");
        }
        Package p = c.getPackage();
        if (p == null || !RPUtils.isPluginAPIPackage(p)) {
            return null;
        }
        if (!c.isInterface()) {
            return null;
        }
        String sub_package_with_dot = "";
        if (PLUGIN_PACKAGE_ROOT.length() < p.getName().length()) {
            sub_package_with_dot = p.getName().substring(PLUGIN_PACKAGE_ROOT.length() + 1) + ".";
        }
        String remote_class_name = "org.gudy.azureus2.pluginsimpl.remote." + sub_package_with_dot + "RP" + RPUtils.getName(c);
        try {
            return Class.forName(remote_class_name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static Class asLocalClass(Class c) {
        String class_name;
        if (c.isArray()) {
            throw new RuntimeException("array type given");
        }
        Package p = c.getPackage();
        if (p == null || !RPUtils.isRemotePluginImplPackage(p)) {
            return null;
        }
        if (c.isInterface()) {
            return null;
        }
        String sub_package_with_dot = "";
        if (REMOTE_PLUGIN_PACKAGE_ROOT.length() < p.getName().length()) {
            sub_package_with_dot = p.getName().substring(REMOTE_PLUGIN_PACKAGE_ROOT.length() + 1) + ".";
        }
        if (!(class_name = RPUtils.getName(c)).startsWith("RP")) {
            return null;
        }
        class_name = class_name.substring(2);
        String remote_class_name = "org.gudy.azureus2.plugins." + sub_package_with_dot + class_name;
        try {
            return Class.forName(remote_class_name);
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
    }

    public static Class[] getPluginAPIInterfacesForClass(Class c) {
        ArrayList result = new ArrayList();
        RPUtils.getPluginAPIInterfacesForClass(c, result);
        return result.toArray(new Class[result.size()]);
    }

    public static Class getPluginAPIInterfaceForClass(Class c) {
        return RPUtils.getPluginAPIInterfacesForClass(c, null);
    }

    private static Class getPluginAPIInterfacesForClass(Class c, ArrayList l) {
        boolean special_class = false;
        if (PluginManager.class.isAssignableFrom(c)) {
            special_class = true;
        }
        if (special_class || c.isInterface() && RPUtils.isPluginAPIPackage(c.getPackage())) {
            if (l == null) {
                return c;
            }
            l.add(c);
        }
        Class<?>[] interfaces = c.getInterfaces();
        Class result = null;
        for (int i = 0; i < interfaces.length; ++i) {
            result = RPUtils.getPluginAPIInterfacesForClass(interfaces[i], l);
            if (result == null) continue;
            return result;
        }
        Class superclass = c.getSuperclass();
        if (superclass != null && (result = RPUtils.getPluginAPIInterfacesForClass(superclass, l)) != null) {
            return result;
        }
        return null;
    }

    public static String getName(Class c) {
        return RPUtils.getName(c, false);
    }

    public static String getName(Class c, boolean include_package) {
        String name_with_pkg;
        int array_dimensions = 0;
        while (c.isArray()) {
            c = c.getComponentType();
            ++array_dimensions;
        }
        String class_name = name_with_pkg = c.getName();
        if (!include_package) {
            int package_separator = name_with_pkg.lastIndexOf(46);
            class_name = package_separator == -1 ? name_with_pkg : name_with_pkg.substring(package_separator + 1);
        }
        for (int i = 0; i < array_dimensions; ++i) {
            class_name = class_name + "[]";
        }
        return class_name;
    }

    public static boolean issubclassByName(Class c, String name) {
        if (RPUtils.getName(c).equals(name)) {
            return true;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!RPUtils.getName(interfaces[i]).equals(name)) continue;
            return true;
        }
        Class superclass = c.getSuperclass();
        return superclass != null && !superclass.equals(Object.class) && RPUtils.issubclassByName(superclass, name);
    }

    public static String toString(Method m) {
        Class<?>[] param_types = m.getParameterTypes();
        ArrayList<String> param_names = new ArrayList<String>(param_types.length);
        for (int i = 0; i < param_types.length; ++i) {
            param_names.add(RPUtils.getName(param_types[i]));
        }
        return MethodSignature.asString(RPUtils.getName(m.getReturnType()), m.getName(), param_names.toArray(new String[param_types.length]));
    }

    public static String describeObject(Object o) {
        if (o == null) {
            return "null";
        }
        Class<?> c = o.getClass();
        int array_length = -1;
        if (c.isArray()) {
            array_length = Array.getLength(o);
            c = c.getComponentType();
        }
        String result = RPUtils.getName(c);
        if (array_length != -1) {
            result = result + "[" + array_length + "]";
        }
        result = result + '@' + Integer.toHexString(System.identityHashCode(o));
        return result;
    }

    public static boolean hasDescriptiveToStringMethod(Object o) {
        if (o == null) {
            return true;
        }
        if (o instanceof Number) {
            return true;
        }
        if (o instanceof String) {
            return true;
        }
        if (o instanceof Character) {
            return true;
        }
        return o instanceof RPObject;
    }

    public static String exceptionToString(Throwable e) {
        Throwable cause = e.getCause();
        if (cause != null) {
            String m = cause.getMessage();
            if (m != null) {
                return m;
            }
            return cause.toString();
        }
        String m = e.getMessage();
        if (m != null) {
            return m;
        }
        return e.toString();
    }
}

