/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.console.commands;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.gudy.azureus2.ui.console.ConsoleInput;
import org.gudy.azureus2.ui.console.commands.OptionsConsoleCommand;

public class Alias
extends OptionsConsoleCommand {
    public Alias() {
        super(new String[]{"alias"});
        this.getOptions().addOption(new Option("d", "delete", false, "delete the specified alias"));
    }

    public String getCommandDescriptions() {
        return "alias [-d] [aliasname] [arguments...]\tadd/modify/delete aliases. use with no argument to show existing aliases";
    }

    public void execute(String commandName, ConsoleInput console, CommandLine commandLine) {
        List args = commandLine.getArgList();
        if (args.isEmpty()) {
            if (commandLine.hasOption('d')) {
                console.out.println(commandName + " --delete requires the name of an alias to remove");
            } else {
                this.printAliases(console);
            }
            return;
        }
        if (commandLine.hasOption('d')) {
            this.deleteAlias(console, (String)args.get(0));
        } else {
            String aliasName = (String)args.remove(0);
            if (args.isEmpty()) {
                this.printAlias(console, aliasName);
            } else {
                this.addAlias(console, aliasName, args);
            }
        }
    }

    private void printAlias(ConsoleInput ci, String aliasName) {
        String aliasText = (String)ci.aliases.get(aliasName);
        if (aliasText == null) {
            ci.out.println("> Error: Alias '" + aliasName + "' does not exist");
        } else {
            ci.out.println("> " + aliasName + "=" + aliasText);
        }
    }

    private void deleteAlias(ConsoleInput ci, String aliasName) {
        if (ci.aliases.remove(aliasName) == null) {
            ci.out.println("> Error: Alias '" + aliasName + "' does not exist");
        } else {
            ci.out.println("> Alias: '" + aliasName + "' deleted");
            ci.saveAliases();
        }
    }

    private void addAlias(ConsoleInput ci, String aliasName, List argList) {
        StringBuffer aliasText = new StringBuffer();
        Iterator iter = argList.iterator();
        while (iter.hasNext()) {
            String arg = (String)iter.next();
            if (arg.indexOf(" ") != -1) {
                aliasText.append("\"").append(arg).append("\"");
            } else {
                aliasText.append(arg);
            }
            aliasText.append(" ");
        }
        ci.aliases.put(aliasName, aliasText.toString());
        ci.saveAliases();
        this.printAlias(ci, aliasName);
    }

    private void printAliases(ConsoleInput ci) {
        Iterator<Object> iter = ci.aliases.keySet().iterator();
        while (iter.hasNext()) {
            String aliasName = (String)iter.next();
            this.printAlias(ci, aliasName);
        }
    }
}

