/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.ILogAlertListener;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;

public class Alerts {
    private static List alert_queue = new ArrayList();
    private static AEMonitor alert_queue_mon = new AEMonitor("Alerts:Q");
    private static List alert_history = new ArrayList();
    private static AEMonitor alert_history_mon = new AEMonitor("Alerts:H");
    private static boolean initialisation_complete = false;
    private static transient boolean stopping;

    private Alerts() {
    }

    public static void showWarningMessageBox(String message) {
        Alerts.showMessageBoxUsingResourceString(8, "AlertMessageBox.warning", message);
    }

    public static void showMessageBoxUsingResourceString(int type, String key, String message) {
        Alerts.showMessageBox(type, MessageText.getString(key), message, null);
    }

    public static void showMessageBox(final int type, final String title, String message, final String details) {
        final Display display = SWTThread.getInstance().getDisplay();
        if (stopping || display.isDisposed()) {
            List close_alerts = COConfigurationManager.getListParameter("Alerts.raised.at.close", new ArrayList());
            HashMap<String, Object> alert_map = new HashMap<String, Object>();
            alert_map.put("type", new Long(type));
            alert_map.put("title", title);
            alert_map.put("message", message);
            if (details != null) {
                alert_map.put("details", details);
            }
            close_alerts.add(alert_map);
            COConfigurationManager.setParameter("Alerts.raised.at.close", close_alerts);
        }
        if (display.isDisposed()) {
            return;
        }
        final String message2 = message != null && COConfigurationManager.getBooleanParameter("Show Timestamp For Alerts") ? "[" + DisplayFormatters.formatDateShort(SystemTime.getCurrentTime()) + "] " + message : message;
        display.asyncExec((Runnable)new AERunnable(){

            public void runSupport() {
                new MessageSlideShell(display, type, title, message2 == null ? "" : message2, details);
            }
        });
    }

    public static void showErrorMessageBoxUsingResourceString(String title_key, Throwable error) {
        Alerts.showErrorMessageBox(MessageText.getString(title_key), error);
    }

    public static void showErrorMessageBox(String message, Throwable error) {
        String error_message = Debug.getStackTrace(error);
        Alerts.showMessageBox(1, MessageText.getString("AlertMessageBox.error"), message + "\n" + Debug.getExceptionMessage(error), error_message);
    }

    public static void showErrorMessageBox(String message) {
        Alerts.showMessageBoxUsingResourceString(1, "AlertMessageBox.error", message);
    }

    public static void showCommentMessageBox(String message) {
        Alerts.showMessageBoxUsingResourceString(2, "AlertMessageBox.information", message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showAlert(String message, Throwable exception, boolean repeatable) {
        try {
            alert_history_mon.enter();
            if (!repeatable) {
                String key = message + ":" + exception.toString();
                if (alert_history.contains(key)) {
                    return;
                }
                alert_history.add(key);
                if (alert_history.size() > 512) {
                    alert_history.remove(0);
                }
            }
        }
        finally {
            alert_history_mon.exit();
        }
        Alerts.showErrorMessageBox(message, exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void showAlert(int type, String message, boolean repeatable) {
        try {
            alert_history_mon.enter();
            if (!repeatable) {
                if (alert_history.contains(message)) {
                    return;
                }
                alert_history.add(message);
                if (alert_history.size() > 512) {
                    alert_history.remove(0);
                }
            }
        }
        finally {
            alert_history_mon.exit();
        }
        if (type == 0) {
            Alerts.showCommentMessageBox(message);
        } else if (type == 1) {
            Alerts.showWarningMessageBox(message);
        } else {
            Alerts.showErrorMessageBox(message);
        }
    }

    public static void initComplete() {
        new AEThread("Init Complete"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void runSupport() {
                try {
                    alert_queue_mon.enter();
                    initialisation_complete = true;
                    for (int i = 0; i < alert_queue.size(); ++i) {
                        Object[] x = (Object[])alert_queue.get(i);
                        boolean repeatable = (Boolean)x[2];
                        if (x[0] instanceof String) {
                            String message = (String)x[0];
                            Throwable exception = (Throwable)x[1];
                            Alerts.showAlert(message, exception, repeatable);
                            continue;
                        }
                        int type = (Integer)x[0];
                        String message = (String)x[1];
                        Alerts.showAlert(type, message, repeatable);
                    }
                    List close_alerts = COConfigurationManager.getListParameter("Alerts.raised.at.close", new ArrayList());
                    if (close_alerts.size() > 0) {
                        COConfigurationManager.setParameter("Alerts.raised.at.close", new ArrayList());
                        String intro = MessageText.getString("alert.raised.at.close") + "\n";
                        for (int i = 0; i < close_alerts.size(); ++i) {
                            try {
                                Map alert_map = (Map)close_alerts.get(i);
                                byte[] details = (byte[])alert_map.get("details");
                                Alerts.showMessageBox(((Long)alert_map.get("type")).intValue(), new String((byte[])alert_map.get("title")), intro + new String((byte[])alert_map.get("message")), details == null ? null : new String(details));
                                continue;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
                        }
                    }
                    alert_queue.clear();
                }
                finally {
                    alert_queue_mon.exit();
                }
            }
        }.start();
    }

    public static void stopInitiated() {
        stopping = true;
    }

    public static void init() {
        Logger.addListener(new ILogAlertListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void alertRaised(LogAlert alert) {
                try {
                    alert_queue_mon.enter();
                    if (!initialisation_complete) {
                        if (alert.err == null) {
                            alert_queue.add(new Object[]{new Integer(alert.entryType), alert.text, new Boolean(alert.repeatable)});
                        } else {
                            alert_queue.add(new Object[]{alert.text, alert.err, new Boolean(alert.repeatable)});
                        }
                        return;
                    }
                }
                finally {
                    alert_queue_mon.exit();
                }
                if (alert.err == null) {
                    Alerts.showAlert(alert.entryType, alert.text, alert.repeatable);
                } else {
                    Alerts.showAlert(alert.text, alert.err, alert.repeatable);
                }
            }
        });
    }
}

