/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.ui.swt.StartServer;
import org.gudy.azureus2.ui.swt.StartSocket;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;

public class Main {
    private static final LogIDs LOGID = LogIDs.GUI;
    public static final String PR_MULTI_INSTANCE = "MULTI_INSTANCE";
    StartServer startServer;

    public Main(String[] args) {
        try {
            COConfigurationManager.preInitialise();
            String mi_str = System.getProperty(PR_MULTI_INSTANCE);
            boolean mi = mi_str != null && mi_str.equalsIgnoreCase("true");
            this.startServer = new StartServer();
            boolean debugGUI = Boolean.getBoolean("debug");
            if (mi || debugGUI) {
                AzureusCore core = AzureusCoreFactory.create();
                new Initializer(core, this.startServer, args);
                return;
            }
            if (Main.processParams(args, this.startServer)) {
                AzureusCore core = AzureusCoreFactory.create();
                this.startServer.pollForConnections(core);
                new Initializer(core, this.startServer, args);
            }
        }
        catch (AzureusCoreException e) {
            Logger.log(new LogEvent(LOGID, "Start failed", e));
        }
    }

    public static boolean processParams(String[] args, StartServer startServer) {
        StartSocket ss;
        boolean another_instance;
        boolean closedown = false;
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equalsIgnoreCase("--closedown")) {
                closedown = true;
                break;
            }
            String filename = arg;
            if (filename.toUpperCase().startsWith("HTTP:") || filename.toUpperCase().startsWith("HTTPS:") || filename.toUpperCase().startsWith("MAGNET:")) {
                Logger.log(new LogEvent(LOGID, "Main::main: args[" + i + "] handling as a URI: " + filename));
                continue;
            }
            try {
                File file = new File(filename);
                if (!file.exists()) {
                    throw new Exception("File not found");
                }
                args[i] = file.getCanonicalPath();
                if (!Logger.isEnabled()) continue;
                Logger.log(new LogEvent(LOGID, "Main::main: args[" + i + "] exists = " + new File(filename).exists()));
                continue;
            }
            catch (Throwable e) {
                Logger.log(new LogAlert(true, 3, "Failed to access torrent file '" + filename + "'. Ensure sufficient temporary " + "file space available (check browser cache usage)."));
            }
        }
        boolean bl = another_instance = startServer.getState() != 1;
        if (another_instance && !(ss = new StartSocket(args)).sendArgs()) {
            another_instance = false;
            String msg = "There appears to be another program process already listening on socket [127.0.0.1: 6880].\nLoading of torrents via command line parameter will fail until this is fixed.";
            System.out.println(msg);
            Logger.log(new LogAlert(true, 1, msg));
        }
        if (!another_instance) {
            return !closedown;
        }
        return false;
    }

    public static void main(String[] args) {
        new Main(args);
    }
}

