/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.StringIterator;
import org.gudy.azureus2.core3.config.StringList;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerInitialisationAdapter;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.LocaleTorrentUtil;
import org.gudy.azureus2.core3.internat.LocaleUtilDecoder;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFile;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloader;
import org.gudy.azureus2.core3.torrentdownloader.TorrentDownloaderCallBackInterface;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.core3.util.HashWrapper;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.FileDownloadWindow;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.OpenUrlWindow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.shells.MessageBoxShell;
import org.gudy.azureus2.ui.swt.shells.MessageSlideShell;

public class OpenTorrentWindow
implements TorrentDownloaderCallBackInterface {
    private static final int MIN_NODOWNLOAD_SIZE = 65536;
    private static final int MAX_NODOWNLOAD_COUNT = 3;
    private static final int MIN_BUTTON_HEIGHT = Constants.isWindows ? 24 : -1;
    private static final String PARAM_DEFSAVEPATH = "Default save path";
    private static final String PARAM_MOVEWHENDONE = "Move Completed When Done";
    private static final int STARTMODE_QUEUED = 0;
    private static final int STARTMODE_STOPPED = 1;
    private static final int STARTMODE_FORCESTARTED = 2;
    private static final int STARTMODE_SEEDING = 3;
    private static final int QUEUELOCATION_TOP = 0;
    private static final int QUEUELOCATION_BOTTOM = 1;
    private static final String[] startModes = new String[]{"queued", "stopped", "forceStarted", "seeding"};
    private static final String[] queueLocations = new String[]{"first", "last"};
    private static OpenTorrentWindow stOpenTorrentWindow = null;
    private Shell shell;
    private Table dataFileTable;
    private Table tableTorrents;
    private Button ok;
    private Combo cmbDataDir;
    private Composite cSaveTo;
    private Combo cmbStartMode = null;
    private Combo cmbQueueLocation = null;
    private GlobalManager gm;
    private ArrayList dataFiles = new ArrayList();
    private ArrayList torrentList = new ArrayList();
    private ArrayList downloaders = new ArrayList();
    private boolean bOverrideStartModeToStopped = false;
    private boolean bDefaultForSeeding;
    private ArrayList disposeList = new ArrayList();
    private boolean bClosed = false;
    private Shell shellForChildren;
    private String sDestDir;
    protected boolean bSkipDataDirModify = false;
    private static final AzureusCore core;
    private StringList dirList;
    private Label dataFileTableLabel;

    public static final synchronized void invoke(Shell parent, GlobalManager gm, String sPathOfFilesToOpen, String[] sFilesToOpen, boolean bDefaultStopped, boolean bForSeeding, boolean bPopupOpenURL) {
        String saveSilentlyDir = null;
        if (stOpenTorrentWindow == null) {
            boolean bMustOpen;
            boolean bl = bMustOpen = sPathOfFilesToOpen == null && sFilesToOpen == null || bForSeeding;
            if (!bMustOpen) {
                saveSilentlyDir = OpenTorrentWindow.getSaveSilentlyDir();
                bMustOpen = saveSilentlyDir == null;
            }
            stOpenTorrentWindow = new OpenTorrentWindow(parent, gm, bMustOpen);
        } else if (OpenTorrentWindow.stOpenTorrentWindow.shell != null) {
            OpenTorrentWindow.stOpenTorrentWindow.shell.forceActive();
        }
        if (stOpenTorrentWindow != null) {
            OpenTorrentWindow openTorrentWindow = stOpenTorrentWindow;
            openTorrentWindow.bOverrideStartModeToStopped = bDefaultStopped;
            openTorrentWindow.bDefaultForSeeding = bForSeeding;
            if (sFilesToOpen != null && !bPopupOpenURL && openTorrentWindow.addTorrents(sPathOfFilesToOpen, sFilesToOpen) == 0 && openTorrentWindow.torrentList.size() == 0 && openTorrentWindow.downloaders.size() == 0) {
                openTorrentWindow.close(true, true);
                return;
            }
            if (bPopupOpenURL) {
                openTorrentWindow.browseURL();
            }
            if (saveSilentlyDir != null) {
                openTorrentWindow.sDestDir = saveSilentlyDir;
                for (int i = 0; i < openTorrentWindow.torrentList.size(); ++i) {
                    TorrentInfo info = (TorrentInfo)openTorrentWindow.torrentList.get(i);
                    info.renameDuplicates();
                }
                openTorrentWindow.openTorrents();
                openTorrentWindow.close(true, false);
            }
        }
    }

    public static final synchronized void invoke(Shell parent, GlobalManager gm) {
        OpenTorrentWindow.invoke(parent, gm, null, null, false, false, false);
    }

    public static final synchronized void invokeURLPopup(Shell parent, GlobalManager gm) {
        OpenTorrentWindow.invoke(parent, gm, null, null, false, false, true);
    }

    private OpenTorrentWindow(Shell parent, GlobalManager gm, boolean bOpenWindow) {
        this.gm = gm;
        this.sDestDir = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH);
        if (bOpenWindow) {
            this.openWindow(parent);
        } else {
            this.shellForChildren = parent;
        }
    }

    private void openWindow(Shell parent) {
        boolean bTorrentInClipboard = false;
        this.shellForChildren = this.shell = ShellFactory.createShell(parent, 2160);
        this.shell.setText(MessageText.getString("OpenTorrentWindow.title"));
        Utils.setShellIcon(this.shell);
        GridLayout layout = this.FixupLayout(new GridLayout(), false);
        this.shell.setLayout((Layout)layout);
        this.shell.addListener(11, new Listener(){

            public void handleEvent(Event e) {
                OpenTorrentWindow.this.resizeTables(3);
            }
        });
        Clipboard clipboard = new Clipboard(this.shell.getDisplay());
        String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
        if (sClipText != null) {
            bTorrentInClipboard = this.addTorrentsFromTextList(sClipText, true) > 0;
        }
        Composite cButtons = new Composite((Composite)this.shell, 0);
        RowLayout rLayout = new RowLayout(256);
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        cButtons.setLayout((Layout)rLayout);
        Button browseTorrent = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)browseTorrent, "OpenTorrentWindow.addFiles");
        browseTorrent.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                FileDialog fDialog = new FileDialog(OpenTorrentWindow.this.shell, 4098);
                fDialog.setFilterExtensions(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterNames(new String[]{"*.torrent", "*.tor", Constants.FILE_WILDCARD});
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setText(MessageText.getString("MainWindow.dialog.choose.file"));
                String fileName = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (fileName != null) {
                    OpenTorrentWindow.this.addTorrents(fDialog.getFilterPath(), fDialog.getFileNames());
                }
            }
        });
        Utils.setGridData(cButtons, 768, (Control)browseTorrent, MIN_BUTTON_HEIGHT);
        Button browseURL = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)browseURL, "OpenTorrentWindow.addFiles.URL");
        browseURL.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.browseURL();
            }
        });
        Button browseFolder = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)browseFolder, "OpenTorrentWindow.addFiles.Folder");
        browseFolder.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog fDialog = new DirectoryDialog(OpenTorrentWindow.this.shell, 0);
                fDialog.setFilterPath(TorrentOpener.getFilterPathTorrent());
                fDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.folder"));
                String path = TorrentOpener.setFilterPathTorrent(fDialog.open());
                if (path != null) {
                    OpenTorrentWindow.this.addTorrents(path, null);
                }
            }
        });
        if (bTorrentInClipboard) {
            Button pasteOpen = new Button(cButtons, 8);
            Messages.setLanguageText((Widget)pasteOpen, "OpenTorrentWindow.addFiles.Clipboard");
            pasteOpen.setToolTipText(sClipText);
            pasteOpen.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    Clipboard clipboard = new Clipboard(OpenTorrentWindow.this.shell.getDisplay());
                    String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (sClipText != null) {
                        OpenTorrentWindow.this.addTorrentsFromTextList(sClipText.trim(), false);
                    }
                }
            });
        }
        Group gTorrentsArea = new Group((Composite)this.shell, 0);
        GridData gridData = new GridData(768);
        gTorrentsArea.setLayoutData((Object)gridData);
        layout = this.FixupLayout(new GridLayout(), true);
        gTorrentsArea.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)gTorrentsArea, "OpenTorrentWindow.torrentLocation");
        Composite cTorrentList = new Composite((Composite)gTorrentsArea, 0);
        gridData = new GridData(768);
        cTorrentList.setLayoutData((Object)gridData);
        this.createTorrentListArea(cTorrentList);
        Composite cTorrentOptions = new Composite((Composite)gTorrentsArea, 0);
        gridData = new GridData(768);
        cTorrentOptions.setLayoutData((Object)gridData);
        layout = this.FixupLayout(new GridLayout(), true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cTorrentOptions.setLayout((Layout)layout);
        Label label = new Label(cTorrentOptions, 0);
        gridData = new GridData(768);
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "OpenTorrentWindow.torrent.options");
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode > 0) {
            Composite cTorrentModes = new Composite(cTorrentOptions, 0);
            gridData = new GridData(768);
            cTorrentModes.setLayoutData((Object)gridData);
            layout = new GridLayout();
            layout.numColumns = 4;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            cTorrentModes.setLayout((Layout)layout);
            label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "OpenTorrentWindow.startMode");
            this.cmbStartMode = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            this.cmbStartMode.setLayoutData((Object)gridData);
            this.updateStartModeCombo();
            this.cmbStartMode.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentWindow.this.setSelectedStartMode(OpenTorrentWindow.this.cmbStartMode.getSelectionIndex());
                }
            });
            label = new Label(cTorrentModes, 0);
            gridData = new GridData(4);
            label.setLayoutData((Object)gridData);
            Messages.setLanguageText((Widget)label, "OpenTorrentWindow.addPosition");
            this.cmbQueueLocation = new Combo(cTorrentModes, 2056);
            gridData = new GridData(768);
            this.cmbQueueLocation.setLayoutData((Object)gridData);
            this.updateQueueLocationCombo();
            this.cmbQueueLocation.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    OpenTorrentWindow.this.setSelectedQueueLocation(OpenTorrentWindow.this.cmbQueueLocation.getSelectionIndex());
                }
            });
        }
        this.cSaveTo = new Composite(cTorrentOptions, 0);
        layout = this.FixupLayout(new GridLayout(), false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.numColumns = 2;
        this.cSaveTo.setLayout((Layout)layout);
        Label lblDataDir = new Label(this.cSaveTo, 0);
        gridData = new GridData(256);
        gridData.horizontalSpan = 2;
        lblDataDir.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)lblDataDir, "OpenTorrentWindow.dataLocation");
        this.cmbDataDir = new Combo(this.cSaveTo, 2048);
        gridData = new GridData(768);
        this.cmbDataDir.setLayoutData((Object)gridData);
        this.cmbDataDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (OpenTorrentWindow.this.bSkipDataDirModify) {
                    return;
                }
                OpenTorrentWindow.this.sDestDir = OpenTorrentWindow.this.cmbDataDir.getText();
                int[] indexes = OpenTorrentWindow.this.tableTorrents.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(indexes[i]);
                    if (info.allFilesMoving()) continue;
                    info.sDestDir = OpenTorrentWindow.this.sDestDir;
                }
                OpenTorrentWindow.this.tableTorrents.clearAll();
                OpenTorrentWindow.this.checkSeedingMode();
                File file = new File(OpenTorrentWindow.this.sDestDir);
                if (!file.isDirectory()) {
                    OpenTorrentWindow.this.cmbDataDir.setBackground(Colors.colorErrorBG);
                } else {
                    OpenTorrentWindow.this.cmbDataDir.setBackground(null);
                }
                OpenTorrentWindow.this.cmbDataDir.redraw();
                OpenTorrentWindow.this.cmbDataDir.update();
            }
        });
        this.updateDataDirCombo();
        if (this.sDestDir != null && this.sDestDir.length() > 0) {
            this.cmbDataDir.add(this.sDestDir);
        }
        this.dirList = COConfigurationManager.getStringListParameter("saveTo_list");
        StringIterator iter = this.dirList.iterator();
        while (iter.hasNext()) {
            String s = iter.next();
            if (s.equals(this.sDestDir)) continue;
            this.cmbDataDir.add(s);
        }
        Button browseData = new Button(this.cSaveTo, 8);
        Messages.setLanguageText((Widget)browseData, "ConfigView.button.browse");
        browseData.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                File file;
                File f;
                String sDefPath = OpenTorrentWindow.this.cmbDataDir.getText();
                if (sDefPath.length() > 0 && !(f = new File(sDefPath)).exists()) {
                    FileUtil.mkdirs(f);
                }
                DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentWindow.this.shell, 131072);
                dDialog.setFilterPath(sDefPath);
                dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath_forallfiles"));
                String sSavePath = dDialog.open();
                if (sSavePath != null) {
                    OpenTorrentWindow.this.cmbDataDir.setText(sSavePath);
                }
                if (!(file = new File(OpenTorrentWindow.this.sDestDir)).isDirectory()) {
                    OpenTorrentWindow.this.cmbDataDir.setBackground(Colors.colorErrorBG);
                } else {
                    OpenTorrentWindow.this.cmbDataDir.setBackground(null);
                }
            }
        });
        gridData = new GridData(768);
        this.cSaveTo.setLayoutData((Object)gridData);
        Group gFilesArea = new Group((Composite)this.shell, 0);
        gridData = new GridData(1808);
        gFilesArea.setLayoutData((Object)gridData);
        layout = this.FixupLayout(new GridLayout(), true);
        gFilesArea.setLayout((Layout)layout);
        Messages.setLanguageText((Widget)gFilesArea, "OpenTorrentWindow.fileList");
        this.createTableDataFiles((Composite)gFilesArea);
        Composite cArea = new Composite((Composite)this.shell, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        this.ok = new Button(cArea, 8);
        Messages.setLanguageText((Widget)this.ok, "Button.ok");
        gridData = new GridData(128);
        gridData.widthHint = 70;
        this.ok.setLayoutData((Object)gridData);
        this.shell.setDefaultButton(this.ok);
        this.ok.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.okPressed();
            }
        });
        this.checkSeedingMode();
        Button cancel = new Button(cArea, 8);
        Messages.setLanguageText((Widget)cancel, "Button.cancel");
        gridData = new GridData();
        gridData.widthHint = 70;
        cancel.setLayoutData((Object)gridData);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.close(true, true);
            }
        });
        Utils.setGridData(cArea, 128, (Control)this.ok, MIN_BUTTON_HEIGHT);
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (!OpenTorrentWindow.this.bClosed) {
                    OpenTorrentWindow.this.close(false, true);
                }
            }
        });
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.detail == 2) {
                    OpenTorrentWindow.this.close(true, true);
                }
            }
        });
        KeyAdapter pasteKeyListener = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = e.character;
                if ((e.stateMask & SWT.MOD1) != 0 && e.character <= '\u001a' && e.character > '\u0000') {
                    key += 96;
                }
                if (key == 118 && (e.stateMask & SWT.MOD1) > 0 || e.keyCode == 0x1000009 && (e.stateMask & 0x20000) > 0) {
                    e.doit = false;
                    Clipboard clipboard = new Clipboard(OpenTorrentWindow.this.shell.getDisplay());
                    String sClipText = (String)clipboard.getContents((Transfer)TextTransfer.getInstance());
                    if (sClipText != null) {
                        OpenTorrentWindow.this.addTorrentsFromTextList(sClipText, false);
                    }
                }
            }
        };
        this.setPasteKeyListener((Control)this.shell, (KeyListener)pasteKeyListener);
        Utils.createTorrentDropTarget((Composite)this.shell, false);
        this.shell.pack();
        if (!Utils.linkShellMetricsToConfig(this.shell, "OpenTorrentWindow")) {
            Utils.centreWindow(this.shell);
        }
        this.resizeTables(3);
        this.shell.open();
        if (this.cSaveTo != null && !this.cSaveTo.isDisposed()) {
            this.cSaveTo.setFocus();
        }
    }

    protected void okPressed() {
        int j;
        File fileDefSavePath;
        if (this.bClosed) {
            return;
        }
        if (this.torrentList.size() == 0 && this.downloaders.size() == 0) {
            this.close(true, false);
            return;
        }
        File file = new File(this.cmbDataDir.getText());
        if (file.equals(fileDefSavePath = new File(COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH))) && !fileDefSavePath.isDirectory()) {
            FileUtil.mkdirs(fileDefSavePath);
        }
        if (this.cmbDataDir.getText().length() == 0 || !file.isDirectory()) {
            Utils.openMessageBox(this.shellForChildren, 33, "OpenTorrentWindow.mb.noGlobalDestDir", new String[]{file.toString()});
            this.cmbDataDir.setFocus();
            return;
        }
        String sExistingFiles = "";
        int iNumExistingFiles = 0;
        block4: for (int i = 0; i < this.torrentList.size(); ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
            file = new File(info.sDestDir);
            if (!file.isDirectory() && !FileUtil.mkdirs(file)) {
                Utils.openMessageBox(this.shellForChildren, 33, "OpenTorrentWindow.mb.noDestDir", new String[]{file.toString(), info.getTorrentName()});
                return;
            }
            if (!info.isValid) {
                Utils.openMessageBox(this.shellForChildren, 33, "OpenTorrentWindow.mb.notValid", new String[]{info.getTorrentName()});
                return;
            }
            TorrentFileInfo[] files = info.getFiles();
            for (j = 0; j < files.length; ++j) {
                TorrentFileInfo fileInfo2 = files[j];
                if (!fileInfo2.getDestFile().exists()) continue;
                sExistingFiles = sExistingFiles + fileInfo2.sFileName + " - " + info.getTorrentName() + "\n";
                if (++iNumExistingFiles > 5) continue block4;
            }
        }
        if (sExistingFiles.length() > 0 && Utils.openMessageBox(this.shellForChildren, 296, "OpenTorrentWindow.mb.existingFiles", new String[]{sExistingFiles}) != 32) {
            return;
        }
        String sDefaultPath = COConfigurationManager.getStringParameter(PARAM_DEFSAVEPATH);
        if (!this.sDestDir.equals(sDefaultPath)) {
            File fDestDir = new File(this.sDestDir);
            int iDirPos = -1;
            for (int i = 0; i < this.dirList.size(); ++i) {
                String sDirName = this.dirList.get(i);
                File dir = new File(sDirName);
                if (!dir.equals(fDestDir)) continue;
                iDirPos = i;
                break;
            }
            if (iDirPos > 0 && iDirPos < this.dirList.size()) {
                this.dirList.remove(iDirPos);
            }
            this.dirList.add(0, this.sDestDir);
            if (this.dirList.size() > 15) {
                this.dirList.remove(this.dirList.size() - 1);
            }
            try {
                for (j = 0; j < this.dirList.size(); ++j) {
                    File dirJ = new File(this.dirList.get(j));
                    for (int i = 0; i < this.dirList.size(); ++i) {
                        try {
                            File dirI;
                            if (i == j || !(dirI = new File(this.dirList.get(i))).equals(dirJ)) continue;
                            this.dirList.remove(i);
                            if (j > i) {
                                --j;
                            }
                            --i;
                            continue;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            COConfigurationManager.setParameter("saveTo_list", this.dirList);
            COConfigurationManager.save();
        }
        if (COConfigurationManager.getBooleanParameter("DefaultDir.AutoUpdate") && !COConfigurationManager.getBooleanParameter("Use default data dir")) {
            COConfigurationManager.setParameter(PARAM_DEFSAVEPATH, this.sDestDir);
        }
        this.openTorrents();
        this.close(true, false);
    }

    private GridLayout FixupLayout(GridLayout layout, boolean bFixMargin) {
        if (Constants.isOSX) {
            layout.horizontalSpacing = 0;
            layout.verticalSpacing = 0;
            if (bFixMargin) {
                layout.marginHeight = 0;
                layout.marginWidth = 0;
            }
        }
        return layout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDataDirCombo() {
        if (this.cmbDataDir == null) {
            return;
        }
        try {
            this.bSkipDataDirModify = true;
            int[] indexes = this.tableTorrents.getSelectionIndices();
            if (indexes.length == 0) {
                this.cmbDataDir.setText(this.sDestDir);
                return;
            }
            boolean allSame = true;
            String lastDir = null;
            for (int i = 0; i < indexes.length; ++i) {
                TorrentInfo info = (TorrentInfo)this.torrentList.get(indexes[i]);
                if (lastDir != null && !info.sDestDir.equals(lastDir)) {
                    allSame = false;
                    break;
                }
                lastDir = info.sDestDir;
            }
            if (allSame && lastDir != null) {
                this.cmbDataDir.setText(lastDir);
                this.sDestDir = lastDir;
            } else {
                this.cmbDataDir.setText("");
            }
        }
        finally {
            this.bSkipDataDirModify = false;
        }
    }

    private void updateStartModeCombo() {
        if (this.cmbStartMode == null) {
            return;
        }
        int[] indexes = this.tableTorrents.getSelectionIndices();
        String[] sItemsText = new String[startModes.length];
        int iMaxMatches = 0;
        int iIndexToSelect = this.getDefaultStartMode();
        for (int i = 0; i < startModes.length; ++i) {
            int iMatches = 0;
            for (int j = 0; j < indexes.length; ++j) {
                TorrentInfo info = (TorrentInfo)this.torrentList.get(indexes[j]);
                if (info.iStartID != i) continue;
                ++iMatches;
            }
            if (iMatches > iMaxMatches) {
                iMaxMatches = iMatches;
                iIndexToSelect = i;
            }
            String sText = MessageText.getString("OpenTorrentWindow.startMode." + startModes[i]);
            if (iMatches > 0) {
                sText = sText + " " + MessageText.getString("OpenTorrentWindow.xOfTotal", new String[]{Integer.toString(iMatches), Integer.toString(indexes.length)});
            }
            sItemsText[i] = sText;
        }
        this.cmbStartMode.setItems(sItemsText);
        this.cmbStartMode.select(iIndexToSelect);
        this.cmbStartMode.layout(true);
    }

    private void updateQueueLocationCombo() {
        if (this.cmbQueueLocation == null) {
            return;
        }
        int[] indexes = this.tableTorrents.getSelectionIndices();
        String[] sItemsText = new String[queueLocations.length];
        int iMaxMatches = 0;
        int iIndexToSelect = 1;
        for (int i = 0; i < queueLocations.length; ++i) {
            int iMatches = 0;
            for (int j = 0; j < indexes.length; ++j) {
                TorrentInfo info = (TorrentInfo)this.torrentList.get(indexes[j]);
                if (info.iQueueLocation != i) continue;
                ++iMatches;
            }
            if (iMatches > iMaxMatches) {
                iMaxMatches = iMatches;
                iIndexToSelect = i;
            }
            String sText = MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[i]);
            if (iMatches > 0) {
                sText = sText + " " + MessageText.getString("OpenTorrentWindow.xOfTotal", new String[]{Integer.toString(iMatches), Integer.toString(indexes.length)});
            }
            sItemsText[i] = sText;
        }
        this.cmbQueueLocation.setItems(sItemsText);
        this.cmbQueueLocation.select(iIndexToSelect);
    }

    private void setPasteKeyListener(Control c, KeyListener keyListener) {
        if (!(c instanceof Text) && !(c instanceof Combo) && !(c instanceof Composite) || c instanceof Table) {
            c.addKeyListener(keyListener);
        }
        if (c instanceof Composite) {
            Control[] controls = ((Composite)c).getChildren();
            for (int i = 0; i < controls.length; ++i) {
                this.setPasteKeyListener(controls[i], keyListener);
            }
        }
    }

    private void browseURL() {
        new OpenUrlWindow(core, this.shellForChildren, null, null, this);
    }

    private void close(boolean dispose, boolean bCancel) {
        Iterator iter;
        stOpenTorrentWindow = null;
        this.bClosed = true;
        if (dispose && this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        Utils.disposeSWTObjects(this.disposeList);
        if (this.downloaders.size() > 0) {
            iter = this.downloaders.iterator();
            while (iter.hasNext()) {
                TorrentDownloader element = (TorrentDownloader)iter.next();
                element.cancel();
            }
            this.downloaders.clear();
        }
        if (bCancel) {
            iter = this.torrentList.iterator();
            while (iter.hasNext()) {
                File file;
                TorrentInfo info = (TorrentInfo)iter.next();
                if (!info.bDeleteFileOnCancel || !(file = new File(info.sFileName)).exists()) continue;
                file.delete();
            }
            this.torrentList.clear();
        }
    }

    private void createTorrentListArea(Composite cArea) {
        MenuItem item;
        int i;
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        this.tableTorrents = new Table(cArea, 268503042);
        GridData gridData = new GridData(784);
        gridData.heightHint = 50;
        gridData.widthHint = 450;
        this.tableTorrents.setLayoutData((Object)gridData);
        TableColumn tc = new TableColumn(this.tableTorrents, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.torrentTable.name");
        tc.setWidth(150);
        tc = new TableColumn(this.tableTorrents, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.torrentTable.saveLocation");
        tc.setWidth(150);
        tc = new TableColumn(this.tableTorrents, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.startMode");
        tc.setWidth(70);
        tc = new TableColumn(this.tableTorrents, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.addPosition");
        tc.setWidth(80);
        if (Utils.LAST_TABLECOLUMN_EXPANDS) {
            tc.setData("Width", (Object)new Long(80L));
        }
        this.tableTorrents.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                String sRealDestDir;
                if (OpenTorrentWindow.this.bClosed) {
                    return;
                }
                TableItem item = (TableItem)event2.item;
                int index = OpenTorrentWindow.this.tableTorrents.indexOf(item);
                if (index < 0) {
                    return;
                }
                TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(index);
                TorrentFileInfo[] files = info.getFiles();
                if (files.length > 1 && !info.allFilesMoving()) {
                    File f = new File(info.sDestDir, info.getTorrentName());
                    sRealDestDir = f.getAbsolutePath();
                } else {
                    sRealDestDir = info.sDestDir;
                }
                item.setText(new String[]{info.getTorrentName(), sRealDestDir, MessageText.getString("OpenTorrentWindow.startMode." + startModes[info.iStartID]), MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[info.iQueueLocation])});
                if (!info.isValid) {
                    item.setForeground(Colors.red);
                    Font font = item.getFont();
                    FontData[] fd = font.getFontData();
                    for (int i = 0; i < fd.length; ++i) {
                        fd[i].setStyle(2);
                    }
                    font = new Font((Device)item.getDisplay(), fd);
                    OpenTorrentWindow.this.disposeList.add(font);
                    item.setFont(font);
                }
                Utils.alternateRowBackground(item);
            }
        });
        this.tableTorrents.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenTorrentWindow.this.dataFiles.clear();
                int[] indexes = OpenTorrentWindow.this.tableTorrents.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(indexes[i]);
                    TorrentFileInfo[] files = info.getFiles();
                    OpenTorrentWindow.this.dataFiles.addAll(Arrays.asList(files));
                }
                OpenTorrentWindow.this.updateDataDirCombo();
                OpenTorrentWindow.this.updateStartModeCombo();
                OpenTorrentWindow.this.updateQueueLocationCombo();
                OpenTorrentWindow.this.dataFileTable.setItemCount(OpenTorrentWindow.this.dataFiles.size());
                OpenTorrentWindow.this.dataFileTable.clearAll();
                OpenTorrentWindow.this.updateSize();
                OpenTorrentWindow.this.resizeTables(2);
            }
        });
        this.tableTorrents.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.character == '\u007f') {
                    OpenTorrentWindow.this.deleteSelected(OpenTorrentWindow.this.tableTorrents, OpenTorrentWindow.this.torrentList);
                    e.doit = false;
                }
            }
        });
        this.tableTorrents.setHeaderVisible(true);
        Menu menu = new Menu((Control)this.tableTorrents);
        String sTitle = MessageText.getString("OpenTorrentWindow.startMode");
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        for (i = 0; i < startModes.length; ++i) {
            if (i == 2 && userMode == 0) continue;
            item = new MenuItem(menu, 8);
            item.setData("Value", (Object)new Long(i));
            item.setText(sTitle + ": " + MessageText.getString("OpenTorrentWindow.startMode." + startModes[i]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Long l = (Long)e.widget.getData("Value");
                    if (l != null) {
                        OpenTorrentWindow.this.setSelectedStartMode(l.intValue());
                        OpenTorrentWindow.this.checkSeedingMode();
                    }
                }
            });
        }
        item = new MenuItem(menu, 2);
        sTitle = MessageText.getString("OpenTorrentWindow.addPosition");
        for (i = 0; i < queueLocations.length; ++i) {
            item = new MenuItem(menu, 8);
            item.setData("Value", (Object)new Long(i));
            item.setText(sTitle + ": " + MessageText.getString("OpenTorrentWindow.addPosition." + queueLocations[i]));
            item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Long l = (Long)e.widget.getData("Value");
                    if (l != null) {
                        OpenTorrentWindow.this.setSelectedQueueLocation(l.intValue());
                    }
                }
            });
        }
        item = new MenuItem(menu, 2);
        item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "MyTorrentsView.menu.remove");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OpenTorrentWindow.this.deleteSelected(OpenTorrentWindow.this.tableTorrents, OpenTorrentWindow.this.torrentList);
            }
        });
        item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = OpenTorrentWindow.this.tableTorrents.getSelectionIndices();
                String sDefPath = OpenTorrentWindow.this.sDestDir;
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentInfo info = (TorrentInfo)OpenTorrentWindow.this.torrentList.get(indexes[i]);
                    TorrentFileInfo[] files = info.getFiles();
                    if (files.length == 1) {
                        OpenTorrentWindow.this.chageFileDestination(new int[]{0});
                        continue;
                    }
                    DirectoryDialog dDialog = new DirectoryDialog(OpenTorrentWindow.this.shellForChildren, 131072);
                    dDialog.setFilterPath(sDefPath);
                    dDialog.setMessage(MessageText.getString("MainWindow.dialog.choose.savepath") + " (" + info.getTorrentName() + ")");
                    String sNewDir = dDialog.open();
                    if (sNewDir == null) {
                        return;
                    }
                    info.sDestDir = sNewDir;
                    for (int j = 0; j < files.length; ++j) {
                        TorrentFileInfo fileInfo2 = files[j];
                        File file = new File(sNewDir, fileInfo2.sFileName);
                        fileInfo2.sDestFileName = file.getAbsolutePath();
                        String sNewPath = file.getParent();
                        if (sNewPath == null) continue;
                        sDefPath = sNewPath;
                    }
                }
                OpenTorrentWindow.this.checkSeedingMode();
            }
        });
        this.tableTorrents.setMenu(menu);
        Composite cTorrentListRight = new Composite(cArea, 0);
        gridData = new GridData();
        cTorrentListRight.setLayoutData((Object)gridData);
        RowLayout rLayout = new RowLayout(512);
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        if (!Constants.isOSX) {
            rLayout.spacing = 0;
        }
        rLayout.fill = true;
        cTorrentListRight.setLayout((Layout)rLayout);
        Button torMoveUp = new Button(cTorrentListRight, 8);
        torMoveUp.setImage(ImageRepository.getImage("up"));
        torMoveUp.setToolTipText(MessageText.getString("Button.moveUp"));
        torMoveUp.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indices = OpenTorrentWindow.this.tableTorrents.getSelectionIndices();
                if (indices.length == 0) {
                    return;
                }
                Arrays.sort(indices);
                if (indices[0] == 0) {
                    return;
                }
                int i = 0;
                while (i < indices.length) {
                    int pos = indices[i];
                    Object save = OpenTorrentWindow.this.torrentList.get(pos - 1);
                    OpenTorrentWindow.this.torrentList.set(pos - 1, OpenTorrentWindow.this.torrentList.get(pos));
                    OpenTorrentWindow.this.torrentList.set(pos, save);
                    int n = i++;
                    indices[n] = indices[n] - 1;
                }
                OpenTorrentWindow.this.tableTorrents.setSelection(indices);
                OpenTorrentWindow.this.tableTorrents.clearAll();
            }
        });
        Button torMoveDown = new Button(cTorrentListRight, 8);
        torMoveDown.setImage(ImageRepository.getImage("down"));
        torMoveDown.setToolTipText(MessageText.getString("Button.moveDown"));
        torMoveDown.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indices = OpenTorrentWindow.this.tableTorrents.getSelectionIndices();
                if (indices.length == 0) {
                    return;
                }
                Arrays.sort(indices);
                int max = indices.length - 1;
                if (indices[max] == OpenTorrentWindow.this.torrentList.size() - 1) {
                    return;
                }
                int i = max;
                while (i >= 0) {
                    int pos = indices[i];
                    Object save = OpenTorrentWindow.this.torrentList.get(pos + 1);
                    OpenTorrentWindow.this.torrentList.set(pos + 1, OpenTorrentWindow.this.torrentList.get(pos));
                    OpenTorrentWindow.this.torrentList.set(pos, save);
                    int n = i--;
                    indices[n] = indices[n] + 1;
                }
                OpenTorrentWindow.this.tableTorrents.setSelection(indices);
                OpenTorrentWindow.this.tableTorrents.clearAll();
            }
        });
        Button torMoveRemove = new Button(cTorrentListRight, 8);
        torMoveRemove.setToolTipText(MessageText.getString("OpenTorrentWindow.torrent.remove"));
        torMoveRemove.setImage(ImageRepository.getImage("delete"));
        torMoveRemove.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.deleteSelected(OpenTorrentWindow.this.tableTorrents, OpenTorrentWindow.this.torrentList);
            }
        });
    }

    protected void setSelectedQueueLocation(int iLocation) {
        int[] indices = this.tableTorrents.getSelectionIndices();
        for (int i = 0; i < indices.length; ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(indices[i]);
            info.iQueueLocation = iLocation;
        }
        this.updateQueueLocationCombo();
        this.tableTorrents.clear(indices);
    }

    protected void setSelectedStartMode(int iStartID) {
        int[] indices = this.tableTorrents.getSelectionIndices();
        for (int i = 0; i < indices.length; ++i) {
            TorrentInfo info = (TorrentInfo)this.torrentList.get(indices[i]);
            info.iStartID = iStartID;
        }
        this.checkSeedingMode();
        this.updateStartModeCombo();
        this.tableTorrents.clear(indices);
    }

    private void checkSeedingMode() {
        for (int i = 0; i < this.torrentList.size(); ++i) {
            boolean bTorrentValid = true;
            TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
            if (info.iStartID == 3) {
                TorrentFileInfo[] files = info.getFiles();
                for (int j = 0; j < files.length; ++j) {
                    String sFullPath;
                    TorrentFileInfo fileInfo2 = files[j];
                    if (!fileInfo2.bDownload) continue;
                    if (fileInfo2.sDestFileName == null) {
                        File f = new File(info.sDestDir, fileInfo2.sFullFileName);
                        sFullPath = f.getAbsolutePath();
                    } else {
                        sFullPath = fileInfo2.sDestFileName;
                    }
                    File file = new File(sFullPath);
                    if (!file.exists()) {
                        fileInfo2.isValid = false;
                        bTorrentValid = false;
                        continue;
                    }
                    if (fileInfo2.isValid) continue;
                    fileInfo2.isValid = true;
                }
            }
            info.isValid = bTorrentValid;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (OpenTorrentWindow.this.tableTorrents != null && !OpenTorrentWindow.this.tableTorrents.isDisposed()) {
                    OpenTorrentWindow.this.tableTorrents.clearAll();
                }
                if (OpenTorrentWindow.this.dataFileTable != null && !OpenTorrentWindow.this.dataFileTable.isDisposed()) {
                    OpenTorrentWindow.this.dataFileTable.clearAll();
                }
            }
        });
    }

    private void deleteSelected(Table table, ArrayList list) {
        int[] indexes = table.getSelectionIndices();
        Arrays.sort(indexes);
        for (int i = indexes.length - 1; i >= 0; --i) {
            if (list.get(indexes[i]) instanceof TorrentInfo) {
                File file;
                TorrentInfo info = (TorrentInfo)list.get(indexes[i]);
                if (info.bDeleteFileOnCancel && (file = new File(info.sFileName)).exists()) {
                    file.delete();
                }
            }
            list.remove(indexes[i]);
        }
        table.setItemCount(list.size());
        table.clearAll();
        table.notifyListeners(13, new Event());
    }

    private void createTableDataFiles(Composite cArea) {
        this.dataFileTable = new Table(cArea, 268503074);
        GridData gridData = new GridData(1808);
        gridData.heightHint = 80;
        gridData.widthHint = 100;
        this.dataFileTable.setLayoutData((Object)gridData);
        TableColumn tc = new TableColumn(this.dataFileTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.fileTable.fileName");
        tc.setWidth(150);
        tc = new TableColumn(this.dataFileTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.fileTable.destinationName");
        tc.setWidth(140);
        tc = new TableColumn(this.dataFileTable, 0);
        Messages.setLanguageText((Widget)tc, "OpenTorrentWindow.fileTable.size");
        tc.setAlignment(131072);
        tc.setWidth(90);
        if (Utils.LAST_TABLECOLUMN_EXPANDS) {
            tc.setData("Width", (Object)new Long(90L));
        }
        this.dataFileTable.addListener(36, new Listener(){

            public void handleEvent(Event event2) {
                if (OpenTorrentWindow.this.bClosed) {
                    return;
                }
                TableItem item = (TableItem)event2.item;
                int index = OpenTorrentWindow.this.dataFileTable.indexOf(item);
                TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(index);
                item.setText(new String[]{file.sFileName, file.sDestFileName, DisplayFormatters.formatByteCountToKiBEtc(file.lSize)});
                if (!file.isValid) {
                    item.setForeground(Colors.red);
                    Font font = item.getFont();
                    FontData[] fd = font.getFontData();
                    for (int i = 0; i < fd.length; ++i) {
                        fd[i].setStyle(2);
                    }
                    font = new Font((Device)item.getDisplay(), fd);
                    OpenTorrentWindow.this.disposeList.add(font);
                    item.setFont(font);
                }
                Utils.alternateRowBackground(item);
                Utils.setCheckedInSetData(item, file.bDownload);
                item.setGrayed(!file.okToDisable());
            }
        });
        this.dataFileTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event2) {
                if (event2.detail == 32) {
                    TableItem item = (TableItem)event2.item;
                    int index = OpenTorrentWindow.this.dataFileTable.indexOf(item);
                    TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(index);
                    if (!item.getChecked() && !file.okToDisable()) {
                        item.setChecked(true);
                    } else {
                        file.bDownload = item.getChecked();
                    }
                    OpenTorrentWindow.this.updateSize();
                }
            }
        });
        this.dataFileTable.setHeaderVisible(true);
        Menu menu = new Menu((Control)this.dataFileTable);
        this.dataFileTable.setMenu(menu);
        MenuItem item = new MenuItem(menu, 8);
        Messages.setLanguageText((Widget)item, "OpenTorrentWindow.fileList.changeDestination");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int[] indexes = OpenTorrentWindow.this.dataFileTable.getSelectionIndices();
                OpenTorrentWindow.this.chageFileDestination(indexes);
            }
        });
        Composite cBottomArea = new Composite(cArea, 0);
        GridLayout gLayout = new GridLayout();
        gLayout.marginHeight = 0;
        gLayout.marginWidth = 0;
        gLayout.numColumns = 2;
        cBottomArea.setLayout((Layout)gLayout);
        gridData = new GridData(768);
        cBottomArea.setLayoutData((Object)gridData);
        Composite cButtons = new Composite(cBottomArea, 0);
        RowLayout rLayout = new RowLayout(256);
        rLayout.wrap = false;
        rLayout.marginBottom = 0;
        rLayout.marginLeft = 0;
        rLayout.marginRight = 0;
        rLayout.marginTop = 0;
        cButtons.setLayout((Layout)rLayout);
        Button btnSelectAll = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnSelectAll, "Button.selectAll");
        btnSelectAll.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                OpenTorrentWindow.this.dataFileTable.selectAll();
            }
        });
        Button btnMarkSelected = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnMarkSelected, "Button.markSelected");
        btnMarkSelected.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indexes = OpenTorrentWindow.this.dataFileTable.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(indexes[i]);
                    file.bDownload = true;
                }
                OpenTorrentWindow.this.dataFileTable.clearAll();
                OpenTorrentWindow.this.updateSize();
            }
        });
        Button btnUnmarkSelected = new Button(cButtons, 8);
        Messages.setLanguageText((Widget)btnUnmarkSelected, "Button.unmarkSelected");
        btnUnmarkSelected.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                int[] indexes = OpenTorrentWindow.this.dataFileTable.getSelectionIndices();
                for (int i = 0; i < indexes.length; ++i) {
                    TorrentFileInfo file = (TorrentFileInfo)OpenTorrentWindow.this.dataFiles.get(indexes[i]);
                    if (!file.okToDisable()) continue;
                    file.bDownload = false;
                }
                OpenTorrentWindow.this.dataFileTable.clearAll();
                OpenTorrentWindow.this.updateSize();
            }
        });
        this.dataFileTableLabel = new Label(cBottomArea, 64);
        this.dataFileTableLabel.setAlignment(131072);
        gridData = new GridData(1808);
        this.dataFileTableLabel.setLayoutData((Object)gridData);
    }

    protected void chageFileDestination(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            TorrentFileInfo fileInfo2 = (TorrentFileInfo)this.dataFiles.get(indexes[i]);
            int style = fileInfo2.parent.iStartID == 3 ? 4096 : 8192;
            FileDialog fDialog = new FileDialog(this.shellForChildren, 0x20000 | style);
            String sFilterPath = fileInfo2.getDestPath();
            String sFileName = new File(fileInfo2.sFileName).getName();
            File f = new File(sFilterPath);
            if (!f.isDirectory()) {
                String parentPath;
                while (sFilterPath != null && (parentPath = f.getParent()) != null && !(f = new File(sFilterPath = parentPath)).isDirectory()) {
                }
            }
            if (sFilterPath != null) {
                fDialog.setFilterPath(sFilterPath);
            }
            fDialog.setFileName(sFileName);
            fDialog.setText(MessageText.getString("MainWindow.dialog.choose.savepath") + " (" + fileInfo2.sFullFileName + ")");
            String sNewName = fDialog.open();
            if (sNewName == null) {
                return;
            }
            if (fileInfo2.parent.iStartID == 3) {
                File file = new File(sNewName);
                if (file.length() == fileInfo2.lSize) {
                    fileInfo2.sDestFileName = sNewName;
                    continue;
                }
                Utils.openMessageBox(this.shellForChildren, 32, "OpenTorrentWindow.mb.badSize", new String[]{file.getName(), fileInfo2.sFullFileName});
                continue;
            }
            fileInfo2.sDestFileName = sNewName;
        }
        this.checkSeedingMode();
    }

    private int addTorrentsFromTextList(String sClipText, boolean bVerifyOnly) {
        int i;
        String[] lines = null;
        int iNumFound = 0;
        int iNoTorrentLines = 0;
        int MAX_CONSECUTIVE_NONTORRENT_LINES = 100;
        String[] splitters = new String[]{"\r\n", "\n", "\r", "\t"};
        for (i = 0; i < splitters.length; ++i) {
            if (sClipText.indexOf(splitters[i]) < 0) continue;
            lines = sClipText.split(splitters[i]);
            break;
        }
        if (lines == null) {
            lines = new String[]{sClipText};
        }
        for (i = 0; i < lines.length; ++i) {
            boolean ok;
            String line = lines[i].trim();
            if (line.startsWith("\"") && line.endsWith("\"")) {
                line = line.length() < 3 ? "" : line.substring(1, line.length() - 2);
            }
            if (line == "") {
                ok = false;
            } else if (UrlUtils.isURL(line)) {
                ok = true;
            } else {
                File file = new File(line);
                if (!file.exists()) {
                    ok = false;
                } else if (file.isDirectory()) {
                    if (bVerifyOnly) {
                        ok = true;
                    } else {
                        iNumFound += this.addTorrents(lines[i], null);
                        ok = false;
                    }
                } else {
                    ok = true;
                }
            }
            if (!ok) {
                lines[i] = null;
                if (++iNoTorrentLines <= 100) continue;
                break;
            }
            ++iNumFound;
            iNoTorrentLines = 0;
        }
        if (bVerifyOnly) {
            return iNumFound;
        }
        return this.addTorrents(null, lines);
    }

    private int addTorrents(String sTorrentFilePath, String[] sTorrentFilenames) {
        if ((sTorrentFilePath = this.ensureTrailingSeparator(sTorrentFilePath)) != null && sTorrentFilenames == null) {
            File dir = new File(sTorrentFilePath);
            if (!dir.isDirectory()) {
                return 0;
            }
            File[] files = dir.listFiles(new FileFilter(){

                public boolean accept(File arg0) {
                    if (FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".torrent")) {
                        return true;
                    }
                    return FileUtil.getCanonicalFileName(arg0.getName()).endsWith(".tor");
                }
            });
            if (files.length == 0) {
                return 0;
            }
            sTorrentFilenames = new String[files.length];
            for (int i = 0; i < files.length; ++i) {
                sTorrentFilenames[i] = files[i].getName();
            }
        }
        int numAdded = 0;
        for (int i = 0; i < sTorrentFilenames.length; ++i) {
            String sURL;
            if (sTorrentFilenames[i] == null || sTorrentFilenames[i] == "") continue;
            String sFileName = (sTorrentFilePath == null ? "" : sTorrentFilePath) + sTorrentFilenames[i];
            if (!new File(sFileName).exists() && (sURL = UrlUtils.parseTextForURL(sTorrentFilenames[i], true)) != null) {
                if (COConfigurationManager.getBooleanParameter("Add URL Silently")) {
                    new FileDownloadWindow(core, this.shellForChildren, sURL, null, this);
                } else {
                    new OpenUrlWindow(core, this.shellForChildren, sURL, null, this);
                }
                ++numAdded;
                continue;
            }
            if (this.addTorrent(sFileName, sFileName) == null) continue;
            ++numAdded;
        }
        if (numAdded > 0 && this.shell != null && this.tableTorrents != null && !this.shell.isDisposed()) {
            int iTotal = this.torrentList.size();
            this.tableTorrents.setItemCount(iTotal);
            this.tableTorrents.select(iTotal - numAdded, iTotal - 1);
            this.tableTorrents.clearAll();
            this.tableTorrents.notifyListeners(13, new Event());
            this.resizeTables(1);
            this.checkSeedingMode();
        }
        return numAdded;
    }

    private TorrentInfo addTorrent(String sFileName, final String sOriginatingLocation) {
        String sExistingName;
        File torrentFile;
        boolean bDeleteFileOnCancel;
        TOTorrent torrent;
        TorrentInfo info;
        block17: {
            info = null;
            torrent = null;
            bDeleteFileOnCancel = false;
            try {
                File fOriginal = new File(sFileName);
                if (!fOriginal.isFile() || !fOriginal.exists()) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (OpenTorrentWindow.this.shell == null) {
                                new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.openError", "", new String[]{sOriginatingLocation, "Not a File"});
                            } else {
                                Utils.openMessageBox(OpenTorrentWindow.this.shell, 32, "OpenTorrentWindow.mb.openError", new String[]{sOriginatingLocation, "Not a File"});
                            }
                        }
                    });
                    return null;
                }
                torrentFile = TorrentUtils.copyTorrentFileToSaveDir(fOriginal, true);
                bDeleteFileOnCancel = !fOriginal.equals(torrentFile);
            }
            catch (IOException e1) {
                torrentFile = new File(sFileName);
            }
            try {
                torrent = TorrentUtils.readFromFile(torrentFile, false);
            }
            catch (TOTorrentException e) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (OpenTorrentWindow.this.shell == null) {
                            new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{sOriginatingLocation, e.getMessage()});
                        } else {
                            Utils.openMessageBox(OpenTorrentWindow.this.shell, 32, "OpenTorrentWindow.mb.openError", new String[]{sOriginatingLocation, e.getMessage()});
                        }
                    }
                });
                if (bDeleteFileOnCancel) {
                    torrentFile.delete();
                }
                return null;
            }
            sExistingName = null;
            try {
                HashWrapper hash = torrent.getHashWrapper();
                if (hash == null) break block17;
                for (int i = 0; i < this.torrentList.size(); ++i) {
                    try {
                        TorrentInfo existing = (TorrentInfo)this.torrentList.get(i);
                        if (!existing.torrent.getHashWrapper().equals(hash)) continue;
                        if (bDeleteFileOnCancel) {
                            torrentFile.delete();
                        }
                        return null;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (sExistingName == null) {
            DownloadManager existingDownload;
            DownloadManager downloadManager = existingDownload = this.gm == null ? null : this.gm.getDownloadManager(torrent);
            if (existingDownload != null) {
                sExistingName = existingDownload.getDisplayName();
            }
        }
        if (sExistingName == null) {
            info = new TorrentInfo(torrentFile.getAbsolutePath(), torrent, bDeleteFileOnCancel);
            info.sOriginatingLocation = sOriginatingLocation;
            this.torrentList.add(info);
        } else {
            final String sfExistingName = sExistingName;
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    if (OpenTorrentWindow.this.shell == null) {
                        new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.alreadyExists", null, new String[]{sOriginatingLocation, sfExistingName});
                    } else {
                        Utils.openMessageBox(OpenTorrentWindow.this.shell, 32, "OpenTorrentWindow.mb.alreadyExists", new String[]{sOriginatingLocation, sfExistingName});
                    }
                }
            });
            if (bDeleteFileOnCancel) {
                torrentFile.delete();
            }
        }
        return info;
    }

    private void resizeTables(int which) {
        try {
            int i;
            boolean columnToExpand;
            int iLength;
            int newSize;
            TableColumn[] tcs;
            if ((which & 1) > 0 && this.tableTorrents != null && !this.tableTorrents.isDisposed()) {
                tcs = this.tableTorrents.getColumns();
                newSize = this.tableTorrents.getClientArea().width - 20;
                iLength = tcs.length;
                if (Utils.LAST_TABLECOLUMN_EXPANDS) {
                    newSize -= ((Long)tcs[--iLength].getData("Width")).intValue();
                }
                columnToExpand = true;
                for (i = 0; i < iLength; ++i) {
                    if (i == 1) continue;
                    newSize -= tcs[i].getWidth();
                }
                if (newSize > 10) {
                    tcs[1].setWidth(newSize);
                }
            }
            if ((which & 2) > 0 && this.dataFileTable != null && !this.dataFileTable.isDisposed()) {
                tcs = this.dataFileTable.getColumns();
                newSize = this.dataFileTable.getClientArea().width - 20;
                iLength = tcs.length;
                if (Utils.LAST_TABLECOLUMN_EXPANDS) {
                    newSize -= ((Long)tcs[--iLength].getData("Width")).intValue();
                }
                columnToExpand = false;
                for (i = 0; i < iLength; ++i) {
                    if (i == 0) continue;
                    newSize -= tcs[i].getWidth();
                }
                if (newSize > 10) {
                    tcs[0].setWidth(newSize);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void openTorrents() {
        ArrayList<DownloadManager> addedTorrentsTop = new ArrayList<DownloadManager>();
        for (int i = 0; i < this.torrentList.size(); ++i) {
            final TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
            try {
                if (info.torrent == null) continue;
                int iStartMode = info.iStartID == 1 ? 70 : 75;
                final TorrentFileInfo[] files = info.getFiles();
                byte[] hash = null;
                try {
                    hash = info.torrent.getHash();
                }
                catch (TOTorrentException e1) {
                    // empty catch block
                }
                DownloadManager dm = this.gm.addDownloadManager(info.sFileName, hash, info.sDestDir, iStartMode, true, info.iStartID == 3, new DownloadManagerInitialisationAdapter(){

                    public void initialised(DownloadManager dm) {
                        DiskManagerFileInfo[] fileInfos = dm.getDiskManagerFileInfo();
                        for (int iIndex = 0; iIndex < fileInfos.length; ++iIndex) {
                            File fDest;
                            DiskManagerFileInfo fileInfo2 = fileInfos[iIndex];
                            if (iIndex < 0 || iIndex >= files.length || files[iIndex].lSize != fileInfo2.getLength()) continue;
                            if (files[iIndex].sDestFileName != null) {
                                fDest = new File(files[iIndex].sDestFileName);
                                dm.getDownloadState().setFileLink(fileInfo2.getFile(false), fDest);
                            } else {
                                fDest = new File(info.sDestDir, files[iIndex].sFullFileName);
                            }
                            if (files[iIndex].bDownload) continue;
                            fileInfo2.setSkipped(true);
                            if (fDest.exists()) continue;
                            fileInfo2.setStorageType(2);
                        }
                    }
                });
                if (dm == null) continue;
                if (info.iQueueLocation == 0) {
                    addedTorrentsTop.add(dm);
                }
                if (iStartMode != 2) continue;
                dm.setForceStart(true);
                continue;
            }
            catch (Exception e) {
                if (this.shell == null) {
                    new MessageSlideShell(Display.getCurrent(), 1, "OpenTorrentWindow.mb.openError", Debug.getStackTrace(e), new String[]{info.sOriginatingLocation, e.getMessage()});
                    continue;
                }
                Utils.openMessageBox(this.shell, 32, "OpenTorrentWindow.mb.openError", new String[]{info.sOriginatingLocation, e.getMessage()});
            }
        }
        if (addedTorrentsTop.size() > 0) {
            DownloadManager[] dms = addedTorrentsTop.toArray(new DownloadManager[0]);
            this.gm.moveTop(dms);
        }
        this.torrentList.clear();
    }

    private int getDefaultStartMode() {
        if (this.bDefaultForSeeding) {
            return 3;
        }
        return this.bOverrideStartModeToStopped || COConfigurationManager.getBooleanParameter("Default Start Torrents Stopped") ? 1 : 0;
    }

    public void TorrentDownloaderEvent(int state, TorrentDownloader inf) {
        if (!(inf.getDeleteFileOnCancel() || state != 6 && state != 4 && state != 5 && state != 3)) {
            if (!this.downloaders.contains(inf)) {
                return;
            }
            this.downloaders.remove(inf);
            File file = inf.getFile();
            String html = null;
            if (file.exists()) {
                try {
                    html = FileUtil.readFileAsString(file, 16384);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                file.delete();
            }
            MessageBoxShell boxShell = new MessageBoxShell(this.shellForChildren, MessageText.getString("OpenTorrentWindow.mb.notTorrent.title"), MessageText.getString("OpenTorrentWindow.mb.notTorrent.text", new String[]{inf.getURL(), ""}), new String[]{MessageText.getString("Button.ok")}, 0);
            boxShell.setHtml(html);
            boxShell.open();
            return;
        }
        if (state == 0) {
            this.downloaders.add(inf);
        } else if (state == 3) {
            if (!this.downloaders.contains(inf)) {
                return;
            }
            this.downloaders.remove(inf);
            File file = inf.getFile();
            if (this.addTorrent(file.getAbsolutePath(), inf.getURL()) == null) {
                if (file.exists()) {
                    file.delete();
                }
            } else if (this.shell != null && !this.shell.isDisposed()) {
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        OpenTorrentWindow.this.tableTorrents.setItemCount(OpenTorrentWindow.this.torrentList.size());
                        OpenTorrentWindow.this.tableTorrents.clearAll();
                        OpenTorrentWindow.this.tableTorrents.select(OpenTorrentWindow.this.torrentList.size() - 1);
                        OpenTorrentWindow.this.tableTorrents.notifyListeners(13, new Event());
                        OpenTorrentWindow.this.resizeTables(1);
                    }
                });
            } else {
                String saveSilentlyDir = OpenTorrentWindow.getSaveSilentlyDir();
                if (saveSilentlyDir != null) {
                    this.sDestDir = saveSilentlyDir;
                    for (int i = 0; i < this.torrentList.size(); ++i) {
                        TorrentInfo info = (TorrentInfo)this.torrentList.get(i);
                        info.renameDuplicates();
                    }
                    this.openTorrents();
                }
            }
        } else if (state == 6 || state == 4 || state == 5) {
            this.downloaders.remove(inf);
        } else if (state == 2) {
            byte[] bytes;
            int count = inf.getLastReadCount();
            int numRead = inf.getTotalRead();
            if (!inf.getDeleteFileOnCancel() && numRead >= 16384) {
                inf.cancel();
            } else if (numRead == count && count > 0 && (bytes = inf.getLastReadBytes())[0] != 100) {
                inf.setDeleteFileOnCancel(false);
            }
        } else {
            return;
        }
        this.checkSeedingMode();
    }

    private String ensureTrailingSeparator(String sPath) {
        if (sPath == null || sPath.length() == 0 || sPath.endsWith(File.separator)) {
            return sPath;
        }
        return sPath + File.separator;
    }

    private static String getSaveSilentlyDir() {
        boolean bUseDefault = COConfigurationManager.getBooleanParameter("Use default data dir");
        if (!bUseDefault) {
            return null;
        }
        String sDefDir = "";
        try {
            sDefDir = COConfigurationManager.getDirectoryParameter(PARAM_DEFSAVEPATH);
        }
        catch (IOException e) {
            return null;
        }
        return sDefDir == "" ? null : sDefDir;
    }

    private void updateSize() {
        long totalSize = 0L;
        long checkedSize = 0L;
        for (int i = 0; i < this.dataFiles.size(); ++i) {
            TorrentFileInfo file = (TorrentFileInfo)this.dataFiles.get(i);
            totalSize += file.lSize;
            if (!file.bDownload) continue;
            checkedSize += file.lSize;
        }
        if (totalSize == 0L) {
            this.dataFileTableLabel.setText("");
        } else {
            this.dataFileTableLabel.setText(MessageText.getString("OpenTorrentWindow.filesInfo", new String[]{DisplayFormatters.formatByteCountToKiBEtc(checkedSize), DisplayFormatters.formatByteCountToKiBEtc(totalSize)}));
        }
        this.dataFileTableLabel.update();
        this.dataFileTableLabel.getParent().getParent().layout(true, true);
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        ImageRepository.loadImages(display);
        OpenTorrentWindow.invoke(null, core.getGlobalManager());
        while (stOpenTorrentWindow != null && !OpenTorrentWindow.stOpenTorrentWindow.bClosed) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        core.stop();
    }

    static {
        if (!AzureusCoreFactory.isCoreAvailable()) {
            AzureusCore core2 = AzureusCoreFactory.create();
            core2.start();
        }
        core = AzureusCoreFactory.getSingleton();
    }

    private class TorrentFileInfo {
        String sFileName;
        String sFullFileName;
        long lSize;
        boolean bDownload;
        String sDestFileName;
        long iIndex;
        boolean isValid;
        final TorrentInfo parent;

        public TorrentFileInfo(TorrentInfo parent, TOTorrentFile torrentFile, int iIndex) {
            this.parent = parent;
            this.lSize = torrentFile.getLength();
            this.iIndex = iIndex;
            this.bDownload = true;
            this.sDestFileName = null;
            this.isValid = true;
            this.sFileName = torrentFile.getRelativePath();
            this.sFullFileName = parent.torrent.isSimpleTorrent() ? this.sFileName : parent.getTorrentName() + File.separator + torrentFile.getRelativePath();
        }

        public String getDestPath() {
            if (this.sDestFileName != null) {
                return new File(this.sDestFileName).getParent();
            }
            if (this.parent.torrent.isSimpleTorrent()) {
                return this.parent.sDestDir;
            }
            return new File(this.parent.sDestDir, this.sFullFileName).getParent();
        }

        public File getDestFile() {
            if (this.sDestFileName != null) {
                return new File(this.sDestFileName);
            }
            return new File(OpenTorrentWindow.this.sDestDir, this.sFullFileName);
        }

        public boolean okToDisable() {
            return this.lSize >= 65536L || this.parent.okToDisableAll();
        }
    }

    private class TorrentInfo {
        String sOriginatingLocation;
        String sFileName;
        String sDestDir;
        TOTorrent torrent;
        int iStartID;
        int iQueueLocation;
        boolean isValid;
        boolean bDeleteFileOnCancel;
        private TorrentFileInfo[] files = null;
        private Boolean has_multiple_small_files = null;

        public TorrentInfo(String sFileName, TOTorrent torrent, boolean bDeleteFileOnCancel) {
            this.bDeleteFileOnCancel = bDeleteFileOnCancel;
            this.sFileName = sFileName;
            this.sOriginatingLocation = sFileName;
            this.torrent = torrent;
            this.sDestDir = OpenTorrentWindow.this.sDestDir;
            this.iStartID = OpenTorrentWindow.this.getDefaultStartMode();
            this.iQueueLocation = 1;
            this.isValid = true;
            try {
                LocaleTorrentUtil.getTorrentEncoding(this.torrent);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (OpenTorrentWindow.getSaveSilentlyDir() == null && COConfigurationManager.getBooleanParameter("DefaultDir.BestGuess") && !COConfigurationManager.getBooleanParameter(OpenTorrentWindow.PARAM_MOVEWHENDONE)) {
                this.sDestDir = this.getSmartDestDir();
            }
        }

        public String getSmartDestDir() {
            String sSmartDir = this.sDestDir;
            try {
                int iMatchLevel;
                String name = this.getTorrentName();
                int totalSegmentsLengths = 0;
                String[][] segments = new String[][]{name.split("[^a-zA-Z]+"), this.sFileName.split("[^a-zA-Z]+")};
                List downloadManagers = OpenTorrentWindow.this.gm.getDownloadManagers();
                for (int x = 0; x < segments.length; ++x) {
                    String[] segmentArray = segments[x];
                    for (int i = 0; i < segmentArray.length; ++i) {
                        int l = segmentArray[i].length();
                        if (l <= 1) continue;
                        totalSegmentsLengths += l;
                    }
                }
                int maxMatches = 0;
                DownloadManager match = null;
                Iterator iter = downloadManagers.iterator();
                while (iter.hasNext()) {
                    DownloadManager dm = (DownloadManager)iter.next();
                    if (dm.getState() == 100) continue;
                    int numMatches = 0;
                    String dmName = dm.getDisplayName().toLowerCase();
                    for (int x = 0; x < segments.length; ++x) {
                        String[] segmentArray = segments[x];
                        for (int i = 0; i < segmentArray.length; ++i) {
                            int l = segmentArray[i].length();
                            if (l <= 1) continue;
                            String segment = segmentArray[i].toLowerCase();
                            if (!dmName.matches(".*" + segment + ".*")) continue;
                            numMatches += l;
                        }
                    }
                    if (numMatches <= maxMatches) continue;
                    maxMatches = numMatches;
                    match = dm;
                }
                if (match != null && (iMatchLevel = maxMatches * 100 / totalSegmentsLengths) >= 30) {
                    File f = match.getSaveLocation();
                    if (!f.isDirectory() || match.getDiskManagerFileInfo().length > 1) {
                        f = f.getParentFile();
                    }
                    if (f != null && f.isDirectory()) {
                        sSmartDir = f.getAbsolutePath();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return sSmartDir;
        }

        public TorrentFileInfo[] getFiles() {
            if (this.files == null && this.torrent != null) {
                TOTorrentFile[] tfiles = this.torrent.getFiles();
                this.files = new TorrentFileInfo[tfiles.length];
                for (int i = 0; i < this.files.length; ++i) {
                    this.files[i] = new TorrentFileInfo(this, tfiles[i], i);
                }
            }
            return this.files;
        }

        public String getTorrentName() {
            if (this.torrent == null) {
                return "";
            }
            try {
                LocaleUtilDecoder decoder = LocaleTorrentUtil.getTorrentEncodingIfAvailable(this.torrent);
                if (decoder != null) {
                    return decoder.decodeString(this.torrent.getName());
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                return new String(this.torrent.getName());
            }
            catch (Exception e) {
                return "TextDecodingError";
            }
        }

        public boolean allFilesMoving() {
            TorrentFileInfo[] files = this.getFiles();
            for (int j = 0; j < files.length; ++j) {
                if (files[j].sDestFileName != null) continue;
                return false;
            }
            return true;
        }

        public boolean allFilesExist() {
            TorrentFileInfo[] files = this.getFiles();
            for (int i = 0; i < files.length; ++i) {
                String sFullPath;
                TorrentFileInfo fileInfo2 = files[i];
                if (!fileInfo2.bDownload) continue;
                if (fileInfo2.sDestFileName == null) {
                    File f = new File(this.sDestDir, fileInfo2.sFullFileName);
                    sFullPath = f.getAbsolutePath();
                } else {
                    sFullPath = fileInfo2.sDestFileName;
                }
                File file = new File(sFullPath);
                if (file.exists() && file.length() == fileInfo2.lSize) continue;
                return false;
            }
            return true;
        }

        public void renameDuplicates() {
            block6: {
                block5: {
                    File f;
                    if (this.iStartID == 3 || !COConfigurationManager.getBooleanParameter("DefaultDir.AutoSave.AutoRename") || !this.allFilesExist()) {
                        return;
                    }
                    if (this.torrent.isSimpleTorrent()) break block5;
                    if (!new File(this.sDestDir, this.getTorrentName()).isDirectory()) break block6;
                    int idx = 0;
                    while ((f = new File(this.sDestDir, this.getTorrentName() + "-" + ++idx)).isDirectory()) {
                    }
                    String sNewDir = f.getAbsolutePath();
                    TorrentFileInfo[] fileInfos = this.getFiles();
                    for (int i = 0; i < fileInfos.length; ++i) {
                        TorrentFileInfo info = fileInfos[i];
                        File file = new File(sNewDir, info.sFileName);
                        info.sDestFileName = file.getAbsolutePath();
                    }
                    break block6;
                }
                TorrentFileInfo[] fileInfos = this.getFiles();
                for (int i = 0; i < fileInfos.length; ++i) {
                    TorrentFileInfo info = fileInfos[i];
                    File file = new File(this.sDestDir, info.sFileName);
                    int idx = 0;
                    while (file.exists()) {
                        file = new File(this.sDestDir, ++idx + "-" + info.sFileName);
                    }
                    info.sDestFileName = file.getAbsolutePath();
                }
            }
        }

        private boolean hasMultipleSmallFiles() {
            TorrentFileInfo[] tfi_files = this.getFiles();
            if (tfi_files.length <= 3) {
                return false;
            }
            int small_files_counted = 0;
            for (int i = 0; i < tfi_files.length; ++i) {
                if (tfi_files[i].lSize >= 65536L || ++small_files_counted <= 3) continue;
                return true;
            }
            return false;
        }

        public boolean okToDisableAll() {
            if (this.iStartID == 3) {
                return true;
            }
            if (this.has_multiple_small_files == null) {
                this.has_multiple_small_files = new Boolean(this.hasMultipleSmallFiles());
            }
            return this.has_multiple_small_files;
        }
    }
}

