/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.plugins.PluginView;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTPluginView;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.IViewExtension;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;

public class Tab {
    private static HashMap tabs;
    private static AEMonitor class_mon;
    private boolean useCustomTab = mainwindow.isUseCustomTab();
    private static Composite _folder;
    private Composite folder;
    private Item tabItem;
    private static boolean eventCloseAllowed;
    private static Item selectedItem;
    private IView view;
    private static List tabAddListeners;
    private static List tabRemoveListeners;
    private static MainWindow mainwindow;

    public Item getTabItem() {
        return this.tabItem;
    }

    public Tab(IView _view) {
        this(_view, true);
    }

    public Tab(IView _view, boolean bFocus) {
        CTabFolder tabFolder;
        this.view = _view;
        this.folder = _folder;
        if (this.useCustomTab) {
            tabFolder = (CTabFolder)this.folder;
            this.tabItem = new CTabItem(tabFolder, 0, _view instanceof MyTorrentsSuperView ? 0 : tabFolder.getItemCount());
            this.folder.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDown(MouseEvent arg0) {
                    if (arg0.button == 2) {
                        Rectangle rectangle;
                        if (eventCloseAllowed && (rectangle = ((CTabItem)Tab.this.tabItem).getBounds()).contains(arg0.x, arg0.y)) {
                            eventCloseAllowed = false;
                            Tab.this.folder.removeMouseListener((MouseListener)this);
                            Tab.closed(Tab.this.tabItem);
                        }
                    } else {
                        selectedItem = (Item)((CTabFolder)Tab.this.folder).getSelection();
                    }
                }

                public void mouseUp(MouseEvent arg0) {
                    eventCloseAllowed = true;
                    if (selectedItem != null && _folder instanceof CTabFolder) {
                        ((CTabFolder)_folder).setSelection((CTabItem)selectedItem);
                    }
                }
            });
        } else {
            tabFolder = (TabFolder)this.folder;
            this.tabItem = new TabItem((TabFolder)tabFolder, 0, _view instanceof MyTorrentsSuperView ? 0 : tabFolder.getItemCount());
        }
        Listener activateListener = new Listener(){

            public void handleEvent(Event event2) {
                IView view = null;
                Composite parent = (Composite)event2.widget;
                IView oldView = Tab.getView(selectedItem);
                if (oldView instanceof IViewExtension) {
                    ((IViewExtension)((Object)oldView)).viewDeactivated();
                }
                while (parent != null && !parent.isDisposed() && view == null) {
                    TabItem[] selection;
                    CTabFolder folder;
                    if (parent instanceof CTabFolder) {
                        folder = (CTabFolder)parent;
                        selectedItem = (Item)folder.getSelection();
                        view = Tab.getView(selectedItem);
                    } else if (parent instanceof TabFolder && (selection = (folder = (TabFolder)parent).getSelection()).length > 0) {
                        selectedItem = (Item)selection[0];
                        view = Tab.getView(selectedItem);
                    }
                    if (view != null) continue;
                    parent = parent.getParent();
                }
                if (view != null) {
                    if (view instanceof IViewExtension) {
                        ((IViewExtension)((Object)view)).viewActivated();
                    }
                    view.refresh();
                }
            }
        };
        tabs.put(this.tabItem, this.view);
        try {
            final Composite tabArea = new Composite(this.folder, 0);
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            tabArea.setLayout((Layout)layout);
            _view.initialize(tabArea);
            this.tabItem.setText(Tab.escapeAccelerators(this.view.getShortTitle()));
            Composite viewComposite = _view.getComposite();
            if (viewComposite != null && !viewComposite.isDisposed()) {
                viewComposite.addListener(26, activateListener);
                if (tabArea.getLayout() instanceof GridLayout && !(viewComposite.getLayoutData() instanceof GridData)) {
                    viewComposite.setLayoutData((Object)new GridData(1808));
                }
                if (viewComposite != tabArea) {
                    viewComposite.addDisposeListener(new DisposeListener(){
                        boolean alreadyHere = false;

                        public void widgetDisposed(DisposeEvent e) {
                            if (this.alreadyHere) {
                                return;
                            }
                            this.alreadyHere = true;
                            Utils.disposeComposite(tabArea);
                        }
                    });
                }
            }
            if (this.useCustomTab) {
                ((CTabItem)this.tabItem).setControl((Control)tabArea);
                if (bFocus) {
                    ((CTabFolder)this.folder).setSelection((CTabItem)this.tabItem);
                }
            } else {
                ((TabItem)this.tabItem).setControl((Control)tabArea);
                ((TabItem)this.tabItem).setToolTipText(this.view.getFullTitle());
                TabItem[] items = new TabItem[]{(TabItem)this.tabItem};
                if (bFocus) {
                    ((TabFolder)this.folder).setSelection(items);
                }
            }
        }
        catch (Exception e) {
            tabs.remove(this.tabItem);
            Debug.printStackTrace(e);
        }
        if (bFocus) {
            mainwindow.refreshIconBar();
            selectedItem = this.tabItem;
        }
        Tab.notifyListeners(tabAddListeners, this.tabItem);
        this.tabItem.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                Tab.notifyListeners(tabRemoveListeners, Tab.this.tabItem);
            }
        });
    }

    public static IView getView(Item item) {
        return (IView)tabs.get(item);
    }

    public IView getView() {
        return this.view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item getTab(IView view) {
        try {
            class_mon.enter();
            Iterator iter = tabs.keySet().iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                IView this_view = (IView)tabs.get(item);
                if (this_view != view) continue;
                Item item2 = item;
                return item2;
            }
            Item item = null;
            return item;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Item[] getAllTabs() {
        try {
            class_mon.enter();
            Item[] tabItems = new Item[tabs.size()];
            if (tabItems.length > 0) {
                tabItems = tabs.keySet().toArray(tabItems);
            }
            Item[] itemArray = tabItems;
            return itemArray;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IView[] getAllViews() {
        try {
            class_mon.enter();
            IView[] views = new IView[tabs.size()];
            if (views.length > 0) {
                views = tabs.values().toArray(views);
            }
            IView[] iViewArray = views;
            return iViewArray;
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void refresh() {
        try {
            class_mon.enter();
            Iterator iter = tabs.keySet().iterator();
            while (iter.hasNext()) {
                Item item = (Item)iter.next();
                IView view = (IView)tabs.get(item);
                try {
                    if (item.isDisposed()) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getShortTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(Tab.escapeAccelerators(newTitle));
                    }
                    if (item instanceof CTabItem || !(item instanceof TabItem)) continue;
                    String lastToolTip = ((TabItem)item).getToolTipText();
                    String newToolTip = view.getFullTitle() + " " + MessageText.getString("Tab.closeHint");
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    ((TabItem)item).setToolTipText(newToolTip);
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateLanguage() {
        IView[] views;
        try {
            class_mon.enter();
            views = tabs.values().toArray(new IView[tabs.size()]);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < views.length; ++i) {
            IView view = views[i];
            try {
                view.updateLanguage();
                view.refresh();
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllTabs() {
        Item[] tab_items;
        try {
            class_mon.enter();
            tab_items = tabs.keySet().toArray(new Item[tabs.size()]);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < tab_items.length; ++i) {
            Tab.closed(tab_items[i], true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean hasDetails() {
        boolean hasDetails = false;
        try {
            class_mon.enter();
            Iterator iter = tabs.values().iterator();
            while (iter.hasNext()) {
                IView view = (IView)iter.next();
                if (!(view instanceof ManagerView)) continue;
                hasDetails = true;
                break;
            }
        }
        finally {
            class_mon.exit();
        }
        return hasDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closeAllDetails() {
        Item[] tab_items;
        try {
            class_mon.enter();
            tab_items = tabs.keySet().toArray(new Item[tabs.size()]);
        }
        finally {
            class_mon.exit();
        }
        for (int i = 0; i < tab_items.length; ++i) {
            IView view = (IView)tabs.get(tab_items[i]);
            if (!(view instanceof ManagerView)) continue;
            Tab.closed(tab_items[i]);
        }
    }

    public static void closeCurrent() {
        if (_folder == null || _folder.isDisposed()) {
            return;
        }
        if (_folder instanceof TabFolder) {
            TabItem[] items = ((TabFolder)_folder).getSelection();
            if (items.length == 1) {
                Tab.closed((Item)items[0]);
            }
        } else {
            Tab.closed((Item)((CTabFolder)_folder).getSelection());
        }
    }

    public static void selectNextTab(boolean selectNext) {
        int nextOrPrevious;
        if (_folder == null || _folder.isDisposed()) {
            return;
        }
        int n = nextOrPrevious = selectNext ? 1 : -1;
        if (_folder instanceof TabFolder) {
            TabFolder tabFolder = (TabFolder)_folder;
            int index = tabFolder.getSelectionIndex() + nextOrPrevious;
            if (index == 0 && selectNext || index == -2 || tabFolder.getItemCount() < 2) {
                return;
            }
            if (index == tabFolder.getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = tabFolder.getItemCount() - 1;
            }
            tabFolder.setSelection(index);
        } else {
            CTabFolder tabFolder = (CTabFolder)_folder;
            int index = tabFolder.getSelectionIndex() + nextOrPrevious;
            if (index == 0 && selectNext || index == -2 || tabFolder.getItemCount() < 2) {
                return;
            }
            if (index == tabFolder.getItemCount()) {
                index = 0;
            } else if (index < 0) {
                index = tabFolder.getItemCount() - 1;
            }
            tabFolder.setSelection(index);
        }
    }

    public static void initialize(MainWindow mainwindow, Composite folder) {
        Tab.mainwindow = mainwindow;
        _folder = folder;
    }

    public static boolean closed(Item item) {
        return Tab.closed(item, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean closed(Item item, boolean bForceClose) {
        if (item == null) {
            return true;
        }
        IView view = (IView)tabs.get(item);
        if (!bForceClose && view instanceof UISWTViewImpl && !((UISWTViewImpl)view).requestClose()) {
            return false;
        }
        try {
            class_mon.enter();
            view = (IView)tabs.remove(item);
        }
        finally {
            class_mon.exit();
        }
        if (view != null) {
            try {
                if (view instanceof PluginView) {
                    mainwindow.removeActivePluginView(((PluginView)view).getPluginViewName());
                }
                if (view instanceof UISWTPluginView) {
                    mainwindow.removeActivePluginView(((UISWTPluginView)view).getPluginViewName());
                }
                if (view instanceof UISWTView) {
                    mainwindow.removeActivePluginView(((UISWTView)((Object)view)).getViewID());
                }
                view.delete();
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
            if (view instanceof MyTorrentsSuperView) {
                item.dispose();
                return true;
            }
            if (view instanceof MyTrackerView) {
                item.dispose();
                return true;
            }
            if (view instanceof MySharesView) {
                item.dispose();
                return true;
            }
        }
        try {
            item.dispose();
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
        return true;
    }

    public void setFocus() {
        if (this.folder != null && !this.folder.isDisposed()) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).setSelection((CTabItem)this.tabItem);
            } else {
                TabItem[] items = new TabItem[]{(TabItem)this.tabItem};
                ((TabFolder)this.folder).setSelection(items);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        IView localView = null;
        try {
            class_mon.enter();
            localView = (IView)tabs.get(this.tabItem);
            if (localView instanceof UISWTViewImpl && !((UISWTViewImpl)localView).requestClose()) {
                return;
            }
            tabs.remove(this.tabItem);
        }
        finally {
            class_mon.exit();
        }
        try {
            if (localView != null) {
                if (localView instanceof PluginView) {
                    mainwindow.removeActivePluginView(((PluginView)localView).getPluginViewName());
                }
                if (localView instanceof UISWTPluginView) {
                    mainwindow.removeActivePluginView(((UISWTPluginView)localView).getPluginViewName());
                }
                localView.delete();
            }
            this.tabItem.dispose();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void addTabAddedListener(Listener listener) {
        Tab.addListener(tabAddListeners, listener);
    }

    public static void removeTabAddedListener(Listener listener) {
        Tab.removeListener(tabAddListeners, listener);
    }

    public static void addTabRemovedListener(Listener listener) {
        Tab.addListener(tabRemoveListeners, listener);
    }

    public static void removeTabRemovedListener(Listener listener) {
        Tab.removeListener(tabRemoveListeners, listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addListener(List listenerList, Listener listener) {
        try {
            class_mon.enter();
            listenerList.add(listener);
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void removeListener(List listenerList, Listener listener) {
        try {
            class_mon.enter();
            listenerList.remove(listener);
        }
        finally {
            class_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void notifyListeners(List listenerList, Item sender) {
        try {
            class_mon.enter();
            Iterator iter = listenerList.iterator();
            for (int i = 0; i < listenerList.size(); ++i) {
                ((Listener)iter.next()).handleEvent(Tab.getEvent(sender));
            }
        }
        finally {
            class_mon.exit();
        }
    }

    protected static String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    private static Event getEvent(Item sender) {
        Event e = new Event();
        e.widget = sender;
        return e;
    }

    public void generateDiagnostics(IndentWriter writer) {
        this.view.generateDiagnostics(writer);
    }

    static {
        class_mon = new AEMonitor("Tab:class");
        eventCloseAllowed = true;
        selectedItem = null;
        tabs = new HashMap();
        tabAddListeners = new LinkedList();
        tabRemoveListeners = new LinkedList();
    }
}

