/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import java.util.ArrayList;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.security.SESecurityManager;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.ui.swt.Utils;

public class UIExitUtilsSWT {
    public static boolean canClose(GlobalManager globalManager, boolean bForRestart) {
        if (COConfigurationManager.getBooleanParameter("confirmationOnExit") && !UIExitUtilsSWT.getExitConfirmation(bForRestart)) {
            return false;
        }
        if (globalManager != null) {
            ArrayList<DownloadManager> listUnfinished = new ArrayList<DownloadManager>();
            Object[] dms = globalManager.getDownloadManagers().toArray();
            for (int i = 0; i < dms.length; ++i) {
                DownloadManager dm = (DownloadManager)dms[i];
                if (dm.getState() != 60 || !dm.getDownloadState().isOurContent() || !(dm.getStats().getAvailability() < 2.0f)) continue;
                TRTrackerScraperResponse scrape = dm.getTrackerScrapeResponse();
                int numSeeds = scrape.getSeeds();
                long seedingStartedOn = dm.getStats().getTimeStartedSeeding();
                if (numSeeds > 0 && seedingStartedOn > 0L && scrape.getScrapeStartTime() > seedingStartedOn) {
                    --numSeeds;
                }
                if (numSeeds != 0) continue;
                listUnfinished.add(dm);
            }
            if (listUnfinished.size() > 0) {
                int result;
                if (listUnfinished.size() == 1) {
                    result = Utils.openMessageBox(Utils.findAnyShell(), 192, "Content.alert.notuploaded", new String[]{((DownloadManager)listUnfinished.get(0)).getDisplayName(), MessageText.getString("Content.alert.notuploaded.quit")});
                } else {
                    String sList = "";
                    for (int i = 0; i < listUnfinished.size() && i < 5; ++i) {
                        DownloadManager dm = (DownloadManager)listUnfinished.get(i);
                        if (sList != "") {
                            sList = sList + "\n";
                        }
                        sList = sList + dm.getDisplayName();
                    }
                    result = Utils.openMessageBox(Utils.findAnyShell(), 192, "Content.alert.notuploaded.multi", new String[]{"" + listUnfinished.size(), MessageText.getString("Content.alert.notuploaded.quit"), sList});
                }
                if (result != 64) {
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean getExitConfirmation(boolean for_restart) {
        int result = Utils.openMessageBox(Utils.findAnyShell(), 200, for_restart ? "MainWindow.dialog.restartconfirmation" : "MainWindow.dialog.exitconfirmation", (String[])null);
        return result == 64;
    }

    public static void uiShutdown() {
        if (SystemProperties.isJavaWebStartInstance()) {
            AEThread close = new AEThread("JWS Force Terminate"){

                public void runSupport() {
                    try {
                        Thread.sleep(2500L);
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                    SESecurityManager.exitVM(1);
                }
            };
            close.setDaemon(true);
            close.start();
        }
    }
}

