/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt;

import com.aelitis.azureus.core.impl.AzureusCoreImpl;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.FileTransfer;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.UrlUtils;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.URLTransfer;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.views.utils.VerticalAligner;

public class Utils {
    public static final boolean isGTK;
    public static final boolean LAST_TABLECOLUMN_EXPANDS;
    public static final boolean TABLE_GRIDLINE_IS_ALTERNATING_COLOR;
    private static final boolean DIRECT_SETCHECKED;
    public static final boolean SWT32_TABLEPAINT = false;

    public static void disposeComposite(Composite composite, boolean disposeSelf) {
        if (composite == null || composite.isDisposed()) {
            return;
        }
        Control[] controls = composite.getChildren();
        for (int i = 0; i < controls.length; ++i) {
            Control control = controls[i];
            if (control == null || control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.disposeComposite((Composite)control, true);
            }
            try {
                control.dispose();
                continue;
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
        if (!composite.isDisposed() && disposeSelf) {
            try {
                composite.dispose();
            }
            catch (SWTException e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public static void disposeComposite(Composite composite) {
        Utils.disposeComposite(composite, true);
    }

    public static void disposeSWTObjects(List disposeList) {
        Utils.disposeSWTObjects(disposeList.toArray());
        disposeList.clear();
    }

    public static void disposeSWTObjects(Object[] disposeList) {
        boolean bResourceObjectExists = SWT.getVersion() >= 3129;
        for (int i = 0; i < disposeList.length; ++i) {
            Object o = disposeList[i];
            if (o instanceof Widget && !((Widget)o).isDisposed()) {
                ((Widget)o).dispose();
                continue;
            }
            if (bResourceObjectExists && o instanceof Resource && !((Resource)o).isDisposed()) {
                ((Resource)o).dispose();
                continue;
            }
            try {
                if (o instanceof Cursor && !((Cursor)o).isDisposed()) {
                    ((Cursor)o).dispose();
                    continue;
                }
                if (o instanceof Font && !((Font)o).isDisposed()) {
                    ((Font)o).dispose();
                    continue;
                }
                if (o instanceof GC && !((GC)o).isDisposed()) {
                    ((GC)o).dispose();
                    continue;
                }
                if (o instanceof Image && !((Image)o).isDisposed()) {
                    ((Image)o).dispose();
                    continue;
                }
                if (o instanceof Region && !((Region)o).isDisposed()) {
                    ((Region)o).dispose();
                    continue;
                }
                if (!(o instanceof TextLayout) || ((TextLayout)o).isDisposed()) continue;
                ((TextLayout)o).dispose();
                continue;
            }
            catch (NoClassDefFoundError e) {
                // empty catch block
            }
        }
    }

    public static void setTextLinkFromClipboard(Shell shell, Text url, boolean accept_magnets) {
        String link = Utils.getLinkFromClipboard(shell.getDisplay(), accept_magnets);
        if (link != null) {
            url.setText(link);
        }
    }

    public static String getLinkFromClipboard(Display display, boolean accept_magnets) {
        Clipboard cb = new Clipboard(display);
        TextTransfer transfer = TextTransfer.getInstance();
        String data = (String)cb.getContents((Transfer)transfer);
        String text = UrlUtils.parseTextForURL(data, accept_magnets);
        if (text == null) {
            return "http://";
        }
        return text;
    }

    public static void centreWindow(Shell shell) {
        Rectangle displayArea;
        try {
            displayArea = shell.getMonitor().getClientArea();
        }
        catch (NoSuchMethodError e) {
            displayArea = shell.getDisplay().getClientArea();
        }
        Rectangle shellRect = shell.getBounds();
        if (shellRect.height > displayArea.height) {
            shellRect.height = displayArea.height;
        }
        if (shellRect.width > displayArea.width - 50) {
            shellRect.width = displayArea.width;
        }
        shellRect.x = displayArea.x + (displayArea.width - shellRect.width) / 2;
        shellRect.y = displayArea.y + (displayArea.height - shellRect.height) / 2;
        shell.setBounds(shellRect);
    }

    public static void centerWindowRelativeTo(Shell window, Control control) {
        Rectangle bounds = control.getBounds();
        Point shellSize = window.getSize();
        window.setLocation(bounds.x + bounds.width / 2 - shellSize.x / 2, bounds.y + bounds.height / 2 - shellSize.y / 2);
    }

    public static void createTorrentDropTarget(Composite composite, boolean bAllowShareAdd) {
        try {
            Utils.createDropTarget(composite, bAllowShareAdd, null);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public static void createURLDropTarget(Composite composite, Text url) {
        try {
            Utils.createDropTarget(composite, false, url);
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    private static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url, DropTargetListener dropTargetListener) {
        Transfer[] transferList = SWT.getVersion() >= 3107 ? new Transfer[]{HTMLTransfer.getInstance(), URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()} : new Transfer[]{URLTransfer.getInstance(), FileTransfer.getInstance(), TextTransfer.getInstance()};
        DropTarget dropTarget = new DropTarget((Control)composite, 31);
        dropTarget.setTransfer(transferList);
        dropTarget.addDropListener(dropTargetListener);
        if (Constants.isWindows) {
            return;
        }
        Control[] children = composite.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control.isDisposed()) continue;
            if (control instanceof Composite) {
                Utils.createDropTarget((Composite)control, bAllowShareAdd, url, dropTargetListener);
                continue;
            }
            DropTarget dropTarget2 = new DropTarget(control, 31);
            dropTarget2.setTransfer(transferList);
            dropTarget2.addDropListener(dropTargetListener);
        }
    }

    private static void createDropTarget(Composite composite, boolean bAllowShareAdd, Text url) {
        URLDropTarget target = new URLDropTarget(url, bAllowShareAdd);
        Utils.createDropTarget(composite, bAllowShareAdd, url, (DropTargetListener)target);
    }

    public static void alternateRowBackground(TableItem item) {
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!item.getParent().getLinesVisible()) {
                item.getParent().setLinesVisible(true);
            }
            return;
        }
        if (item == null || item.isDisposed()) {
            return;
        }
        Color[] colors = new Color[]{item.getDisplay().getSystemColor(25), Colors.colorAltRow};
        Color newColor = colors[item.getParent().indexOf(item) % colors.length];
        if (!item.getBackground().equals((Object)newColor)) {
            item.setBackground(newColor);
        }
    }

    public static void alternateTableBackground(Table table) {
        if (table == null || table.isDisposed()) {
            return;
        }
        if (TABLE_GRIDLINE_IS_ALTERNATING_COLOR) {
            if (!table.getLinesVisible()) {
                table.setLinesVisible(true);
            }
            return;
        }
        int iTopIndex = table.getTopIndex();
        int iBottomIndex = Utils.getTableBottomIndex(table, iTopIndex);
        Color[] colors = new Color[]{table.getDisplay().getSystemColor(25), Colors.colorAltRow};
        int iFixedIndex = iTopIndex;
        for (int i = iTopIndex; i <= iBottomIndex; ++i) {
            TableItem row = table.getItem(i);
            if (row.isDisposed()) continue;
            Color newColor = colors[iFixedIndex % colors.length];
            ++iFixedIndex;
            if (row.getBackground().equals((Object)newColor)) continue;
            row.setBackground(newColor);
        }
    }

    public static void setMenuItemImage(MenuItem item, String repoKey) {
        if (!Constants.isOSX) {
            item.setImage(ImageRepository.getImage(repoKey));
        }
    }

    public static void setMenuItemImage(MenuItem item, Image image) {
        if (!Constants.isOSX) {
            item.setImage(image);
        }
    }

    public static void setShellIcon(Shell shell) {
        block5: {
            String[] sImageNames = new String[]{"azureus", "azureus32", "azureus64", "azureus128"};
            if (Constants.isOSX) {
                return;
            }
            try {
                ArrayList<Image> list = new ArrayList<Image>();
                Image[] images = new Image[]{ImageRepository.getImage("azureus"), ImageRepository.getImage("azureus32"), ImageRepository.getImage("azureus64"), ImageRepository.getImage("azureus128")};
                for (int i = 0; i < images.length; ++i) {
                    Image image = ImageRepository.getImage(sImageNames[i]);
                    if (image == null) continue;
                    list.add(image);
                }
                if (list.size() == 0) {
                    return;
                }
                shell.setImages(list.toArray(new Image[0]));
            }
            catch (NoSuchMethodError e) {
                Image image = ImageRepository.getImage(sImageNames[0]);
                if (image == null) break block5;
                shell.setImage(image);
            }
        }
    }

    public static boolean execSWTThread(Runnable code, boolean async) {
        Display display;
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            display = Display.getDefault();
            if (display == null) {
                System.err.println("SWT Thread not started yet!");
                return false;
            }
        } else {
            if (swt.isTerminated()) {
                return false;
            }
            display = swt.getDisplay();
        }
        if (display == null || display.isDisposed() || code == null) {
            return false;
        }
        if (display.getThread() == Thread.currentThread()) {
            code.run();
        } else if (async) {
            try {
                display.asyncExec(code);
            }
            catch (NullPointerException e) {
                return false;
            }
        } else {
            display.syncExec(code);
        }
        return true;
    }

    public static boolean execSWTThread(Runnable code) {
        return Utils.execSWTThread(code, true);
    }

    public static boolean isThisThreadSWT() {
        SWTThread swt = SWTThread.getInstance();
        if (swt == null) {
            System.err.println("SWT Thread not started yet");
            return false;
        }
        Display display = swt.getDisplay();
        if (display == null || display.isDisposed()) {
            return false;
        }
        return display.getThread() == Thread.currentThread();
    }

    public static int openMessageBox(Shell parent, int style, String keyPrefix, String[] textParams) {
        MessageBox mb = new MessageBox(parent, style);
        mb.setMessage(MessageText.getString(keyPrefix + ".text", textParams));
        mb.setText(MessageText.getString(keyPrefix + ".title"));
        return mb.open();
    }

    public static int openMessageBox(Shell parent, int style, String title, String text) {
        MessageBox mb = new MessageBox(parent, style);
        mb.setMessage(text);
        mb.setText(title);
        return mb.open();
    }

    public static int getTableBottomIndex(Table table, int iTopIndex) {
        int itemCount = table.getItemCount();
        if (!table.isVisible() || iTopIndex >= itemCount) {
            return -1;
        }
        if (Constants.isOSX) {
            try {
                TableItem item = table.getItem(iTopIndex);
                Rectangle bounds = item.getBounds();
                Rectangle clientArea = table.getClientArea();
                int itemHeight = table.getItemHeight();
                int iBottomIndex = Math.min(iTopIndex + (clientArea.height + clientArea.y - bounds.y - 1) / itemHeight, itemCount - 1);
                return iBottomIndex;
            }
            catch (NoSuchMethodError e) {
                return Math.min(iTopIndex + (table.getClientArea().height - table.getHeaderHeight() - 1) / table.getItemHeight() + 1, table.getItemCount() - 1);
            }
        }
        int areaHeight = table.getClientArea().height;
        if (areaHeight <= table.getHeaderHeight()) {
            return -1;
        }
        TableItem bottomItem = table.getItem(new Point(2, table.getClientArea().height - 1));
        int iBottomIndex = bottomItem != null ? table.indexOf(bottomItem) : itemCount - 1;
        return iBottomIndex;
    }

    public static void launch(String sFile) {
        if (sFile == null) {
            return;
        }
        if (SWT.getVersion() >= 3315 || SWT.getVersion() < 3300 || UrlUtils.isURL(sFile) || sFile.startsWith("mailto:")) {
            Program.launch((String)sFile);
        } else if (Constants.isOSX) {
            Program.launch((String)("file://" + sFile.replaceAll(" ", "%20")));
        } else {
            Program.launch((String)sFile);
        }
    }

    public static void setCheckedInSetData(final TableItem item, final boolean checked) {
        if (DIRECT_SETCHECKED) {
            item.setChecked(checked);
        } else {
            item.setChecked(!checked);
            item.getDisplay().asyncExec((Runnable)new AERunnable(){

                public void runSupport() {
                    item.setChecked(checked);
                }
            });
        }
        if (Constants.isWindowsXP || isGTK) {
            Rectangle r = item.getBounds(0);
            Table table = item.getParent();
            Rectangle rTable = table.getClientArea();
            r.y += VerticalAligner.getTableAdjustVerticalBy(table);
            table.redraw(0, r.y, rTable.width, r.height, true);
        }
    }

    public static boolean linkShellMetricsToConfig(Shell shell, String sConfigPrefix) {
        String windowRectangle = COConfigurationManager.getStringParameter(sConfigPrefix + ".rectangle", null);
        boolean bDidResize = false;
        if (null != windowRectangle) {
            int i = 0;
            int[] values = new int[4];
            StringTokenizer st = new StringTokenizer(windowRectangle, ",");
            try {
                while (st.hasMoreTokens() && i < 4) {
                    values[i++] = Integer.valueOf(st.nextToken());
                }
                if (i == 4) {
                    Rectangle shellBounds = new Rectangle(values[0], values[1], values[2], values[3]);
                    shell.setBounds(shellBounds);
                    Utils.verifyShellRect(shell, true);
                    bDidResize = true;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        boolean isMaximized = COConfigurationManager.getBooleanParameter(sConfigPrefix + ".maximized");
        shell.setMaximized(isMaximized);
        new ShellMetricsResizeListener(shell, sConfigPrefix);
        return bDidResize;
    }

    public static GridData setGridData(Composite composite, int gridStyle, Control ctrlBestSize, int maxHeight) {
        GridData gridData = new GridData(gridStyle);
        gridData.heightHint = ctrlBestSize.computeSize((int)-1, (int)-1).y;
        if (gridData.heightHint > maxHeight && maxHeight > 0) {
            gridData.heightHint = maxHeight;
        }
        composite.setLayoutData((Object)gridData);
        return gridData;
    }

    public static FormData getFilledFormData() {
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        formData.right = new FormAttachment(100, 0);
        formData.bottom = new FormAttachment(100, 0);
        return formData;
    }

    public static int pixelsToPoint(int pixels, int dpi) {
        int ret = (int)Math.round((double)pixels * 72.0 / (double)dpi);
        return isGTK ? ret - 2 : ret;
    }

    public static int pixelsToPoint(double pixels, int dpi) {
        int ret = (int)Math.round(pixels * 72.0 / (double)dpi);
        return isGTK ? ret - 2 : ret;
    }

    public static boolean drawImage(GC gc, Image image, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        return Utils.drawImage(gc, image, new Point(0, 0), dstRect, clipping, hOffset, vOffset, clearArea);
    }

    public static boolean drawImage(GC gc, Image image, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset) {
        return Utils.drawImage(gc, image, new Point(0, 0), dstRect, clipping, hOffset, vOffset, false);
    }

    public static boolean drawImage(GC gc, Image image, Point srcStart, Rectangle dstRect, Rectangle clipping, int hOffset, int vOffset, boolean clearArea) {
        Rectangle srcRect;
        Point dstAdj;
        if (clipping == null) {
            dstAdj = new Point(0, 0);
            srcRect = new Rectangle(srcStart.x, srcStart.y, dstRect.width, dstRect.height);
        } else {
            if (!dstRect.intersects(clipping)) {
                return false;
            }
            dstAdj = new Point(Math.max(0, clipping.x - dstRect.x), Math.max(0, clipping.y - dstRect.y));
            srcRect = new Rectangle(0, 0, 0, 0);
            srcRect.x = srcStart.x + dstAdj.x;
            srcRect.y = srcStart.y + dstAdj.y;
            srcRect.width = Math.min(dstRect.width - dstAdj.x, clipping.x + clipping.width - dstRect.x);
            srcRect.height = Math.min(dstRect.height - dstAdj.y, clipping.y + clipping.height - dstRect.y);
        }
        if (!srcRect.isEmpty()) {
            try {
                if (clearArea) {
                    gc.fillRectangle(dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
                }
                gc.drawImage(image, srcRect.x, srcRect.y, srcRect.width, srcRect.height, dstRect.x + dstAdj.x + hOffset, dstRect.y + dstAdj.y + vOffset, srcRect.width, srcRect.height);
            }
            catch (Exception e) {
                System.out.println("drawImage: " + e.getMessage() + ": " + image + ", " + srcRect + ", " + (dstRect.x + dstAdj.y + hOffset) + "," + (dstRect.y + dstAdj.y + vOffset) + "," + srcRect.width + "," + srcRect.height + "; imageBounds = " + image.getBounds());
            }
        }
        return true;
    }

    public static void addListenerAndChildren(Composite area, int event2, Listener listener) {
        area.addListener(event2, listener);
        Control[] children = area.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control child = children[i];
            if (child instanceof Composite) {
                Utils.addListenerAndChildren((Composite)child, event2, listener);
                continue;
            }
            child.addListener(event2, listener);
        }
    }

    public static Shell findAnyShell() {
        Shell shell;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null && (shell = uiFunctions.getMainShell()) != null && shell.isDisposed()) {
            return shell;
        }
        Display current = Display.getCurrent();
        if (current == null) {
            return null;
        }
        Shell shell2 = current.getActiveShell();
        if (shell2 != null && !shell2.isDisposed()) {
            return shell2;
        }
        Shell[] shells = current.getShells();
        if (shells.length == 0) {
            return null;
        }
        if (shells[0] != null && !shells[0].isDisposed()) {
            return shells[0];
        }
        return null;
    }

    public static boolean verifyShellRect(Shell shell, boolean bAdjustIfInvalid) {
        boolean bMetricsOk;
        try {
            bMetricsOk = false;
            Point ptTopLeft = shell.getLocation();
            Monitor[] monitors = shell.getDisplay().getMonitors();
            for (int j = 0; j < monitors.length && !bMetricsOk; ++j) {
                Rectangle bounds = monitors[j].getBounds();
                bMetricsOk = bounds.contains(ptTopLeft);
            }
        }
        catch (NoSuchMethodError e) {
            Rectangle bounds = shell.getDisplay().getBounds();
            bMetricsOk = shell.getBounds().intersects(bounds);
        }
        if (!bMetricsOk && bAdjustIfInvalid) {
            Utils.centreWindow(shell);
        }
        return bMetricsOk;
    }

    public static void relayout(Control control) {
        Composite parent;
        if (control == null || control.isDisposed()) {
            return;
        }
        Point size = control.computeSize(-1, -1, true);
        for (parent = control.getParent(); parent != null; parent = parent.getParent()) {
            parent.layout(true);
            Point newSize = control.getSize();
            if (newSize.y < size.y || newSize.x < size.x) continue;
            break;
        }
        if (parent != null) {
            parent.layout();
        }
    }

    public static void beep() {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Display display = Display.getDefault();
                if (display != null) {
                    display.beep();
                }
            }
        });
    }

    static {
        LAST_TABLECOLUMN_EXPANDS = isGTK = SWT.getPlatform().equals("gtk");
        TABLE_GRIDLINE_IS_ALTERNATING_COLOR = isGTK;
        DIRECT_SETCHECKED = !Constants.isOSX || SWT.getVersion() >= 3212;
    }

    private static class ShellMetricsResizeListener
    implements Listener {
        private int state = -1;
        private String sConfigPrefix;
        private Rectangle bounds = null;

        ShellMetricsResizeListener(Shell shell, String sConfigPrefix) {
            this.sConfigPrefix = sConfigPrefix;
            this.state = this.calcState(shell);
            if (this.state == 0) {
                this.bounds = shell.getBounds();
            }
            shell.addListener(11, (Listener)this);
            shell.addListener(10, (Listener)this);
            shell.addListener(12, (Listener)this);
        }

        private int calcState(Shell shell) {
            return shell.getMinimized() ? 128 : (shell.getMaximized() ? 1024 : 0);
        }

        private void saveMetrics() {
            COConfigurationManager.setParameter(this.sConfigPrefix + ".maximized", this.state == 1024);
            if (this.bounds == null) {
                return;
            }
            COConfigurationManager.setParameter(this.sConfigPrefix + ".rectangle", this.bounds.x + "," + this.bounds.y + "," + this.bounds.width + "," + this.bounds.height);
        }

        public void handleEvent(Event event2) {
            Shell shell = (Shell)event2.widget;
            this.state = this.calcState(shell);
            if (event2.type != 12 && this.state == 0) {
                this.bounds = shell.getBounds();
            }
            if (event2.type == 12) {
                this.saveMetrics();
            }
        }
    }

    public static class LabelWrapControlListener
    extends ControlAdapter {
        public void controlResized(ControlEvent e) {
            GridLayout parentLayout;
            if (SWT.getVersion() >= 3105) {
                return;
            }
            Composite parent = (Composite)e.widget;
            Control[] children = parent.getChildren();
            if (children.length > 0 && (parentLayout = (GridLayout)parent.getLayout()) != null) {
                Point size;
                int marginWidth = parentLayout.marginWidth;
                Composite grandParent = parent.getParent();
                if (grandParent instanceof ScrolledComposite) {
                    ScrollBar sb;
                    Composite greatGP = grandParent.getParent();
                    if (greatGP != null) {
                        size = greatGP.getSize();
                        if (greatGP.getLayout() instanceof GridLayout) {
                            marginWidth += ((GridLayout)greatGP.getLayout()).marginWidth;
                        }
                    } else {
                        size = grandParent.getSize();
                    }
                    if (grandParent.getLayout() instanceof GridLayout) {
                        marginWidth += ((GridLayout)grandParent.getLayout()).marginWidth;
                    }
                    if ((sb = grandParent.getVerticalBar()) != null) {
                        size.x -= sb.getSize().x + 1;
                    }
                } else {
                    size = parent.getSize();
                }
                boolean oneChanged = false;
                for (int i = 0; i < children.length; ++i) {
                    GridData gd;
                    if (!(children[i] instanceof Label) || (children[i].getStyle() & 0x40) != 64 || (gd = (GridData)children[i].getLayoutData()) == null || gd.horizontalAlignment != 4) continue;
                    if (gd.horizontalSpan == parentLayout.numColumns) {
                        gd.widthHint = size.x - 2 * marginWidth;
                        oneChanged = true;
                        continue;
                    }
                    Point pt = children[i].getLocation();
                    gd.widthHint = size.x - pt.x - 2 * marginWidth;
                    oneChanged = true;
                }
                if (oneChanged) {
                    parent.layout(true);
                    if (grandParent instanceof ScrolledComposite) {
                        ((ScrolledComposite)grandParent).setMinSize(parent.computeSize(-1, -1, true));
                    }
                }
            }
        }
    }

    private static class URLDropTarget
    extends DropTargetAdapter {
        private final Text url;
        private final boolean bAllowShareAdd;

        public URLDropTarget(Text url, boolean bAllowShareAdd) {
            this.url = url;
            this.bAllowShareAdd = bAllowShareAdd;
        }

        public void dropAccept(DropTargetEvent event2) {
            event2.currentDataType = URLTransfer.pickBestType(event2.dataTypes, event2.currentDataType);
        }

        public void dragOver(DropTargetEvent event2) {
            if (event2.detail != 16 && (event2.operations & event2.detail) > 0) {
                return;
            }
            if ((event2.operations & 4) > 0) {
                event2.detail = 4;
            } else if ((event2.operations & 0x10) > 0) {
                event2.detail = 16;
            } else if ((event2.operations & 1) > 0) {
                event2.detail = 1;
            }
        }

        public void drop(DropTargetEvent event2) {
            String sURL;
            if (this.url == null || this.url.isDisposed()) {
                TorrentOpener.openDroppedTorrents(AzureusCoreImpl.getSingleton(), event2, this.bAllowShareAdd);
            } else if (event2.data instanceof URLTransfer.URLType) {
                if (((URLTransfer.URLType)event2.data).linkURL != null) {
                    this.url.setText(((URLTransfer.URLType)event2.data).linkURL);
                }
            } else if (event2.data instanceof String && (sURL = UrlUtils.parseTextForURL((String)event2.data, true)) != null) {
                this.url.setText(sURL);
            }
        }
    }
}

