/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.components.graphics;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.ui.swt.components.graphics.BackGroundGraphic;
import org.gudy.azureus2.ui.swt.components.graphics.Scale;
import org.gudy.azureus2.ui.swt.components.graphics.ValueFormater;
import org.gudy.azureus2.ui.swt.mainwindow.Colors;

public class ScaledGraphic
extends BackGroundGraphic {
    protected Scale scale;
    protected ValueFormater formater;
    protected Image bufferScale;
    protected int lastMax;

    public ScaledGraphic(Scale scale, ValueFormater formater) {
        this.scale = scale;
        this.formater = formater;
    }

    protected void drawScale(boolean sizeChanged) {
        boolean scaleChanged;
        if (this.drawCanvas == null || this.drawCanvas.isDisposed()) {
            return;
        }
        this.drawBackGround(sizeChanged);
        boolean bl = scaleChanged = this.lastMax != this.scale.getMax();
        if (sizeChanged || scaleChanged || this.bufferScale == null) {
            Rectangle bounds = this.drawCanvas.getClientArea();
            if (bounds.height < 30 || bounds.width < 100) {
                return;
            }
            if (this.bufferScale != null && !this.bufferScale.isDisposed()) {
                this.bufferScale.dispose();
            }
            this.bufferScale = new Image((Device)this.drawCanvas.getDisplay(), bounds);
            GC gcBuffer = new GC((Drawable)this.bufferScale);
            gcBuffer.drawImage(this.bufferBackground, 0, 0);
            gcBuffer.setForeground(Colors.black);
            this.scale.setNbPixels(bounds.height - 16);
            int[] levels = this.scale.getScaleValues();
            for (int i = 0; i < levels.length; ++i) {
                int height = bounds.height - this.scale.getScaledValue(levels[i]) - 2;
                gcBuffer.drawLine(1, height, bounds.width - 70, height);
                gcBuffer.drawText(this.formater.format(levels[i]), bounds.width - 65, height - 12, true);
            }
            gcBuffer.dispose();
        }
    }

    public void dispose() {
        super.dispose();
        if (this.bufferScale != null && !this.bufferScale.isDisposed()) {
            this.bufferScale.dispose();
        }
    }
}

