/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.config;

import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.ui.swt.config.Parameter;

public class ColorParameter
extends Parameter
implements ParameterListener {
    private Button colorChooser;
    protected String sParamName;
    private Image img;

    public ColorParameter(final Composite composite, final String name, int r, int g, int b) {
        super(name);
        this.sParamName = name;
        this.colorChooser = new Button(composite, 8);
        final int rV = COConfigurationManager.getIntParameter(name + ".red", r);
        final int gV = COConfigurationManager.getIntParameter(name + ".green", g);
        final int bV = COConfigurationManager.getIntParameter(name + ".blue", b);
        this.updateButtonColor(composite.getDisplay(), rV, gV, bV);
        COConfigurationManager.addParameterListener(this.sParamName, this);
        this.colorChooser.addListener(12, new Listener(){

            public void handleEvent(Event e) {
                COConfigurationManager.removeParameterListener(ColorParameter.this.sParamName, ColorParameter.this);
                if (ColorParameter.this.img != null && !ColorParameter.this.img.isDisposed()) {
                    ColorParameter.this.img.dispose();
                }
            }
        });
        this.colorChooser.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                ColorDialog cd = new ColorDialog(composite.getShell());
                cd.setRGB(new RGB(rV, gV, bV));
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                ColorParameter.this.newColorChosen();
                COConfigurationManager.setRGBParameter(name, newColor.red, newColor.green, newColor.blue);
            }
        });
    }

    private void updateButtonColor(Display display, int rV, int gV, int bV) {
        Image oldImg = this.img;
        Color color = new Color((Device)display, rV, gV, bV);
        this.img = new Image((Device)display, 25, 10);
        GC gc = new GC((Drawable)this.img);
        gc.setBackground(color);
        gc.fillRectangle(0, 0, 25, 10);
        gc.dispose();
        color.dispose();
        this.colorChooser.setImage(this.img);
        if (oldImg != null && !oldImg.isDisposed()) {
            oldImg.dispose();
        }
    }

    public Control getControl() {
        return this.colorChooser;
    }

    public void setLayoutData(Object layoutData) {
        this.colorChooser.setLayoutData(layoutData);
    }

    public void parameterChanged(String parameterName) {
        int rV = COConfigurationManager.getIntParameter(this.sParamName + ".red");
        int gV = COConfigurationManager.getIntParameter(this.sParamName + ".green");
        int bV = COConfigurationManager.getIntParameter(this.sParamName + ".blue");
        this.updateButtonColor(this.colorChooser.getDisplay(), rV, gV, bV);
    }

    public void newColorChosen() {
    }

    public void setValue(Object value) {
    }
}

