/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.importtorrent.wizard;

import com.aelitis.azureus.core.AzureusCore;
import java.io.File;
import java.io.IOException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.torrent.TOTorrentException;
import org.gudy.azureus2.core3.torrent.TOTorrentFactory;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.TorrentUtils;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizardInputPanel;
import org.gudy.azureus2.ui.swt.wizard.Wizard;

public class ImportTorrentWizard
extends Wizard {
    String torrent_file = "";
    String import_file = "";

    public ImportTorrentWizard(AzureusCore azureus_core, Display display) {
        super(azureus_core, display, "importTorrentWizard.title");
        ImportTorrentWizardInputPanel input_panel = new ImportTorrentWizardInputPanel(this, null);
        this.setFirstPanel(input_panel);
    }

    public void onClose() {
        super.onClose();
    }

    protected void setTorrentFile(String str) {
        this.torrent_file = str;
    }

    protected String getTorrentFile() {
        return this.torrent_file;
    }

    protected void setImportFile(String str) {
        this.import_file = str;
        this.torrent_file = str + ".torrent";
    }

    protected String getImportFile() {
        return this.import_file;
    }

    protected boolean performImport() {
        String error_detail;
        String error_title;
        File input_file;
        try {
            input_file = new File(this.getImportFile()).getCanonicalFile();
        }
        catch (IOException e) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 33);
            mb.setText(MessageText.getString("importTorrentWizard.process.inputfilebad.title"));
            mb.setMessage(MessageText.getString("importTorrentWizard.process.inputfilebad.message") + "\n" + e.toString());
            mb.open();
            return false;
        }
        File output_file = new File(this.getTorrentFile());
        if (output_file.exists()) {
            MessageBox mb = new MessageBox(this.getWizardWindow(), 196);
            mb.setText(MessageText.getString("importTorrentWizard.process.outputfileexists.title"));
            mb.setMessage(MessageText.getString("importTorrentWizard.process.outputfileexists.message"));
            int result = mb.open();
            if (result == 128) {
                return false;
            }
        }
        try {
            try {
                TOTorrent torrent = TOTorrentFactory.deserialiseFromXMLFile(input_file);
                try {
                    torrent.serialiseToBEncodedFile(output_file);
                    return true;
                }
                catch (TOTorrentException e) {
                    error_title = MessageText.getString("importTorrentWizard.process.torrentfail.title");
                    error_detail = TorrentUtils.exceptionToText(e);
                }
            }
            catch (TOTorrentException e) {
                error_title = MessageText.getString("importTorrentWizard.process.importfail.title");
                error_detail = TorrentUtils.exceptionToText(e);
            }
        }
        catch (Throwable e) {
            error_title = MessageText.getString("importTorrentWizard.process.unknownfail.title");
            Debug.printStackTrace(e);
            error_detail = e.toString();
        }
        MessageBox mb = new MessageBox(this.getWizardWindow(), 33);
        mb.setText(error_title);
        mb.setMessage(error_detail);
        mb.open();
        return false;
    }
}

