/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.Iterator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.predicate.AllPredicate;
import org.gudy.azureus2.core3.predicate.NotPredicate;
import org.gudy.azureus2.core3.predicate.Predicable;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.update.UpdateCheckInstance;
import org.gudy.azureus2.plugins.update.UpdateCheckInstanceListener;
import org.gudy.azureus2.ui.swt.BlockedIpsWindow;
import org.gudy.azureus2.ui.swt.KeyBindings;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.debug.UIDebugGenerator;
import org.gudy.azureus2.ui.swt.exporttorrent.wizard.ExportTorrentWizard;
import org.gudy.azureus2.ui.swt.help.AboutWindow;
import org.gudy.azureus2.ui.swt.help.HealthHelpWindow;
import org.gudy.azureus2.ui.swt.importtorrent.wizard.ImportTorrentWizard;
import org.gudy.azureus2.ui.swt.mainwindow.MainWindow;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.nat.NatTestWindow;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.BasicPluginViewImpl;
import org.gudy.azureus2.ui.swt.pluginsinstaller.InstallPluginWizard;
import org.gudy.azureus2.ui.swt.pluginsuninstaller.UnInstallPluginWizard;
import org.gudy.azureus2.ui.swt.predicate.shell.ShellCanMaximizePredicate;
import org.gudy.azureus2.ui.swt.predicate.shell.ShellCanMinimizePredicate;
import org.gudy.azureus2.ui.swt.predicate.shell.ShellIsMinimizedPredicate;
import org.gudy.azureus2.ui.swt.predicate.shell.ShellIsModalPredicate;
import org.gudy.azureus2.ui.swt.predicate.shellmanager.AllManagedShellsAreMinimizedPredicate;
import org.gudy.azureus2.ui.swt.predicate.shellmanager.ShellManagerIsEmptyPredicate;
import org.gudy.azureus2.ui.swt.sharing.ShareUtils;
import org.gudy.azureus2.ui.swt.update.UpdateMonitor;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;

public class MainMenu {
    public static int MENU_BAR = 0;
    public static int MENU_TRANSFER = 1;
    public static int MENU_VIEW = 2;
    private static final LogIDs LOGID = LogIDs.GUI;
    private Display display;
    private MainWindow mainWindow;
    private Shell attachedShell;
    private Menu menuBar;
    private MenuItem menu_plugin;
    private Menu pluginMenu;
    private Menu pluginLogsMenu;
    private Menu transferMenu;
    private Menu viewMenu;
    private AzureusCore core;

    public MainMenu(Shell shell) {
        this.mainWindow = MainWindow.getWindow();
        if (this.mainWindow != null && !this.mainWindow.getShell().isDisposed() && this.mainWindow.getShell() != shell) {
            this.display = SWTThread.getInstance().getDisplay();
            this.attachedShell = shell;
            this.buildMenu(shell, true);
        }
    }

    public MainMenu(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
        this.display = SWTThread.getInstance().getDisplay();
        this.attachedShell = mainWindow.getShell();
        this.buildMenu(mainWindow.getShell(), true);
    }

    public void setMainWindow(MainWindow mainWindow) {
        this.mainWindow = mainWindow;
    }

    public void linkMenuBar(Shell parent) {
        parent.setMenuBar(this.menuBar);
    }

    public void createMenu(AzureusCore core, Shell shell) {
        this.display = SWTThread.getInstance().getDisplay();
        this.attachedShell = shell;
        this.core = core;
        this.buildMenu(shell, false);
    }

    private void buildMenu(final Shell parent, boolean linkToParent) {
        try {
            if (this.core == null) {
                this.core = AzureusCoreFactory.getSingleton();
            }
            this.menuBar = new Menu((Decorations)parent, 2);
            boolean notMainWindow = this.mainWindow != null && this.attachedShell != this.mainWindow.getShell();
            boolean isModal = new ShellIsModalPredicate().evaluate(this.attachedShell);
            MenuItem fileItem = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)fileItem, "MainWindow.menu.file");
            Menu fileMenu = new Menu((Decorations)parent, 4);
            fileItem.setMenu(fileMenu);
            if (isModal) {
                this.performOneTimeDisable(fileItem, true);
            }
            MenuItem file_create = new MenuItem(fileMenu, 0);
            Messages.setLanguageText((Widget)file_create, "MainWindow.menu.file.create");
            KeyBindings.setAccelerator(file_create, "MainWindow.menu.file.create");
            MenuItem file_new = new MenuItem(fileMenu, 64);
            Messages.setLanguageText((Widget)file_new, "MainWindow.menu.file.open");
            MenuItem file_share = new MenuItem(fileMenu, 64);
            Messages.setLanguageText((Widget)file_share, "MainWindow.menu.file.share");
            new MenuItem(fileMenu, 2);
            MenuItem file_import = new MenuItem(fileMenu, 0);
            KeyBindings.setAccelerator(file_import, "MainWindow.menu.file.import");
            Messages.setLanguageText((Widget)file_import, "MainWindow.menu.file.import");
            MenuItem file_export = new MenuItem(fileMenu, 0);
            KeyBindings.setAccelerator(file_export, "MainWindow.menu.file.export");
            Messages.setLanguageText((Widget)file_export, "MainWindow.menu.file.export");
            new MenuItem(fileMenu, 2);
            this.addCloseWindowMenuItem(fileMenu);
            MenuItem closeTabItem = this.addCloseTabMenuItem(fileMenu);
            if (notMainWindow) {
                this.performOneTimeDisable(closeTabItem, false);
            }
            this.addCloseDetailsMenuItem(fileMenu);
            this.addCloseDownloadBarsToMenu(fileMenu);
            if (!Constants.isOSX) {
                new MenuItem(fileMenu, 2);
                MenuItem file_restart = new MenuItem(fileMenu, 0);
                Messages.setLanguageText((Widget)file_restart, "MainWindow.menu.file.restart");
                file_restart.addListener(13, new Listener(){

                    public void handleEvent(Event event2) {
                        UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(true, false);
                    }
                });
                final MenuItem file_exit = new MenuItem(fileMenu, 0);
                if (!COConfigurationManager.getBooleanParameter("Enable System Tray") || !COConfigurationManager.getBooleanParameter("Close To Tray")) {
                    KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
                }
                Messages.setLanguageText((Widget)file_exit, "MainWindow.menu.file.exit");
                file_exit.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        UIFunctionsManagerSWT.getUIFunctionsSWT().dispose(false, false);
                    }
                });
                ParameterListener paramListener = new ParameterListener(){

                    public void parameterChanged(String parameterName) {
                        if (COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                            KeyBindings.removeAccelerator(file_exit, "MainWindow.menu.file.exit");
                        } else {
                            KeyBindings.setAccelerator(file_exit, "MainWindow.menu.file.exit");
                        }
                    }
                };
                COConfigurationManager.addParameterListener("Enable System Tray", paramListener);
                COConfigurationManager.addParameterListener("Close To Tray", paramListener);
            }
            String PREFIX_FILEOPEN = "MainWindow.menu.file.open.";
            Menu newMenu = new Menu((Decorations)parent, 4);
            file_new.setMenu(newMenu);
            MenuItem fileOpenTorrent = new MenuItem(newMenu, 0);
            Messages.setLanguageText((Widget)fileOpenTorrent, "MainWindow.menu.file.open.torrent");
            KeyBindings.setAccelerator(fileOpenTorrent, "MainWindow.menu.file.open.torrent");
            fileOpenTorrent.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openTorrentWindow();
                }
            });
            MenuItem file_new_torrent_for_tracking = new MenuItem(newMenu, 0);
            KeyBindings.setAccelerator(file_new_torrent_for_tracking, "MainWindow.menu.file.open.torrentfortracking");
            Messages.setLanguageText((Widget)file_new_torrent_for_tracking, "MainWindow.menu.file.open.torrentfortracking");
            file_new_torrent_for_tracking.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    TorrentOpener.openTorrentTrackingOnly();
                }
            });
            Menu shareMenu = new Menu((Decorations)parent, 4);
            file_share.setMenu(shareMenu);
            MenuItem file_share_file = new MenuItem(shareMenu, 0);
            KeyBindings.setAccelerator(file_share_file, "MainWindow.menu.file.share.file");
            Messages.setLanguageText((Widget)file_share_file, "MainWindow.menu.file.share.file");
            file_share_file.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareFile(MainMenu.this.core, parent);
                }
            });
            MenuItem file_share_dir = new MenuItem(shareMenu, 0);
            KeyBindings.setAccelerator(file_share_dir, "MainWindow.menu.file.share.dir");
            Messages.setLanguageText((Widget)file_share_dir, "MainWindow.menu.file.share.dir");
            file_share_dir.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareDir(MainMenu.this.core, parent);
                }
            });
            MenuItem file_share_dircontents = new MenuItem(shareMenu, 0);
            KeyBindings.setAccelerator(file_share_dircontents, "MainWindow.menu.file.share.dircontents");
            Messages.setLanguageText((Widget)file_share_dircontents, "MainWindow.menu.file.share.dircontents");
            file_share_dircontents.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareDirContents(MainMenu.this.core, parent, false);
                }
            });
            MenuItem file_share_dircontents_rec = new MenuItem(shareMenu, 0);
            KeyBindings.setAccelerator(file_share_dircontents_rec, "MainWindow.menu.file.share.dircontentsrecursive");
            Messages.setLanguageText((Widget)file_share_dircontents_rec, "MainWindow.menu.file.share.dircontentsrecursive");
            file_share_dircontents_rec.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    ShareUtils.shareDirContents(MainMenu.this.core, parent, true);
                }
            });
            file_create.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new NewTorrentWizard(MainMenu.this.core, MainMenu.this.display);
                }
            });
            file_export.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new ExportTorrentWizard(MainMenu.this.core, MainMenu.this.display);
                }
            });
            file_import.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new ImportTorrentWizard(MainMenu.this.core, MainMenu.this.display);
                }
            });
            if (Constants.isOSX) {
                this.addViewMenu(parent, notMainWindow);
                this.addTransferMenu(parent, isModal, notMainWindow);
            } else {
                this.addTransferMenu(parent, isModal, notMainWindow);
                this.addViewMenu(parent, notMainWindow);
            }
            if (!Constants.isOSX) {
                MenuItem menu_tools = new MenuItem(this.menuBar, 64);
                Messages.setLanguageText((Widget)menu_tools, "MainWindow.menu.tools");
                Menu toolsMenu = new Menu((Decorations)parent, 4);
                menu_tools.setMenu(toolsMenu);
                this.addBlockedIPsMenuItem(toolsMenu);
                this.addConsoleMenuItem(toolsMenu);
                this.addStatisticsMenuItem(toolsMenu);
                this.addNatTestMenuItem(toolsMenu);
                new MenuItem(toolsMenu, 2);
                this.addConfigWizardMenuItem(toolsMenu);
                MenuItem view_config = new MenuItem(toolsMenu, 0);
                KeyBindings.setAccelerator(view_config, "MainWindow.menu.view.configuration");
                Messages.setLanguageText((Widget)view_config, "MainWindow.menu.view.configuration");
                view_config.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                        if (uiFunctions != null) {
                            uiFunctions.showConfig(null);
                        }
                    }
                });
                if (isModal) {
                    this.performOneTimeDisable(menu_tools, true);
                }
            }
            this.menu_plugin = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)this.menu_plugin, "MainWindow.menu.view.plugins");
            this.pluginMenu = new Menu((Decorations)parent, 4);
            this.menu_plugin.setEnabled(false);
            this.menu_plugin.setMenu(this.pluginMenu);
            if (notMainWindow) {
                this.performOneTimeDisable(this.menu_plugin, true);
            }
            MenuItem menu_plugin_logViews = new MenuItem(this.pluginMenu, 64);
            Messages.setLanguageText((Widget)menu_plugin_logViews, "MainWindow.menu.view.plugins.logViews");
            this.pluginLogsMenu = new Menu((Decorations)parent, 4);
            menu_plugin_logViews.setMenu(this.pluginLogsMenu);
            menu_plugin_logViews.setData("EOL", (Object)"1");
            new MenuItem(this.pluginMenu, 2);
            MenuItem plugins_install_wizard = new MenuItem(this.pluginMenu, 0);
            KeyBindings.setAccelerator(plugins_install_wizard, "MainWindow.menu.plugins.installPlugins");
            Messages.setLanguageText((Widget)plugins_install_wizard, "MainWindow.menu.plugins.installPlugins");
            plugins_install_wizard.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new InstallPluginWizard(MainMenu.this.core, MainMenu.this.display);
                }
            });
            MenuItem plugins_uninstall_wizard = new MenuItem(this.pluginMenu, 0);
            KeyBindings.setAccelerator(plugins_uninstall_wizard, "MainWindow.menu.plugins.uninstallPlugins");
            Messages.setLanguageText((Widget)plugins_uninstall_wizard, "MainWindow.menu.plugins.uninstallPlugins");
            plugins_uninstall_wizard.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new UnInstallPluginWizard(MainMenu.this.core, MainMenu.this.display);
                }
            });
            if (Constants.isOSX) {
                MenuItem menu_window = new MenuItem(this.menuBar, 64);
                Messages.setLanguageText((Widget)menu_window, "MainWindow.menu.window");
                Menu windowMenu = new Menu((Decorations)parent, 4);
                menu_window.setMenu(windowMenu);
                if (isModal) {
                    this.performOneTimeDisable(menu_window, true);
                }
                this.addMinimizeWindowMenuItem(windowMenu);
                this.addZoomWindowMenuItem(windowMenu);
                new MenuItem(windowMenu, 2);
                this.addBlockedIPsMenuItem(windowMenu);
                new MenuItem(windowMenu, 2);
                this.addBringAllToFrontMenuItem(windowMenu);
                new MenuItem(windowMenu, 2);
                this.appendWindowMenuItems(windowMenu);
            }
            if (Constants.isCVSVersion()) {
                this.addDebugMenu(this.menuBar);
            }
            MenuItem helpItem = new MenuItem(this.menuBar, 64);
            Messages.setLanguageText((Widget)helpItem, "MainWindow.menu.help");
            Menu helpMenu = new Menu((Decorations)parent, 4);
            helpItem.setMenu(helpMenu);
            if (isModal) {
                this.performOneTimeDisable(helpItem, true);
            }
            if (!Constants.isOSX) {
                MenuItem help_about = new MenuItem(helpMenu, 0);
                Messages.setLanguageText((Widget)help_about, "MainWindow.menu.help.about");
                help_about.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        AboutWindow.show(MainMenu.this.display);
                    }
                });
                new MenuItem(helpMenu, 2);
            }
            MenuItem help_health = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_health, "MyTorrentsView.menu.health");
            help_health.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    HealthHelpWindow.show(MainMenu.this.display);
                }
            });
            MenuItem help_whatsnew = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_whatsnew, "MainWindow.menu.help.releasenotes");
            help_whatsnew.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    new WelcomeWindow(parent);
                }
            });
            MenuItem help_new = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_new, "MainWindow.menu.help.whatsnew");
            help_new.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    Utils.launch("http://azureus.sourceforge.net/changelog.php?version=2.5.0.4");
                }
            });
            MenuItem help_faq = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_faq, "MainWindow.menu.help.faq");
            help_faq.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String faqString = "http://www.azureuswiki.com/index.php/";
                    Utils.launch(faqString);
                }
            });
            MenuItem help_plugin = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_plugin, "MainWindow.menu.help.plugins");
            help_plugin.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    String pluginString = "http://azureus.sourceforge.net/plugin_list.php";
                    Utils.launch(pluginString);
                }
            });
            new MenuItem(helpMenu, 2);
            if (!SystemProperties.isJavaWebStartInstance()) {
                MenuItem help_checkupdate = new MenuItem(helpMenu, 0);
                KeyBindings.setAccelerator(help_checkupdate, "MainWindow.menu.help.checkupdate");
                Messages.setLanguageText((Widget)help_checkupdate, "MainWindow.menu.help.checkupdate");
                help_checkupdate.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions != null) {
                            uiFunctions.bringToFront();
                        }
                        UpdateMonitor.getSingleton(MainMenu.this.core).performCheck(true, false, new UpdateCheckInstanceListener(){

                            public void cancelled(UpdateCheckInstance instance) {
                            }

                            public void complete(UpdateCheckInstance instance) {
                                if (instance.getUpdates().length == 0) {
                                    Utils.execSWTThread(new AERunnable(){

                                        public void runSupport() {
                                            Utils.openMessageBox(parent, 34, "window.update.noupdates", (String[])null);
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
            new MenuItem(helpMenu, 2);
            MenuItem help_debug = new MenuItem(helpMenu, 0);
            Messages.setLanguageText((Widget)help_debug, "MainWindow.menu.help.debug");
            help_debug.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    UIDebugGenerator.generate();
                }
            });
        }
        catch (Exception e) {
            Logger.log(new LogEvent(LOGID, "Error while creating menu items", e));
        }
        if (linkToParent) {
            parent.setMenuBar(this.menuBar);
        }
    }

    private void addDebugMenu(Menu menu) {
        MenuItem item = new MenuItem(menu, 64);
        item.setText("Debug");
        Menu menuDebug = new Menu(menu.getParent(), 4);
        item.setMenu(menuDebug);
        item = new MenuItem(menuDebug, 64);
        item.setText("ScreenSize");
        Menu menuSS = new Menu(menu.getParent(), 4);
        item.setMenu(menuSS);
        item = new MenuItem(menuSS, 0);
        item.setText("640x400");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainMenu.this.mainWindow.getShell().setSize(640, 400);
            }
        });
        item = new MenuItem(menuSS, 0);
        item.setText("800x560");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainMenu.this.mainWindow.getShell().setSize(850, 560);
            }
        });
        item = new MenuItem(menuSS, 0);
        item.setText("1024x700");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainMenu.this.mainWindow.getShell().setSize(1024, 700);
            }
        });
        item = new MenuItem(menuSS, 0);
        item.setText("1280x980");
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MainMenu.this.mainWindow.getShell().setSize(1280, 980);
            }
        });
    }

    private void addTransferMenu(Shell parent, boolean modal, boolean notMainWindow) {
        MenuItem downloadItem = new MenuItem(this.menuBar, 64);
        Messages.setLanguageText((Widget)downloadItem, "MainWindow.menu.transfers");
        this.transferMenu = new Menu((Decorations)parent, 4);
        downloadItem.setMenu(this.transferMenu);
        if (modal) {
            this.performOneTimeDisable(downloadItem, true);
        }
        MenuItem itemStartAll = new MenuItem(this.transferMenu, 0);
        KeyBindings.setAccelerator(itemStartAll, "MainWindow.menu.transfers.startalltransfers");
        Messages.setLanguageText((Widget)itemStartAll, "MainWindow.menu.transfers.startalltransfers");
        MenuItem itemStopAll = new MenuItem(this.transferMenu, 0);
        KeyBindings.setAccelerator(itemStopAll, "MainWindow.menu.transfers.stopalltransfers");
        Messages.setLanguageText((Widget)itemStopAll, "MainWindow.menu.transfers.stopalltransfers");
        final MenuItem itemPause = new MenuItem(this.transferMenu, 0);
        KeyBindings.setAccelerator(itemPause, "MainWindow.menu.transfers.pausetransfers");
        Messages.setLanguageText((Widget)itemPause, "MainWindow.menu.transfers.pausetransfers");
        if (notMainWindow) {
            this.performOneTimeDisable(itemPause, true);
        }
        final MenuItem itemResume = new MenuItem(this.transferMenu, 0);
        KeyBindings.setAccelerator(itemResume, "MainWindow.menu.transfers.resumetransfers");
        Messages.setLanguageText((Widget)itemResume, "MainWindow.menu.transfers.resumetransfers");
        if (notMainWindow) {
            this.performOneTimeDisable(itemResume, true);
        }
        itemStartAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MainMenu.this.core.getGlobalManager().startAllDownloads();
            }
        });
        itemStopAll.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncStopAll();
            }
        });
        itemPause.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                ManagerUtils.asyncPause();
            }
        });
        itemResume.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                MainMenu.this.core.getGlobalManager().resumeDownloads();
            }
        });
        this.transferMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent menu) {
                itemPause.setEnabled(MainMenu.this.core.getGlobalManager().canPauseDownloads());
                itemResume.setEnabled(MainMenu.this.core.getGlobalManager().canResumeDownloads());
            }

            public void menuHidden(MenuEvent menu) {
            }
        });
    }

    private void addViewMenu(Shell parent, boolean notMainWindow) {
        MenuItem viewItem = new MenuItem(this.menuBar, 64);
        Messages.setLanguageText((Widget)viewItem, "MainWindow.menu.view");
        this.viewMenu = new Menu((Decorations)parent, 4);
        viewItem.setMenu(this.viewMenu);
        if (notMainWindow) {
            this.performOneTimeDisable(viewItem, true);
        }
        MainMenu.addMenuItemLabel(this.viewMenu, "MainWindow.menu.view.show");
        MainMenu.indent(this.addMyTorrentsMenuItem(this.viewMenu));
        MainMenu.indent(this.addMyTrackerMenuItem(this.viewMenu));
        MainMenu.indent(this.addMySharesMenuItem(this.viewMenu));
        MainMenu.indent(this.addViewToolbarMenuItem(this.viewMenu));
        if (Constants.isOSX) {
            MainMenu.indent(this.addConsoleMenuItem(this.viewMenu));
            MainMenu.indent(this.addStatisticsMenuItem(this.viewMenu));
        }
    }

    protected void addPluginView(final String sViewID, final UISWTViewEventListener l) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String sResourceID = "Views.plugins." + sViewID + ".title";
                boolean bResourceExists = MessageText.keyExists(sResourceID);
                String name = bResourceExists ? MessageText.getString(sResourceID) : ((bResourceExists = MessageText.keyExists(sResourceID = sViewID)) ? MessageText.getString(sResourceID) : sViewID.replace('.', ' '));
                Menu menu = l instanceof BasicPluginViewImpl ? MainMenu.this.pluginLogsMenu : MainMenu.this.pluginMenu;
                MenuItem[] items = menu.getItems();
                int insert_at = items.length;
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].getData("EOL") == null && name.compareTo(items[i].getText()) >= 0) continue;
                    insert_at = i;
                    break;
                }
                MenuItem item = new MenuItem(menu, 0, insert_at);
                item.setData("ViewID", (Object)sViewID);
                if (bResourceExists) {
                    Messages.setLanguageText((Widget)item, sResourceID);
                } else {
                    item.setText(name);
                }
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions != null) {
                            uiFunctions.openPluginView("Main", sViewID, l, null, true);
                        }
                    }
                });
                MainMenu.this.menu_plugin.setEnabled(true);
            }
        });
    }

    protected void removePluginViews(final String sViewID) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                String sID;
                int i;
                MenuItem[] items = MainMenu.this.pluginMenu.getItems();
                for (i = 0; i < items.length; ++i) {
                    sID = (String)items[i].getData("ViewID");
                    if (sID == null || !sID.equals(sViewID)) continue;
                    items[i].dispose();
                }
                items = MainMenu.this.pluginLogsMenu.getItems();
                for (i = 0; i < items.length; ++i) {
                    sID = (String)items[i].getData("ViewID");
                    if (sID == null || !sID.equals(sViewID)) continue;
                    items[i].dispose();
                }
                UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                if (uiFunctions != null) {
                    uiFunctions.closePluginViews(sViewID);
                }
            }
        });
    }

    protected void addPluginView(final AbstractIView view, final String name) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainMenu.this.pluginMenu == null || MainMenu.this.pluginMenu.isDisposed()) {
                    return;
                }
                MenuItem[] items = MainMenu.this.pluginMenu.getItems();
                int insert_at = items.length;
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].getData("EOL") == null && name.compareTo(items[i].getText()) >= 0) continue;
                    insert_at = i;
                    break;
                }
                MenuItem item = new MenuItem(MainMenu.this.pluginMenu, 0, insert_at);
                item.setText(name);
                item.addListener(13, new Listener(){

                    public void handleEvent(Event e) {
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions != null) {
                            uiFunctions.openPluginView(view, name);
                        }
                    }
                });
                MainMenu.this.menu_plugin.setEnabled(true);
            }
        });
    }

    protected void removePluginView(final AbstractIView view, final String name) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (MainMenu.this.pluginMenu == null || MainMenu.this.pluginMenu.isDisposed()) {
                    return;
                }
                MenuItem[] items = MainMenu.this.pluginMenu.getItems();
                boolean others = false;
                for (int i = 0; i < items.length; ++i) {
                    MenuItem item = items[i];
                    if (item.getStyle() == 2) continue;
                    if (item.getText().equals(name)) {
                        item.dispose();
                        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uiFunctions == null) continue;
                        uiFunctions.closePluginView(view);
                        continue;
                    }
                    others = true;
                }
                MainMenu.this.menu_plugin.setEnabled(others);
            }
        });
    }

    private void appendWindowMenuItems(final Menu windowMenu) {
        final int numTopItems = windowMenu.getItemCount();
        Listener rebuild = new Listener(){

            public void handleEvent(Event event2) {
                try {
                    if (windowMenu.isDisposed() || MainMenu.this.attachedShell.isDisposed()) {
                        return;
                    }
                    int size = ShellManager.sharedManager().getSize();
                    if (size == windowMenu.getItemCount() - numTopItems) {
                        for (int i = numTopItems; i < windowMenu.getItemCount(); ++i) {
                            MenuItem item;
                            item.setSelection((item = windowMenu.getItem(i)).getData() == MainMenu.this.attachedShell);
                        }
                        return;
                    }
                    int i = numTopItems;
                    while (i < windowMenu.getItemCount()) {
                        windowMenu.getItem(i).dispose();
                    }
                    Iterator iter = ShellManager.sharedManager().getWindows();
                    for (int i2 = 0; i2 < size; ++i2) {
                        final Shell sh = (Shell)iter.next();
                        if (sh.isDisposed() || sh.getText().length() == 0) continue;
                        MenuItem item = new MenuItem(windowMenu, 32);
                        item.setText(sh.getText());
                        item.setSelection(MainMenu.this.attachedShell == sh);
                        item.setData((Object)sh);
                        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent event2) {
                                if (event2.widget.isDisposed() || sh.isDisposed()) {
                                    return;
                                }
                                if (sh.getMinimized()) {
                                    sh.setMinimized(false);
                                }
                                sh.open();
                            }
                        });
                    }
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LogIDs.GUI, "rebuild menu error", e));
                }
            }
        };
        ShellManager.sharedManager().addWindowAddedListener(rebuild);
        ShellManager.sharedManager().addWindowRemovedListener(rebuild);
        this.attachedShell.addListener(15, rebuild);
        windowMenu.addListener(22, rebuild);
    }

    private static final MenuItem addMenuItem(Menu menu, String localizationKey, Listener selListener) {
        return MainMenu.addMenuItem(menu, 0, localizationKey, selListener);
    }

    private static final MenuItem addMenuItem(Menu menu, int style, String localizationKey, Listener selListener) {
        MenuItem item = new MenuItem(menu, style);
        Messages.setLanguageText((Widget)item, localizationKey);
        KeyBindings.setAccelerator(item, localizationKey);
        item.addListener(13, selListener);
        return item;
    }

    private static final void indent(MenuItem item) {
        item.setData("IndentItem", (Object)"YES");
        item.setText("  " + item.getText());
    }

    private static final MenuItem addMenuItemLabel(Menu menu, String localizationKey) {
        MenuItem item = new MenuItem(menu, 0);
        Messages.setLanguageText((Widget)item, localizationKey);
        item.setEnabled(false);
        return item;
    }

    private MenuItem addMyTorrentsMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.view.mytorrents", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.showMyTorrents();
                }
            }
        });
    }

    private MenuItem addMyTrackerMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.view.mytracker", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.showMyTracker();
                }
            }
        });
    }

    private MenuItem addMySharesMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.view.myshares", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.showMyShares();
                }
            }
        });
    }

    private MenuItem addViewToolbarMenuItem(Menu menu) {
        final MenuItem item = MainMenu.addMenuItem(menu, 32, "MainWindow.menu.view.iconbar", new Listener(){

            public void handleEvent(Event e) {
                MainMenu.this.mainWindow.setIconBarEnabled(!MainMenu.this.mainWindow.getIconBarEnabled());
            }
        });
        final ParameterListener listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                item.setSelection(COConfigurationManager.getBooleanParameter(parameterName));
            }
        };
        COConfigurationManager.addAndFireParameterListener("IconBar.enabled", listener);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener("IconBar.enabled", listener);
            }
        });
        return item;
    }

    private MenuItem addConsoleMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.view.console", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.showConsole();
                }
            }
        });
    }

    private MenuItem addStatisticsMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.view.stats", new Listener(){

            public void handleEvent(Event e) {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.showStats();
                }
            }
        });
    }

    private MenuItem addNatTestMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.tools.nattest", new Listener(){

            public void handleEvent(Event e) {
                new NatTestWindow();
            }
        });
    }

    private MenuItem addConfigWizardMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.file.configure", new Listener(){

            public void handleEvent(Event e) {
                new ConfigureWizard(MainMenu.this.core, MainMenu.this.display);
            }
        });
    }

    private MenuItem addCloseDetailsMenuItem(Menu menu) {
        final MenuItem item = MainMenu.addMenuItem(menu, "MainWindow.menu.closealldetails", new Listener(){

            public void handleEvent(Event e) {
                Tab.closeAllDetails();
            }
        });
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (!item.isDisposed() && !event2.widget.isDisposed()) {
                    item.setEnabled(MainMenu.this.mainWindow != null && MainMenu.this.mainWindow.getShell() == MainMenu.this.attachedShell && Tab.hasDetails());
                }
            }
        };
        menu.addListener(22, enableHandler);
        this.attachedShell.addListener(15, enableHandler);
        Tab.addTabAddedListener(enableHandler);
        Tab.addTabRemovedListener(enableHandler);
        return item;
    }

    private MenuItem addCloseWindowMenuItem(Menu menu) {
        final boolean isMainWindow = this.mainWindow != null && this.mainWindow.getShell() == this.attachedShell;
        MenuItem item = MainMenu.addMenuItem(menu, "MainWindow.menu.file.closewindow", new Listener(){

            public void handleEvent(Event event2) {
                if (isMainWindow) {
                    if (MainWindow.isAlreadyDead) {
                        return;
                    }
                    MainMenu.this.mainWindow.close();
                } else if (MainMenu.this.attachedShell != null && !MainMenu.this.attachedShell.isDisposed()) {
                    MainMenu.this.attachedShell.close();
                }
            }
        });
        if (!isMainWindow) {
            String oldText = item.getText();
            KeyBindings.setAccelerator(item, "MainWindow.menu.file.closetab");
            item.setText(oldText);
        }
        return item;
    }

    private MenuItem addCloseTabMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.file.closetab", new Listener(){

            public void handleEvent(Event event2) {
                if (MainWindow.isAlreadyDead) {
                    return;
                }
                MainMenu.this.mainWindow.closeViewOrWindow();
            }
        });
    }

    private MenuItem addMinimizeWindowMenuItem(Menu menu) {
        AllPredicate pred = new AllPredicate(new Predicable[]{new ShellCanMinimizePredicate(), new NotPredicate(new ShellIsMinimizedPredicate())});
        MenuItem item = MainMenu.addMenuItem(menu, "MainWindow.menu.window.minimize", new Listener(){

            public void handleEvent(Event event2) {
                if (MainMenu.this.attachedShell.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                MainMenu.this.attachedShell.setMinimized(true);
            }
        });
        Listener enableHandler = MainMenu.getEnableHandler(item, pred, this.attachedShell);
        menu.addListener(22, enableHandler);
        this.attachedShell.addListener(15, enableHandler);
        this.attachedShell.addListener(19, enableHandler);
        this.attachedShell.addListener(20, enableHandler);
        return item;
    }

    private MenuItem addZoomWindowMenuItem(Menu menu) {
        AllPredicate pred = new AllPredicate(new Predicable[]{new ShellCanMaximizePredicate(), new NotPredicate(new ShellIsMinimizedPredicate())});
        MenuItem item = MainMenu.addMenuItem(menu, "MainWindow.menu.window.zoom", new Listener(){

            public void handleEvent(Event event2) {
                if (MainMenu.this.attachedShell.isDisposed()) {
                    event2.doit = false;
                    return;
                }
                MainMenu.this.attachedShell.setMaximized(!MainMenu.this.attachedShell.getMaximized());
            }
        });
        Listener enableHandler = MainMenu.getEnableHandler(item, pred, this.attachedShell);
        menu.addListener(22, enableHandler);
        this.attachedShell.addListener(15, enableHandler);
        this.attachedShell.addListener(19, enableHandler);
        this.attachedShell.addListener(20, enableHandler);
        return item;
    }

    private MenuItem addBringAllToFrontMenuItem(Menu menu) {
        NotPredicate pred = new NotPredicate(new AllManagedShellsAreMinimizedPredicate());
        MenuItem item = MainMenu.addMenuItem(menu, "MainWindow.menu.window.alltofront", new Listener(){

            public void handleEvent(Event event2) {
                Iterator iter = ShellManager.sharedManager().getWindows();
                while (iter.hasNext()) {
                    Shell shell = (Shell)iter.next();
                    if (shell.isDisposed() || shell.getMinimized()) continue;
                    shell.open();
                }
            }
        });
        Listener enableHandler = MainMenu.getEnableHandler(item, pred, ShellManager.sharedManager());
        menu.addListener(22, enableHandler);
        this.attachedShell.addListener(15, enableHandler);
        MainMenu.setHandlerForShellManager(item, ShellManager.sharedManager(), enableHandler);
        return item;
    }

    private MenuItem addBlockedIPsMenuItem(Menu menu) {
        return MainMenu.addMenuItem(menu, "MainWindow.menu.view.ipFilter", new Listener(){

            public void handleEvent(Event event2) {
                if (MainWindow.isAlreadyDead) {
                    return;
                }
                BlockedIpsWindow.showBlockedIps(MainMenu.this.core, MainMenu.this.mainWindow.getShell());
            }
        });
    }

    public MenuItem addCloseDownloadBarsToMenu(Menu menu) {
        MenuItem item = MainMenu.addMenuItem(menu, "MainWindow.menu.closealldownloadbars", new Listener(){

            public void handleEvent(Event e) {
                MinimizedWindow.closeAll();
            }
        });
        NotPredicate pred = new NotPredicate(new ShellManagerIsEmptyPredicate());
        Listener enableHandler = MainMenu.getEnableHandler(item, pred, MinimizedWindow.getShellManager());
        menu.addListener(22, enableHandler);
        this.attachedShell.addListener(15, enableHandler);
        MainMenu.setHandlerForShellManager(item, MinimizedWindow.getShellManager(), enableHandler);
        return item;
    }

    public void updateMenuText(Object menu) {
        MenuItem item;
        if (menu == null) {
            return;
        }
        if (menu instanceof Menu) {
            MenuItem[] menus = ((Menu)menu).getItems();
            for (int i = 0; i < menus.length; ++i) {
                this.updateMenuText(menus[i]);
            }
        } else if (menu instanceof MenuItem && (item = (MenuItem)menu).getData() != null && item.getData() instanceof String) {
            item.setText(MessageText.getString((String)item.getData()));
            this.updateMenuText(item.getMenu());
        }
    }

    private static void setHandlerForShellManager(MenuItem item, final ShellManager mgr, final Listener evtHandler) {
        mgr.addWindowAddedListener(evtHandler);
        mgr.addWindowRemovedListener(evtHandler);
        item.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event2) {
                mgr.removeWindowAddedListener(evtHandler);
                mgr.removeWindowRemovedListener(evtHandler);
            }
        });
    }

    private static Listener getEnableHandler(final MenuItem item, final Predicable pred, final Object evalObj) {
        Listener enableHandler = new Listener(){

            public void handleEvent(Event event2) {
                if (!item.isDisposed() && !event2.widget.isDisposed()) {
                    item.setEnabled(pred.evaluate(evalObj));
                }
            }
        };
        return enableHandler;
    }

    private void performOneTimeDisable(MenuItem item, boolean affectsChildMenuItems) {
        item.setEnabled(false);
        if (affectsChildMenuItems) {
            Menu childMenu = item.getMenu();
            if (childMenu == null) {
                return;
            }
            for (int i = 0; i < childMenu.getItemCount(); ++i) {
                childMenu.getItem(i).setEnabled(false);
            }
        }
    }

    public Menu getMenu(int id) {
        if (id == MENU_BAR) {
            return this.menuBar;
        }
        if (id == MENU_TRANSFER) {
            return this.transferMenu;
        }
        if (id == MENU_VIEW) {
            return this.viewMenu;
        }
        return null;
    }
}

