/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.AzureusCoreException;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderAdapter;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerListener;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEDiagnostics;
import org.gudy.azureus2.core3.util.AEDiagnosticsEvidenceGenerator;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.IndentWriter;
import org.gudy.azureus2.ui.swt.IconBar;
import org.gudy.azureus2.ui.swt.IconBarEnabler;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.MinimizedWindow;
import org.gudy.azureus2.ui.swt.OpenTorrentWindow;
import org.gudy.azureus2.ui.swt.PasswordWindow;
import org.gudy.azureus2.ui.swt.Tab;
import org.gudy.azureus2.ui.swt.TrayWindow;
import org.gudy.azureus2.ui.swt.UIExitUtilsSWT;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.associations.AssociationChecker;
import org.gudy.azureus2.ui.swt.components.ColorUtils;
import org.gudy.azureus2.ui.swt.components.shell.ShellManager;
import org.gudy.azureus2.ui.swt.config.wizard.ConfigureWizard;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateShell;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.mainwindow.GUIUpdater;
import org.gudy.azureus2.ui.swt.mainwindow.Initializer;
import org.gudy.azureus2.ui.swt.mainwindow.MainMenu;
import org.gudy.azureus2.ui.swt.mainwindow.MainStatusBar;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThread;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;
import org.gudy.azureus2.ui.swt.mainwindow.UIFunctionsImpl;
import org.gudy.azureus2.ui.swt.maketorrent.NewTorrentWizard;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.sharing.progress.ProgressWindow;
import org.gudy.azureus2.ui.swt.update.UpdateWindow;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.ConfigView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.ManagerView;
import org.gudy.azureus2.ui.swt.views.MySharesView;
import org.gudy.azureus2.ui.swt.views.MyTorrentsSuperView;
import org.gudy.azureus2.ui.swt.views.MyTrackerView;
import org.gudy.azureus2.ui.swt.views.stats.StatsView;
import org.gudy.azureus2.ui.swt.views.table.utils.TableColumnManager;
import org.gudy.azureus2.ui.swt.welcome.WelcomeWindow;
import org.gudy.azureus2.ui.swt.wizard.WizardListener;
import org.gudy.azureus2.ui.systray.SystemTraySWT;

public class MainWindow
extends AERunnable
implements GlobalManagerListener,
DownloadManagerListener,
ParameterListener,
IconBarEnabler,
AEDiagnosticsEvidenceGenerator,
ObfusticateShell {
    private static final LogIDs LOGID = LogIDs.GUI;
    private static MainWindow window;
    private Initializer initializer;
    private GUIUpdater updater;
    private AzureusCore azureus_core;
    private GlobalManager globalManager;
    public static boolean isAlreadyDead;
    public static boolean isDisposeFromListener;
    private Display display;
    private Composite parent;
    private Shell shell;
    private MainMenu mainMenu;
    private IconBar iconBar;
    private boolean useCustomTab;
    private Composite folder;
    private MainStatusBar mainStatusBar;
    private TrayWindow downloadBasket;
    private SystemTraySWT systemTraySWT;
    private HashMap downloadViews;
    private AEMonitor downloadViews_mon = new AEMonitor("MainWindow:dlviews");
    private Tab mytorrents;
    private Tab my_tracker_tab;
    private Tab my_shares_tab;
    private Tab stats_tab;
    private Tab console;
    private Tab config;
    private ConfigView config_view;
    protected AEMonitor this_mon = new AEMonitor("MainWindow");
    private UISWTInstanceImpl uiSWTInstanceImpl = null;
    private ArrayList events;
    private UIFunctionsSWT uiFunctions;
    private boolean bIconBarEnabled = false;
    private boolean bShowMainWindow;
    Map pluginTabs = new HashMap();

    public MainWindow(AzureusCore _azureus_core, Initializer _initializer, ArrayList events) {
        this.bShowMainWindow = true;
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MainWindow start"));
            }
            AEDiagnostics.addEvidenceGenerator(this);
            this.azureus_core = _azureus_core;
            this.globalManager = this.azureus_core.getGlobalManager();
            this.initializer = _initializer;
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
            this.events = events;
            this.display.asyncExec((Runnable)this);
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public MainWindow(AzureusCore _azureus_core, Initializer _initializer, Shell shell, Composite parent, UISWTInstanceImpl swtinstance) {
        this.shell = shell;
        this.parent = parent;
        this.bShowMainWindow = true;
        try {
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "MainWindow start"));
            }
            AEDiagnostics.addEvidenceGenerator(this);
            this.azureus_core = _azureus_core;
            this.globalManager = this.azureus_core.getGlobalManager();
            this.initializer = _initializer;
            this.display = SWTThread.getInstance().getDisplay();
            window = this;
            this.uiSWTInstanceImpl = swtinstance;
        }
        catch (AzureusCoreException e) {
            Debug.printStackTrace(e);
        }
    }

    public void setShowMainWindow(boolean b) {
        this.bShowMainWindow = b;
    }

    public void runSupport() {
        try {
            FormData formData;
            this.uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (this.uiFunctions == null) {
                this.uiFunctions = new UIFunctionsImpl(this);
                UIFunctionsManager.setUIFunctions(this.uiFunctions);
            } else {
                this.uiFunctions = new UIFunctionsImpl(this);
            }
            this.globalManager.loadExistingTorrentsNow(true);
            this.useCustomTab = COConfigurationManager.getBooleanParameter("useCustomTab");
            COConfigurationManager.addParameterListener("config.style.useSIUnits", this);
            this.mytorrents = null;
            this.my_tracker_tab = null;
            this.console = null;
            this.config = null;
            this.config_view = null;
            this.downloadViews = new HashMap();
            Label attachToTopOf = null;
            Label controlAboveFolder = null;
            Composite controlBelowFolder = null;
            if (this.shell == null) {
                this.shell = new Shell(this.display, 3280);
                this.shell.setData("class", (Object)this);
                this.shell.setText("Azureus");
                Utils.setShellIcon(this.shell);
                if (this.parent == null) {
                    this.parent = this.shell;
                }
                ShellManager.sharedManager().addWindow(this.shell);
                this.mainMenu = new MainMenu(this);
                FormLayout mainLayout = new FormLayout();
                mainLayout.marginHeight = 0;
                mainLayout.marginWidth = 0;
                try {
                    mainLayout.spacing = 0;
                }
                catch (NoSuchFieldError e) {
                    // empty catch block
                }
                this.shell.setLayout((Layout)mainLayout);
                Utils.linkShellMetricsToConfig(this.shell, "window");
                this.shell.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event2) {
                        if (!isAlreadyDead) {
                            isDisposeFromListener = true;
                            if (MainWindow.this.shell != null) {
                                MainWindow.this.shell.removeDisposeListener((DisposeListener)this);
                                MainWindow.this.dispose(false, false);
                            }
                            isAlreadyDead = true;
                        }
                    }
                });
                this.shell.addShellListener((ShellListener)new ShellAdapter(){

                    public void shellClosed(ShellEvent event2) {
                        if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Close To Tray")) {
                            MainWindow.this.minimizeToTray(event2);
                        } else {
                            event2.doit = MainWindow.this.dispose(false, false);
                        }
                    }

                    public void shellIconified(ShellEvent event2) {
                        if (MainWindow.this.systemTraySWT != null && COConfigurationManager.getBooleanParameter("Enable System Tray") && COConfigurationManager.getBooleanParameter("Minimize To Tray")) {
                            MainWindow.this.minimizeToTray(event2);
                        }
                    }
                });
                this.shell.addListener(20, new Listener(){

                    public void handleEvent(Event e) {
                        if (Constants.isOSX && COConfigurationManager.getBooleanParameter("Password enabled", false)) {
                            e.doit = false;
                            MainWindow.this.shell.setVisible(false);
                            PasswordWindow.showPasswordWindow(MainWindow.this.display);
                        }
                    }
                });
                Label separator = new Label(this.parent, 258);
                formData = new FormData();
                formData.top = new FormAttachment(0, 0);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                separator.setLayoutData((Object)formData);
                attachToTopOf = separator;
                this.mainStatusBar = new MainStatusBar();
                Composite statusBar = this.mainStatusBar.initStatusBar(this.azureus_core, this.globalManager, this.display, (Composite)this.shell);
                controlAboveFolder = attachToTopOf;
                controlBelowFolder = statusBar;
            }
            try {
                Utils.createTorrentDropTarget(this.parent, true);
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, "Drag and Drop not available", e));
            }
            if (!this.useCustomTab) {
                this.folder = new TabFolder(this.parent, 512);
            } else {
                this.folder = new CTabFolder(this.parent, 0x800040);
                final Color bg = ColorUtils.getShade(this.folder.getBackground(), Constants.isOSX ? -25 : -6);
                final Color fg = ColorUtils.getShade(this.folder.getForeground(), Constants.isOSX ? 25 : 6);
                this.folder.setBackground(bg);
                this.folder.setForeground(fg);
                ((CTabFolder)this.folder).setBorderVisible(false);
                this.folder.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent event2) {
                        bg.dispose();
                        fg.dispose();
                    }
                });
                ((CTabFolder)this.folder).addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

                    public void close(CTabFolderEvent event2) {
                        if (!Tab.closed((Item)event2.item)) {
                            event2.doit = false;
                        }
                    }
                });
            }
            formData = new FormData();
            formData.top = controlAboveFolder == null ? new FormAttachment(0, 0) : new FormAttachment(controlAboveFolder);
            formData.bottom = controlBelowFolder == null ? new FormAttachment(100, 0) : new FormAttachment(controlBelowFolder);
            formData.left = new FormAttachment(0, 0);
            formData.right = new FormAttachment(100, 0);
            this.folder.setLayoutData((Object)formData);
            Tab.initialize(this, this.folder);
            this.folder.getDisplay().addFilter(1, new Listener(){

                public void handleEvent(Event event2) {
                    Control focus_control = MainWindow.this.display.getFocusControl();
                    if (focus_control != null && focus_control.getShell() != MainWindow.this.shell) {
                        return;
                    }
                    int key = event2.character;
                    if ((event2.stateMask & SWT.MOD1) != 0 && event2.character <= '\u001a' && event2.character > '\u0000') {
                        key += 96;
                    }
                    if (key == 27 || event2.keyCode == 0x100000D && event2.stateMask == 262144) {
                        Tab.closeCurrent();
                        event2.doit = false;
                    } else if (event2.keyCode == 0x100000F || event2.character == '\t' && (event2.stateMask & 0x40000) != 0) {
                        if ((event2.stateMask & 0x20000) == 0) {
                            event2.doit = false;
                            Tab.selectNextTab(true);
                        } else if (event2.stateMask == 131072) {
                            Tab.selectNextTab(false);
                            event2.doit = false;
                        }
                    } else if (key == 108 && (event2.stateMask & SWT.MOD1) != 0) {
                        OpenTorrentWindow.invokeURLPopup(MainWindow.this.shell, MainWindow.this.globalManager);
                        event2.doit = false;
                    }
                }
            });
            SelectionAdapter selectionAdapter = new SelectionAdapter(){

                public void widgetSelected(final SelectionEvent event2) {
                    if (MainWindow.this.display != null && !MainWindow.this.display.isDisposed()) {
                        Utils.execSWTThread(new AERunnable(){

                            public void runSupport() {
                                CTabItem item;
                                if (MainWindow.this.useCustomTab && (item = (CTabItem)event2.item) != null && !item.isDisposed() && !MainWindow.this.folder.isDisposed()) {
                                    try {
                                        ((CTabFolder)MainWindow.this.folder).setSelection(item);
                                        Control control = item.getControl();
                                        if (control != null) {
                                            control.setVisible(true);
                                            control.setFocus();
                                        }
                                    }
                                    catch (Throwable e) {
                                        Debug.printStackTrace(e);
                                    }
                                }
                                if (MainWindow.this.iconBar != null) {
                                    MainWindow.this.iconBar.setCurrentEnabler(MainWindow.this);
                                }
                            }
                        });
                    }
                }
            };
            if (!this.useCustomTab) {
                ((TabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
            } else {
                try {
                    ((CTabFolder)this.folder).setMinimumCharacters(75);
                }
                catch (Exception e) {
                    Logger.log(new LogEvent(LOGID, "Can't set MIN_TAB_WIDTH", e));
                }
                ((CTabFolder)this.folder).addCTabFolderListener((CTabFolderListener)new CTabFolderAdapter(){

                    public void itemClosed(CTabFolderEvent event2) {
                        if (!event2.doit) {
                            return;
                        }
                        Tab.closed((Item)((CTabItem)event2.item));
                        event2.doit = true;
                        ((CTabItem)event2.item).dispose();
                    }
                });
                ((CTabFolder)this.folder).addSelectionListener((SelectionListener)selectionAdapter);
                try {
                    ((CTabFolder)this.folder).setSelectionBackground(new Color[]{this.display.getSystemColor(25), this.display.getSystemColor(25), this.display.getSystemColor(22)}, new int[]{10, 90}, true);
                }
                catch (NoSuchMethodError e) {
                    ((CTabFolder)this.folder).setSelectionBackground(new Color[]{this.display.getSystemColor(25)}, new int[0]);
                }
                ((CTabFolder)this.folder).setSelectionForeground(this.display.getSystemColor(24));
                try {
                    ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
                }
                catch (NoSuchMethodError e) {
                    // empty catch block
                }
            }
            if (Logger.isEnabled()) {
                Logger.log(new LogEvent(LOGID, "Initializing GUI complete"));
            }
            this.globalManager.addListener(this);
            this.azureus_core.getPluginManager().firePluginEvent(1);
            if (!COConfigurationManager.getBooleanParameter("Wizard Completed")) {
                ConfigureWizard wizard = new ConfigureWizard(this.getAzureusCore(), this.display);
                wizard.addListener(new WizardListener(){

                    public void closed() {
                        MainWindow.this.azureus_core.getPluginManager().firePluginEvent(2);
                    }
                });
            } else {
                this.azureus_core.getPluginManager().firePluginEvent(2);
            }
            if (this.uiSWTInstanceImpl == null) {
                this.uiSWTInstanceImpl = new UISWTInstanceImpl(this.azureus_core);
                this.uiSWTInstanceImpl.init();
            }
            if (this.azureus_core.getTrackerHost().getTorrents().length > 0) {
                this.showMyTracker();
            }
            if (COConfigurationManager.getBooleanParameter("Open MyTorrents", true)) {
                this.showMyTorrents();
            }
            new ProgressWindow();
            if (COConfigurationManager.getBooleanParameter("Open Console", false)) {
                this.showConsole();
            }
            this.events = null;
            if (COConfigurationManager.getBooleanParameter("Open Config", false)) {
                this.showConfig();
            }
            if (COConfigurationManager.getBooleanParameter("Open Stats On Start", false)) {
                this.showStats();
            }
            COConfigurationManager.addParameterListener("GUI_SWT_bFancyTab", this);
            this.updater = new GUIUpdater(this);
            this.updater.start();
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        COConfigurationManager.addAndFireParameterListener("IconBar.enabled", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                MainWindow.this.setIconBarEnabled(COConfigurationManager.getBooleanParameter(parameterName));
            }
        });
        this.showMainWindow();
    }

    protected boolean getIconBarEnabled() {
        return this.bIconBarEnabled;
    }

    protected void setIconBarEnabled(boolean enabled) {
        if (enabled == this.bIconBarEnabled || this.shell.isDisposed()) {
            return;
        }
        this.bIconBarEnabled = enabled;
        COConfigurationManager.setParameter("IconBar.enabled", this.bIconBarEnabled);
        if (this.bIconBarEnabled) {
            try {
                this.iconBar = new IconBar(this.parent);
                this.iconBar.setCurrentEnabler(this);
                Composite cIconBar = this.iconBar.getComposite();
                FormData folderLayoutData = (FormData)this.folder.getLayoutData();
                FormData formData = new FormData();
                formData.top = folderLayoutData.top != null && folderLayoutData.top.control != null ? new FormAttachment(folderLayoutData.top.control) : new FormAttachment(0, 0);
                folderLayoutData.top = new FormAttachment((Control)cIconBar);
                formData.left = new FormAttachment(0, 0);
                formData.right = new FormAttachment(100, 0);
                this.iconBar.setLayoutData(formData);
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Creating Icon Bar", e));
            }
        } else if (this.iconBar != null) {
            try {
                FormData folderLayoutData = (FormData)this.folder.getLayoutData();
                FormData iconBarLayoutData = (FormData)this.iconBar.getComposite().getLayoutData();
                folderLayoutData.top = iconBarLayoutData.top != null && iconBarLayoutData.top.control != null ? new FormAttachment(iconBarLayoutData.top.control) : new FormAttachment(0, 0);
                this.iconBar.delete();
                this.iconBar = null;
            }
            catch (Exception e) {
                Logger.log(new LogEvent(LOGID, "Removing Icon Bar", e));
            }
        }
        this.shell.layout(true, true);
    }

    private void showMainWindow() {
        boolean bStartMinimize;
        if (!this.bShowMainWindow) {
            return;
        }
        boolean bEnableTray = COConfigurationManager.getBooleanParameter("Enable System Tray") && (!Constants.isOSX || SWT.getVersion() > 3300);
        boolean bPassworded = COConfigurationManager.getBooleanParameter("Password enabled", false);
        boolean bl = bStartMinimize = bEnableTray && (bPassworded || COConfigurationManager.getBooleanParameter("Start Minimized", false));
        if (!bStartMinimize) {
            this.shell.layout();
            this.shell.open();
            if (!Constants.isOSX) {
                this.shell.forceActive();
            }
        } else if (Constants.isOSX) {
            this.shell.setMinimized(true);
            this.shell.setVisible(true);
        }
        if (bEnableTray) {
            try {
                this.systemTraySWT = new SystemTraySWT();
            }
            catch (Throwable e) {
                Logger.log(new LogEvent(LOGID, 3, "Upgrade to SWT3.0M8 or later for system tray support."));
            }
            if (bStartMinimize) {
                this.minimizeToTray(null);
            } else if (bPassworded) {
                this.minimizeToTray(null);
                this.setVisible(true);
            }
        }
        COConfigurationManager.addAndFireParameterListener("Show Download Basket", this);
        this.checkForWhatsNewWindow();
        AssociationChecker.checkAssociations();
        this.azureus_core.triggerLifeCycleComponentCreated(this.uiFunctions);
        this.azureus_core.getPluginManager().firePluginEvent(6);
    }

    protected void showMyTracker() {
        if (this.my_tracker_tab == null) {
            this.my_tracker_tab = new Tab(new MyTrackerView(this.azureus_core));
            this.my_tracker_tab.getView().getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.my_tracker_tab = null;
                }
            });
        } else {
            this.my_tracker_tab.setFocus();
            this.refreshIconBar();
        }
    }

    protected void showMyShares() {
        if (this.my_shares_tab == null) {
            this.my_shares_tab = new Tab(new MySharesView(this.azureus_core));
            this.my_shares_tab.getView().getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.my_shares_tab = null;
                }
            });
        } else {
            this.my_shares_tab.setFocus();
            this.refreshIconBar();
        }
    }

    protected void showMyTorrents() {
        if (this.mytorrents == null) {
            MyTorrentsSuperView view = new MyTorrentsSuperView(this.azureus_core);
            this.mytorrents = new Tab(view);
            this.mytorrents.getView().getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.mytorrents = null;
                }
            });
        } else {
            this.mytorrents.setFocus();
        }
        this.refreshIconBar();
    }

    private void minimizeToTray(ShellEvent event2) {
        if (event2 != null) {
            event2.doit = false;
        }
        if (Constants.isOSX) {
            this.shell.setMinimized(true);
        } else {
            this.shell.setVisible(false);
        }
        if (this.downloadBasket != null) {
            this.downloadBasket.setVisible(true);
        }
        MinimizedWindow.setAllVisible(true);
    }

    private void updateComponents() {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.refreshStatusText();
        }
        if (this.folder != null) {
            if (this.useCustomTab) {
                ((CTabFolder)this.folder).update();
            } else {
                ((TabFolder)this.folder).update();
            }
        }
    }

    public boolean destroyRequest() {
        Logger.log(new LogEvent(LOGID, "MainWindow::destroyRequest"));
        if (COConfigurationManager.getBooleanParameter("Password enabled", false) && !PasswordWindow.showPasswordWindow(this.display)) {
            Logger.log(new LogEvent(LOGID, "    denied - password is enabled"));
            return false;
        }
        Utils.execSWTThread(new Runnable(){

            public void run() {
                MainWindow.this.dispose(false, false);
            }
        });
        return true;
    }

    public void destroyed() {
    }

    public void destroyInitiated() {
    }

    public void seedingStatusChanged(boolean seeding_only_mode) {
    }

    public void downloadManagerAdded(DownloadManager created) {
        created.addListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void openManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(downloadManager)) {
                Tab tab = (Tab)this.downloadViews.get(downloadManager);
                tab.setFocus();
                this.refreshIconBar();
            } else {
                Tab tab = new Tab(new ManagerView(this.azureus_core, downloadManager));
                this.downloadViews.put(downloadManager, tab);
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeManagerView(DownloadManager downloadManager) {
        try {
            this.downloadViews_mon.enter();
            this.downloadViews.remove(downloadManager);
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void downloadManagerRemoved(DownloadManager removed) {
        try {
            this.downloadViews_mon.enter();
            if (this.downloadViews.containsKey(removed)) {
                final Tab tab = (Tab)this.downloadViews.get(removed);
                Utils.execSWTThread(new AERunnable(){

                    public void runSupport() {
                        if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                            return;
                        }
                        tab.dispose();
                    }
                });
            }
        }
        finally {
            this.downloadViews_mon.exit();
        }
    }

    public Display getDisplay() {
        return this.display;
    }

    public Shell getShell() {
        return this.shell;
    }

    public void setVisible(final boolean visible) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                if (visible && !MainWindow.this.shell.getVisible() && COConfigurationManager.getBooleanParameter("Password enabled", false) && !PasswordWindow.showPasswordWindow(MainWindow.this.display)) {
                    MainWindow.this.shell.setVisible(false);
                    return;
                }
                MainWindow.this.shell.setVisible(visible);
                if (visible) {
                    if (MainWindow.this.downloadBasket != null) {
                        MainWindow.this.downloadBasket.setVisible(false);
                        MainWindow.this.downloadBasket.setMoving(false);
                    }
                    MainWindow.this.shell.forceActive();
                    MainWindow.this.shell.setMinimized(false);
                }
            }
        });
    }

    public boolean isVisible() {
        return this.shell.isVisible();
    }

    public boolean dispose(boolean for_restart, boolean close_already_in_progress) {
        if (isAlreadyDead) {
            return true;
        }
        if (!UIExitUtilsSWT.canClose(this.globalManager, for_restart)) {
            return false;
        }
        if (this.systemTraySWT != null) {
            this.systemTraySWT.dispose();
        }
        Tab.closeAllTabs();
        isAlreadyDead = true;
        if (this.updater != null) {
            this.updater.stopIt();
        }
        if (this.initializer != null) {
            this.initializer.stopIt(for_restart, close_already_in_progress);
        }
        if (!this.shell.isDisposed() && !isDisposeFromListener) {
            this.shell.dispose();
        }
        COConfigurationManager.removeParameterListener("config.style.useSIUnits", this);
        COConfigurationManager.removeParameterListener("Show Download Basket", this);
        COConfigurationManager.removeParameterListener("GUI_SWT_bFancyTab", this);
        UIExitUtilsSWT.uiShutdown();
        return true;
    }

    public GlobalManager getGlobalManager() {
        return this.globalManager;
    }

    public static MainWindow getWindow() {
        return window;
    }

    public TrayWindow getTray() {
        return this.downloadBasket;
    }

    public boolean isUseCustomTab() {
        return this.useCustomTab;
    }

    protected void openPluginView(String sParentID, String sViewID, UISWTViewEventListener l, Object dataSource, boolean bSetFocus) {
        UISWTViewImpl view = null;
        try {
            view = new UISWTViewImpl(sParentID, sViewID, l);
        }
        catch (Exception e) {
            Tab tab = (Tab)this.pluginTabs.get(sViewID);
            if (tab != null) {
                tab.setFocus();
            }
            return;
        }
        view.dataSourceChanged(dataSource);
        Tab tab = new Tab(view, bSetFocus);
        this.pluginTabs.put(sViewID, tab);
    }

    protected void closePluginViews(String sViewID) {
        CTabItem[] items;
        if (this.folder instanceof CTabFolder) {
            items = ((CTabFolder)this.folder).getItems();
        } else if (this.folder instanceof TabFolder) {
            items = ((TabFolder)this.folder).getItems();
        } else {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            String sID;
            IView view = Tab.getView((Item)items[i]);
            if (!(view instanceof UISWTViewImpl) || (sID = ((UISWTViewImpl)view).getViewID()) == null || !sID.equals(sViewID)) continue;
            try {
                this.closePluginView(view);
                continue;
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected UISWTView[] getPluginViews() {
        CTabItem[] items;
        if (this.folder instanceof CTabFolder) {
            items = ((CTabFolder)this.folder).getItems();
        } else if (this.folder instanceof TabFolder) {
            items = ((TabFolder)this.folder).getItems();
        } else {
            return new UISWTView[0];
        }
        ArrayList<IView> views = new ArrayList<IView>();
        for (int i = 0; i < items.length; ++i) {
            IView view = Tab.getView((Item)items[i]);
            if (!(view instanceof UISWTViewImpl)) continue;
            views.add(view);
        }
        return views.toArray(new UISWTView[0]);
    }

    protected void openPluginView(final AbstractIView view, final String name) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                Tab tab = (Tab)MainWindow.this.pluginTabs.get(name);
                if (tab != null) {
                    tab.setFocus();
                } else {
                    tab = new Tab(view);
                    MainWindow.this.pluginTabs.put(name, tab);
                }
            }
        });
    }

    protected void closePluginView(IView view) {
        Item tab = Tab.getTab(view);
        if (tab != null) {
            Tab.closed(tab);
        }
    }

    public void removeActivePluginView(String view_name) {
        this.pluginTabs.remove(view_name);
    }

    public void parameterChanged(String parameterName) {
        if (parameterName.equals("Show Download Basket")) {
            if (COConfigurationManager.getBooleanParameter("Show Download Basket")) {
                if (this.downloadBasket == null) {
                    this.downloadBasket = new TrayWindow(this);
                    this.downloadBasket.setVisible(true);
                }
            } else if (this.downloadBasket != null) {
                this.downloadBasket.setVisible(false);
                this.downloadBasket = null;
            }
        }
        if (parameterName.equals("GUI_SWT_bFancyTab") && this.folder instanceof CTabFolder && this.folder != null && !this.folder.isDisposed()) {
            try {
                ((CTabFolder)this.folder).setSimple(!COConfigurationManager.getBooleanParameter("GUI_SWT_bFancyTab"));
            }
            catch (NoSuchMethodError noSuchMethodError) {
                // empty catch block
            }
        }
        if (parameterName.equals("config.style.useSIUnits")) {
            this.updateComponents();
        }
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("open")) {
            return true;
        }
        if (itemKey.equals("new")) {
            return true;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            return currentView.isEnabled(itemKey);
        }
        return false;
    }

    public boolean isSelected(String itemKey) {
        return false;
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("open")) {
            TorrentOpener.openTorrentWindow();
            return;
        }
        if (itemKey.equals("new")) {
            new NewTorrentWizard(this.getAzureusCore(), this.display);
            return;
        }
        IView currentView = this.getCurrentView();
        if (currentView != null) {
            currentView.itemActivated(itemKey);
        }
    }

    IView getCurrentView() {
        try {
            if (!this.useCustomTab) {
                TabItem[] selection = ((TabFolder)this.folder).getSelection();
                if (selection.length > 0) {
                    return Tab.getView((Item)selection[0]);
                }
                return null;
            }
            return Tab.getView((Item)((CTabFolder)this.folder).getSelection());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void refreshIconBar() {
        if (this.iconBar != null) {
            this.iconBar.setCurrentEnabler(this);
        }
    }

    public void close() {
        this.getShell().close();
    }

    public void closeViewOrWindow() {
        if (this.getCurrentView() != null) {
            Tab.closeCurrent();
        } else {
            this.close();
        }
    }

    protected ConfigView showConfig() {
        if (this.config == null) {
            this.config_view = new ConfigView(this.azureus_core);
            this.config = new Tab(this.config_view);
            this.config_view.getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.config = null;
                    MainWindow.this.config_view = null;
                }
            });
        } else {
            this.config.setFocus();
        }
        return this.config_view;
    }

    protected boolean showConfig(String id) {
        this.showConfig();
        if (this.config_view == null) {
            return false;
        }
        if (id == null) {
            return true;
        }
        return this.config_view.selectSection(id);
    }

    public void showConsole() {
        if (this.console == null) {
            this.console = new Tab(new LoggerView(this.events));
            this.console.getView().getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.console = null;
                }
            });
        } else {
            this.console.setFocus();
        }
    }

    protected void showStats() {
        if (this.stats_tab == null) {
            this.stats_tab = new Tab(new StatsView(this.globalManager, this.azureus_core));
            this.stats_tab.getView().getComposite().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    MainWindow.this.stats_tab = null;
                }
            });
        } else {
            this.stats_tab.setFocus();
        }
    }

    protected void showStatsDHT() {
        this.showStats();
        if (this.stats_tab == null) {
            return;
        }
        ((StatsView)this.stats_tab.getView()).showDHT();
    }

    protected void showStatsTransfers() {
        this.showStats();
        if (this.stats_tab == null) {
            return;
        }
        ((StatsView)this.stats_tab.getView()).showTransfers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedLanguageItem() {
        try {
            this.this_mon.enter();
            Messages.updateLanguageForControl((Widget)this.shell);
            if (this.systemTraySWT != null) {
                this.systemTraySWT.updateLanguage();
            }
            if (this.mainStatusBar != null) {
                this.mainStatusBar.refreshStatusText();
            }
            if (this.folder != null) {
                if (this.useCustomTab) {
                    ((CTabFolder)this.folder).update();
                } else {
                    ((TabFolder)this.folder).update();
                }
            }
            if (this.downloadBasket != null) {
                this.downloadBasket.updateLanguage();
            }
            Tab.updateLanguage();
            if (this.mainStatusBar != null) {
                this.mainStatusBar.updateStatusText();
            }
            if (this.mainMenu != null) {
                this.mainMenu.updateMenuText(this.mainMenu.getMenu(MainMenu.MENU_BAR));
            }
        }
        finally {
            this.this_mon.exit();
        }
    }

    public MainMenu getMenu() {
        return this.mainMenu;
    }

    public void setMenu(MainMenu menu) {
        this.mainMenu = menu;
    }

    public void setUpdateNeeded(UpdateWindow updateWindow) {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.setUpdateNeeded(updateWindow);
        }
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void stateChanged(final DownloadManager manager, int state) {
        if (!(state != 50 && state != 60 || this.display == null || this.display.isDisposed())) {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    MinimizedWindow mw;
                    if (MainWindow.this.display == null || MainWindow.this.display.isDisposed()) {
                        return;
                    }
                    if (COConfigurationManager.getBooleanParameter("Open Details", false)) {
                        MainWindow.this.openManagerView(manager);
                    }
                    if (COConfigurationManager.getBooleanParameter("Open Bar", false) && (mw = MinimizedWindow.get(manager)) == null) {
                        new MinimizedWindow(manager, MainWindow.this.shell);
                    }
                }
            });
        }
    }

    public AzureusCore getAzureusCore() {
        return this.azureus_core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generate(IndentWriter writer) {
        writer.println("SWT UI");
        try {
            writer.indent();
            writer.println("SWT Version:" + SWT.getVersion() + "/" + SWT.getPlatform());
            writer.println("MyTorrents");
            Tab t = this.mytorrents;
            if (t != null) {
                try {
                    writer.indent();
                    t.generateDiagnostics(writer);
                }
                finally {
                    writer.exdent();
                }
            }
            if ((t = this.my_tracker_tab) != null) {
                writer.println("MyTracker");
                try {
                    writer.indent();
                    t.generateDiagnostics(writer);
                }
                finally {
                    writer.exdent();
                }
            }
            if ((t = this.my_shares_tab) != null) {
                writer.println("MyShares");
                try {
                    writer.indent();
                    t.generateDiagnostics(writer);
                }
                finally {
                    writer.exdent();
                }
            }
            TableColumnManager.getInstance().generateDiagnostics(writer);
        }
        finally {
            writer.exdent();
        }
    }

    private void checkForWhatsNewWindow() {
        String CONFIG_LASTSHOWN = "welcome.version.lastshown";
        try {
            int latestDisplayed;
            String lastShown = "";
            boolean bIsStringParam = true;
            try {
                lastShown = COConfigurationManager.getStringParameter("welcome.version.lastshown", "");
            }
            catch (Exception e) {
                bIsStringParam = false;
            }
            if (lastShown.length() == 0 && (latestDisplayed = COConfigurationManager.getIntParameter("welcome.version.lastshown", 0)) > 0) {
                bIsStringParam = false;
                String s = "" + latestDisplayed;
                for (int i = 0; i < s.length(); ++i) {
                    if (i != 0) {
                        lastShown = lastShown + ".";
                    }
                    lastShown = lastShown + s.charAt(i);
                }
            }
            if (Constants.compareVersions(lastShown, Constants.getBaseVersion()) < 0) {
                new WelcomeWindow(this.shell);
                if (!bIsStringParam) {
                    COConfigurationManager.removeParameter("welcome.version.lastshown");
                }
                COConfigurationManager.setParameter("welcome.version.lastshown", Constants.getBaseVersion());
                COConfigurationManager.save();
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public UISWTInstanceImpl getUISWTInstanceImpl() {
        return this.uiSWTInstanceImpl;
    }

    protected void setStatusText(String string) {
        if (this.mainStatusBar != null) {
            this.mainStatusBar.setStatusText(string);
        }
    }

    public SystemTraySWT getSystemTraySWT() {
        return this.systemTraySWT;
    }

    public MainStatusBar getMainStatusBar() {
        return this.mainStatusBar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Image generateObfusticatedImage() {
        IView[] allViews = Tab.getAllViews();
        for (int i = 0; i < allViews.length; ++i) {
            IView view = allViews[i];
            if (!(view instanceof ObfusticateTab)) continue;
            Item tab = Tab.getTab(view);
            tab.setText(((ObfusticateTab)((Object)view)).getObfusticatedHeader());
            this.folder.update();
        }
        Rectangle clientArea = this.shell.getClientArea();
        Image image = new Image((Device)this.display, clientArea.width, clientArea.height);
        GC gc = new GC((Drawable)this.shell);
        try {
            gc.copyArea(image, clientArea.x, clientArea.y);
        }
        finally {
            gc.dispose();
        }
        IView currentView = this.getCurrentView();
        if (currentView instanceof ObfusticateImage) {
            Point ofs = this.shell.toDisplay(clientArea.x, clientArea.y);
            try {
                ((ObfusticateImage)((Object)currentView)).obfusticatedImage(image, ofs);
            }
            catch (Exception e) {
                Debug.out("Obfusticating " + currentView, e);
            }
        }
        for (int i = 0; i < allViews.length; ++i) {
            IView view = allViews[i];
            if (!(view instanceof ObfusticateTab)) continue;
            view.refresh();
        }
        return image;
    }

    private static Point getStoredWindowSize() {
        String[] values;
        Display current;
        Point size = null;
        boolean isMaximized = COConfigurationManager.getBooleanParameter("window.maximized", false);
        if (isMaximized && (current = Display.getCurrent()) != null) {
            Rectangle clientArea = current.getClientArea();
            size = new Point(clientArea.width, clientArea.height);
            return size;
        }
        String windowRectangle = COConfigurationManager.getStringParameter("window.rectangle", null);
        if (windowRectangle != null && (values = windowRectangle.split(",")).length == 4) {
            try {
                size = new Point(Integer.parseInt(values[2]), Integer.parseInt(values[3]));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return size;
    }

    public static void addToVersionCheckMessage(final Map map) {
        try {
            Utils.execSWTThread(new AERunnable(){

                public void runSupport() {
                    Shell shell;
                    Point size = null;
                    if (window != null && (shell = window.getShell()) != null && !shell.getMinimized()) {
                        size = shell.getSize();
                    }
                    if (size == null && (size = MainWindow.getStoredWindowSize()) == null) {
                        return;
                    }
                    map.put("mainwindow.w", new Long(size.x));
                    map.put("mainwindow.h", new Long(size.y));
                }
            }, false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public UIFunctionsSWT getUIFunctions() {
        return this.uiFunctions;
    }

    static {
        isAlreadyDead = false;
        isDisposeFromListener = false;
    }
}

