/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.ui.IUIIntializer;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.ui.swt.mainwindow.SWTThreadAlreadyInstanciatedException;

public class SWTThread {
    private static final int FREQ_PER_SEC_LIMIT = 10;
    private static SWTThread instance;
    Display display;
    private boolean sleak;
    private boolean terminated;
    private Thread runner;
    private final IUIIntializer initializer;
    private Map freq_map = new HashMap();

    public static SWTThread getInstance() {
        return instance;
    }

    public static void createInstance(IUIIntializer initializer) throws SWTThreadAlreadyInstanciatedException {
        if (instance != null) {
            throw new SWTThreadAlreadyInstanciatedException();
        }
        boolean bGTKTableBug_default = SWT.getPlatform().equals("gtk");
        COConfigurationManager.setBooleanDefault("SWT_bGTKTableBug", bGTKTableBug_default);
        new SWTThread(initializer);
    }

    private SWTThread(final IUIIntializer app) {
        this.initializer = app;
        instance = this;
        try {
            this.display = Display.getCurrent();
            if (this.display == null) {
                this.display = new Display();
                this.sleak = false;
            } else {
                this.sleak = true;
            }
        }
        catch (Exception e) {
            this.display = new Display();
            this.sleak = false;
        }
        Display.setAppName((String)"Azureus");
        if (Constants.isOSX) {
            try {
                Class<?> ehancerClass = Class.forName("org.gudy.azureus2.ui.swt.osx.CarbonUIEnhancer");
                Constructor<?> constructor = ehancerClass.getConstructor(new Class[0]);
                constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                Debug.printStackTrace(e);
            }
        }
        if (app != null) {
            this.runner = new Thread((Runnable)new AERunnable(){

                public void runSupport() {
                    app.run();
                }
            }, "Main Thread");
            this.runner.start();
        }
        if (!this.sleak) {
            while (!this.display.isDisposed() && !this.terminated) {
                try {
                    if (this.display.readAndDispatch()) continue;
                    this.display.sleep();
                }
                catch (Exception e) {
                    if (Constants.isOSX && e instanceof SWTException && e.getMessage().equals("Device is disposed")) {
                        Logger.log(new LogEvent(LogIDs.GUI, "Weird non-critical display disposal in readAndDispatch"));
                        continue;
                    }
                    if (SWT.getVersion() < 3119) {
                        e.printStackTrace();
                        continue;
                    }
                    Debug.printStackTrace(e);
                }
            }
            if (!this.terminated) {
                app.stopIt(false, false);
                this.terminated = true;
            }
            try {
                if (!this.display.isDisposed()) {
                    this.display.dispose();
                }
            }
            catch (Throwable t) {
                if (SWT.getVersion() < 3119) {
                    t.printStackTrace();
                }
                Debug.printStackTrace(t);
            }
            PlatformManagerFactory.getPlatformManager().dispose();
        }
    }

    public void terminate() {
        this.terminated = true;
        this.display.dispose();
    }

    public Display getDisplay() {
        return this.display;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public IUIIntializer getInitializer() {
        return this.initializer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void limitFrequencyAsyncExec(Object owner, Display display, AERunnable target) {
        if (display.isDisposed()) {
            return;
        }
        int now = (int)(SystemTime.getCurrentTime() / 1000L);
        boolean do_it = true;
        Map map = this.freq_map;
        synchronized (map) {
            if (this.freq_map.size() > 1024) {
                Debug.out("Frequency map is overloaded - check your logic!!!!");
            } else {
                int[] data = (int[])this.freq_map.get(owner);
                if (data == null) {
                    data = new int[]{now, 0};
                    this.freq_map.put(owner, data);
                }
                if (data[0] == now) {
                    data[1] = data[1] + 1;
                    if (data[1] > 10) {
                        do_it = false;
                        Debug.out("SWT frequency limit exceeded for " + owner.getClass());
                    }
                } else {
                    data[0] = now;
                    data[1] = 1;
                }
            }
        }
        if (do_it) {
            display.asyncExec((Runnable)target);
        }
    }
}

