/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.mainwindow;

import com.aelitis.azureus.core.AzureusCore;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.impl.TransferSpeedValidator;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.shells.InputShell;

public class SelectableSpeedMenu {
    private static Map parseSpeedPartitionStringCache = new HashMap();

    public static void generateMenuItems(final Menu parent, AzureusCore core, final GlobalManager globalManager, final boolean up_menu) {
        boolean unlim;
        MenuItem[] oldItems = parent.getItems();
        for (int i = 0; i < oldItems.length; ++i) {
            oldItems[i].dispose();
        }
        final String configKey = up_menu ? TransferSpeedValidator.getActiveUploadParameter(globalManager) : "Max Download Speed KBs";
        int speedPartitions = 12;
        int maxBandwidth = COConfigurationManager.getIntParameter(configKey);
        boolean bl = unlim = maxBandwidth == 0;
        if (maxBandwidth == 0 && !up_menu) {
            GlobalManagerStats stats = globalManager.getStats();
            int dataReceive = stats.getDataReceiveRate();
            maxBandwidth = dataReceive < 1024 ? 275 : dataReceive / 1024;
        }
        boolean auto = false;
        if (up_menu) {
            final String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
            auto = COConfigurationManager.getBooleanParameter(configAutoKey);
            final MenuItem auto_item = new MenuItem(parent, 32);
            auto_item.setText(MessageText.getString("ConfigView.auto"));
            auto_item.addListener(13, new Listener(){

                public void handleEvent(Event e) {
                    COConfigurationManager.setParameter(configAutoKey, auto_item.getSelection());
                    COConfigurationManager.save();
                }
            });
            if (auto) {
                auto_item.setSelection(true);
            }
            auto_item.setEnabled(TransferSpeedValidator.isAutoUploadAvailable(core));
            new MenuItem(parent, 2);
        }
        MenuItem item = new MenuItem(parent, 16);
        item.setText(MessageText.getString("MyTorrentsView.menu.setSpeed.unlimited"));
        item.setData("maxkb", (Object)new Integer(0));
        item.setSelection(unlim && !auto);
        item.addListener(13, SelectableSpeedMenu.getLimitMenuItemListener(up_menu, parent, globalManager, configKey));
        Integer[] speed_limits = null;
        String config_prefix = "config.ui.speed.partitions.manual." + (up_menu ? "upload" : "download") + ".";
        if (COConfigurationManager.getBooleanParameter(config_prefix + "enabled", false)) {
            speed_limits = SelectableSpeedMenu.parseSpeedPartitionString(COConfigurationManager.getStringParameter(config_prefix + "values", ""));
        }
        if (speed_limits == null) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            int delta = 0;
            for (int i = 0; i < 12; ++i) {
                int[] valuePair = delta == 0 ? new int[]{maxBandwidth} : new int[]{maxBandwidth - delta, maxBandwidth + delta};
                for (int j = 0; j < valuePair.length; ++j) {
                    if (j == 0) {
                        l.add(0, new Integer(valuePair[j]));
                        continue;
                    }
                    l.add(new Integer(valuePair[j]));
                }
                delta += delta >= 50 ? 50 : (delta >= 10 ? 10 : (delta >= 5 ? 5 : (delta >= 2 ? 3 : 1)));
            }
            speed_limits = l.toArray(new Integer[l.size()]);
        }
        for (int i = 0; i < speed_limits.length; ++i) {
            void i_value = speed_limits[i];
            int value = i_value.intValue();
            if (value < 5) continue;
            item = new MenuItem(parent, 16);
            item.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(value * 1024, true));
            item.setData("maxkb", (Object)i_value);
            item.addListener(13, SelectableSpeedMenu.getLimitMenuItemListener(up_menu, parent, globalManager, configKey));
            item.setSelection(!unlim && value == maxBandwidth && !auto);
        }
        new MenuItem(parent, 2);
        MenuItem itemDownSpeedManual = new MenuItem(parent, 8);
        Messages.setLanguageText((Widget)itemDownSpeedManual, "MyTorrentsView.menu.manual");
        itemDownSpeedManual.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int newSpeed;
                String kbps_str = MessageText.getString("MyTorrentsView.dialog.setNumber.inKbps", new String[]{DisplayFormatters.getRateUnit(1)});
                InputShell is = new InputShell("MyTorrentsView.dialog.setSpeed.title", new String[]{MessageText.getString(up_menu ? "MyTorrentsView.dialog.setNumber.upload" : "MyTorrentsView.dialog.setNumber.download")}, "MyTorrentsView.dialog.setNumber.text", new String[]{kbps_str, MessageText.getString(up_menu ? "MyTorrentsView.dialog.setNumber.upload" : "MyTorrentsView.dialog.setNumber.download")});
                String sReturn = is.open();
                if (sReturn == null) {
                    return;
                }
                try {
                    newSpeed = (int)Double.valueOf(sReturn).doubleValue();
                }
                catch (NumberFormatException er) {
                    MessageBox mb = new MessageBox(parent.getShell(), 33);
                    mb.setText(MessageText.getString("MyTorrentsView.dialog.NumberError.title"));
                    mb.setMessage(MessageText.getString("MyTorrentsView.dialog.NumberError.text"));
                    mb.open();
                    return;
                }
                if (up_menu) {
                    // empty if block
                }
                if (up_menu) {
                    String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
                    COConfigurationManager.setParameter(configAutoKey, false);
                }
                int cValue = (Integer)new TransferSpeedValidator(configKey, new Integer(newSpeed)).getValue();
                COConfigurationManager.setParameter(configKey, cValue);
                COConfigurationManager.save();
            }
        });
    }

    private static synchronized Integer[] parseSpeedPartitionString(String s) {
        Integer[] result = (Integer[])parseSpeedPartitionStringCache.get(s);
        if (result == null) {
            try {
                result = SelectableSpeedMenu.parseSpeedPartitionString0(s);
            }
            catch (NumberFormatException nfe) {
                result = new Integer[]{};
            }
            parseSpeedPartitionStringCache.put(s, result);
        }
        if (result.length == 0) {
            return null;
        }
        return result;
    }

    private static Integer[] parseSpeedPartitionString0(String s) {
        StringTokenizer tokeniser = new StringTokenizer(s.trim(), ",");
        TreeSet<Integer> values = new TreeSet<Integer>();
        while (tokeniser.hasMoreTokens()) {
            values.add(new Integer(Integer.parseInt(tokeniser.nextToken().trim())));
        }
        return values.toArray(new Integer[values.size()]);
    }

    private static final Listener getLimitMenuItemListener(final boolean up_menu, final Menu parent, final GlobalManager globalManager, final String configKey) {
        return new Listener(){

            public void handleEvent(Event event2) {
                MenuItem[] items = parent.getItems();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i] == event2.widget) {
                        items[i].setSelection(true);
                        if (up_menu) {
                            String configAutoKey = TransferSpeedValidator.getActiveAutoUploadParameter(globalManager);
                            COConfigurationManager.setParameter(configAutoKey, false);
                        }
                        int cValue = (Integer)new TransferSpeedValidator(configKey, (Number)items[i].getData("maxkb")).getValue();
                        COConfigurationManager.setParameter(configKey, cValue);
                        COConfigurationManager.save();
                        continue;
                    }
                    items[i].setSelection(false);
                }
            }
        };
    }
}

