/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.pluginsimpl;

import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.awt.Frame;
import java.awt.Panel;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.ui.swt.plugins.UISWTView;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewEventImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class UISWTViewImpl
extends AbstractIView
implements UISWTView {
    public static final String CFG_PREFIX = "Views.plugins.";
    private Object dataSource = null;
    private final UISWTViewEventListener eventListener;
    private Composite composite;
    private final String sViewID;
    private int iControlType = 0;
    private boolean bFirstGetCompositeCall = true;
    private final String sParentID;
    private String sTitle = null;

    public UISWTViewImpl(String sParentID, String sViewID, UISWTViewEventListener eventListener) throws Exception {
        this.sParentID = sParentID;
        this.sViewID = sViewID;
        this.eventListener = eventListener;
        if (!eventListener.eventOccurred(new UISWTViewEventImpl(this, 0, this))) {
            throw new Exception();
        }
    }

    public Object getDataSource() {
        return this.dataSource;
    }

    public String getViewID() {
        return this.sViewID;
    }

    public void closeView() {
        try {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null) {
                uiFunctions.closePluginView(this);
            }
        }
        catch (Exception e) {
            Debug.out(e);
        }
    }

    public void setControlType(int iControlType) {
        if (iControlType == 1 || iControlType == 0) {
            this.iControlType = iControlType;
        }
    }

    public void triggerEvent(int eventType, Object data) {
        try {
            this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.sViewID + "; EventID=" + eventType + "; data=" + data, t);
        }
    }

    private boolean triggerEvent2(int eventType, Object data) {
        try {
            return this.eventListener.eventOccurred(new UISWTViewEventImpl(this, eventType, data));
        }
        catch (Throwable t) {
            throw new UIRuntimeException("UISWTView.triggerEvent:: ViewID=" + this.sViewID + "; EventID=" + eventType + "; data=" + data, t);
        }
    }

    public void setTitle(String title) {
        this.sTitle = title;
    }

    public void dataSourceChanged(Object newDataSource) {
        this.dataSource = newDataSource;
        this.triggerEvent(1, newDataSource);
    }

    public void delete() {
        this.triggerEvent(7, null);
        super.delete();
    }

    public Composite getComposite() {
        if (this.bFirstGetCompositeCall) {
            this.bFirstGetCompositeCall = false;
        }
        return this.composite;
    }

    public String getData() {
        String key = CFG_PREFIX + this.sViewID + ".title";
        if (MessageText.keyExists(key)) {
            return key;
        }
        return this.sViewID;
    }

    public String getFullTitle() {
        if (this.sTitle != null) {
            return this.sTitle;
        }
        return super.getFullTitle();
    }

    public void initialize(Composite parent) {
        if (this.iControlType == 0) {
            this.composite = new Composite(parent, 0);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData((Object)gridData);
            this.triggerEvent(2, this.composite);
            if (this.composite.getLayout() instanceof GridLayout) {
                Control[] children = this.composite.getChildren();
                for (int i = 0; i < children.length; ++i) {
                    Control control = children[i];
                    Object layoutData = control.getLayoutData();
                    if (layoutData != null && layoutData instanceof GridData) continue;
                    if (layoutData != null) {
                        Logger.log(new LogEvent(LogIDs.PLUGIN, 1, "Plugin View '" + this.sViewID + "' tried to setLayouData of " + control + " to a " + layoutData.getClass().getName()));
                    }
                    gridData = children.length == 1 ? new GridData(4, 4, true, true) : new GridData();
                    control.setLayoutData((Object)gridData);
                }
            }
        } else {
            this.composite = new Composite(parent, 0x1000000);
            FillLayout layout = new FillLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.composite.setLayout((Layout)layout);
            GridData gridData = new GridData(1808);
            this.composite.setLayoutData((Object)gridData);
            Frame f = SWT_AWT.new_Frame((Composite)this.composite);
            Panel pan = new Panel();
            f.add(pan);
            this.triggerEvent(2, pan);
        }
        if (this.composite != null) {
            this.composite.addListener(26, new Listener(){

                public void handleEvent(Event event2) {
                    UISWTViewImpl.this.triggerEvent(3, null);
                }
            });
            this.composite.addListener(27, new Listener(){

                public void handleEvent(Event event2) {
                    UISWTViewImpl.this.triggerEvent(4, null);
                }
            });
        }
    }

    public void refresh() {
        this.triggerEvent(5, null);
    }

    public void updateLanguage() {
        super.updateLanguage();
        this.triggerEvent(6, null);
    }

    public String getParentID() {
        return this.sParentID;
    }

    public boolean requestClose() {
        return this.triggerEvent2(8, null);
    }
}

