/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.shells;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SimpleTimer;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.core3.util.TimerEvent;
import org.gudy.azureus2.core3.util.TimerEventPerformer;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.mainwindow.TorrentOpener;

public class MessageBoxShell {
    private static final String REGEX_URLHTML = "<A HREF=\"(.+?)\">(.+?)</A>";
    private static final int MIN_SIZE_X = 300;
    private static final int MIN_SIZE_Y = 200;
    private static final int MAX_SIZE_X = 500;
    private static int numOpen = 0;
    private Shell parent;
    private final String title;
    private final String text;
    private final String[] buttons;
    private final int defaultOption;
    private final String rememberID;
    private final String rememberText;
    private final boolean rememberByDefault;
    private final int autoCloseInMS;
    private String html;
    private String url;

    public static int open(Shell parent, String title, String text, String[] buttons, int defaultOption) {
        return MessageBoxShell.open(parent, title, text, buttons, defaultOption, null, false, -1);
    }

    public static int getRememberedDecision(String id) {
        if (id == null) {
            return -1;
        }
        Map remembered_decisions = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap());
        Long l = (Long)remembered_decisions.get(id);
        System.out.println("getR " + id + " -> " + l);
        if (l != null) {
            return l.intValue();
        }
        return -1;
    }

    protected static void setRemembered(String id, int value) {
        if (id == null) {
            return;
        }
        Map remembered_decisions = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap());
        if (value == -1) {
            remembered_decisions.remove(id);
        } else {
            remembered_decisions.put(id, new Long(value));
        }
        System.out.println("setR " + id + " -> " + value);
        COConfigurationManager.setParameter("MessageBoxWindow.decisions", remembered_decisions);
        COConfigurationManager.save();
    }

    public static int open(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, boolean bRememberByDefault, int autoCloseInMS) {
        return MessageBoxShell.open(parent, title, text, buttons, defaultOption, rememberID, MessageText.getString("MessageBoxWindow.rememberdecision"), bRememberByDefault, autoCloseInMS);
    }

    public static int open(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean bRememberByDefault, int autoCloseInMS) {
        MessageBoxShell messageBoxShell = new MessageBoxShell(parent, title, text, buttons, defaultOption, rememberID, rememberText, bRememberByDefault, autoCloseInMS);
        return messageBoxShell.open();
    }

    public static boolean isOpen() {
        return numOpen > 0;
    }

    public MessageBoxShell(Shell parent, String title, String text, String[] buttons, int defaultOption, String rememberID, String rememberText, boolean bRememberByDefault, int autoCloseInMS) {
        this.parent = parent;
        this.title = title;
        this.text = text;
        this.buttons = buttons;
        this.defaultOption = defaultOption;
        this.rememberID = rememberID;
        this.rememberText = rememberText;
        this.rememberByDefault = bRememberByDefault;
        this.autoCloseInMS = autoCloseInMS;
    }

    public MessageBoxShell(Shell parent, String title, String text, String[] buttons, int defaultOption) {
        this(parent, title, text, buttons, defaultOption, null, null, false, -1);
    }

    public int open() {
        int rememberedDecision;
        if (this.rememberID != null && (rememberedDecision = MessageBoxShell.getRememberedDecision(this.rememberID)) >= 0) {
            return rememberedDecision;
        }
        ++numOpen;
        final int[] result = new int[]{-1};
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                result[0] = MessageBoxShell.this._open();
            }
        }, false);
        --numOpen;
        return result[0];
    }

    private int _open() {
        FormData formData;
        int i;
        GridData gridData;
        Link linkControl;
        final int[] result = new int[]{-1};
        if (this.parent == null || this.parent.isDisposed()) {
            this.parent = Utils.findAnyShell();
            if (this.parent == null || this.parent.isDisposed()) {
                return result[0];
            }
        }
        MouseTrackListener mouseAdapter = null;
        Display display = this.parent.getDisplay();
        final Shell shell = new Shell(this.parent, 67696);
        shell.setText(this.title);
        GridLayout gridLayout = new GridLayout();
        shell.setLayout((Layout)gridLayout);
        Utils.setShellIcon(shell);
        try {
            Link linkLabel;
            linkControl = linkLabel = new Link((Composite)shell, 64);
            linkLabel.setForeground(display.getSystemColor(2));
            linkLabel.setText(this.text);
            linkLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (e.text.endsWith(".torrent")) {
                        TorrentOpener.openTorrent(e.text);
                    } else {
                        Utils.launch(e.text);
                    }
                }
            });
            Matcher matcher = Pattern.compile(REGEX_URLHTML, 2).matcher(this.text);
            String tooltip = null;
            while (matcher.find()) {
                tooltip = tooltip == null ? "" : tooltip + "\n";
                tooltip = tooltip + matcher.group(2) + ": " + matcher.group(1);
            }
            linkLabel.setToolTipText(tooltip);
        }
        catch (Throwable t) {
            Label linkLabel = new Label((Composite)shell, 64);
            linkControl = linkLabel;
            String urlText = Pattern.compile(REGEX_URLHTML, 2).matcher(this.text).replaceAll("$2 ($1)");
            linkLabel.setForeground(display.getSystemColor(2));
            linkLabel.setText(urlText);
        }
        if (this.html != null && this.html.length() > 0 || this.url != null && this.url.length() > 0) {
            block25: {
                GridData gd;
                try {
                    int i2 = 0 / 0;
                    final Browser browser = new Browser((Composite)shell, 0);
                    if (this.url != null && this.url.length() > 0) {
                        browser.setUrl(this.url);
                    } else {
                        browser.setText(this.html);
                    }
                    gd = new GridData(1808);
                    gd.heightHint = 200;
                    browser.setLayoutData((Object)gd);
                    browser.addProgressListener(new ProgressListener(){

                        public void completed(ProgressEvent event2) {
                            browser.addLocationListener(new LocationListener(){

                                public void changing(LocationEvent event2) {
                                    event2.doit = false;
                                }

                                public void changed(LocationEvent event2) {
                                }
                            });
                            browser.addOpenWindowListener(new OpenWindowListener(){

                                public void open(WindowEvent event2) {
                                }
                            });
                        }

                        public void changed(ProgressEvent event2) {
                        }
                    });
                }
                catch (Exception e) {
                    Debug.out(e);
                    if (this.html == null) break block25;
                    Text text = new Text((Composite)shell, 2056);
                    text.setText(this.html);
                    gd = new GridData(1808);
                    gd.heightHint = 200;
                    text.setLayoutData((Object)gd);
                }
            }
            gridData = new GridData(768);
            linkControl.setLayoutData((Object)gridData);
        } else {
            gridData = new GridData(1808);
            linkControl.setLayoutData((Object)gridData);
        }
        if (this.autoCloseInMS > 0) {
            final Label lblCloseIn = new Label((Composite)shell, 64);
            lblCloseIn.setLayoutData((Object)new GridData(768));
            long endOn = SystemTime.getCurrentTime() + (long)this.autoCloseInMS;
            lblCloseIn.setData("CloseOn", (Object)new Long(endOn));
            SimpleTimer.addPeriodicEvent("autoclose", 500L, new TimerEventPerformer(){

                public void perform(TimerEvent event2) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (!shell.isDisposed()) {
                                boolean bDelayPaused;
                                boolean bl = bDelayPaused = lblCloseIn.getData("DelayPaused") != null;
                                if (bDelayPaused) {
                                    return;
                                }
                                long endOn = (Long)lblCloseIn.getData("CloseOn");
                                if (SystemTime.getCurrentTime() > endOn) {
                                    (this).result[0] = MessageBoxShell.this.defaultOption;
                                    shell.dispose();
                                } else {
                                    String sText = "";
                                    if (lblCloseIn == null || lblCloseIn.isDisposed()) {
                                        return;
                                    }
                                    if (!bDelayPaused) {
                                        long delaySecs = (endOn - SystemTime.getCurrentTime()) / 1000L;
                                        sText = MessageText.getString("popup.closing.in", new String[]{String.valueOf(delaySecs)});
                                    }
                                    lblCloseIn.setText(sText);
                                }
                            }
                        }
                    });
                }
            });
            SimpleTimer.addPeriodicEvent("OverPopup", 100L, new TimerEventPerformer(){
                boolean wasOver = true;
                long lEnterOn = 0L;

                public void perform(final TimerEvent event2) {
                    Utils.execSWTThread(new AERunnable(){

                        public void runSupport() {
                            if (shell.isDisposed()) {
                                event2.cancel();
                                return;
                            }
                            boolean isOver = shell.getBounds().contains(shell.getDisplay().getCursorLocation());
                            if (isOver != wasOver) {
                                wasOver = isOver;
                                if (isOver) {
                                    lblCloseIn.setData("DelayPaused", (Object)"");
                                    lEnterOn = SystemTime.getCurrentTime();
                                    lblCloseIn.setText("");
                                } else {
                                    lblCloseIn.setData("DelayPaused", null);
                                    if (lEnterOn > 0L) {
                                        long diff = SystemTime.getCurrentTime() - lEnterOn;
                                        long endOn = (Long)lblCloseIn.getData("CloseOn") + diff;
                                        lblCloseIn.setData("CloseOn", (Object)new Long(endOn));
                                    }
                                }
                            }
                        }
                    });
                }
            });
        }
        Button checkRemember = null;
        if (this.rememberID != null) {
            checkRemember = new Button((Composite)shell, 32);
            checkRemember.setText(this.rememberText);
            checkRemember.setSelection(this.rememberByDefault);
            checkRemember.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Button checkRemember = (Button)e.widget;
                    if (MessageBoxShell.this.rememberID != null && checkRemember != null && checkRemember.getSelection()) {
                        MessageBoxShell.setRemembered(MessageBoxShell.this.rememberID, result[0]);
                    }
                }
            });
        }
        Composite cButtons = new Composite((Composite)shell, 0);
        FormLayout layout = new FormLayout();
        cButtons.setLayout((Layout)layout);
        gridData = new GridData(64);
        cButtons.setLayoutData((Object)gridData);
        Button lastButton = null;
        Listener buttonListener = new Listener(){

            public void handleEvent(Event event2) {
                result[0] = (Integer)event2.widget.getData();
                shell.dispose();
            }
        };
        int buttonWidth = 0;
        Button[] swtButtons = new Button[this.buttons.length];
        for (i = 0; i < this.buttons.length; ++i) {
            Button button;
            swtButtons[i] = button = new Button(cButtons, 8);
            button.setData((Object)new Integer(i));
            button.setText(this.buttons[i]);
            button.addListener(13, buttonListener);
            formData = new FormData();
            if (lastButton != null) {
                formData.left = new FormAttachment(lastButton, 5);
            }
            button.setLayoutData((Object)formData);
            Point size = button.computeSize(-1, -1);
            if (size.x > buttonWidth) {
                buttonWidth = size.x;
            }
            if (i == this.defaultOption) {
                button.setFocus();
                shell.setDefaultButton(button);
            }
            lastButton = button;
        }
        if (buttonWidth > 0) {
            for (i = 0; i < this.buttons.length; ++i) {
                Point size = swtButtons[i].computeSize(buttonWidth, -1);
                swtButtons[i].setSize(size);
                formData = (FormData)swtButtons[i].getLayoutData();
                formData.width = buttonWidth;
            }
        }
        shell.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event2) {
                if (event2.detail == 2) {
                    shell.dispose();
                }
            }
        });
        if (mouseAdapter != null) {
            this.addMouseTrackListener((Composite)shell, mouseAdapter);
        }
        shell.pack();
        Point size = shell.getSize();
        if (size.x < 300) {
            size.x = 300;
            shell.setSize(size);
        } else if (size.x > 500) {
            size = shell.computeSize(500, -1);
            shell.setSize(size);
        }
        if (size.y < 200) {
            size.y = 200;
            shell.setSize(size);
        }
        Utils.centerWindowRelativeTo(shell, (Control)this.parent);
        shell.open();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return result[0];
    }

    private void addMouseTrackListener(Composite parent, MouseTrackListener listener) {
        if (parent == null || listener == null || parent.isDisposed()) {
            return;
        }
        parent.addMouseTrackListener(listener);
        Control[] children = parent.getChildren();
        for (int i = 0; i < children.length; ++i) {
            Control control = children[i];
            if (control instanceof Composite) {
                this.addMouseTrackListener((Composite)control, listener);
                continue;
            }
            control.addMouseTrackListener(listener);
        }
    }

    public static void main(String[] args) {
        Display display = Display.getDefault();
        Shell shell = new Shell(display, 1264);
        shell.open();
        MessageBoxShell messageBoxShell = new MessageBoxShell(shell, "Title", "Test\nTHis is a very long line that tests whether the box gets really wide which is something we don't want.\nA <A HREF=\"Link\">link</A> for <A HREF=\"http://moo.com\">you</a>", new String[]{"Okay", "Cancyyyyyy", "Maybe"}, 1, "test2", MessageText.getString("MessageBoxWindow.nomoreprompting"), false, 15000);
        messageBoxShell.setHtml("<b>Moo</b> goes the cow<p><hr>");
        System.out.println(messageBoxShell.open());
    }

    public String getHtml() {
        return this.html;
    }

    public void setHtml(String html) {
        this.html = html;
    }

    public void setUrl(String url) {
        this.url = url;
    }
}

