/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.ui.UIFunctions;
import com.aelitis.azureus.ui.UIFunctionsManager;
import com.aelitis.azureus.ui.swt.UIFunctionsManagerSWT;
import com.aelitis.azureus.ui.swt.UIFunctionsSWT;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.download.DownloadManagerListener;
import org.gudy.azureus2.core3.global.GlobalManagerDownloadRemovalVetoException;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.download.DownloadException;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadImpl;
import org.gudy.azureus2.pluginsimpl.local.download.DownloadManagerImpl;
import org.gudy.azureus2.ui.swt.Alerts;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.debug.ObfusticateImage;
import org.gudy.azureus2.ui.swt.debug.ObfusticateTab;
import org.gudy.azureus2.ui.swt.plugins.UISWTViewEventListener;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTInstanceImpl;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTViewImpl;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.FilesView;
import org.gudy.azureus2.ui.swt.views.GeneralView;
import org.gudy.azureus2.ui.swt.views.IView;
import org.gudy.azureus2.ui.swt.views.LoggerView;
import org.gudy.azureus2.ui.swt.views.PeersGraphicView;
import org.gudy.azureus2.ui.swt.views.PeersView;
import org.gudy.azureus2.ui.swt.views.PiecesView;
import org.gudy.azureus2.ui.swt.views.TorrentInfoView;
import org.gudy.azureus2.ui.swt.views.TorrentOptionsView;
import org.gudy.azureus2.ui.swt.views.utils.ManagerUtils;

public class ManagerView
extends AbstractIView
implements DownloadManagerListener,
ObfusticateTab,
ObfusticateImage {
    private AzureusCore azureus_core;
    private DownloadManager manager;
    private TabFolder folder;
    private ArrayList tabViews = new ArrayList();

    public ManagerView(AzureusCore _azureus_core, DownloadManager manager) {
        this.azureus_core = _azureus_core;
        this.manager = manager;
        this.dataSourceChanged(manager);
        manager.addListener(this);
    }

    public void delete() {
        UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
        if (uiFunctions != null) {
            uiFunctions.removeManagerView(this.manager);
        }
        this.manager.removeListener(this);
        if (!this.folder.isDisposed()) {
            this.folder.setSelection(0);
        }
        if (Constants.isOSX && this.folder != null && !this.folder.isDisposed()) {
            TabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                if (items[i].isDisposed()) continue;
                items[i].dispose();
            }
        }
        for (int i = 0; i < this.tabViews.size(); ++i) {
            IView view = (IView)this.tabViews.get(i);
            if (view == null) continue;
            view.delete();
        }
        this.tabViews.clear();
        if (this.folder != null && !this.folder.isDisposed()) {
            this.folder.dispose();
        }
    }

    public Composite getComposite() {
        return this.folder;
    }

    public String getFullTitle() {
        int completed = this.manager.getStats().getCompleted();
        return DisplayFormatters.formatPercentFromThousands(completed) + " : " + this.manager.getDisplayName();
    }

    public void initialize(Composite composite) {
        if (this.folder == null) {
            this.folder = new TabFolder(composite, 16384);
        } else {
            System.out.println("ManagerView::initialize : folder isn't null !!!");
        }
        IView[] views = new IView[]{new GeneralView(), new PeersView(), new PeersGraphicView(), new PiecesView(), new FilesView(), new TorrentInfoView(this.manager), new TorrentOptionsView(this.manager), new LoggerView()};
        for (int i = 0; i < views.length; ++i) {
            this.addSection(views[i], this.manager);
        }
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            Map pluginViews;
            UISWTInstanceImpl pluginUI = uiFunctions.getSWTPluginInstanceImpl();
            Map map = pluginViews = pluginUI == null ? null : pluginUI.getViewListeners("MyTorrents");
            if (pluginViews != null) {
                String[] sNames = pluginViews.keySet().toArray(new String[0]);
                for (int i = 0; i < sNames.length; ++i) {
                    UISWTViewEventListener l = (UISWTViewEventListener)pluginViews.get(sNames[i]);
                    if (l == null) continue;
                    try {
                        UISWTViewImpl view = new UISWTViewImpl("MyTorrents", sNames[i], l);
                        this.addSection(view);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
        }
        this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TabItem item = (TabItem)e.item;
                if (item != null && item.getControl() == null) {
                    IView view = (IView)item.getData("IView");
                    view.initialize((Composite)ManagerView.this.folder);
                    item.setControl((Control)view.getComposite());
                }
                ManagerView.this.refresh();
            }
        });
        views[0].initialize((Composite)this.folder);
        this.folder.getItem(0).setControl((Control)views[0].getComposite());
        views[0].refresh();
        views[0].getComposite().layout(true);
    }

    private IView getActiveView() {
        int index = this.folder.getSelectionIndex();
        if (index == -1) {
            return null;
        }
        TabItem ti = this.folder.getItem(index);
        if (ti.isDisposed()) {
            return null;
        }
        return (IView)ti.getData("IView");
    }

    public void refresh() {
        if (this.getComposite() == null || this.getComposite().isDisposed()) {
            return;
        }
        try {
            IView view = this.getActiveView();
            if (view != null) {
                view.refresh();
            }
            TabItem[] items = this.folder.getItems();
            for (int i = 0; i < items.length; ++i) {
                TabItem item = items[i];
                view = (IView)item.getData("IView");
                try {
                    if (item.isDisposed()) continue;
                    String lastTitle = item.getText();
                    String newTitle = view.getShortTitle();
                    if (lastTitle == null || !lastTitle.equals(newTitle)) {
                        item.setText(ManagerView.escapeAccelerators(newTitle));
                    }
                    String lastToolTip = item.getToolTipText();
                    String newToolTip = view.getFullTitle() + " " + MessageText.getString("Tab.closeHint");
                    if (lastToolTip != null && lastToolTip.equals(newToolTip)) continue;
                    item.setToolTipText(newToolTip);
                    continue;
                }
                catch (Exception e) {
                    Debug.printStackTrace(e);
                }
            }
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    protected static String escapeAccelerators(String str) {
        if (str == null) {
            return str;
        }
        return str.replaceAll("&", "&&");
    }

    public boolean isEnabled(String itemKey) {
        if (itemKey.equals("run")) {
            return true;
        }
        if (itemKey.equals("start")) {
            return ManagerUtils.isStartable(this.manager);
        }
        if (itemKey.equals("stop")) {
            return ManagerUtils.isStopable(this.manager);
        }
        if (itemKey.equals("host")) {
            return true;
        }
        if (itemKey.equals("publish")) {
            return true;
        }
        return itemKey.equals("remove");
    }

    public void itemActivated(String itemKey) {
        if (itemKey.equals("run")) {
            ManagerUtils.run(this.manager);
            return;
        }
        if (itemKey.equals("start")) {
            ManagerUtils.queue(this.manager, (Composite)this.folder);
            return;
        }
        if (itemKey.equals("stop")) {
            ManagerUtils.stop(this.manager, (Composite)this.folder);
            return;
        }
        if (itemKey.equals("host")) {
            ManagerUtils.host(this.azureus_core, this.manager, (Composite)this.folder);
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions != null) {
                uiFunctions.showMyTracker();
            }
            return;
        }
        if (itemKey.equals("publish")) {
            ManagerUtils.publish(this.azureus_core, this.manager, (Composite)this.folder);
            UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
            if (uiFunctions != null) {
                uiFunctions.showMyTracker();
            }
            return;
        }
        if (itemKey.equals("remove")) {
            if (COConfigurationManager.getBooleanParameter("confirm_torrent_removal")) {
                MessageBox mb = new MessageBox(this.folder.getShell(), 200);
                mb.setText(MessageText.getString("deletedata.title"));
                mb.setMessage(MessageText.getString("MyTorrentsView.confirm_torrent_removal") + this.manager.getDisplayName());
                if (mb.open() == 128) {
                    return;
                }
            }
            new AEThread("asyncStop", true){

                public void runSupport() {
                    block2: {
                        try {
                            ManagerView.this.manager.stopIt(70, false, false);
                            ManagerView.this.manager.getGlobalManager().removeDownloadManager(ManagerView.this.manager);
                        }
                        catch (GlobalManagerDownloadRemovalVetoException e) {
                            if (e.isSilent()) break block2;
                            Alerts.showErrorMessageBoxUsingResourceString("globalmanager.download.remove.veto", e);
                        }
                    }
                }
            }.start();
        }
    }

    public void downloadComplete(DownloadManager manager) {
    }

    public void completionChanged(DownloadManager manager, boolean bCompleted) {
    }

    public void filePriorityChanged(DownloadManager download, DiskManagerFileInfo file) {
    }

    public void stateChanged(DownloadManager manager, int state) {
        if (this.folder == null || this.folder.isDisposed()) {
            return;
        }
        Display display = this.folder.getDisplay();
        if (display == null || display.isDisposed()) {
            return;
        }
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                UIFunctions uiFunctions = UIFunctionsManager.getUIFunctions();
                if (uiFunctions != null) {
                    uiFunctions.refreshIconBar();
                }
            }
        });
    }

    public void positionChanged(DownloadManager download, int oldPosition, int newPosition) {
    }

    public void addSection(UISWTViewImpl view) {
        DownloadImpl pluginDataSource = null;
        try {
            pluginDataSource = DownloadManagerImpl.getDownloadStatic(this.manager);
        }
        catch (DownloadException downloadException) {
            // empty catch block
        }
        this.addSection(view, pluginDataSource);
    }

    private void addSection(IView view, Object dataSource) {
        if (view == null) {
            return;
        }
        view.dataSourceChanged(dataSource);
        TabItem item = new TabItem(this.folder, 0);
        Messages.setLanguageText((Widget)item, view.getData());
        item.setData("IView", (Object)view);
        this.tabViews.add(view);
    }

    public Image obfusticatedImage(Image image, Point shellOffset) {
        IView view = this.getActiveView();
        if (view instanceof ObfusticateImage) {
            try {
                ((ObfusticateImage)((Object)view)).obfusticatedImage(image, shellOffset);
            }
            catch (Exception e) {
                Debug.out("Obfusticating " + view, e);
            }
        }
        return image;
    }

    public String getObfusticatedHeader() {
        int completed = this.manager.getStats().getCompleted();
        return DisplayFormatters.formatPercentFromThousands(completed) + " : " + this.manager;
    }
}

