/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionConnectionEncryption
implements UISWTConfigSection {
    private final String CFG_PREFIX = "ConfigView.section.connection.encryption.";
    private final int REQUIRED_MODE = 1;

    public String configSectionGetParentSection() {
        return "server";
    }

    public String configSectionGetName() {
        return "connection.encryption";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout advanced_layout = new GridLayout();
        cSection.setLayout((Layout)advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 1) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 1 < modeKeys.length ? MessageText.getString(modeKeys[1]) : String.valueOf(1);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        Group gCrypto = new Group(cSection, 0);
        Messages.setLanguageText((Widget)gCrypto, "ConfigView.section.connection.encryption.encrypt.group");
        gridData = new GridData(768);
        gCrypto.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        gCrypto.setLayout((Layout)layout);
        Label lcrypto = new Label((Composite)gCrypto, 64);
        Messages.setLanguageText((Widget)lcrypto, "ConfigView.section.connection.encryption.encrypt.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        lcrypto.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        LinkLabel linkLabel = new LinkLabel((Composite)gCrypto, gridData, "ConfigView.section.connection.encryption.encrypt.info.link", "http://azureus.aelitis.com/wiki/index.php/Avoid_traffic_shaping");
        BooleanParameter require = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.require", "ConfigView.section.connection.encryption.require_encrypted_transport");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        require.setLayoutData(gridData);
        String[] encryption_types = new String[]{"Plain", "RC4"};
        String[] dropLabels = new String[encryption_types.length];
        String[] dropValues = new String[encryption_types.length];
        for (int i = 0; i < encryption_types.length; ++i) {
            dropLabels[i] = encryption_types[i];
            dropValues[i] = encryption_types[i];
        }
        Composite cEncryptLevel = new Composite((Composite)gCrypto, 0);
        gridData = new GridData(272);
        gridData.horizontalSpan = 2;
        cEncryptLevel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        cEncryptLevel.setLayout((Layout)layout);
        Label lmin = new Label(cEncryptLevel, 0);
        Messages.setLanguageText((Widget)lmin, "ConfigView.section.connection.encryption.min_encryption_level");
        StringListParameter min_level = new StringListParameter(cEncryptLevel, "network.transport.encrypted.min_level", encryption_types[1], dropLabels, dropValues);
        Label lcryptofb = new Label((Composite)gCrypto, 64);
        Messages.setLanguageText((Widget)lcryptofb, "ConfigView.section.connection.encryption.encrypt.fallback_info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 200;
        lcryptofb.setLayoutData((Object)gridData);
        BooleanParameter fallback_outgoing = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.fallback.outgoing", "ConfigView.section.connection.encryption.encrypt.fallback_outgoing");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fallback_outgoing.setLayoutData(gridData);
        BooleanParameter fallback_incoming = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.fallback.incoming", "ConfigView.section.connection.encryption.encrypt.fallback_incoming");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        fallback_incoming.setLayoutData(gridData);
        BooleanParameter use_crypto_port = new BooleanParameter((Composite)gCrypto, "network.transport.encrypted.use.crypto.port", "ConfigView.section.connection.encryption.use_crypto_port");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        use_crypto_port.setLayoutData(gridData);
        fallback_incoming.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(use_crypto_port.getControls(), true));
        Control[] encryption_controls = new Control[]{min_level.getControl(), lmin, lcryptofb, fallback_outgoing.getControl(), fallback_incoming.getControl(), use_crypto_port.getControl()};
        require.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(encryption_controls));
        return cSection;
    }
}

