/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionFileMove
implements UISWTConfigSection {
    public String configSectionGetParentSection() {
        return "files";
    }

    public String configSectionGetName() {
        return "files.move";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        GridData gridData;
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Composite gFile = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        gFile.setLayout((Layout)layout);
        this.createMoveOnEventGrouping(gFile, "ConfigView.label.movecompleted", "Move Completed When Done", "Completed Files Directory", "Move Torrent When Done", "Move Only When In Default Save Dir", null);
        this.createMoveOnEventGrouping(gFile, "ConfigView.label.moveremoved", "File.move.download.removed.enabled", "File.move.download.removed.path", "File.move.download.removed.move_torrent", "File.move.download.removed.only_in_default", "File.move.download.removed.move_partial");
        if (userMode > 0) {
            BooleanParameter copyDontMove = new BooleanParameter(gFile, "Copy And Delete Data Rather Than Move", "ConfigView.label.copyanddeleteratherthanmove");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            copyDontMove.setLayoutData(gridData);
        }
        BooleanParameter subdirIsDefault = new BooleanParameter(gFile, "File.move.subdir_is_default", "ConfigView.label.subdir_is_in_default");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        subdirIsDefault.setLayoutData(gridData);
        return gFile;
    }

    private void createMoveOnEventGrouping(final Composite gFile, String enable_section_label, String move_when_done_setting, String move_path_setting, String move_torrent_setting, String move_when_in_save_dir_setting, String move_partial_downloads_setting) {
        Image imgOpenFolder = ImageRepository.getImage("openFolderButton");
        BooleanParameter moveCompleted = new BooleanParameter(gFile, move_when_done_setting, enable_section_label);
        GridData gridData = new GridData();
        GridLayout layout = null;
        gridData.horizontalSpan = 2;
        moveCompleted.setLayoutData(gridData);
        Composite gMoveCompleted = new Composite(gFile, 0);
        gridData = new GridData(768);
        gridData.horizontalIndent = 25;
        gridData.horizontalSpan = 2;
        gMoveCompleted.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 4;
        layout.numColumns = 3;
        gMoveCompleted.setLayout((Layout)layout);
        Label lDir = new Label(gMoveCompleted, 0);
        Messages.setLanguageText((Widget)lDir, "ConfigView.label.directory");
        gridData = new GridData(768);
        final StringParameter movePath = new StringParameter(gMoveCompleted, move_path_setting);
        movePath.setLayoutData(gridData);
        Button browse3 = new Button(gMoveCompleted, 8);
        browse3.setImage(imgOpenFolder);
        imgOpenFolder.setBackground(browse3.getBackground());
        browse3.setToolTipText(MessageText.getString("ConfigView.button.browse"));
        browse3.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                DirectoryDialog dialog = new DirectoryDialog(gFile.getShell(), 65536);
                dialog.setFilterPath(movePath.getValue());
                dialog.setText(MessageText.getString("ConfigView.dialog.choosemovepath"));
                String path = dialog.open();
                if (path != null) {
                    movePath.setValue(path);
                }
            }
        });
        BooleanParameter moveTorrent = new BooleanParameter(gMoveCompleted, move_torrent_setting, "ConfigView.label.movetorrent");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        moveTorrent.setLayoutData(gridData);
        BooleanParameter moveOnly = new BooleanParameter(gMoveCompleted, move_when_in_save_dir_setting, "ConfigView.label.moveonlyusingdefaultsave");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        moveOnly.setLayoutData(gridData);
        if (move_partial_downloads_setting != null) {
            BooleanParameter movePartial = new BooleanParameter(gMoveCompleted, move_partial_downloads_setting, "ConfigView.label.movepartialdownloads");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            movePartial.setLayoutData(gridData);
        }
        Control[] controls3 = new Control[]{gMoveCompleted};
        ChangeSelectionActionPerformer grayPathAndButton2 = new ChangeSelectionActionPerformer(controls3);
        moveCompleted.setAdditionalActionPerformer(grayPathAndButton2);
    }
}

