/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import java.util.HashMap;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.platform.PlatformManager;
import org.gudy.azureus2.platform.PlatformManagerCapabilities;
import org.gudy.azureus2.platform.PlatformManagerFactory;
import org.gudy.azureus2.plugins.platform.PlatformManagerException;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.GenericActionPerformer;
import org.gudy.azureus2.ui.swt.config.PasswordParameter;
import org.gudy.azureus2.ui.swt.config.StringListParameter;
import org.gudy.azureus2.ui.swt.config.StringParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionInterface
implements UISWTConfigSection {
    private static final String KEY_PREFIX = "ConfigView.section.interface.";
    private static final String LBLKEY_PREFIX = "ConfigView.label.";
    Label passwordMatch;
    private ParameterListener decisions_parameter_listener;

    public String configSectionGetParentSection() {
        return "root";
    }

    public String configSectionGetName() {
        return "style";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
        if (this.decisions_parameter_listener != null) {
            COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        }
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cDisplay = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cDisplay.setLayoutData((Object)gridData);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        cDisplay.setLayout((Layout)layout);
        new BooleanParameter(cDisplay, "Open Details", "ConfigView.label.opendetails");
        new BooleanParameter(cDisplay, "Open Bar", false, "ConfigView.label.openbar");
        if (!Constants.isOSX || SWT.getVersion() >= 3300) {
            BooleanParameter est = new BooleanParameter(cDisplay, "Enable System Tray", "ConfigView.section.interface.enabletray");
            BooleanParameter ctt = new BooleanParameter(cDisplay, "Close To Tray", "ConfigView.label.closetotray");
            BooleanParameter mtt = new BooleanParameter(cDisplay, "Minimize To Tray", "ConfigView.label.minimizetotray");
            est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(ctt.getControls()));
            est.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(mtt.getControls()));
        }
        Group limit_group = new Group(cDisplay, 0);
        Messages.setLanguageText((Widget)limit_group, "ConfigView.label.set_ui_transfer_speeds");
        layout = new GridLayout();
        limit_group.setLayout((Layout)layout);
        Label limit_group_label = new Label((Composite)limit_group, 64);
        Messages.setLanguageText((Widget)limit_group_label, "ConfigView.label.set_ui_transfer_speeds.description");
        String[] limit_types = new String[]{"download", "upload"};
        String limit_type_prefix = "config.ui.speed.partitions.manual.";
        for (int i = 0; i < limit_types.length; ++i) {
            final BooleanParameter bp = new BooleanParameter((Composite)limit_group, "config.ui.speed.partitions.manual." + limit_types[i] + ".enabled", false, "ConfigView.label.set_ui_transfer_speeds.description." + limit_types[i]);
            final StringParameter sp = new StringParameter((Composite)limit_group, "config.ui.speed.partitions.manual." + limit_types[i] + ".values", "");
            GenericActionPerformer iaap = new GenericActionPerformer(new Control[0]){

                public void performAction() {
                    sp.getControl().setEnabled(bp.isSelected());
                }
            };
            gridData = new GridData();
            gridData.widthHint = 150;
            sp.setLayoutData(gridData);
            iaap.performAction();
            bp.setAdditionalActionPerformer(iaap);
        }
        new BooleanParameter(cDisplay, "Send Version Info", true, "ConfigView.label.allowSendVersion");
        Composite cArea = new Composite(cDisplay, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        if (!Constants.isOSX) {
            BooleanParameter confirm = new BooleanParameter(cArea, "confirmationOnExit", "ConfigView.section.style.confirmationOnExit");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            confirm.setLayoutData(gridData);
        }
        cArea = new Composite(cDisplay, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        cArea.setLayout((Layout)layout);
        cArea.setLayoutData((Object)new GridData(768));
        BooleanParameter confirm_removal = new BooleanParameter(cArea, "confirm_torrent_removal", "ConfigView.section.interface.confirm_torrent_removal");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        confirm_removal.setLayoutData(gridData);
        final Label clear_label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)clear_label, "ConfigView.section.interface.cleardecisions");
        final Button clear_decisions = new Button(cArea, 8);
        Messages.setLanguageText((Widget)clear_decisions, "ConfigView.section.interface.cleardecisionsbutton");
        clear_decisions.addListener(13, new Listener(){

            public void handleEvent(Event event2) {
                COConfigurationManager.setParameter("MessageBoxWindow.decisions", new HashMap());
            }
        });
        this.decisions_parameter_listener = new ParameterListener(){

            public void parameterChanged(String parameterName) {
                if (clear_decisions.isDisposed()) {
                    COConfigurationManager.removeParameterListener("MessageBoxWindow.decisions", this);
                } else {
                    boolean enabled = COConfigurationManager.getMapParameter("MessageBoxWindow.decisions", new HashMap()).size() > 0;
                    clear_label.setEnabled(enabled);
                    clear_decisions.setEnabled(enabled);
                }
            }
        };
        this.decisions_parameter_listener.parameterChanged(null);
        COConfigurationManager.addParameterListener("MessageBoxWindow.decisions", this.decisions_parameter_listener);
        Label label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.password");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw1 = new PasswordParameter(cArea, "Password");
        pw1.setLayoutData(gridData);
        Text t1 = (Text)pw1.getControl();
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordconfirm");
        gridData = new GridData();
        gridData.widthHint = 150;
        PasswordParameter pw2 = new PasswordParameter(cArea, "Password Confirm");
        pw2.setLayoutData(gridData);
        Text t2 = (Text)pw2.getControl();
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.label.passwordmatch");
        this.passwordMatch = new Label(cArea, 0);
        gridData = new GridData();
        gridData.widthHint = 150;
        this.passwordMatch.setLayoutData((Object)gridData);
        this.refreshPWLabel();
        t1.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterface.this.refreshPWLabel();
            }
        });
        t2.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConfigSectionInterface.this.refreshPWLabel();
            }
        });
        label = new Label(cArea, 0);
        Messages.setLanguageText((Widget)label, "ConfigView.section.style.dropdiraction");
        String[] drop_options = new String[]{"ConfigView.section.style.dropdiraction.opentorrents", "ConfigView.section.style.dropdiraction.sharefolder", "ConfigView.section.style.dropdiraction.sharefoldercontents", "ConfigView.section.style.dropdiraction.sharefoldercontentsrecursive"};
        String[] dropLabels = new String[drop_options.length];
        String[] dropValues = new String[drop_options.length];
        for (int i = 0; i < drop_options.length; ++i) {
            dropLabels[i] = MessageText.getString(drop_options[i]);
            dropValues[i] = "" + i;
        }
        new StringListParameter(cArea, "config.style.dropdiraction", "1", dropLabels, dropValues);
        final PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.hasCapability(PlatformManagerCapabilities.RegisterFileAssociations)) {
            Composite cResetAssoc = new Composite(cArea, 0);
            layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            layout.numColumns = 2;
            cResetAssoc.setLayout((Layout)layout);
            cResetAssoc.setLayoutData((Object)new GridData());
            label = new Label(cResetAssoc, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.interface.resetassoc");
            Button reset = new Button(cResetAssoc, 8);
            Messages.setLanguageText((Widget)reset, "ConfigView.section.interface.resetassocbutton");
            reset.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    try {
                        platform.registerApplication();
                    }
                    catch (PlatformManagerException e) {
                        Logger.log(new LogAlert(false, "Failed to register application", e));
                    }
                }
            });
            new BooleanParameter(cArea, "config.interface.checkassoc", "ConfigView.section.interface.checkassoc");
        }
        return cDisplay;
    }

    private void refreshPWLabel() {
        if (this.passwordMatch == null || this.passwordMatch.isDisposed()) {
            return;
        }
        byte[] password = COConfigurationManager.getByteParameter("Password", "".getBytes());
        COConfigurationManager.setParameter("Password enabled", false);
        if (password.length == 0) {
            this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchnone"));
        } else {
            byte[] confirm = COConfigurationManager.getByteParameter("Password Confirm", "".getBytes());
            if (confirm.length == 0) {
                this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
            } else {
                boolean same = true;
                for (int i = 0; i < password.length; ++i) {
                    if (password[i] == confirm[i]) continue;
                    same = false;
                }
                if (same) {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchyes"));
                    COConfigurationManager.setParameter("Password enabled", true);
                } else {
                    this.passwordMatch.setText(MessageText.getString("ConfigView.label.passwordmatchno"));
                }
            }
        }
    }
}

