/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.components.LinkLabel;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.FloatParameter;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTransferAutoSpeed
implements UISWTConfigSection {
    private final String CFG_PREFIX = "ConfigView.section.transfer.autospeed.";

    public String configSectionGetParentSection() {
        return "transfer";
    }

    public String configSectionGetName() {
        return "transfer.autospeed";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout advanced_layout = new GridLayout();
        advanced_layout.numColumns = 2;
        cSection.setLayout((Layout)advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        Label linfo = new Label(cSection, 0);
        Messages.setLanguageText((Widget)linfo, "ConfigView.section.transfer.autospeed.info");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        linfo.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        LinkLabel linkLabel = new LinkLabel(cSection, gridData, "ConfigView.label.please.visit.here", "http://azureus.aelitis.com/wiki/index.php/Auto_Speed");
        String[] units = new String[]{DisplayFormatters.getRateUnit(1)};
        Label llmux = new Label(cSection, 0);
        Messages.setLanguageText((Widget)llmux, "ConfigView.section.transfer.autospeed.minupload", units);
        IntParameter min_upload = new IntParameter(cSection, "AutoSpeed Min Upload KBs");
        gridData = new GridData();
        gridData.widthHint = 40;
        min_upload.setLayoutData(gridData);
        Label llmdx = new Label(cSection, 0);
        Messages.setLanguageText((Widget)llmdx, "ConfigView.section.transfer.autospeed.maxupload", units);
        IntParameter max_upload = new IntParameter(cSection, "AutoSpeed Max Upload KBs");
        gridData = new GridData();
        gridData.widthHint = 40;
        max_upload.setLayoutData(gridData);
        BooleanParameter enable_au = new BooleanParameter(cSection, "Auto Upload Speed Enabled", "ConfigView.section.transfer.autospeed.enableauto");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enable_au.setLayoutData(gridData);
        BooleanParameter enable_au_seeding = new BooleanParameter(cSection, "Auto Upload Speed Seeding Enabled", "ConfigView.section.transfer.autospeed.enableautoseeding");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enable_au_seeding.setLayoutData(gridData);
        enable_au.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(enable_au_seeding.getControls(), true));
        if (userMode > 0) {
            BooleanParameter enable_down_adj = new BooleanParameter(cSection, "AutoSpeed Download Adj Enable", "ConfigView.section.transfer.autospeed.enabledownadj");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            enable_down_adj.setLayoutData(gridData);
            Label label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.downadjratio");
            FloatParameter down_adj = new FloatParameter(cSection, "AutoSpeed Download Adj Ratio", 0.0f, Float.MAX_VALUE, false, 2);
            gridData = new GridData();
            gridData.widthHint = 40;
            down_adj.setLayoutData(gridData);
            enable_down_adj.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{down_adj.getControl()}));
        }
        if (userMode > 1) {
            Label label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.maxinc", units);
            final IntParameter max_increase = new IntParameter(cSection, "AutoSpeed Max Increment KBs");
            gridData = new GridData();
            gridData.widthHint = 40;
            max_increase.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.maxdec", units);
            final IntParameter max_decrease = new IntParameter(cSection, "AutoSpeed Max Decrement KBs");
            gridData = new GridData();
            gridData.widthHint = 40;
            max_decrease.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.chokeping");
            final IntParameter choke_ping = new IntParameter(cSection, "AutoSpeed Choking Ping Millis");
            gridData = new GridData();
            gridData.widthHint = 40;
            choke_ping.setLayoutData(gridData);
            label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)label, "ConfigView.section.transfer.autospeed.latencyfactor");
            final IntParameter latency_factor = new IntParameter(cSection, "AutoSpeed Latency Factor", 1, Integer.MAX_VALUE);
            gridData = new GridData();
            gridData.widthHint = 40;
            latency_factor.setLayoutData(gridData);
            Label reset_label = new Label(cSection, 0);
            Messages.setLanguageText((Widget)reset_label, "ConfigView.section.transfer.autospeed.reset");
            Button reset_button = new Button(cSection, 8);
            Messages.setLanguageText((Widget)reset_button, "ConfigView.section.transfer.autospeed.reset.button");
            reset_button.addListener(13, new Listener(){

                public void handleEvent(Event event2) {
                    max_increase.resetToDefault();
                    max_decrease.resetToDefault();
                    choke_ping.resetToDefault();
                    latency_factor.resetToDefault();
                }
            });
            BooleanParameter debug_au = new BooleanParameter(cSection, "Auto Upload Speed Debug Enabled", "ConfigView.section.transfer.autospeed.enabledebug");
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            debug_au.setLayoutData(gridData);
        }
        return cSection;
    }
}

