/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.configsections;

import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.config.BooleanParameter;
import org.gudy.azureus2.ui.swt.config.ChangeSelectionActionPerformer;
import org.gudy.azureus2.ui.swt.config.IntParameter;
import org.gudy.azureus2.ui.swt.config.Parameter;
import org.gudy.azureus2.ui.swt.plugins.UISWTConfigSection;

public class ConfigSectionTransferLAN
implements UISWTConfigSection {
    private final String CFG_PREFIX = "ConfigView.section.transfer.lan.";
    private final int REQUIRED_MODE = 2;

    public String configSectionGetParentSection() {
        return "transfer";
    }

    public String configSectionGetName() {
        return "transfer.lan";
    }

    public void configSectionSave() {
    }

    public void configSectionDelete() {
    }

    public Composite configSectionCreate(Composite parent) {
        Composite cSection = new Composite(parent, 0);
        GridData gridData = new GridData(272);
        cSection.setLayoutData((Object)gridData);
        GridLayout advanced_layout = new GridLayout();
        advanced_layout.numColumns = 2;
        cSection.setLayout((Layout)advanced_layout);
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        if (userMode < 2) {
            Label label = new Label(cSection, 64);
            gridData = new GridData();
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            String[] modeKeys = new String[]{"ConfigView.section.mode.beginner", "ConfigView.section.mode.intermediate", "ConfigView.section.mode.advanced"};
            String param1 = 2 < modeKeys.length ? MessageText.getString(modeKeys[2]) : String.valueOf(2);
            String param2 = userMode < modeKeys.length ? MessageText.getString(modeKeys[userMode]) : String.valueOf(userMode);
            label.setText(MessageText.getString("ConfigView.notAvailableForMode", new String[]{param1, param2}));
            return cSection;
        }
        BooleanParameter enable_lan = new BooleanParameter(cSection, "LAN Speed Enabled", "ConfigView.section.transfer.lan.enable");
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        enable_lan.setLayoutData(gridData);
        IntParameter lan_max_upload = new IntParameter(cSection, "Max LAN Upload Speed KBs");
        gridData = new GridData();
        gridData.widthHint = 40;
        lan_max_upload.setLayoutData(gridData);
        Label llmux = new Label(cSection, 0);
        Messages.setLanguageText((Widget)llmux, "ConfigView.section.transfer.lan.uploadrate");
        IntParameter lan_max_download = new IntParameter(cSection, "Max LAN Download Speed KBs");
        gridData = new GridData();
        gridData.widthHint = 40;
        lan_max_download.setLayoutData(gridData);
        Label llmdx = new Label(cSection, 0);
        Messages.setLanguageText((Widget)llmdx, "ConfigView.section.transfer.lan.downloadrate");
        enable_lan.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Parameter[]{lan_max_upload, lan_max_download}));
        enable_lan.setAdditionalActionPerformer(new ChangeSelectionActionPerformer(new Control[]{llmux, llmdx}));
        return cSection;
    }
}

