/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCore;
import com.aelitis.azureus.core.speedmanager.SpeedManager;
import com.aelitis.azureus.core.speedmanager.SpeedManagerPingSource;
import java.text.DecimalFormat;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.gudy.azureus2.core3.global.GlobalManager;
import org.gudy.azureus2.core3.global.GlobalManagerStats;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.stats.transfer.OverallStats;
import org.gudy.azureus2.core3.stats.transfer.StatsFactory;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.ui.swt.Messages;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedLabel;
import org.gudy.azureus2.ui.swt.components.Legend;
import org.gudy.azureus2.ui.swt.components.graphics.PingGraphic;
import org.gudy.azureus2.ui.swt.views.AbstractIView;

public class TransferStatsView
extends AbstractIView {
    GlobalManager manager;
    AzureusCore core;
    GlobalManagerStats stats;
    OverallStats totalStats;
    Composite mainPanel;
    Composite generalPanel;
    BufferedLabel nowUp;
    BufferedLabel nowDown;
    BufferedLabel sessionDown;
    BufferedLabel sessionUp;
    BufferedLabel session_ratio;
    BufferedLabel sessionTime;
    BufferedLabel totalDown;
    BufferedLabel totalUp;
    BufferedLabel total_ratio;
    BufferedLabel totalTime;
    Group autoSpeedPanel;
    StackLayout autoSpeedPanelLayout;
    Composite autoSpeedInfoPanel;
    Composite autoSpeedDisabledPanel;
    Canvas pingCanvas;
    PingGraphic pingGraph;
    BufferedLabel idlePing;
    BufferedLabel maxPing;
    BufferedLabel maxUp;
    BufferedLabel currentPing;
    private final DecimalFormat formatter = new DecimalFormat("##.#");

    public TransferStatsView(GlobalManager manager, AzureusCore core) {
        this.core = core;
        this.manager = manager;
        this.stats = manager.getStats();
        this.totalStats = StatsFactory.getStats();
    }

    public void initialize(Composite composite) {
        this.mainPanel = new Composite(composite, 0);
        GridLayout mainLayout = new GridLayout();
        this.mainPanel.setLayout((Layout)mainLayout);
        this.createGeneralPanel();
        this.createAutoSpeedPanel();
    }

    private void createGeneralPanel() {
        this.generalPanel = new Composite(this.mainPanel, 2048);
        GridData generalPanelData = new GridData(768);
        this.generalPanel.setLayoutData((Object)generalPanelData);
        GridLayout panelLayout = new GridLayout();
        panelLayout.numColumns = 5;
        panelLayout.makeColumnsEqualWidth = true;
        this.generalPanel.setLayout((Layout)panelLayout);
        Label lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.downloaded");
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uploaded");
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.ratio");
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.uptime");
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.now");
        this.nowDown = new BufferedLabel(this.generalPanel, 0);
        GridData gridData = new GridData(768);
        this.nowDown.setLayoutData(gridData);
        this.nowUp = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.nowUp.setLayoutData(gridData);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.session");
        this.sessionDown = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.sessionDown.setLayoutData(gridData);
        this.sessionUp = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.sessionUp.setLayoutData(gridData);
        this.session_ratio = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.session_ratio.setLayoutData(gridData);
        this.sessionTime = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.sessionTime.setLayoutData(gridData);
        lbl = new Label(this.generalPanel, 0);
        Messages.setLanguageText((Widget)lbl, "SpeedView.stats.total");
        this.totalDown = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.totalDown.setLayoutData(gridData);
        this.totalUp = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.totalUp.setLayoutData(gridData);
        this.total_ratio = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.total_ratio.setLayoutData(gridData);
        this.totalTime = new BufferedLabel(this.generalPanel, 0);
        gridData = new GridData(768);
        this.totalTime.setLayoutData(gridData);
    }

    private void createAutoSpeedPanel() {
        this.autoSpeedPanel = new Group(this.mainPanel, 0);
        GridData generalPanelData = new GridData(1808);
        this.autoSpeedPanel.setLayoutData((Object)generalPanelData);
        Messages.setLanguageText((Widget)this.autoSpeedPanel, "SpeedView.stats.autospeed");
        this.autoSpeedPanelLayout = new StackLayout();
        this.autoSpeedPanel.setLayout((Layout)this.autoSpeedPanelLayout);
        this.autoSpeedInfoPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedInfoPanel.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.numColumns = 8;
        layout.makeColumnsEqualWidth = true;
        this.autoSpeedInfoPanel.setLayout((Layout)layout);
        Label label = new Label(this.autoSpeedInfoPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.idlePing");
        this.idlePing = new BufferedLabel(this.autoSpeedInfoPanel, 0);
        GridData gridData = new GridData(768);
        this.idlePing.setLayoutData(gridData);
        label = new Label(this.autoSpeedInfoPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.maxPing");
        this.maxPing = new BufferedLabel(this.autoSpeedInfoPanel, 0);
        gridData = new GridData(768);
        this.maxPing.setLayoutData(gridData);
        label = new Label(this.autoSpeedInfoPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.maxUp");
        this.maxUp = new BufferedLabel(this.autoSpeedInfoPanel, 0);
        gridData = new GridData(768);
        this.maxUp.setLayoutData(gridData);
        label = new Label(this.autoSpeedInfoPanel, 0);
        Messages.setLanguageText((Widget)label, "SpeedView.stats.currentPing");
        this.currentPing = new BufferedLabel(this.autoSpeedInfoPanel, 0);
        gridData = new GridData(768);
        this.currentPing.setLayoutData(gridData);
        this.pingCanvas = new Canvas(this.autoSpeedInfoPanel, 0);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 8;
        this.pingCanvas.setLayoutData((Object)gridData);
        this.pingGraph = PingGraphic.getInstance();
        this.pingGraph.initialize(this.pingCanvas);
        this.autoSpeedDisabledPanel = new Composite((Composite)this.autoSpeedPanel, 0);
        this.autoSpeedDisabledPanel.setLayout((Layout)new GridLayout());
        Label disabled = new Label(this.autoSpeedDisabledPanel, 0);
        disabled.setEnabled(false);
        Messages.setLanguageText((Widget)disabled, "SpeedView.stats.autospeed.disabled");
        disabled.setLayoutData((Object)new GridData(832));
        SpeedManager speedManager = this.core.getSpeedManager();
        this.autoSpeedPanelLayout.topControl = speedManager.isAvailable() ? this.autoSpeedInfoPanel : this.autoSpeedDisabledPanel;
        gridData = new GridData(768);
        gridData.horizontalSpan = 8;
        Legend.createLegendComposite(this.autoSpeedInfoPanel, PingGraphic.colors, new String[]{"TransferStatsView.legend.pingaverage", "TransferStatsView.legend.ping1", "TransferStatsView.legend.ping2", "TransferStatsView.legend.ping3"}, gridData);
    }

    public void delete() {
        Utils.disposeComposite(this.generalPanel);
        this.pingGraph.dispose();
    }

    public String getFullTitle() {
        return MessageText.getString("SpeedView.title.full");
    }

    public Composite getComposite() {
        return this.mainPanel;
    }

    public void refresh() {
        this.refreshGeneral();
        this.refreshPingPanel();
    }

    private void refreshGeneral() {
        int now_prot_down_rate = this.stats.getProtocolReceiveRate();
        int now_prot_up_rate = this.stats.getProtocolSendRate();
        int now_total_down_rate = this.stats.getDataReceiveRate() + now_prot_down_rate;
        int now_total_up_rate = this.stats.getDataSendRate() + now_prot_up_rate;
        float now_perc_down = (float)(now_prot_down_rate * 100) / (float)(now_total_down_rate == 0 ? 1 : now_total_down_rate);
        float now_perc_up = (float)(now_prot_up_rate * 100) / (float)(now_total_up_rate == 0 ? 1 : now_total_up_rate);
        this.nowDown.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_down_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_down_rate) + ", " + this.formatter.format(now_perc_down) + "%)");
        this.nowUp.setText(DisplayFormatters.formatByteCountToKiBEtcPerSec(now_total_up_rate) + "  (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(now_prot_up_rate) + ", " + this.formatter.format(now_perc_up) + "%)");
        long session_prot_received = this.stats.getTotalProtocolBytesReceived();
        long session_prot_sent = this.stats.getTotalProtocolBytesSent();
        long session_total_received = this.stats.getTotalDataBytesReceived() + session_prot_received;
        long session_total_sent = this.stats.getTotalDataBytesSent() + session_prot_sent;
        float session_perc_received = (float)(session_prot_received * 100L) / (float)(session_total_received == 0L ? 1L : session_total_received);
        float session_perc_sent = (float)(session_prot_sent * 100L) / (float)(session_total_sent == 0L ? 1L : session_total_sent);
        this.sessionDown.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_received) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_received) + ", " + this.formatter.format(session_perc_received) + "%)");
        this.sessionUp.setText(DisplayFormatters.formatByteCountToKiBEtc(session_total_sent) + "  (" + DisplayFormatters.formatByteCountToKiBEtc(session_prot_sent) + ", " + this.formatter.format(session_perc_sent) + "%)");
        this.totalDown.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getDownloadedBytes()));
        this.totalUp.setText(DisplayFormatters.formatByteCountToKiBEtc(this.totalStats.getUploadedBytes()));
        this.sessionTime.setText(DisplayFormatters.formatETA(this.totalStats.getSessionUpTime()));
        this.totalTime.setText(DisplayFormatters.formatETA(this.totalStats.getTotalUpTime()));
        long dl_bytes = this.totalStats.getDownloadedBytes();
        long t_ratio_raw = 1000L * this.totalStats.getUploadedBytes() / (dl_bytes == 0L ? 1L : dl_bytes);
        long s_ratio_raw = 1000L * session_total_sent / (session_total_received == 0L ? 1L : session_total_received);
        String t_ratio = "";
        String s_ratio = "";
        String partial = String.valueOf(t_ratio_raw % 1000L);
        while (partial.length() < 3) {
            partial = "0" + partial;
        }
        t_ratio = t_ratio_raw / 1000L + "." + partial;
        partial = String.valueOf(s_ratio_raw % 1000L);
        while (partial.length() < 3) {
            partial = "0" + partial;
        }
        s_ratio = s_ratio_raw / 1000L + "." + partial;
        this.total_ratio.setText(t_ratio);
        this.session_ratio.setText(s_ratio);
    }

    private void refreshPingPanel() {
        SpeedManager speedManager = this.core.getSpeedManager();
        if (speedManager.isAvailable() && speedManager.isEnabled()) {
            this.autoSpeedPanelLayout.topControl = this.autoSpeedInfoPanel;
            this.autoSpeedPanel.layout();
            SpeedManagerPingSource[] sources = speedManager.getPingSources();
            if (sources.length > 0) {
                int average = 0;
                for (int i = 0; i < sources.length; ++i) {
                    average += sources[i].getPingTime();
                }
                this.pingGraph.refresh();
                this.currentPing.setText((average /= sources.length) + " ms");
                this.idlePing.setText(speedManager.getIdlePingMillis() + " ms");
                this.maxPing.setText(speedManager.getMaxPingMillis() + " ms");
                this.maxUp.setText(DisplayFormatters.formatByteCountToBase10KBEtcPerSec(speedManager.getMaxUploadSpeed()));
            }
        } else {
            this.autoSpeedPanelLayout.topControl = this.autoSpeedDisabledPanel;
            this.autoSpeedPanel.layout();
        }
    }

    public void periodicUpdate() {
        SpeedManagerPingSource[] sources;
        SpeedManager speedManager = this.core.getSpeedManager();
        if (speedManager.isAvailable() && speedManager.isEnabled() && (sources = speedManager.getPingSources()).length > 0) {
            int[] pings = new int[sources.length];
            for (int i = 0; i < sources.length; ++i) {
                pings[i] = sources[i].getPingTime();
            }
            this.pingGraph.addIntsValue(pings);
        }
    }

    public String getData() {
        return "TransferStatsView.title.full";
    }
}

