/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.stats;

import com.aelitis.azureus.core.AzureusCoreFactory;
import com.aelitis.azureus.core.dht.DHT;
import com.aelitis.azureus.plugins.dht.DHTPlugin;
import java.util.List;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.ui.swt.views.AbstractIView;
import org.gudy.azureus2.ui.swt.views.stats.VivaldiPanel;

public class VivaldiView
extends AbstractIView {
    DHT dht;
    Composite panel;
    VivaldiPanel drawPanel;

    public VivaldiView() {
        this.init();
    }

    private void init() {
        try {
            PluginInterface dht_pi = AzureusCoreFactory.getSingleton().getPluginManager().getPluginInterfaceByClass(DHTPlugin.class);
            if (dht_pi == null) {
                return;
            }
            DHT[] dhts = ((DHTPlugin)dht_pi.getPlugin()).getDHTs();
            if (dhts.length == 0) {
                return;
            }
            this.dht = dhts[dhts.length - 1];
        }
        catch (Exception e) {
            Debug.printStackTrace(e);
        }
    }

    public void initialize(Composite composite) {
        this.panel = new Composite(composite, 0);
        this.panel.setLayout((Layout)new FillLayout());
        this.drawPanel = new VivaldiPanel(this.panel);
    }

    public Composite getComposite() {
        return this.panel;
    }

    public void refresh() {
        if (this.dht != null) {
            List l = this.dht.getControl().getContacts();
            this.drawPanel.refreshContacts(l, this.dht.getControl().getTransport().getLocalContact());
        } else {
            this.init();
        }
    }

    public String getData() {
        return "VivaldiView.title.full";
    }

    public String getFullTitle() {
        return MessageText.getString("VivaldiView.title.full");
    }
}

