/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.table.impl;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Locale;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEMonitor;
import org.gudy.azureus2.core3.util.AERunnable;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemTime;
import org.gudy.azureus2.plugins.ui.Graphic;
import org.gudy.azureus2.plugins.ui.SWT.GraphicSWT;
import org.gudy.azureus2.plugins.ui.UIRuntimeException;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellToolTipListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellVisibilityListener;
import org.gudy.azureus2.plugins.ui.tables.TableColumn;
import org.gudy.azureus2.plugins.ui.tables.TableRow;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem1;
import org.gudy.azureus2.ui.swt.components.BufferedGraphicTableItem2;
import org.gudy.azureus2.ui.swt.components.BufferedTableItem;
import org.gudy.azureus2.ui.swt.components.BufferedTableItemImpl;
import org.gudy.azureus2.ui.swt.components.BufferedTableRow;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.plugins.UISWTGraphic;
import org.gudy.azureus2.ui.swt.pluginsimpl.UISWTGraphicImpl;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.TableColumnCore;
import org.gudy.azureus2.ui.swt.views.table.TableRowCore;

public class TableCellImpl
implements TableCellCore {
    private static final LogIDs LOGID = LogIDs.GUI;
    private TableRowCore tableRow;
    private Comparable sortValue;
    private boolean bSortValueIsText = true;
    private BufferedTableItem bufferedTableItem;
    private ArrayList refreshListeners;
    private ArrayList disposeListeners;
    private ArrayList tooltipListeners;
    private ArrayList cellMouseListeners;
    private ArrayList cellVisibilityListeners;
    private TableColumnCore tableColumn;
    private boolean valid;
    private int refreshErrLoopCount;
    private int tooltipErrLoopCount;
    private int loopFactor;
    private Object oToolTip;
    private int iCursorID = -1;
    private Graphic graphic = null;
    private boolean bIsUpToDate = true;
    private boolean bDisposed = false;
    private boolean bMustRefresh = false;
    public boolean bDebug = false;
    private AEMonitor this_mon = new AEMonitor("TableCell");
    private boolean bCellVisuallyChangedSinceRefresh;
    private static final String CFG_PAINT = "GUI_SWT_bAlternateTablePainting";
    private static boolean bAlternateTablePainting;
    private boolean bInRefresh = false;
    public static final Comparator TEXT_COMPARATOR;

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn, int position, BufferedTableItem item) {
        this.tableColumn = _tableColumn;
        this.tableRow = _tableRow;
        this.valid = false;
        this.refreshErrLoopCount = 0;
        this.tooltipErrLoopCount = 0;
        this.loopFactor = 0;
        this.bufferedTableItem = item;
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableCellImpl.this.tableColumn.invokeCellAddedListeners(TableCellImpl.this);
            }
        });
    }

    public TableCellImpl(TableRowCore _tableRow, TableColumnCore _tableColumn, int position) {
        this.tableColumn = _tableColumn;
        this.tableRow = _tableRow;
        this.valid = false;
        this.refreshErrLoopCount = 0;
        this.tooltipErrLoopCount = 0;
        this.loopFactor = 0;
        this.createBufferedTableItem(position);
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                TableCellImpl.this.tableColumn.invokeCellAddedListeners(TableCellImpl.this);
            }
        });
    }

    private void createBufferedTableItem(int position) {
        BufferedTableRow bufRow = (BufferedTableRow)((Object)this.tableRow);
        if (this.tableColumn.getType() == 2) {
            this.bufferedTableItem = bAlternateTablePainting ? new BufferedGraphicTableItem2(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.valid = false;
                }
            } : new BufferedGraphicTableItem1(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.valid = false;
                }
            };
            this.setOrientationViaColumn();
        } else {
            this.bufferedTableItem = new BufferedTableItemImpl(bufRow, position){

                public void refresh() {
                    TableCellImpl.this.refresh();
                }

                public void invalidate() {
                    TableCellImpl.this.valid = false;
                }
            };
        }
    }

    private void pluginError(Throwable e) {
        String sTitleLanguageKey = this.tableColumn.getTitleLanguageKey();
        String sPosition = this.bufferedTableItem == null ? "null" : "" + this.bufferedTableItem.getPosition() + " (" + MessageText.getString(sTitleLanguageKey) + ")";
        Logger.log(new LogEvent(LOGID, "Table Cell Plugin for Column #" + sPosition + " generated an exception ", e));
    }

    private void checkCellForSetting() {
        if (this.isDisposed()) {
            throw new UIRuntimeException("Table Cell is disposed.");
        }
    }

    public Object getDataSource() {
        TableRowCore row = this.tableRow;
        TableColumnCore col = this.tableColumn;
        if (row == null || col == null) {
            return null;
        }
        return row.getDataSource(col.getUseCoreDataSource());
    }

    public TableColumn getTableColumn() {
        return this.tableColumn;
    }

    public TableRow getTableRow() {
        return this.tableRow;
    }

    public String getTableID() {
        return this.tableRow.getTableID();
    }

    public boolean isValid() {
        return this.valid;
    }

    public Color getForegroundSWT() {
        this.checkCellForSetting();
        return this.bufferedTableItem.getForeground();
    }

    public int[] getForeground() {
        Color color = this.bufferedTableItem.getForeground();
        if (color == null) {
            return new int[3];
        }
        return new int[]{color.getRed(), color.getGreen(), color.getBlue()};
    }

    public boolean setForeground(Color color) {
        this.checkCellForSetting();
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        this.bCellVisuallyChangedSinceRefresh = true;
        return this.bufferedTableItem.setForeground(color);
    }

    public boolean setForeground(int red, int green, int blue) {
        this.checkCellForSetting();
        if (this.isInvisibleAndCanRefresh()) {
            return false;
        }
        this.bCellVisuallyChangedSinceRefresh = true;
        return this.bufferedTableItem.setForeground(red, green, blue);
    }

    public boolean setText(String text) {
        this.checkCellForSetting();
        if (text == null) {
            text = "";
        }
        boolean bChanged = false;
        if (this.bSortValueIsText && !text.equals(this.sortValue)) {
            bChanged = true;
            this.sortValue = text;
            this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
            if (this.bDebug) {
                this.debug("Setting SortValue to text;");
            }
        }
        if (this.bufferedTableItem.setText(text) && !this.bSortValueIsText) {
            bChanged = true;
        }
        if (this.bDebug) {
            this.debug("setText (" + bChanged + ") : " + text);
        }
        if (bChanged) {
            this.bCellVisuallyChangedSinceRefresh = true;
        }
        return bChanged;
    }

    private boolean isInvisibleAndCanRefresh() {
        return !this.isShown() && (this.refreshListeners != null || this.tableColumn.hasCellRefreshListener());
    }

    public String getText() {
        if (this.bSortValueIsText && this.sortValue instanceof String) {
            return (String)((Object)this.sortValue);
        }
        return this.bufferedTableItem.getText();
    }

    public boolean isShown() {
        return this.bufferedTableItem.isShown();
    }

    public boolean setSortValue(Comparable valueToSort) {
        if (!(this.tableColumn.isSortValueLive() || valueToSort instanceof Number || valueToSort instanceof String)) {
            this.tableColumn.setSortValueLive(true);
        }
        return this._setSortValue(valueToSort);
    }

    private boolean _setSortValue(Comparable valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue == valueToSort) {
            return false;
        }
        if (this.bSortValueIsText) {
            this.bSortValueIsText = false;
            if (this.sortValue instanceof String) {
                this.setText((String)((Object)this.sortValue));
            }
        }
        if (valueToSort instanceof String && this.sortValue instanceof String && this.sortValue.equals(valueToSort)) {
            return false;
        }
        if (this.bDebug) {
            this.debug("Setting SortValue to " + (valueToSort == null ? "null" : valueToSort.getClass().getName()));
        }
        this.tableColumn.setLastSortValueChange(SystemTime.getCurrentTime());
        this.sortValue = valueToSort;
        return true;
    }

    public boolean setSortValue(long valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue instanceof Long && (Long)this.sortValue == valueToSort) {
            return false;
        }
        return this._setSortValue(new Long(valueToSort));
    }

    public boolean setSortValue(float valueToSort) {
        this.checkCellForSetting();
        if (this.sortValue instanceof Float && ((Float)this.sortValue).floatValue() == valueToSort) {
            return false;
        }
        return this._setSortValue(new Float(valueToSort));
    }

    public Comparable getSortValue() {
        if (this.bDebug) {
            this.debug("GetSortValue;" + (this.sortValue == null ? "null" : this.sortValue.getClass().getName() + ";" + this.sortValue.toString()));
        }
        if (this.sortValue == null) {
            if (this.bufferedTableItem != null) {
                return this.bufferedTableItem.getText();
            }
            return "";
        }
        return this.sortValue;
    }

    public void setToolTip(Object tooltip) {
        this.oToolTip = tooltip;
    }

    public Object getToolTip() {
        return this.oToolTip;
    }

    public boolean isDisposed() {
        return this.bDisposed;
    }

    public Point getSize() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
    }

    public int getWidth() {
        Point pt = null;
        if (this.bufferedTableItem instanceof BufferedGraphicTableItem) {
            pt = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
        } else {
            Rectangle bounds = this.bufferedTableItem.getBounds();
            if (bounds != null) {
                pt = new Point(bounds.width, bounds.height);
            }
        }
        if (pt == null) {
            return -1;
        }
        return pt.x;
    }

    public int getHeight() {
        Point pt = null;
        if (this.bufferedTableItem instanceof BufferedGraphicTableItem) {
            pt = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getSize();
        } else {
            Rectangle bounds = this.bufferedTableItem.getBounds();
            if (bounds != null) {
                pt = new Point(bounds.width, bounds.height);
            }
        }
        if (pt == null) {
            return -1;
        }
        return pt.y;
    }

    public boolean setGraphic(Image img) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        this.graphic = null;
        boolean b = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(img);
        if (b) {
            this.bCellVisuallyChangedSinceRefresh = true;
        }
        return b;
    }

    public boolean setGraphic(Graphic img) {
        Image imgSWT;
        boolean b;
        boolean b2;
        if (img != null) {
            this.checkCellForSetting();
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return false;
        }
        this.graphic = img;
        if (img == null && (b2 = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(null))) {
            this.bCellVisuallyChangedSinceRefresh = true;
        }
        if (img instanceof GraphicSWT && (b = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(imgSWT = ((GraphicSWT)img).getImage()))) {
            this.bCellVisuallyChangedSinceRefresh = true;
        }
        if (img instanceof UISWTGraphic && (b = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setGraphic(imgSWT = ((UISWTGraphic)img).getImage()))) {
            this.bCellVisuallyChangedSinceRefresh = true;
        }
        return false;
    }

    public Graphic getGraphic() {
        if (this.graphic != null) {
            return this.graphic;
        }
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        Image img = ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getGraphic();
        return new UISWTGraphicImpl(img);
    }

    public Image getGraphicSWT() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return null;
        }
        return ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).getGraphic();
    }

    public void setFillCell(boolean bFillCell) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        if (bFillCell) {
            ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setOrientation(4);
        } else {
            this.setOrientationViaColumn();
        }
        this.bCellVisuallyChangedSinceRefresh = true;
    }

    public void setMarginHeight(int height) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setMargin(-1, height);
        this.bCellVisuallyChangedSinceRefresh = true;
    }

    public void setMarginWidth(int width) {
        this.checkCellForSetting();
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        ((BufferedGraphicTableItem)((Object)this.bufferedTableItem)).setMargin(width, -1);
        this.bCellVisuallyChangedSinceRefresh = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                this.refreshListeners = new ArrayList(1);
            }
            if (this.bDebug) {
                this.debug("addRefreshListener; count=" + this.refreshListeners.size());
            }
            this.refreshListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeRefreshListener(TableCellRefreshListener listener) {
        try {
            this.this_mon.enter();
            if (this.refreshListeners == null) {
                return;
            }
            this.refreshListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                this.disposeListeners = new ArrayList(1);
            }
            this.disposeListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDisposeListener(TableCellDisposeListener listener) {
        try {
            this.this_mon.enter();
            if (this.disposeListeners == null) {
                return;
            }
            this.disposeListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                this.tooltipListeners = new ArrayList(1);
            }
            this.tooltipListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeToolTipListener(TableCellToolTipListener listener) {
        try {
            this.this_mon.enter();
            if (this.tooltipListeners == null) {
                return;
            }
            this.tooltipListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                this.cellMouseListeners = new ArrayList(1);
            }
            this.cellMouseListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMouseListener(TableCellMouseListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellMouseListeners == null) {
                return;
            }
            this.cellMouseListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                this.cellVisibilityListeners = new ArrayList(1);
            }
            this.cellVisibilityListeners.add(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeVisibilityListener(TableCellVisibilityListener listener) {
        try {
            this.this_mon.enter();
            if (this.cellVisibilityListeners == null) {
                return;
            }
            this.cellVisibilityListeners.remove(listener);
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void addListeners(Object listenerObject) {
        if (listenerObject instanceof TableCellDisposeListener) {
            this.addDisposeListener((TableCellDisposeListener)listenerObject);
        }
        if (listenerObject instanceof TableCellRefreshListener) {
            this.addRefreshListener((TableCellRefreshListener)listenerObject);
        }
        if (listenerObject instanceof TableCellToolTipListener) {
            this.addToolTipListener((TableCellToolTipListener)listenerObject);
        }
        if (listenerObject instanceof TableCellMouseListener) {
            this.addMouseListener((TableCellMouseListener)listenerObject);
        }
        if (listenerObject instanceof TableCellVisibilityListener) {
            this.addVisibilityListener((TableCellVisibilityListener)listenerObject);
        }
    }

    public void invalidate() {
        this.checkCellForSetting();
        this.invalidate(true);
    }

    public void invalidate(boolean bMustRefresh) {
        this.valid = false;
        if (this.bDebug) {
            this.debug("Invalidate Cell;" + bMustRefresh);
        }
        if (bMustRefresh) {
            this.bMustRefresh = true;
        }
    }

    public boolean refresh() {
        return this.refresh(true);
    }

    public boolean refresh(boolean bDoGraphics) {
        return this.refresh(bDoGraphics, this.isShown());
    }

    public boolean refresh(boolean bDoGraphics, boolean bRowVisible) {
        return this.refresh(bDoGraphics, bRowVisible, this.isShown());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean refresh(boolean bDoGraphics, boolean bRowVisible, boolean bCellVisible) {
        boolean ret = this.bCellVisuallyChangedSinceRefresh;
        int iErrCount = 0;
        try {
            int iInterval;
            if (this.refreshErrLoopCount > 2) {
                boolean bl = this.bCellVisuallyChangedSinceRefresh;
                return bl;
            }
            iErrCount = this.tableColumn.getConsecutiveErrCount();
            if (iErrCount > 10) {
                this.refreshErrLoopCount = 3;
                boolean bl = this.bCellVisuallyChangedSinceRefresh;
                return bl;
            }
            if (this.bInRefresh) {
                if (this.bDebug) {
                    this.debug("Calling Refresh from Refresh :) Skipping.");
                }
                boolean bl = this.bCellVisuallyChangedSinceRefresh;
                return bl;
            }
            this.bInRefresh = true;
            if (bCellVisible && !this.bIsUpToDate) {
                if (this.bDebug) {
                    this.debug("Setting Invalid because visible & not up to date");
                }
                this.valid = false;
                this.bIsUpToDate = true;
            } else if (!bCellVisible && this.bIsUpToDate) {
                this.bIsUpToDate = false;
            }
            if (this.bDebug) {
                this.debug("Cell Valid?" + this.valid + "; Visible?" + this.tableRow.isVisible() + "/" + this.bufferedTableItem.isShown());
            }
            if ((iInterval = this.tableColumn.getRefreshInterval()) == -3 && !this.valid && !this.bMustRefresh && this.bSortValueIsText && this.sortValue != null && this.tableColumn.getType() == 3) {
                if (bCellVisible) {
                    if (this.bDebug) {
                        this.debug("fast refresh: setText");
                    }
                    this.setText((String)((Object)this.sortValue));
                    this.valid = true;
                }
            } else if (iInterval == -2 || iInterval == -1 && bDoGraphics || iInterval > 0 && this.loopFactor % iInterval == 0 || !this.valid || this.bMustRefresh) {
                boolean bWasValid = this.isValid();
                if (this.bDebug) {
                    this.debug("invoke refresh");
                }
                long lTimeStart = SystemTime.getCurrentTime();
                this.tableColumn.invokeCellRefreshListeners(this);
                if (this.refreshListeners != null) {
                    for (int i = 0; i < this.refreshListeners.size(); ++i) {
                        ((TableCellRefreshListener)this.refreshListeners.get(i)).refresh(this);
                    }
                }
                long lTimeEnd = SystemTime.getCurrentTime();
                this.tableColumn.addRefreshTime(lTimeEnd - lTimeStart);
                if (!bWasValid) {
                    this.valid = true;
                }
                if (this.bMustRefresh) {
                    this.bMustRefresh = false;
                }
            }
            ++this.loopFactor;
            this.refreshErrLoopCount = 0;
            if (iErrCount > 0) {
                this.tableColumn.setConsecutiveErrCount(0);
            }
            ret = this.bCellVisuallyChangedSinceRefresh;
        }
        catch (Throwable e) {
            ++this.refreshErrLoopCount;
            this.tableColumn.setConsecutiveErrCount(++iErrCount);
            this.pluginError(e);
            if (this.refreshErrLoopCount > 2) {
                Logger.log(new LogEvent(LOGID, 3, "TableCell will not be refreshed anymore this session."));
            }
        }
        finally {
            this.bCellVisuallyChangedSinceRefresh = false;
            this.bInRefresh = false;
        }
        return ret;
    }

    public boolean getVisuallyChangedSinceRefresh() {
        return this.bCellVisuallyChangedSinceRefresh;
    }

    public void dispose() {
        this.bDisposed = true;
        this.tableColumn.invokeCellDisposeListeners(this);
        if (this.disposeListeners != null) {
            try {
                Iterator iter = this.disposeListeners.iterator();
                while (iter.hasNext()) {
                    TableCellDisposeListener listener = (TableCellDisposeListener)iter.next();
                    listener.dispose(this);
                }
                this.disposeListeners = null;
            }
            catch (Throwable e) {
                this.pluginError(e);
            }
        }
        if (this.bufferedTableItem != null) {
            this.bufferedTableItem.dispose();
        }
        this.refreshListeners = null;
        this.bufferedTableItem = null;
        this.tableColumn = null;
        this.tableRow = null;
        this.sortValue = null;
    }

    public void setIcon(Image img) {
        if (this.isInvisibleAndCanRefresh()) {
            return;
        }
        this.bufferedTableItem.setIcon(img);
        this.graphic = null;
        this.bCellVisuallyChangedSinceRefresh = true;
    }

    public Image getIcon() {
        return this.bufferedTableItem.getIcon();
    }

    public boolean needsPainting() {
        return this.bufferedTableItem.needsPainting();
    }

    public void doPaint(GC gc) {
        if (!(this.bIsUpToDate && this.valid || this.refreshListeners == null && !this.tableColumn.hasCellRefreshListener())) {
            if (this.bDebug) {
                this.debug("doPaint: invoke refresh");
            }
            this.refresh();
        }
        if (this.bDebug) {
            this.debug("doPaint " + this.bIsUpToDate + ";" + this.valid + ";" + this.refreshListeners);
        }
        this.bufferedTableItem.doPaint(gc);
    }

    public void locationChanged() {
        this.bufferedTableItem.locationChanged();
    }

    public TableRowCore getTableRowCore() {
        return this.tableRow;
    }

    public String toString() {
        return "TableCell {" + this.tableColumn.getName() + "," + (this.bufferedTableItem == null ? "null" : "" + this.bufferedTableItem.getPosition()) + "," + this.getText() + "," + this.getSortValue() + "}";
    }

    public int compareTo(Object o) {
        try {
            Comparable ourSortValue = this.getSortValue();
            Comparable otherSortValue = ((TableCellImpl)o).getSortValue();
            if (ourSortValue instanceof String && otherSortValue instanceof String) {
                Collator collator = Collator.getInstance(Locale.getDefault());
                return collator.compare(ourSortValue, otherSortValue);
            }
            try {
                return ourSortValue.compareTo(otherSortValue);
            }
            catch (ClassCastException e) {
            }
        }
        catch (Exception e) {
            System.out.println("Could not compare cells");
            Debug.printStackTrace(e);
        }
        return 0;
    }

    public void invokeToolTipListeners(int type) {
        block9: {
            if (this.tableColumn == null) {
                return;
            }
            this.tableColumn.invokeCellToolTipListeners(this, type);
            if (this.tooltipListeners == null || this.tooltipErrLoopCount > 2) {
                return;
            }
            int iErrCount = this.tableColumn.getConsecutiveErrCount();
            if (iErrCount > 10) {
                return;
            }
            try {
                if (type == 0) {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHover(this);
                    }
                } else {
                    for (int i = 0; i < this.tooltipListeners.size(); ++i) {
                        ((TableCellToolTipListener)this.tooltipListeners.get(i)).cellHoverComplete(this);
                    }
                }
                this.tooltipErrLoopCount = 0;
            }
            catch (Throwable e) {
                ++this.tooltipErrLoopCount;
                this.tableColumn.setConsecutiveErrCount(++iErrCount);
                this.pluginError(e);
                if (this.tooltipErrLoopCount <= 2) break block9;
                Logger.log(new LogEvent(LOGID, 3, "TableCell's tooltip will not be refreshed anymore this session."));
            }
        }
    }

    public void invokeMouseListeners(TableCellMouseEvent event2) {
        if (this.cellMouseListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellMouseListeners.size(); ++i) {
            try {
                TableCellMouseListener l = (TableCellMouseListener)this.cellMouseListeners.get(i);
                l.cellMouseTrigger(event2);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void invokeVisibilityListeners(int visibility) {
        if (this.cellVisibilityListeners == null) {
            return;
        }
        for (int i = 0; i < this.cellVisibilityListeners.size(); ++i) {
            try {
                TableCellVisibilityListener l = (TableCellVisibilityListener)this.cellVisibilityListeners.get(i);
                l.cellVisibilityChanged(this, visibility);
                continue;
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    public void setUpToDate(boolean upToDate) {
        this.bIsUpToDate = upToDate;
    }

    public boolean isUpToDate() {
        return this.bIsUpToDate;
    }

    private void debug(final String s) {
        Utils.execSWTThread(new AERunnable(){

            public void runSupport() {
                System.out.println(SystemTime.getCurrentTime() + ": r" + TableCellImpl.this.tableRow.getIndex() + "c" + TableCellImpl.this.tableColumn.getPosition() + "r.v?" + (TableCellImpl.this.tableRow.isVisible() ? "Y" : "N") + ";" + s);
            }
        }, true);
    }

    public Rectangle getBounds() {
        Rectangle bounds = this.bufferedTableItem.getBounds();
        if (bounds == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        return bounds;
    }

    private void setOrientationViaColumn() {
        if (!(this.bufferedTableItem instanceof BufferedGraphicTableItem)) {
            return;
        }
        BufferedGraphicTableItem ti = (BufferedGraphicTableItem)((Object)this.bufferedTableItem);
        int align = this.tableColumn.getAlignment();
        if (align == 3) {
            ti.setOrientation(0x1000000);
        } else if (align == 1) {
            ti.setOrientation(16384);
        } else if (align == 2) {
            ti.setOrientation(131072);
        }
    }

    public String getObfusticatedText() {
        if (this.tableColumn.isObfusticated()) {
            if (this.tableColumn instanceof ObfusticateCellText) {
                return ((ObfusticateCellText)((Object)this.tableColumn)).getObfusticatedText(this);
            }
            return "";
        }
        return null;
    }

    public Image getBackgroundImage() {
        return this.bufferedTableItem.getBackgroundImage();
    }

    public BufferedTableItem getBufferedTableItem() {
        return this.bufferedTableItem;
    }

    public int getCursorID() {
        return this.iCursorID;
    }

    public void setCursorID(int cursorID) {
        this.iCursorID = cursorID;
    }

    static {
        COConfigurationManager.addAndFireParameterListener(CFG_PAINT, new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bAlternateTablePainting = COConfigurationManager.getBooleanParameter(TableCellImpl.CFG_PAINT);
            }
        });
        TEXT_COMPARATOR = new TextComparator();
    }

    private static class TextComparator
    implements Comparator {
        private TextComparator() {
        }

        public int compare(Object arg0, Object arg1) {
            return arg0.toString().compareToIgnoreCase(arg1.toString());
        }
    }
}

