/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.files;

import org.gudy.azureus2.core3.disk.DiskManagerFileInfo;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class PercentItem
extends CoreTableColumn
implements TableCellRefreshListener {
    public PercentItem() {
        super("%", 2, -2, 60, "Files");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        DiskManagerFileInfo fileInfo2 = (DiskManagerFileInfo)cell.getDataSource();
        long percent = 0L;
        if (fileInfo2 != null) {
            if (fileInfo2.getDownloaded() < 0L) {
                percent = -1L;
            } else if (fileInfo2.getLength() != 0L) {
                percent = 1000L * fileInfo2.getDownloaded() / fileInfo2.getLength();
            }
        } else {
            percent = -1L;
        }
        if (!cell.setSortValue(percent) && cell.isValid()) {
            return;
        }
        cell.setText(percent < 0L ? "" : DisplayFormatters.formatPercentFromThousands((int)percent));
    }
}

