/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseEvent;
import org.gudy.azureus2.plugins.ui.tables.TableCellMouseListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.SimpleTextEntryWindow;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class CommentItem
extends CoreTableColumn
implements TableCellRefreshListener,
TableCellMouseListener,
ObfusticateCellText {
    public CommentItem(String sTableID) {
        super("comment", -1, 300, sTableID);
        this.setRefreshInterval(-2);
        this.setType(1);
        this.setObfustication(true);
    }

    public void refresh(TableCell cell) {
        String comment = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        comment = dm.getDownloadState().getUserComment();
        if (comment != null) {
            comment = comment.replace('\r', ' ').replace('\n', ' ');
        }
        cell.setText(comment == null ? "" : comment);
    }

    public void cellMouseTrigger(TableCellMouseEvent event2) {
        DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
        if (dm == null) {
            return;
        }
        event2.skipCoreFunctionality = true;
        if (event2.eventType != 2) {
            return;
        }
        CommentItem.openEditCommentWindow(dm);
    }

    public String getObfusticatedText(TableCell cell) {
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        return Integer.toHexString(dm.hashCode());
    }

    static void openEditCommentWindow(DownloadManager dm) {
        String suggested = dm.getDownloadState().getUserComment();
        String msg_key_prefix = "MyTorrentsView.menu.edit_comment.enter.";
        SimpleTextEntryWindow text_entry = new SimpleTextEntryWindow(Display.getCurrent());
        text_entry.setTitle(msg_key_prefix + "title");
        text_entry.setMessage(msg_key_prefix + "message");
        text_entry.setPreenteredText(suggested, false);
        text_entry.setMultiLine(true);
        text_entry.prompt();
        if (text_entry.hasSubmittedInput()) {
            String value = text_entry.getSubmittedInput();
            String value_to_set = value.length() == 0 ? null : value;
            dm.getDownloadState().setUserComment(value_to_set);
        }
    }
}

