/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.config.ParameterListener;
import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.torrent.TOTorrent;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellDisposeListener;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.ImageRepository;
import org.gudy.azureus2.ui.swt.debug.ObfusticateCellText;
import org.gudy.azureus2.ui.swt.views.table.TableCellCore;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class NameItem
extends CoreTableColumn
implements TableCellRefreshListener,
ObfusticateCellText,
TableCellDisposeListener {
    private static boolean bShowIcon;

    public NameItem(String sTableID) {
        super("name", -2, 250, sTableID);
        this.setObfustication(true);
        this.setRefreshInterval(-2);
        this.setType(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(TableCell cell) {
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null) {
            name = dm.getDisplayName();
        }
        if (name == null) {
            name = "";
        }
        if ((cell.setText(name) || !cell.isValid()) && dm != null && bShowIcon) {
            String path = dm.getDownloadState().getPrimaryFile();
            if (path != null) {
                Image icon = ImageRepository.getPathIcon(path);
                if (Constants.isWindows) {
                    this.disposeCellIcon(cell);
                    Rectangle iconBounds = icon.getBounds();
                    int cellHeight = cell.getHeight();
                    if (cellHeight < 20) {
                        cellHeight = 16;
                    }
                    Image dstImage = new Image((Device)Display.getCurrent(), cellHeight, cellHeight);
                    GC gc = new GC((Drawable)dstImage);
                    try {
                        gc.setAdvanced(true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    try {
                        gc.drawImage(icon, 0, 0, iconBounds.width, iconBounds.height, 0, 0, cellHeight, cellHeight);
                        TOTorrent torrent = dm.getTorrent();
                        if (torrent != null && !torrent.isSimpleTorrent()) {
                            Image imgFolder = ImageRepository.getImage("foldersmall");
                            Rectangle folderBounds = imgFolder.getBounds();
                            gc.drawImage(imgFolder, folderBounds.x, folderBounds.y, folderBounds.width, folderBounds.height, cellHeight - folderBounds.width, cellHeight - folderBounds.height, folderBounds.width, folderBounds.height);
                        }
                    }
                    finally {
                        gc.dispose();
                    }
                    icon = dstImage;
                }
                ((TableCellCore)cell).setIcon(icon);
            } else if (Constants.isWindows) {
                this.disposeCellIcon(cell);
            }
        }
    }

    public String getObfusticatedText(TableCell cell) {
        int i;
        String name = null;
        DownloadManager dm = (DownloadManager)cell.getDataSource();
        if (dm != null && (i = (name = dm.toString()).indexOf(35)) > 0) {
            name = name.substring(i + 1);
        }
        if (name == null) {
            name = "";
        }
        return name;
    }

    public void dispose(TableCell cell) {
        if (bShowIcon && Constants.isWindows) {
            this.disposeCellIcon(cell);
        }
    }

    private void disposeCellIcon(TableCell cell) {
        Image img = ((TableCellCore)cell).getIcon();
        if (img != null) {
            ((TableCellCore)cell).setIcon(null);
            if (!img.isDisposed()) {
                img.dispose();
            }
        }
    }

    static {
        COConfigurationManager.addAndFireParameterListener("NameColumn.showProgramIcon", new ParameterListener(){

            public void parameterChanged(String parameterName) {
                bShowIcon = COConfigurationManager.getBooleanParameter("NameColumn.showProgramIcon");
            }
        });
    }
}

