/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.tracker.client.TRTrackerScraperResponse;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellAddedListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;
import org.gudy.azureus2.ui.swt.views.tableitems.mytorrents.AbstractTrackerCell;

public class PeersItem
extends CoreTableColumn
implements TableCellAddedListener {
    public PeersItem(String sTableID) {
        super("peers", 3, -2, 60, sTableID);
        this.setRefreshInterval(-2);
    }

    public void cellAdded(TableCell cell) {
        new Cell(cell);
    }

    private class Cell
    extends AbstractTrackerCell {
        long lTotalPeers;

        public Cell(TableCell cell) {
            super(cell);
            this.lTotalPeers = -1L;
        }

        public void scrapeResult(TRTrackerScraperResponse response) {
            if (this.checkScrapeResult(response)) {
                this.lTotalPeers = response.getPeers();
            }
        }

        public void refresh(TableCell cell) {
            DownloadManager dm;
            long totalPeers;
            super.refresh(cell);
            long lConnectedPeers = 0L;
            if (this.dm != null) {
                TRTrackerScraperResponse response;
                lConnectedPeers = this.dm.getNbPeers();
                if (this.lTotalPeers == -1L && (response = this.dm.getTrackerScrapeResponse()) != null && response.isValid()) {
                    this.lTotalPeers = response.getPeers();
                }
            }
            if ((totalPeers = this.lTotalPeers) <= 0L && (dm = (DownloadManager)cell.getDataSource()) != null) {
                totalPeers = dm.getActivationCount();
            }
            long value = lConnectedPeers * 10000000L;
            if (totalPeers > 0L) {
                value += totalPeers;
            }
            if (!cell.setSortValue(value) && cell.isValid()) {
                return;
            }
            String tmp = String.valueOf(lConnectedPeers);
            if (totalPeers != -1L) {
                tmp = tmp + " (" + totalPeers + ")";
            }
            cell.setText(tmp);
        }

        public void cellHover(TableCell cell) {
            int activationCount;
            super.cellHover(cell);
            long lConnectedPeers = 0L;
            DownloadManager dm = (DownloadManager)cell.getDataSource();
            if (dm != null) {
                lConnectedPeers = dm.getNbPeers();
            }
            String sToolTip = lConnectedPeers + " " + MessageText.getString("GeneralView.label.connected") + "\n";
            if (this.lTotalPeers != -1L) {
                sToolTip = sToolTip + this.lTotalPeers + " " + MessageText.getString("GeneralView.label.in_swarm");
            } else {
                TRTrackerScraperResponse response = dm.getTrackerScrapeResponse();
                sToolTip = sToolTip + "?? " + MessageText.getString("GeneralView.label.in_swarm");
                if (response != null) {
                    sToolTip = sToolTip + "(" + response.getStatusString() + ")";
                }
            }
            int n = activationCount = dm == null ? 0 : dm.getActivationCount();
            if (activationCount > 0) {
                sToolTip = sToolTip + "\n" + MessageText.getString("PeerColumn.activationCount", new String[]{"" + activationCount});
            }
            cell.setToolTip(sToolTip);
        }
    }
}

