/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.views.tableitems.mytorrents;

import org.gudy.azureus2.core3.download.DownloadManager;
import org.gudy.azureus2.core3.util.DisplayFormatters;
import org.gudy.azureus2.plugins.ui.tables.TableCell;
import org.gudy.azureus2.plugins.ui.tables.TableCellRefreshListener;
import org.gudy.azureus2.ui.swt.views.table.utils.CoreTableColumn;

public class RemainingItem
extends CoreTableColumn
implements TableCellRefreshListener {
    private boolean bLastValueEstimate = false;

    public RemainingItem() {
        super("remaining", 2, -1, 70, "MyTorrents");
        this.setRefreshInterval(-2);
    }

    public void refresh(TableCell cell) {
        long lRemaining = this.getRemaining(cell);
        if (!cell.setSortValue(lRemaining) && cell.isValid()) {
            return;
        }
        if (this.bLastValueEstimate) {
            cell.setText("~ " + DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
        } else {
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(lRemaining));
        }
    }

    private long getRemaining(TableCell cell) {
        DownloadManager manager = (DownloadManager)cell.getDataSource();
        if (manager == null) {
            return 0L;
        }
        return manager.getStats().getRemaining();
    }
}

