/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.welcome;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Locale;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.gudy.azureus2.core3.internat.MessageText;
import org.gudy.azureus2.core3.util.AEThread;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.FileUtil;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.pluginsimpl.local.utils.resourcedownloader.ResourceDownloaderFactoryImpl;
import org.gudy.azureus2.ui.swt.Utils;
import org.gudy.azureus2.ui.swt.components.shell.ShellFactory;

public class WelcomeWindow {
    private static final String URL_WHATSNEW = "http://web.azureusplatform.com/az-web/releasenotes";
    private static final String lineSeparator = System.getProperty("line.separator");
    Display display;
    Shell shell;
    Color black;
    Color white;
    Color light;
    Color grey;
    Color green;
    Color blue;
    Color fg;
    Color bg;

    public WelcomeWindow(Shell parentShell) {
        this(parentShell, "http://web.azureusplatform.com/az-web/releasenotes?version=2.5.0.4&locale=" + Locale.getDefault().toString());
    }

    public WelcomeWindow(Shell parentShell, String url) {
        this.shell = ShellFactory.createShell(parentShell, 2160);
        Utils.setShellIcon(this.shell);
        this.shell.setText(MessageText.getString("window.welcome.title", new String[]{"2.5.0.4"}));
        this.display = this.shell.getDisplay();
        GridLayout layout = new GridLayout();
        this.shell.setLayout((Layout)layout);
        Composite cWhatsNew = new Composite((Composite)this.shell, 2048);
        GridData data = new GridData(1808);
        cWhatsNew.setLayoutData((Object)data);
        cWhatsNew.setLayout((Layout)new FillLayout());
        Button bClose = new Button((Composite)this.shell, 8);
        bClose.setText(MessageText.getString("Button.close"));
        data = new GridData();
        data.widthHint = 70;
        data.horizontalAlignment = 131072;
        bClose.setLayoutData((Object)data);
        Listener closeListener = new Listener(){

            public void handleEvent(Event event2) {
                WelcomeWindow.this.close();
            }
        };
        bClose.addListener(13, closeListener);
        this.shell.addListener(21, closeListener);
        this.shell.setDefaultButton(bClose);
        this.shell.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (e.character == '\u001b') {
                    WelcomeWindow.this.close();
                }
            }
        });
        this.shell.setSize(500, 400);
        Utils.centreWindow(this.shell);
        this.shell.layout();
        this.shell.open();
        this.fillWhatsNew(cWhatsNew, url);
    }

    private void fillWhatsNew(Composite cWhatsNew, String url) {
        Label label = new Label(cWhatsNew, 0x1000000);
        label.setText(MessageText.getString("installPluginsWizard.details.loading"));
        this.shell.layout(true, true);
        this.shell.update();
        String sWhatsNew = this.getWhatsNew(url);
        if (this.shell.isDisposed()) {
            return;
        }
        if (sWhatsNew == null || sWhatsNew.length() == 0) {
            String helpFile = MessageText.getString("window.welcome.file");
            InputStream stream = this.getClass().getResourceAsStream("/org/gudy/azureus2/internat/whatsnew/" + helpFile);
            if (stream == null) {
                sWhatsNew = "Welcome Window: Error loading resource: /org/gudy/azureus2/internat/whatsnew/" + helpFile;
            } else {
                try {
                    sWhatsNew = FileUtil.readInputStreamAsString(stream, 65535);
                    stream.close();
                }
                catch (IOException e) {
                    Debug.out(e);
                }
            }
        }
        if (sWhatsNew.indexOf("<html") > 0 || sWhatsNew.indexOf("<HTML") > 0) {
            Browser browser = new Browser(cWhatsNew, 0);
            browser.setText(sWhatsNew);
        } else {
            StyledText helpPanel = new StyledText(cWhatsNew, 512);
            helpPanel.setEditable(false);
            try {
                helpPanel.setRedraw(false);
                helpPanel.setWordWrap(true);
                this.black = new Color((Device)this.display, 0, 0, 0);
                this.white = new Color((Device)this.display, 255, 255, 255);
                this.light = new Color((Device)this.display, 200, 200, 200);
                this.grey = new Color((Device)this.display, 50, 50, 50);
                this.green = new Color((Device)this.display, 30, 80, 30);
                this.blue = new Color((Device)this.display, 20, 20, 80);
                helpPanel.setForeground(this.grey);
                String[] lines = sWhatsNew.split("\\r?\\n");
                for (int i = 0; i < lines.length; ++i) {
                    String text;
                    int styleChar;
                    String line = lines[i];
                    boolean setStyle = false;
                    this.fg = this.grey;
                    this.bg = this.white;
                    int style = 0;
                    if (line.length() < 2) {
                        styleChar = 32;
                        text = " " + lineSeparator;
                    } else {
                        styleChar = line.charAt(0);
                        text = line.substring(1) + lineSeparator;
                    }
                    switch (styleChar) {
                        case 42: {
                            text = "  * " + text;
                            this.fg = this.green;
                            setStyle = true;
                            break;
                        }
                        case 43: {
                            text = "     " + text;
                            this.fg = this.black;
                            this.bg = this.light;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case 33: {
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case 64: {
                            this.fg = this.blue;
                            setStyle = true;
                            break;
                        }
                        case 36: {
                            this.bg = this.blue;
                            this.fg = this.white;
                            style = 1;
                            setStyle = true;
                            break;
                        }
                        case 32: {
                            text = "  " + text;
                        }
                    }
                    helpPanel.append(text);
                    if (!setStyle) continue;
                    int lineCount = helpPanel.getLineCount() - 1;
                    int charCount = helpPanel.getCharCount();
                    int lineOfs = helpPanel.getOffsetAtLine(lineCount - 1);
                    int lineLen = charCount - lineOfs;
                    helpPanel.setStyleRange(new StyleRange(lineOfs, lineLen, this.fg, this.bg, style));
                    helpPanel.setLineBackground(lineCount - 1, 1, this.bg);
                }
                helpPanel.setRedraw(true);
            }
            catch (Exception e) {
                System.out.println("Unable to load help contents because:" + e);
            }
        }
        label.dispose();
        this.shell.layout(true, true);
    }

    private String getWhatsNew(final String url) {
        final String[] s = new String[1];
        new AEThread("getWhatsNew", true){

            public void runSupport() {
                ResourceDownloaderFactory rdf = ResourceDownloaderFactoryImpl.getSingleton();
                try {
                    ResourceDownloader rd = rdf.create(new URL(url));
                    InputStream is = rd.download();
                    int length = is.available();
                    byte[] data = new byte[length];
                    is.read(data);
                    s[0] = new String(data);
                }
                catch (Exception e) {
                    Debug.out(e);
                    s[0] = "";
                }
                if (!WelcomeWindow.this.shell.isDisposed()) {
                    WelcomeWindow.this.shell.getDisplay().wake();
                }
            }
        }.start();
        while (!this.shell.isDisposed() && s[0] == null) {
            if (this.shell.getDisplay().readAndDispatch()) continue;
            this.shell.getDisplay().sleep();
        }
        return s[0];
    }

    private void close() {
        if (this.black != null && !this.black.isDisposed()) {
            this.black.dispose();
        }
        if (this.white != null && !this.white.isDisposed()) {
            this.white.dispose();
        }
        if (this.light != null && !this.light.isDisposed()) {
            this.light.dispose();
        }
        if (this.grey != null && !this.grey.isDisposed()) {
            this.grey.dispose();
        }
        if (this.green != null && !this.green.isDisposed()) {
            this.green.dispose();
        }
        if (this.blue != null && !this.blue.isDisposed()) {
            this.blue.dispose();
        }
        this.shell.dispose();
    }

    public static void main(String[] args) {
        new WelcomeWindow(null);
        Display display = Display.getDefault();
        while (true) {
            if (display.readAndDispatch()) {
                continue;
            }
            display.sleep();
        }
    }
}

