/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.swt.win32;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.TCHAR;

public class Win32UIEnhancer {
    static String findProgramKey(String extension) {
        TCHAR lpData;
        int[] phkResult;
        TCHAR key;
        if (extension == null) {
            SWT.error((int)4);
        }
        if (extension.length() == 0) {
            return null;
        }
        if (extension.charAt(0) != '.') {
            extension = "." + extension;
        }
        if (OS.RegOpenKeyEx((int)Integer.MIN_VALUE, (TCHAR)(key = new TCHAR(0, extension, true)), (int)0, (int)131097, (int[])(phkResult = new int[1])) != 0) {
            return null;
        }
        int[] lpcbData = new int[1];
        int result = OS.RegQueryValueEx((int)phkResult[0], null, (int)0, null, (TCHAR)null, (int[])lpcbData);
        if (result == 0 && (result = OS.RegQueryValueEx((int)phkResult[0], null, (int)0, null, (TCHAR)(lpData = new TCHAR(0, lpcbData[0] / TCHAR.sizeof)), (int[])lpcbData)) == 0) {
            return lpData.toString(0, lpData.strlen());
        }
        OS.RegCloseKey((int)phkResult[0]);
        return null;
    }

    public static ImageData getBigImageData(String extension) {
        String key = Win32UIEnhancer.findProgramKey(extension);
        if (key == null) {
            return null;
        }
        String DEFAULT_ICON = "\\DefaultIcon";
        String iconName = Win32UIEnhancer.getKeyValue(key + DEFAULT_ICON, true);
        if (iconName == null) {
            iconName = "";
        }
        int nIconIndex = 0;
        String fileName = iconName;
        int index = iconName.indexOf(44);
        if (index != -1) {
            fileName = iconName.substring(0, index);
            String iconIndex = iconName.substring(index + 1, iconName.length()).trim();
            try {
                nIconIndex = Integer.parseInt(iconIndex);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        TCHAR lpszFile = new TCHAR(0, fileName, true);
        int[] phiconSmall = null;
        int[] phiconLarge = new int[1];
        OS.ExtractIconEx((TCHAR)lpszFile, (int)nIconIndex, (int[])phiconLarge, phiconSmall, (int)1);
        if (phiconLarge[0] == 0) {
            return null;
        }
        Image image = Image.win32_new(null, (int)1, (int)phiconLarge[0]);
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    static String getKeyValue(String string, boolean expand) {
        TCHAR key = new TCHAR(0, string, true);
        int[] phkResult = new int[1];
        if (OS.RegOpenKeyEx((int)Integer.MIN_VALUE, (TCHAR)key, (int)0, (int)131097, (int[])phkResult) != 0) {
            return null;
        }
        String result = null;
        int[] lpcbData = new int[1];
        if (OS.RegQueryValueEx((int)phkResult[0], (TCHAR)null, (int)0, null, (TCHAR)null, (int[])lpcbData) == 0) {
            TCHAR lpData;
            result = "";
            int length = lpcbData[0] / TCHAR.sizeof;
            if (length != 0 && OS.RegQueryValueEx((int)phkResult[0], null, (int)0, null, (TCHAR)(lpData = new TCHAR(0, length)), (int[])lpcbData) == 0) {
                if (!OS.IsWinCE && expand) {
                    length = OS.ExpandEnvironmentStrings((TCHAR)lpData, null, (int)0);
                    if (length != 0) {
                        TCHAR lpDst = new TCHAR(0, length);
                        OS.ExpandEnvironmentStrings((TCHAR)lpData, (TCHAR)lpDst, (int)length);
                        result = lpDst.toString(0, Math.max(0, length - 1));
                    }
                } else {
                    length = Math.max(0, lpData.length() - 1);
                    result = lpData.toString(0, length);
                }
            }
        }
        if (phkResult[0] != 0) {
            OS.RegCloseKey((int)phkResult[0]);
        }
        return result;
    }
}

