/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin.remoteui.xml.server;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.xml.simpleparser.SimpleXMLParserDocumentFactory;
import org.gudy.azureus2.core3.xml.util.XMLElement;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocument;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentAttribute;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentException;
import org.gudy.azureus2.plugins.utils.xml.simpleparser.SimpleXMLParserDocumentNode;
import org.gudy.azureus2.pluginsimpl.remote.MethodSignature;
import org.gudy.azureus2.pluginsimpl.remote.RPException;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPReply;
import org.gudy.azureus2.pluginsimpl.remote.RPRequest;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestAccessController;
import org.gudy.azureus2.pluginsimpl.remote.RPRequestHandler;
import org.gudy.azureus2.pluginsimpl.remote.RPUtils;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPDeserialiseClassMismatchException;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPDeserialiseParseException;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPInternalProcessException;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPMalformedXMLException;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPUnsupportedInputTypeException;
import org.gudy.azureus2.ui.webplugin.remoteui.xml.server.XMLSerialisationUtils;

public class XMLRequestProcessor2 {
    protected RPRequestHandler request_handler;
    protected SimpleXMLParserDocument request;
    protected boolean serialise_debug;
    protected boolean deserialise_debug;
    protected LoggerChannel logger;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLRequestProcessor2(RPRequestHandler _request_handler, RPRequestAccessController _access_controller, String _client_ip, InputStream _request, OutputStream _reply, PluginInterface pi, LoggerChannel rp_channel, boolean serialise_debug, boolean deserialise_debug, boolean space_out_xml) {
        PrintWriter pw = null;
        try {
            pw = new PrintWriter(new OutputStreamWriter(_reply, "UTF8"));
        }
        catch (UnsupportedEncodingException e) {
            Debug.printStackTrace(e);
            pw = new PrintWriter(_reply);
        }
        this.serialise_debug = serialise_debug;
        this.deserialise_debug = deserialise_debug;
        this.request_handler = _request_handler;
        this.logger = rp_channel;
        pw.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XMLElement response_xml = new XMLElement("RESPONSE", true);
        try {
            this.request = SimpleXMLParserDocumentFactory.create(_request);
            this.process(_client_ip, _access_controller, response_xml, pi);
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            response_xml.clear();
            RPException rpe = null;
            rpe = e instanceof SimpleXMLParserDocumentException ? new RPMalformedXMLException(e) : (e instanceof RPException ? (RPException)e : new RPInternalProcessException(e));
            response_xml.addContent(this.describeError(rpe));
        }
        finally {
            response_xml.printTo(pw, space_out_xml);
            pw.flush();
            pw.close();
        }
    }

    protected void process(String client_ip, RPRequestAccessController access_controller, XMLElement response_xml, PluginInterface pi) throws Exception {
        this.debug_in("About to deserialise the RPRequest");
        RPRequest req_obj = (RPRequest)this.deserialiseObject(this.request, RPRequest.class);
        this.log_general("REQUEST: method=" + req_obj.getMethod() + ", " + "object=" + req_obj.getObject());
        req_obj.setClientIP(client_ip);
        req_obj.setPluginInterface(pi);
        RPReply reply = this.request_handler.processRequest(req_obj, access_controller);
        this.debug_out("About to serialise the RPReply");
        Map props = reply.getProperties();
        Iterator it = props.entrySet().iterator();
        XMLElement response_attr = null;
        Map.Entry mapping = null;
        while (it.hasNext()) {
            mapping = it.next();
            response_attr = new XMLElement((String)mapping.getKey());
            response_attr.addContent((String)mapping.getValue());
            response_xml.addContent(response_attr);
        }
        Object response = null;
        try {
            response = reply.getResponse();
        }
        catch (RPException e) {
            this.debug_out("RPException occurred - possibly occurred during the method invocation", e);
            this.log_general("RESPONSE (ERROR): " + (e.getCause() == null ? e : e.getCause()));
            Debug.printStackTrace(e);
            response_xml.clear();
            response_xml.addContent(this.describeError(e));
            return;
        }
        if (RPUtils.hasDescriptiveToStringMethod(response)) {
            this.log_general("RESPONSE: " + response);
        } else {
            this.log_general("RESPONSE: value=" + response + ", type=" + RPUtils.describeObject(response));
        }
        if (response != null) {
            if (response.getClass().isArray()) {
                response_xml.setAutoOrdering(false);
            }
            this.serialiseObject(response, -1, response_xml);
        }
    }

    public XMLElement describeError(RPException rpe) {
        String type;
        XMLElement xe = new XMLElement("ERROR", true);
        Class c = rpe.getErrorClass();
        if (c != null) {
            xe.addAttribute("class", RPUtils.getName(c));
        }
        if ((type = rpe.getRPType()) != null) {
            xe.addAttribute("type", type);
        }
        xe.addContent(rpe.getSerialisationMessage());
        Throwable t = rpe.getSerialisableObject();
        try {
            if (t != null) {
                this.serialiseObject(t, -3, xe);
            }
        }
        catch (RuntimeException re) {
            Debug.out("Error serialising error object.");
            Debug.printStackTrace(re);
        }
        return xe;
    }

    protected Object deserialiseObject(SimpleXMLParserDocumentNode node, Class cla) throws Exception {
        String request_method = null;
        if (cla == RPRequest.class) {
            request_method = node.getChild("METHOD").getValue().trim();
        }
        this.debug_in("Beginning deserialisation of " + RPUtils.getName(cla) + " instance.");
        Object obj = cla.newInstance();
        Field[] fields = cla.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name;
            SimpleXMLParserDocumentNode child;
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if ((modifiers & 0x88) != 0 || (child = node.getChild(name = field.getName())) == null) continue;
            Class<?> type = field.getType();
            this.debug_in("Deserialising field (\"" + name + "\", type: " + RPUtils.getName(type) + ")");
            if (type.isArray()) {
                Class<?> sub_type = type.getComponentType();
                SimpleXMLParserDocumentNode[] entries = child.getChildren();
                Object array = Array.newInstance(sub_type, entries.length);
                String[] bits = null;
                if (request_method != null) {
                    bits = MethodSignature.parse((String)request_method).arg_classes;
                } else {
                    int arr_length = Array.getLength(array);
                    bits = Collections.nCopies(arr_length, "String").toArray(new String[arr_length]);
                }
                this.debug_in("Attempting to deserialise " + entries.length + " entries for this field (which is an array type).");
                for (int j = 0; j < entries.length; ++j) {
                    SimpleXMLParserDocumentNode array_child = entries[j];
                    SimpleXMLParserDocumentAttribute index_attr = array_child.getAttribute("index");
                    String index_str = index_attr == null ? null : index_attr.getValue().trim();
                    int array_index = index_str == null ? j : Integer.parseInt(index_str);
                    String bit = bits[array_index];
                    String sub_value = array_child.getValue().trim();
                    Object value_to_store = this.deserialiseValue(array_child, sub_value, bit, true);
                    Array.set(array, array_index, value_to_store);
                }
                this.debug_in("Finished deserialising array, about to set value.");
                field.set(obj, array);
                this.debug_in("Field \"" + name + "\" deserialised and set.");
                continue;
            }
            String value = child.getValue().trim();
            Object obj_value = this.deserialiseValue(child, value, RPUtils.getName(type), true);
            field.set(obj, obj_value);
            this.debug_in("Field \"" + name + "\" deserialised and set.");
        }
        return obj;
    }

    protected void serialiseObject(Object obj, int original_modifier_filter, XMLElement container) {
        int modifier_filter = original_modifier_filter & 0xFFFFFF77;
        Class<?> cla = null;
        if (obj != null) {
            cla = obj.getClass();
        }
        String cla_name = cla == null ? "null" : RPUtils.getName(cla);
        this.debug_out("Serialising object of type \"" + cla_name + "\"");
        String value = XMLSerialisationUtils.serialise(obj, cla);
        if (value != null) {
            this.debug_out("Value was easily serialised into a string format.");
            container.addContent(value);
            return;
        }
        if (cla.isArray()) {
            int len = Array.getLength(obj);
            this.debug_out("Object is array type - processing " + len + " item(s).");
            XMLElement entry_xml = null;
            for (int i = 0; i < len; ++i) {
                entry_xml = new XMLElement("ENTRY", true);
                entry_xml.addAttribute("index", i);
                this.serialiseObject(Array.get(obj, i), original_modifier_filter, entry_xml);
                container.addContent(entry_xml);
            }
            this.debug_out("Finished serialising array.");
            return;
        }
        String obj_descr = RPUtils.describeObject(obj);
        this.debug_out("Need to use XMLSerialisationUtils to serialise " + obj_descr);
        Map[] attribute_data = XMLSerialisationUtils.getAttributeData(obj, modifier_filter);
        Map attribute_types = attribute_data[0];
        Map attribute_values = attribute_data[1];
        this.debug_out("Going to process " + attribute_values.size() + " attributes on " + obj_descr);
        Iterator attr_itr = attribute_values.entrySet().iterator();
        Map.Entry me = null;
        String key = null;
        while (attr_itr.hasNext()) {
            me = attr_itr.next();
            key = (String)me.getKey();
            if (me.getValue() != null) {
                this.debug_out("About to serialise attribute \"" + key + "\"");
                Class attr_class = (Class)attribute_types.get(key);
                if (attr_class == null) {
                    throw new NullPointerException("Trying to serialise attribute on " + obj + " (which belongs to " + container + ") - attrname: " + key + ", attrvalue: " + me.getValue() + ", but type not given!");
                }
                XMLElement attribute_content = container.makeContent(key, !attr_class.isArray());
                this.serialiseObject(me.getValue(), original_modifier_filter, attribute_content);
                continue;
            }
            this.debug_out("Attribute \"" + key + "\" was null, skipping.");
        }
        this.debug_out("Finished serialising " + obj_descr);
    }

    public Object deserialiseValue(SimpleXMLParserDocumentNode node, String string_value, String class_type, boolean rp_lookup) {
        Object parsed_value = null;
        Class result_class = XMLSerialisationUtils.getClass(class_type);
        if (result_class != null) {
            this.debug_in("Attempting to deserialise simple value of type \"" + RPUtils.getName(result_class) + "\"");
            try {
                parsed_value = XMLSerialisationUtils.deserialise(string_value, result_class);
            }
            catch (Exception e) {
                throw new RPDeserialiseParseException(e, string_value, result_class);
            }
        }
        if (parsed_value != null) {
            this.debug_in("Deserialisation of simple value successful.");
            return parsed_value;
        }
        if (rp_lookup) {
            this.debug_in("About to see if there is an object reference to process.");
            SimpleXMLParserDocumentNode obj_node = null;
            SimpleXMLParserDocumentNode obj_node_parent = node.getChild("OBJECT");
            if (obj_node_parent == null) {
                obj_node_parent = node;
            }
            if ((obj_node = obj_node_parent.getChild("_object_id")) != null) {
                this.debug_in("Found object ID node, processing...");
                String oid_str = obj_node.getValue().trim();
                long oid = Long.parseLong(oid_str);
                RPObject local_rp_obj = RPObject._lookupLocal(oid);
                if (class_type.equals("RPObject")) {
                    this.debug_in("Found object (type required was RPObject, so we don't need to unwrap the value).");
                    return local_rp_obj;
                }
                Object local_obj = local_rp_obj._getDelegate();
                if (!RPUtils.issubclassByName(local_obj.getClass(), class_type)) {
                    throw new RPDeserialiseClassMismatchException(class_type, local_rp_obj._getName());
                }
                this.debug_in("Found object with ID - returning " + RPUtils.describeObject(local_obj));
                return local_obj;
            }
            this.debug_in("No object ID node found.");
        }
        throw new RPUnsupportedInputTypeException(class_type);
    }

    public void debug_in(String s) {
        if (this.deserialise_debug) {
            this.logger.log(s);
        }
    }

    public void debug_in(String s, Throwable t) {
        if (this.deserialise_debug) {
            this.logger.log(s, t);
        }
    }

    public void debug_out(String s) {
        if (this.serialise_debug) {
            this.logger.log(s);
        }
    }

    public void debug_out(String s, Throwable t) {
        if (this.serialise_debug) {
            this.logger.log(s, t);
        }
    }

    public void log_general(String s) {
        this.logger.log(s);
    }
}

