/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.ui.webplugin.remoteui.xml.server;

import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.gudy.azureus2.core3.util.ByteFormatter;
import org.gudy.azureus2.pluginsimpl.remote.GenericRPAttributes;
import org.gudy.azureus2.pluginsimpl.remote.GenericRPObject;
import org.gudy.azureus2.pluginsimpl.remote.GenericRPPluginInterface;
import org.gudy.azureus2.pluginsimpl.remote.RPObject;
import org.gudy.azureus2.pluginsimpl.remote.RPUtils;
import org.gudy.azureus2.pluginsimpl.remote.rpexceptions.RPInternalProcessException;

public class XMLSerialisationUtils {
    private static Map simple_class_mapping = new HashMap();
    private static Map class_string_mapping = new HashMap();
    private static final Class byte_array_class = new byte[0].getClass();
    private static Map deserialise_functions = new HashMap();

    public static String serialise(Object o, Class c) {
        if (o == null) {
            return "";
        }
        Boolean simple_class = (Boolean)simple_class_mapping.get(c);
        if (simple_class == null) {
            return null;
        }
        if (simple_class.booleanValue()) {
            return o.toString();
        }
        if (c == byte_array_class) {
            return ByteFormatter.nicePrint((byte[])o, true);
        }
        throw new RuntimeException("class is unsupported but not supported? " + c);
    }

    public static Class getClass(String name) {
        return (Class)class_string_mapping.get(name.toLowerCase());
    }

    public static Object deserialise(String s, Class c) {
        ParseFunction pf = (ParseFunction)deserialise_functions.get(c);
        if (pf == null) {
            return null;
        }
        return pf.parse(s);
    }

    public static Map[] getAttributeData(Object o, int modifier_filter) {
        Map[] result = new Map[2];
        if (o instanceof GenericRPObject || o instanceof GenericRPPluginInterface) {
            RPObject ro = (RPObject)o;
            Class pclass = ro._getPluginClass();
            result[0] = new HashMap();
            result[1] = new HashMap();
            result[0].putAll(GenericRPAttributes.getAttributeTypes(pclass));
            result[1].putAll(GenericRPAttributes.getAttributes(ro._getDelegate(), pclass, result[0]));
            result[0].putAll(GenericRPAttributes.getRPAttributeTypes(ro.getClass()));
            result[1].putAll(GenericRPAttributes.getRPAttributes(ro, ro.getClass(), result[0]));
        } else {
            result[0] = new HashMap();
            result[1] = new HashMap();
            Class<?> c = o.getClass();
            do {
                Field[] fields = c.getDeclaredFields();
                for (int i = 0; i < fields.length; ++i) {
                    Field field = fields[i];
                    int modifiers = field.getModifiers();
                    if ((modifiers | modifier_filter) != modifier_filter) continue;
                    String field_name = field.getName();
                    result[0].put(field_name, field.getType());
                    try {
                        result[1].put(field_name, field.get(o));
                        continue;
                    }
                    catch (IllegalAccessException iae) {
                        throw new RPInternalProcessException(iae);
                    }
                }
            } while ((c = c.getSuperclass()) != null);
        }
        return result;
    }

    static {
        Class[] supported_types = new Class[]{Boolean.class, Byte.class, Character.class, Float.class, Integer.class, Long.class, Short.class, Boolean.TYPE, Byte.TYPE, Character.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, String.class, byte_array_class, File.class, URL.class};
        for (int i = 0; i < supported_types.length; ++i) {
            class_string_mapping.put(RPUtils.getName(supported_types[i]).toLowerCase(), supported_types[i]);
            simple_class_mapping.put(supported_types[i], true);
        }
        simple_class_mapping.put(byte_array_class, false);
        ParseFunction pf = null;
        pf = new PrimitiveParseFunction(Float.class);
        deserialise_functions.put(Float.class, pf);
        deserialise_functions.put(Float.TYPE, pf);
        pf = new PrimitiveParseFunction(Integer.class);
        deserialise_functions.put(Integer.class, pf);
        deserialise_functions.put(Integer.TYPE, pf);
        pf = new PrimitiveParseFunction(Long.class);
        deserialise_functions.put(Long.class, pf);
        deserialise_functions.put(Long.TYPE, pf);
        pf = new PrimitiveParseFunction(Short.class);
        deserialise_functions.put(Short.class, pf);
        deserialise_functions.put(Short.TYPE, pf);
        pf = new ConstructorParseFunction(File.class);
        deserialise_functions.put(File.class, pf);
        pf = new ConstructorParseFunction(URL.class);
        deserialise_functions.put(URL.class, pf);
        pf = new BooleanParseFunction();
        deserialise_functions.put(Boolean.class, pf);
        deserialise_functions.put(Boolean.TYPE, pf);
        pf = new ByteArrayParseFunction();
        deserialise_functions.put(byte_array_class, pf);
        pf = new CharacterParseFunction();
        deserialise_functions.put(Character.TYPE, pf);
        deserialise_functions.put(Character.class, pf);
        pf = new StringParseFunction();
        deserialise_functions.put(String.class, pf);
    }

    private static class StringParseFunction
    implements ParseFunction {
        private StringParseFunction() {
        }

        public Object parse(String s) {
            return s;
        }
    }

    private static class CharacterParseFunction
    implements ParseFunction {
        private CharacterParseFunction() {
        }

        public Object parse(String s) {
            if (s.length() == 1) {
                return new Character(s.charAt(0));
            }
            throw new IllegalArgumentException("string is not one character long - cannot convert to char: \"" + s + "\"");
        }
    }

    private static class ByteArrayParseFunction
    implements ParseFunction {
        private ByteArrayParseFunction() {
        }

        public Object parse(String s) {
            return ByteFormatter.decodeString(s);
        }
    }

    private static class BooleanParseFunction
    implements ParseFunction {
        private BooleanParseFunction() {
        }

        public Object parse(String s) {
            if (s.equals("true")) {
                return Boolean.TRUE;
            }
            if (s.equals("false")) {
                return Boolean.FALSE;
            }
            throw new IllegalArgumentException("not boolean argument: \"" + s + "\"");
        }
    }

    private static class ConstructorParseFunction
    implements ParseFunction {
        private Constructor constructor_object;

        public ConstructorParseFunction(Class c_object) {
            try {
                this.constructor_object = c_object.getConstructor(class$java$lang$String == null ? (class$java$lang$String = XMLSerialisationUtils.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException(nsme);
            }
        }

        public Object parse(String s) {
            try {
                return this.constructor_object.newInstance(s);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ite.getCause();
                }
                throw new RuntimeException(ite.getCause() == null ? ite : ite.getCause());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class PrimitiveParseFunction
    implements ParseFunction {
        private Method method_object;

        public PrimitiveParseFunction(Class c_object) {
            try {
                this.method_object = c_object.getMethod("valueOf", class$java$lang$String == null ? (class$java$lang$String = XMLSerialisationUtils.class$("java.lang.String")) : class$java$lang$String);
            }
            catch (NoSuchMethodException nsme) {
                throw new RuntimeException(nsme);
            }
        }

        public Object parse(String s) {
            try {
                return this.method_object.invoke(null, s);
            }
            catch (InvocationTargetException ite) {
                if (ite.getCause() instanceof RuntimeException) {
                    throw (RuntimeException)ite.getCause();
                }
                throw new RuntimeException(ite.getCause() == null ? ite : ite.getCause());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static interface ParseFunction {
        public Object parse(String var1);
    }
}

