/*
 * Decompiled with CFR 0.152.
 */
package org.gudy.azureus2.update;

import com.aelitis.azureus.core.versioncheck.VersionCheckClient;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.gudy.azureus2.core3.config.COConfigurationManager;
import org.gudy.azureus2.core3.html.HTMLPageFactory;
import org.gudy.azureus2.core3.logging.LogAlert;
import org.gudy.azureus2.core3.logging.LogEvent;
import org.gudy.azureus2.core3.logging.LogIDs;
import org.gudy.azureus2.core3.logging.Logger;
import org.gudy.azureus2.core3.util.AEVerifier;
import org.gudy.azureus2.core3.util.BDecoder;
import org.gudy.azureus2.core3.util.Constants;
import org.gudy.azureus2.core3.util.Debug;
import org.gudy.azureus2.core3.util.SystemProperties;
import org.gudy.azureus2.plugins.Plugin;
import org.gudy.azureus2.plugins.PluginInterface;
import org.gudy.azureus2.plugins.logging.LoggerChannel;
import org.gudy.azureus2.plugins.update.UpdatableComponent;
import org.gudy.azureus2.plugins.update.Update;
import org.gudy.azureus2.plugins.update.UpdateChecker;
import org.gudy.azureus2.plugins.update.UpdateInstaller;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloader;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderAdapter;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderDelayedFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderFactory;
import org.gudy.azureus2.plugins.utils.resourcedownloader.ResourceDownloaderListener;

public class CoreUpdateChecker
implements Plugin,
UpdatableComponent {
    public static final String LATEST_VERSION_PROPERTY = "latest_version";
    public static final String MESSAGE_PROPERTY = "message";
    public static final int RD_GET_DETAILS_RETRIES = 3;
    public static final int RD_GET_MIRRORS_RETRIES = 3;
    public static final int RD_SIZE_RETRIES = 3;
    public static final int RD_SIZE_TIMEOUT = 10000;
    protected static CoreUpdateChecker singleton;
    protected PluginInterface plugin_interface;
    protected ResourceDownloaderFactory rdf;
    protected LoggerChannel log;
    protected ResourceDownloaderListener rd_logger;
    protected boolean first_check = true;

    public static void doUsageStats() {
        singleton.doUsageStatsSupport();
    }

    public CoreUpdateChecker() {
        singleton = this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doUsageStatsSupport() {
        try {
            Map decoded = VersionCheckClient.getSingleton().getVersionCheckInfo(this.first_check ? "us" : "up");
            this.displayUserMessage(decoded);
        }
        finally {
            this.first_check = false;
        }
    }

    public void initialize(PluginInterface _plugin_interface) {
        this.plugin_interface = _plugin_interface;
        this.plugin_interface.getPluginProperties().setProperty("plugin.name", "Core Updater");
        this.log = this.plugin_interface.getLogger().getChannel("CoreUpdater");
        this.rd_logger = new ResourceDownloaderAdapter(){

            public void reportActivity(ResourceDownloader downloader, String activity) {
                CoreUpdateChecker.this.log.log(activity);
            }
        };
        Properties props = this.plugin_interface.getPluginProperties();
        props.setProperty("plugin.version", this.plugin_interface.getAzureusVersion());
        this.rdf = this.plugin_interface.getUtilities().getResourceDownloaderFactory();
        this.plugin_interface.getUpdateManager().registerUpdatableComponent(this, true);
    }

    public String getName() {
        return "Azureus Core";
    }

    public int getMaximumCheckTime() {
        return 30;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkForUpdate(final UpdateChecker checker) {
        try {
            ResourceDownloader top_downloader;
            ResourceDownloader backup_downloader;
            URL full_download_url;
            String current_version = this.plugin_interface.getAzureusVersion();
            this.log.log("Update check starts: current = " + current_version);
            Map decoded = VersionCheckClient.getSingleton().getVersionCheckInfo(this.first_check ? "us" : "up");
            this.displayUserMessage(decoded);
            byte[] b_version = (byte[])decoded.get("version");
            if (b_version == null) {
                throw new Exception("No version found in reply");
            }
            String latest_version = new String(b_version);
            this.plugin_interface.getPluginProperties().setProperty(LATEST_VERSION_PROPERTY, latest_version);
            byte[] b_filename = (byte[])decoded.get("filename");
            if (b_filename == null) {
                throw new Exception("No update file details in reply");
            }
            String latest_file_name = new String(b_filename);
            String msg = "Core: latest_version = '" + latest_version + "', file = '" + latest_file_name + "'";
            if (latest_file_name.startsWith("http")) {
                try {
                    full_download_url = new URL(latest_file_name);
                }
                catch (Throwable e) {
                    full_download_url = null;
                    this.log.log(e);
                }
                int pos = latest_file_name.lastIndexOf(47);
                latest_file_name = latest_file_name.substring(pos + 1);
            } else {
                full_download_url = null;
            }
            checker.reportProgress(msg);
            this.log.log(msg);
            if (!CoreUpdateChecker.shouldUpdate(current_version, latest_version)) {
                return;
            }
            final String f_latest_version = latest_version;
            final String f_latest_file_name = latest_file_name;
            if (full_download_url == null) {
                ResourceDownloader[] primary_mirrors = this.getPrimaryDownloaders(latest_file_name);
                ResourceDownloader random_primary_mirrors = this.rdf.getRandomDownloader(primary_mirrors);
                backup_downloader = this.rdf.create(new ResourceDownloaderDelayedFactory(){

                    public ResourceDownloader create() {
                        ResourceDownloader[] backup_mirrors = CoreUpdateChecker.this.getBackupDownloaders(f_latest_file_name);
                        return CoreUpdateChecker.this.rdf.getRandomDownloader(backup_mirrors);
                    }
                });
                top_downloader = this.rdf.getAlternateDownloader(new ResourceDownloader[]{random_primary_mirrors, backup_downloader});
            } else {
                ResourceDownloader full_rd = this.rdf.create(full_download_url);
                full_rd = this.rdf.getSuffixBasedDownloader(full_rd);
                ResourceDownloader primary_downloader = this.rdf.create(new ResourceDownloaderDelayedFactory(){

                    public ResourceDownloader create() {
                        ResourceDownloader[] primary_mirrors = CoreUpdateChecker.this.getPrimaryDownloaders(f_latest_file_name);
                        return CoreUpdateChecker.this.rdf.getRandomDownloader(primary_mirrors);
                    }
                });
                backup_downloader = this.rdf.create(new ResourceDownloaderDelayedFactory(){

                    public ResourceDownloader create() {
                        ResourceDownloader[] backup_mirrors = CoreUpdateChecker.this.getBackupDownloaders(f_latest_file_name);
                        return CoreUpdateChecker.this.rdf.getRandomDownloader(backup_mirrors);
                    }
                });
                top_downloader = this.rdf.getAlternateDownloader(new ResourceDownloader[]{full_rd, primary_downloader, backup_downloader});
            }
            top_downloader.addListener(this.rd_logger);
            top_downloader.getSize();
            byte[] info_b = (byte[])decoded.get("info");
            String info = null;
            if (info_b != null) {
                try {
                    info = new String(info_b);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            String[] desc = info == null ? new String[]{"Core Azureus Version"} : new String[]{"Core Azureus Version", info};
            final Update update = checker.addUpdate("Core Azureus Version", desc, latest_version, top_downloader, 2);
            top_downloader.addListener(new ResourceDownloaderAdapter(){

                public boolean completed(ResourceDownloader downloader, InputStream data) {
                    CoreUpdateChecker.this.installUpdate(checker, update, downloader, f_latest_version, data);
                    return true;
                }
            });
        }
        catch (Throwable e) {
            this.log.log(e);
            Debug.printStackTrace(e);
            checker.failed();
        }
        finally {
            checker.completed();
            this.first_check = false;
        }
    }

    private void displayUserMessage(Map reply) {
        block6: {
            try {
                String last;
                String s_message;
                byte[] message = (byte[])reply.get(MESSAGE_PROPERTY);
                if (message == null || message.length <= 0 || (s_message = new String(message)).equals(last = COConfigurationManager.getStringParameter("CoreUpdateChecker.lastmessage", ""))) break block6;
                byte[] signature = (byte[])reply.get("message_sig");
                if (signature == null) {
                    Logger.log(new LogEvent(LogIDs.LOGGER, "Signature missing from message"));
                    return;
                }
                try {
                    AEVerifier.verifyData(s_message, signature);
                }
                catch (Throwable e) {
                    Logger.log(new LogEvent(LogIDs.LOGGER, "Message signature check failed", e));
                    return;
                }
                int alert_type = 1;
                String alert_text = s_message;
                if (alert_text.startsWith("i:")) {
                    alert_type = 0;
                    alert_text = alert_text.substring(2);
                }
                this.plugin_interface.getPluginProperties().setProperty(MESSAGE_PROPERTY, alert_text);
                Logger.log(new LogAlert(false, alert_type, alert_text));
                COConfigurationManager.setParameter("CoreUpdateChecker.lastmessage", s_message);
                COConfigurationManager.save();
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    protected ResourceDownloader[] getPrimaryDownloaders(String latest_file_name) {
        ArrayList<URL> res;
        block9: {
            this.log.log("Downloading primary mirrors");
            res = new ArrayList<URL>();
            try {
                if (latest_file_name == null) {
                    res.add(new URL("http://azureus.sourceforge.net/Azureus2.jar"));
                    break block9;
                }
                URL mirrors_url = new URL("http://prdownloads.sourceforge.net/azureus/" + latest_file_name + "?download");
                ResourceDownloader rd = this.rdf.create(mirrors_url);
                rd = this.rdf.getRetryDownloader(rd, 3);
                rd.addListener(this.rd_logger);
                String page = HTMLPageFactory.loadPage(rd.download()).getContent();
                String pattern = "/azureus/" + latest_file_name + "?use_mirror=";
                int position = page.indexOf(pattern);
                while (position > 0) {
                    int end = page.indexOf(">", position);
                    if (end < 0) {
                        position = -1;
                        continue;
                    }
                    String mirror = page.substring(position, end);
                    if (mirror.endsWith("\"")) {
                        mirror = mirror.substring(0, mirror.length() - 1);
                    }
                    try {
                        res.add(new URL("http://prdownloads.sourceforge.net" + mirror));
                    }
                    catch (Throwable e) {
                        this.log.log("Invalid URL read:" + mirror, e);
                    }
                    position = page.indexOf(pattern, position + 1);
                }
            }
            catch (Throwable e) {
                this.log.log("Failed to read primary mirror list", e);
            }
        }
        ResourceDownloader[] dls = new ResourceDownloader[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            URL url = (URL)res.get(i);
            this.log.log("    Primary mirror:" + url.toString());
            ResourceDownloader dl = this.rdf.create(url);
            dl = this.rdf.getMetaRefreshDownloader(dl);
            dls[i] = dl = this.rdf.getSuffixBasedDownloader(dl);
        }
        return dls;
    }

    protected ResourceDownloader[] getBackupDownloaders(String latest_file_name) {
        ArrayList<URL> res = new ArrayList<URL>();
        try {
            if (latest_file_name != null) {
                this.log.log("Downloading backup mirrors");
                URL mirrors_url = new URL("http://azureus.sourceforge.net/mirrors.php");
                ResourceDownloader rd = this.rdf.create(mirrors_url);
                rd = this.rdf.getRetryDownloader(rd, 3);
                rd.addListener(this.rd_logger);
                BufferedInputStream data = new BufferedInputStream(rd.download());
                Map decoded = BDecoder.decode(data);
                data.close();
                List mirrors = (List)decoded.get("mirrors");
                for (int i = 0; i < mirrors.size(); ++i) {
                    String mirror = new String((byte[])mirrors.get(i));
                    try {
                        res.add(new URL(mirror + latest_file_name));
                        continue;
                    }
                    catch (Throwable e) {
                        this.log.log("Invalid URL read:" + mirror, e);
                    }
                }
            }
        }
        catch (Throwable e) {
            this.log.log("Failed to read backup mirror list", e);
        }
        ResourceDownloader[] dls = new ResourceDownloader[res.size()];
        for (int i = 0; i < res.size(); ++i) {
            URL url = (URL)res.get(i);
            this.log.log("    Backup mirror:" + url.toString());
            ResourceDownloader dl = this.rdf.create(url);
            dls[i] = dl = this.rdf.getSuffixBasedDownloader(dl);
        }
        return dls;
    }

    protected void installUpdate(UpdateChecker checker, Update update, ResourceDownloader rd, String version, InputStream data) {
        try {
            data = update.verifyData(data, true);
            rd.reportActivity("Data verified successfully");
            String temp_jar_name = "Azureus2_" + version + ".jar";
            String target_jar_name = "Azureus2.jar";
            UpdateInstaller installer = checker.createInstaller();
            installer.addResource(temp_jar_name, data);
            if (Constants.isOSX) {
                installer.addMoveAction(temp_jar_name, installer.getInstallDir() + "/" + SystemProperties.getApplicationName() + ".app/Contents/Resources/Java/" + target_jar_name);
            } else {
                installer.addMoveAction(temp_jar_name, installer.getInstallDir() + File.separator + target_jar_name);
            }
        }
        catch (Throwable e) {
            rd.reportActivity("Update install failed:" + e.getMessage());
        }
    }

    protected static boolean shouldUpdate(String current_version, String latest_version) {
        String current_base = Constants.getBaseVersion(current_version);
        int current_inc = Constants.getIncrementalBuild(current_version);
        String latest_base = Constants.getBaseVersion(latest_version);
        int latest_inc = Constants.getIncrementalBuild(latest_version);
        int major_comp = Constants.compareVersions(current_base, latest_base);
        if (major_comp < 0 && latest_inc == 0) {
            return true;
        }
        return major_comp == 0 && current_inc > 0 && latest_inc > 0 && latest_inc > current_inc;
    }

    public static void main(String[] args) {
        String[][] tests = new String[][]{{"2.4.0.0", "2.4.0.2", "true"}, {"2.4.0.1_CVS", "2.4.0.2", "true"}, {"2.4.0.1_B12", "2.4.0.2", "true"}, {"2.4.0.1_B12", "2.4.0.1_B34", "true"}, {"2.4.0.1_B12", "2.4.0.1_B6", "false"}, {"2.4.0.0", "2.4.0.1_CVS", "false"}, {"2.4.0.0", "2.4.0.1_B12", "false"}, {"2.4.0.0", "2.4.0.0", "false"}, {"2.4.0.1_CVS", "2.4.0.1_CVS", "false"}, {"2.4.0.1_B2", "2.4.0.1_B2", "false"}, {"2.4.0.1_CVS", "2.4.0.1_B2", "false"}, {"2.4.0.1_B2", "2.4.0.1_CVS", "false"}};
        for (int i = 0; i < tests.length; ++i) {
            System.out.println(CoreUpdateChecker.shouldUpdate(tests[i][0], tests[i][1]) + " / " + tests[i][2]);
        }
    }
}

