/*
     This file is part of GNUnet
     (C) 2005, 2006, 2007 Christian Grothoff (and other contributing authors)
     
     GNUnet is free software; you can redistribute it and/or modify
     it under the terms of the GNU General Public License as published
     by the Free Software Foundation; either version 2, or (at your
     option) any later version.

     GNUnet is distributed in the hope that it will be useful, but
     WITHOUT ANY WARRANTY; without even the implied warranty of
     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
     General Public License for more details.

     You should have received a copy of the GNU General Public License
     along with GNUnet; see the file COPYING.  If not, write to the
     Free Software Foundation, Inc., 59 Temple Place - Suite 330,
     Boston, MA 02111-1307, USA.
*/

/**
 * @file src/include/gnunetgtk_common.h
 * @author Igor Wronsky
 * @author Christian Grothoff
 */

#ifndef GTKUI_HELPER_H
#define GTKUI_HELPER_H

#include <gtk/gtk.h>
#include <gtk/gtktext.h>
#include <glade/glade.h>

#define DEBUG_GTK 0

#if DEBUG_GTK
#define DEBUG_BEGIN() fprintf(stderr, "BEGIN of %s\n", __FUNCTION__)
#define DEBUG_MARK() fprintf(stderr, "AT %s:%d\n", __FILE__, __LINE__)
#define DEBUG_END() fprintf(stderr, "END of %s\n", __FUNCTION__)
#else
#define DEBUG_BEGIN()
#define DEBUG_MARK()
#define DEBUG_END()
#endif

void initGNUnetGTKCommon(struct GE_Context * ectx,
			 struct GC_Configuration * cfg,
			 void * callback);

void shutdownPlugins(void);

void doneGNUnetGTKCommon(void);

/**
 * Get the name of the main glade file for gnunet-gtk.
 */
const char * getGladeFileName(void);

/**
 * Get the GladeXML for the main window of gnunet-gtk.
 */
GladeXML * getMainXML(void);

/**
 * Appends a message to the info window
 * @param doPopup if YES, the info window will
 *   be opened
 */
void infoMessage(int doPopup,
		 const char * format,
		 ...);

/**
 * Appends a log entry to the info window
 * and update the statusbar to show this
 * message (until the next call).
 *
 * @param txt the log entry
 */
void addLogEntry(const char * txt, ...);

struct GE_Context * createGtkLogger(GE_KIND mask);
	
/**
 * Call a callback function from the mainloop/main thread ("SaveCall").
 * Since GTK doesn't work with multi-threaded applications under Windows,
 * all GTK operations have to be done in the main thread
 */
void * gtkSaveCall(PThreadMain func,
		   void * arg);

/**
 * Run the given "cb" function and save calls
 * in parallel (used within the event loop to
 * keep save calls going while something else
 * happens).
 */
void * run_with_save_calls(PThreadMain cb,
			   void * arg);

/**
 * Bind handlers defined by the various
 * plugins to the signals defined by the
 * Glade XML.
 */
void connectGladeWithPlugins(GladeXML * xml);

#define NOTIFY_LOW 0
#define NOTIFY_NORMAL 1
#define NOTIFY_CRITICAL 2

/**
 * Sends a message to libnotify
 */
void gnunetgtk_notify(int type,
		      const char * message,
		      ...);

/**
 * Validate that a string is a Utf-8 string.
 * If validation fails, msg is freed and a valid
 * Utf-8 string is returned.
 */
char * validate_utf8(char * msg);

/**
 * Gtk callback to save the main window state (tray icon use)
 */
void saveMainWindowState(GtkWidget *main_window,
                         GdkEventWindowState *event,
                         gpointer user_data);

/**
 * Get the last main window state when restoring (tray icon use)
 */
GdkWindowState getMainWindowState(void);

void gnunet_gtk_main_quit(void);

/**
* Start gnunet-setup, asking for a password if needed
* @param run_wizard TRUE to run the wizard, FALSE to run the complete tool
* @returns FALSE if gnunet-setup was run, TRUE else
*/
gboolean startGNUnetSetup (gboolean run_wizard);

/**
 * Identical to "gtk_tree_selection_selected_foreach",
 * except that modifications of the underlying model
 * during the iteration are tolerated.
 */
void ggc_tree_selection_selected_foreach(GtkTreeSelection *selection,
					 GtkTreeSelectionForeachFunc func,
					 gpointer data);

/**
 * Identical to "gtk_tree_model_foreach",
 * except that modifications of the underlying model
 * during the iteration are tolerated.
 */
void ggc_tree_model_foreach(GtkTreeModel * model,
			    GtkTreeSelectionForeachFunc func,
			    gpointer data);


struct CronManager * gnunet_gtk_get_cron(void);

#endif
