/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2007 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-gtk-webcore.cpp 3111 2007-03-30 08:18:40Z makeinu $
 */

#include <objbase.h>

#include <glib/gi18n.h>
#include <math.h>

#include "kazehakase.h"
#include "kz-ie.h"
#include "kz-embed-prefs.h"
#include "kz-embed.h"
#include "kz-prompt-dialog.h"
#include "kz-proxy-item.h"
#include "gtk-utils.h"

typedef struct _KzIEPrivate	KzIEPrivate;
struct _KzIEPrivate
{
	gint dummy;
};
#define KZ_IE_GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), KZ_TYPE_IE, KzIEPrivate))

static GType           kz_type_ie = 0;
static GtkWidgetClass *kz_ie_parent_class;

GtkWidget  *kz_ie_new          (void);
static void kz_ie_class_init   (KzIEClass *klass);
static void kz_ie_iface_init   (KzEmbedIFace *iface);
static void kz_ie_init         (KzIE *ie);
static void kz_ie_dispose      (GObject      *object);

/* embed iface */
/* no functions is implemented yet */

/* KzEmbedPrefs interfaces */
/* no functions is implemented yet */
static void kz_ie_prefs_iface_init (KzEmbedPrefsIFace *iface);

void
kz_ie_register_type (GTypeModule *module)
{
	static const GTypeInfo kz_ie_info =
	{
		sizeof (KzIEClass),
		NULL,		/* base_init */
		NULL,		/* base_finalize */
		(GClassInitFunc) kz_ie_class_init,
		NULL,		/* class_finalize */
		NULL,		/* class_data */
		sizeof (KzIE),
		0,		/* n_preallocs */
		(GInstanceInitFunc) kz_ie_init,
	};

	const GInterfaceInfo kz_embed_info =
	{
		(GInterfaceInitFunc) kz_ie_iface_init,
		NULL,
		NULL
	};

	const GInterfaceInfo kz_embed_prefs_info =
	{
		(GInterfaceInitFunc) kz_ie_prefs_iface_init,
		NULL,
		NULL
	};

	kz_type_ie = g_type_module_register_type(module,
						 GTK_TYPE_WIDGET,
						 "KzIE",
						 &kz_ie_info,
						 (GTypeFlags)0);

	g_type_module_add_interface(module,
				    KZ_TYPE_IE,
				    KZ_TYPE_EMBED,
				    &kz_embed_info);

	g_type_module_add_interface(module,
				    KZ_TYPE_IE,
				    KZ_TYPE_EMBED_PREFS,
				    &kz_embed_prefs_info);
}

GType
kz_ie_get_type (void)
{
       return kz_type_ie;
}

static void
kz_ie_class_init (KzIEClass *klass)
{
	GObjectClass *object_class;
	GtkWidgetClass *widget_class;

	kz_ie_parent_class = (GtkWidgetClass *)g_type_class_peek_parent (klass);
	object_class = (GObjectClass *) klass;
	widget_class = (GtkWidgetClass *) klass;

	object_class->dispose   = kz_ie_dispose;

	g_type_class_add_private (object_class, sizeof(KzIEPrivate));
}


static void
kz_ie_iface_init (KzEmbedIFace *iface)
{
	iface->load_url               = NULL;
	iface->view_source            = NULL;
	iface->is_loading             = NULL;
	iface->get_title              = NULL;
	iface->get_location           = NULL;
	iface->ensure_title           = NULL;
	iface->get_link_message       = NULL;
	iface->get_progress           = NULL;
	iface->can_cut_selection      = NULL;
	iface->can_copy_selection     = NULL;
	iface->can_paste              = NULL;
	iface->cut_selection          = NULL;
	iface->copy_selection         = NULL;
	iface->paste                  = NULL;
	iface->select_all             = NULL;
	iface->get_selection_string   = NULL;
	iface->find                   = NULL;
	iface->incremental_search     = NULL;
	iface->selection_is_collapsed = NULL;
	iface->get_links              = NULL;
	iface->copy_page              = NULL;
	iface->shistory_copy          = NULL;
	iface->shistory_get_pos       = NULL;
	iface->shistory_get_nth       = NULL;
	iface->reload                 = NULL;
	iface->stop_load              = NULL;
	iface->go_back                = NULL;
	iface->go_forward             = NULL;
	iface->can_go_back            = NULL;
	iface->can_go_forward         = NULL;
	iface->can_go_nav_link        = NULL;
	iface->go_nav_link            = NULL;
	iface->append_nav_link        = NULL;
	iface->set_nav_link           = NULL;
	iface->set_nth_nav_link       = NULL;
	iface->get_nav_link           = NULL;
	iface->get_nth_nav_link       = NULL;
	iface->get_nav_links          = NULL;
	iface->go_history_index       = NULL;
	iface->do_command             = NULL;
	iface->can_do_command         = NULL;
	iface->get_lock               = NULL;
	iface->set_lock               = NULL;
	iface->get_body_text          = NULL;
#if 0
	iface->get_selection_source   = NULL;
#endif
	iface->set_encoding           = NULL;
	iface->get_encoding           = NULL;
	iface->print                  = NULL;
	iface->print_preview          = NULL;
	iface->get_printer_list       = NULL;
	iface->create_thumbnail       = NULL;
	iface->save_with_content      = NULL;
	iface->set_text_into_textarea = NULL;
	iface->get_text_from_textarea = NULL;
	iface->zoom_set               = NULL;
	iface->zoom_get               = NULL;
	iface->set_text_size          = NULL;
	iface->get_text_size          = NULL;
	iface->get_html_with_contents = NULL;
	iface->set_history            = NULL;
	iface->get_history            = NULL;
	iface->get_last_modified      = NULL;
	iface->fine_scroll            = NULL;
	iface->page_up                = NULL;
	iface->page_down              = NULL; 
	iface->get_allow_javascript   = NULL;
	iface->set_allow_javascript   = NULL; 
	iface->get_allow_images       = NULL;
	iface->set_allow_images       = NULL;
#if 0
	iface->set_edit_mode          = NULL;
	iface->set_view_mode          = NULL;
#endif

	iface->link_message           = NULL;
	iface->js_status              = NULL;
	iface->location               = NULL;
	iface->title                  = NULL;
	iface->progress               = NULL;
	iface->net_start              = NULL;
	iface->net_stop               = NULL;
	iface->new_window             = NULL;
	iface->open_uri               = NULL;
	iface->size_to                = NULL;
	iface->dom_key_down           = NULL;
	iface->dom_key_press          = NULL;
	iface->dom_key_up             = NULL;
	iface->dom_mouse_down         = NULL;
	iface->dom_mouse_up           = NULL;
	iface->dom_mouse_click        = NULL;
	iface->dom_mouse_dbl_click    = NULL;
	iface->dom_mouse_over         = NULL;
	iface->dom_mouse_out          = NULL;
	iface->security_change        = NULL;
	iface->status_change          = NULL;
}


static void
kz_ie_prefs_iface_init (KzEmbedPrefsIFace *iface)
{
	iface->init             = NULL; /* kz_ie_prefs_init;*/
	iface->get_font_list    = NULL; /* kz_ie_prefs_get_font_list; */
	iface->get_passwords    = NULL; /* kz_ie_prefs_get_passwords; */
	iface->remove_passwords = NULL; /* kz_ie_prefs_remove_passwords; */
}

static void
kz_ie_init (KzIE *ie)
{
	KzIEPrivate *priv = KZ_IE_GET_PRIVATE (ie);

	priv->dummy   = 0;
}

static void
kz_ie_dispose (GObject *object)
{
	KzIEPrivate *priv = KZ_IE_GET_PRIVATE(object);

	if (G_OBJECT_CLASS(kz_ie_parent_class)->dispose)
		G_OBJECT_CLASS(kz_ie_parent_class)->dispose(object);
}

GtkWidget *
kz_ie_new (void)
{
	return GTK_WIDGET(g_object_new(KZ_TYPE_IE, NULL));
}
